/*
 * Decompiled with CFR 0.152.
 */
package projects.tals.rnaseq;

import de.jstacs.algorithms.optimization.DifferentiableFunction;
import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.algorithms.optimization.EvaluationException;
import java.util.Arrays;

public class DerTALEv2ComplexFunction
extends DifferentiableFunction {
    protected double[] yCounts;
    protected int[][] xIndicators;

    public DerTALEv2ComplexFunction(double[] yCounts, int[][] xIndicators) throws IllegalArgumentException {
        this.yCounts = yCounts;
        this.xIndicators = xIndicators;
    }

    @Override
    public double evaluateFunction(double[] x) throws DimensionException, EvaluationException {
        double value = 0.0;
        int j = 0;
        while (j < this.xIndicators.length) {
            double tempBetaSum = 0.0;
            int c = 0;
            while (c < this.xIndicators[0].length) {
                tempBetaSum += (double)this.xIndicators[j][c] * x[1 + c];
                ++c;
            }
            value += Math.pow(this.yCounts[j] - (x[0] + tempBetaSum), 2.0);
            ++j;
        }
        return value;
    }

    @Override
    public int getDimensionOfScope() {
        return 1 + this.xIndicators[0].length;
    }

    @Override
    public double[] evaluateGradientOfFunction(double[] x) throws DimensionException, EvaluationException {
        double dalpha = 0.0;
        double alpha = x[0];
        int j = 0;
        while (j < this.xIndicators.length) {
            double tempBetaSum = 0.0;
            int c = 0;
            while (c < this.xIndicators[0].length) {
                tempBetaSum += (double)this.xIndicators[j][c] * x[1 + c];
                ++c;
            }
            dalpha += 2.0 * (alpha - this.yCounts[j] + tempBetaSum);
            ++j;
        }
        double[] dbeta = new double[this.xIndicators[0].length];
        Arrays.fill(dbeta, 0.0);
        int ct = 0;
        while (ct < this.xIndicators[0].length) {
            int i = 0;
            while (i < this.xIndicators.length) {
                int n;
                double tempBetaSum2 = 0.0;
                int c2 = 0;
                while (c2 < this.xIndicators[0].length) {
                    tempBetaSum2 += (double)this.xIndicators[i][c2] * x[1 + c2];
                    ++c2;
                }
                double[] array = dbeta;
                int n2 = n = ct;
                array[n2] = array[n2] + (double)(-this.xIndicators[i][ct] * 2) * (this.yCounts[i] - alpha - tempBetaSum2);
                ++i;
            }
            ++ct;
        }
        double[] dArray = new double[x.length];
        dArray[0] = dalpha;
        int c3 = 0;
        while (c3 < this.xIndicators[0].length) {
            dArray[1 + c3] = dbeta[c3];
            ++c3;
        }
        return dArray;
    }
}

