/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.markovchainrqmc;

import umontreal.ssj.markovchainrqmc.MarkovChainComparable;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.stat.Tally;

public abstract class MarkovChainDouble
extends MarkovChainComparable {
    protected double state = 0.0;
    protected int step = 0;
    protected double perf = 0.0;

    public abstract double initialStateDouble();

    @Override
    public void initialState() {
        this.step = 0;
        this.state = this.initialStateDouble();
        this.stopped = false;
    }

    public abstract double nextStepDouble(int var1, double var2, RandomStream var4);

    @Override
    public void nextStep(RandomStream stream) {
        this.state = this.nextStepDouble(this.step, this.state, stream);
        ++this.step;
    }

    public abstract double getPerformanceDouble(double var1, int var3);

    public double getPerformance(int numSteps) {
        return this.getPerformanceDouble(this.state, numSteps);
    }

    @Override
    public double getPerformance() {
        return this.perf;
    }

    @Override
    public boolean hasStopped() {
        return this.state == Double.POSITIVE_INFINITY;
    }

    @Override
    public int getStateDimension() {
        return 1;
    }

    @Override
    public int compareTo(MarkovChainComparable other, int i) {
        double os = ((MarkovChainDouble)other).state;
        return this.state < os ? -1 : (this.state > os ? 1 : 0);
    }

    public double simulStepsDouble(int numSteps, RandomStream stream) {
        this.initialState();
        this.step = 0;
        while (this.step < numSteps && !this.hasStopped()) {
            this.state = this.nextStepDouble(this.step, this.state, stream);
            ++this.step;
        }
        return this.state;
    }

    @Override
    public void simulRunsWithSubstreams(int n, int numSteps, RandomStream stream, Tally statRuns) {
        statRuns.init();
        stream.resetStartStream();
        for (int i = 0; i < n; ++i) {
            this.simulStepsDouble(numSteps, stream);
            statRuns.add(this.getPerformanceDouble(this.state, numSteps));
            stream.resetNextSubstream();
        }
    }
}

