/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.probdist.StudentDist;
import umontreal.ssj.randvar.RandomVariateGen;
import umontreal.ssj.rng.RandomStream;

public class StudentGen
extends RandomVariateGen {
    protected int n = -1;

    public StudentGen(RandomStream s, int n) {
        super(s, new StudentDist(n));
        this.setN(n);
    }

    public StudentGen(RandomStream s, StudentDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setN(dist.getN());
        }
    }

    public static double nextDouble(RandomStream s, int n) {
        return StudentDist.inverseF(n, s.nextDouble());
    }

    public int getN() {
        return this.n;
    }

    protected void setN(int nu) {
        if (nu <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        this.n = nu;
    }
}

