/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.performanceMeasures;

import de.jstacs.classifiers.performanceMeasures.AbstractPerformanceMeasure;
import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasure;
import de.jstacs.io.NonParsableException;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.utils.ToolBox;

public class ClassificationRate
extends AbstractPerformanceMeasure
implements NumericalPerformanceMeasure {
    public ClassificationRate() {
    }

    public ClassificationRate(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public String getName() {
        return "Classification rate";
    }

    @Override
    public NumericalResultSet compute(double[] sortedScoresClass0, double[] sortedScoresClass1) {
        return this.compute(sortedScoresClass0, null, sortedScoresClass1, null);
    }

    @Override
    public NumericalResultSet compute(double[][][] classSpecificScores) {
        return this.compute(classSpecificScores, null);
    }

    @Override
    public NumericalResultSet compute(double[] sortedScoresClass0, double[] weightsClass0, double[] sortedScoresClass1, double[] weightsClass1) {
        double corr = 0.0;
        double fals = 0.0;
        double w = 1.0;
        int i = 0;
        while (i < sortedScoresClass0.length) {
            if (weightsClass0 != null) {
                w = weightsClass0[i];
            }
            if (sortedScoresClass0[i] >= 0.0) {
                corr += w;
            } else {
                fals += w;
            }
            ++i;
        }
        w = 1.0;
        i = 0;
        while (i < sortedScoresClass1.length) {
            if (weightsClass1 != null) {
                w = weightsClass1[i];
            }
            if (sortedScoresClass1[i] < 0.0) {
                corr += w;
            } else {
                fals += w;
            }
            ++i;
        }
        return this.getResult(2, corr, fals);
    }

    @Override
    public NumericalResultSet compute(double[][][] classSpecificScores, double[][] weights) {
        double corr = 0.0;
        double fals = 0.0;
        int i = 0;
        while (i < classSpecificScores.length) {
            double w = 1.0;
            int j = 0;
            while (j < classSpecificScores[i].length) {
                if (weights != null && weights[i] != null) {
                    w = weights[i][j];
                }
                if (ToolBox.getMaxIndex(classSpecificScores[i][j]) == i) {
                    corr += w;
                } else {
                    fals += w;
                }
                ++j;
            }
            ++i;
        }
        return this.getResult(classSpecificScores.length, corr, fals);
    }

    private NumericalResultSet getResult(int classes, double corr, double fals) {
        return new NumericalResultSet(new NumericalResult(this.getName(), String.valueOf(this.getName()) + " for " + classes + " classes.", corr / (corr + fals)));
    }

    @Override
    public int getAllowedNumberOfClasses() {
        return 0;
    }
}

