/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.clustering.distances;

import de.jstacs.clustering.distances.DistanceMetric;

public class PNorm
extends DistanceMetric<double[]> {
    double p;
    double q;

    public PNorm(double p) {
        if (p < 1.0) {
            throw new IllegalArgumentException("p has to be larger or equal to 1.");
        }
        this.p = p;
        this.q = 1.0 / p;
    }

    @Override
    public double getDistance(double[] o1, double[] o2) throws Exception {
        if (o1 == null || o2 == null || o1.length != o2.length) {
            throw new IllegalArgumentException("The object have to have the same length.");
        }
        double sum = 0.0;
        int i = 0;
        while (i < o1.length) {
            double diff = Math.abs(o1[i] - o2[i]);
            sum += Math.pow(diff, this.p);
            ++i;
        }
        return Math.pow(sum, this.q);
    }
}

