/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.results.savers;

import de.jstacs.io.FileManager;
import de.jstacs.parameters.FileParameter;
import de.jstacs.results.TextResult;
import de.jstacs.results.savers.ResultSaver;
import de.jstacs.results.savers.ResultSaverLibrary;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;

public class TextResultSaver
implements ResultSaver<TextResult> {
    public static void register() {
        ResultSaverLibrary.register(TextResult.class, new TextResultSaver());
    }

    private TextResultSaver() {
    }

    @Override
    public String[] getFileExtensions(TextResult result) {
        String[] mimes = result.getMime().split("\\,");
        return mimes;
    }

    @Override
    public boolean writeOutput(TextResult result, File path) {
        try {
            FileParameter.FileRepresentation rep = result.getValue();
            String relPath = this.getRelative(path.getAbsolutePath());
            if (rep.getFilename() != null && new File(rep.getFilename()).exists()) {
                FileManager.copy(rep.getFilename(), relPath);
                if (result.isTempFile()) {
                    new File(rep.getFilename()).delete();
                    rep.setFilename(relPath);
                    result.setTempFile(false);
                }
            } else {
                PrintWriter wr = new PrintWriter(path);
                wr.println(rep.getContent());
                wr.close();
            }
            rep.setFilename(relPath);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private String getRelative(String path) {
        Path home = Paths.get(new File("").getAbsolutePath(), new String[0]);
        Path absolute = Paths.get(path, new String[0]);
        try {
            return home.relativize(absolute).toString();
        }
        catch (IllegalArgumentException e) {
            return path;
        }
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public boolean writeOutput(TextResult result, StringBuffer buf) {
        buf.append(result.getValue().getContent());
        return true;
    }
}

