/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.tools.ui.cli;

import de.jstacs.DataType;
import de.jstacs.io.FileManager;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.AbstractSelectionParameter;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.MultiSelectionParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.results.savers.ResultSaver;
import de.jstacs.results.savers.ResultSaverLibrary;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import de.jstacs.utils.Pair;
import de.jstacs.utils.SafeOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CLI {
    private String opt;
    private JstacsTool[] tools;
    private boolean[] configureThreads;
    private ToolParameterSet[] toolParameters;
    private HashMap<String, String>[] keyMap;
    private String description;

    public CLI(JstacsTool ... tools) throws CloneNotSupportedException {
        this((boolean[])null, tools);
    }

    public CLI(boolean[] configureThreads, JstacsTool ... tools) throws CloneNotSupportedException {
        this("", configureThreads, tools);
    }

    public CLI(String opt, boolean[] configureThreads, JstacsTool ... tools) throws CloneNotSupportedException {
        this(null, opt, configureThreads, tools);
    }

    public CLI(String description, String opt, boolean[] configureThreads, JstacsTool ... tools) throws CloneNotSupportedException {
        this.configureThreads = configureThreads == null ? new boolean[tools.length] : configureThreads;
        this.tools = tools;
        this.toolParameters = new ToolParameterSet[tools.length];
        this.keyMap = new HashMap[tools.length];
        int i = 0;
        while (i < tools.length) {
            this.toolParameters[i] = tools[i].getToolParameters();
            this.keyMap[i] = new HashMap();
            CLI.addToKeyMap("", "", this.keyMap[i], this.toolParameters[i]);
            ++i;
        }
        this.opt = opt.trim();
        if (this.opt.indexOf(32) >= 0) {
            throw new IllegalArgumentException(opt);
        }
        if (this.opt.length() > 0) {
            this.opt = " " + this.opt;
        }
        this.description = description;
    }

    private static void addToKeyMap(String pathPrefix, String keyPrefix, HashMap<String, String> hashMap, ParameterSet parameterSet) throws CloneNotSupportedException {
        boolean isExp = parameterSet instanceof ExpandableParameterSet;
        int i = 0;
        while (i < (isExp ? 1 : parameterSet.getNumberOfParameters())) {
            String key;
            String add;
            Parameter par;
            if (isExp) {
                boolean intermediate;
                ExpandableParameterSet e = (ExpandableParameterSet)parameterSet;
                boolean bl = intermediate = parameterSet.getNumberOfParameters() == 0;
                if (intermediate) {
                    e.addParameterToSet();
                }
                par = parameterSet.getParameterAt(0);
                if (intermediate) {
                    e.removeParameterFromSet();
                }
            } else {
                par = parameterSet.getParameterAt(i);
            }
            String parKey = String.valueOf(pathPrefix) + ":" + par.getName();
            String string = add = isExp ? "?" : String.valueOf(i);
            if (par.getDatatype() != DataType.PARAMETERSET) {
                key = hashMap.get(parKey);
                if (key == null) {
                    key = CLI.getKey(keyPrefix, hashMap, par);
                    hashMap.put(parKey, key);
                }
            } else if (par instanceof AbstractSelectionParameter) {
                if (par instanceof MultiSelectionParameter) {
                    throw new RuntimeException("Not implemented for " + par.getClass());
                }
                key = hashMap.get(parKey);
                if (key == null) {
                    key = CLI.getKey(keyPrefix, hashMap, par);
                    hashMap.put(parKey, key);
                }
                ParameterSet incoll = ((AbstractSelectionParameter)par).getParametersInCollection();
                HashMap copyTemp = (HashMap)hashMap.clone();
                int j = 0;
                while (j < incoll.getNumberOfParameters()) {
                    HashMap copy = (HashMap)copyTemp.clone();
                    ParameterSetContainer cont = (ParameterSetContainer)incoll.getParameterAt(j);
                    ParameterSet ps = cont.getValue();
                    if (ps instanceof ToolParameterSet) {
                        CLI.addToKeyMap(String.valueOf(pathPrefix) + ":" + add + "-" + j, String.valueOf(keyPrefix) + ((ToolParameterSet)ps).getToolName() + ".", copy, ps);
                    } else {
                        CLI.addToKeyMap(String.valueOf(pathPrefix) + ":" + add + "-" + j, keyPrefix, copy, ps);
                    }
                    hashMap.putAll(copy);
                    ++j;
                }
            } else {
                ParameterSet ps = (ParameterSet)par.getValue();
                if (ps instanceof ToolParameterSet) {
                    CLI.addToKeyMap(String.valueOf(pathPrefix) + ":" + add, String.valueOf(keyPrefix) + ((ToolParameterSet)ps).getToolName() + ".", hashMap, ps);
                } else {
                    CLI.addToKeyMap(String.valueOf(pathPrefix) + ":" + add, keyPrefix, hashMap, ps);
                }
            }
            ++i;
        }
    }

    private static String getKey(String keyPrefix, HashMap<String, String> hashMap, Parameter par) {
        Collection<String> valueSet2 = hashMap.values();
        LinkedList<String> valueSet = new LinkedList<String>(valueSet2);
        valueSet.add("outdir");
        valueSet.add("info");
        valueSet.add("threads");
        String parName = par.getName();
        String key = String.valueOf(keyPrefix) + String.valueOf(parName.charAt(0)).toLowerCase();
        if (!valueSet.contains(key)) {
            return key;
        }
        String[] temp = parName.split("\\s");
        key = "";
        int i = 0;
        while (i < temp.length) {
            key = String.valueOf(key) + temp[i].charAt(0);
            ++i;
        }
        key = String.valueOf(keyPrefix) + key.toLowerCase();
        if (!valueSet.contains(key)) {
            return key;
        }
        key = String.valueOf(keyPrefix) + parName.replaceAll("[\\s=]", "");
        int k = 1;
        String temp2 = key;
        while (valueSet.contains(temp2)) {
            temp2 = String.valueOf(key) + k;
            ++k;
        }
        return key;
    }

    private int getToolIndex(String shortName) {
        int i = 0;
        while (i < this.tools.length) {
            if (shortName.equals(this.tools[i].getShortName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void run(String[] args) throws Exception {
        int toolIndex;
        SysProtocol protocol = new SysProtocol();
        String outdir = ".";
        int n = this.tools.length == 1 ? 0 : (toolIndex = args.length > 0 ? this.getToolIndex(args[0]) : -1);
        if (toolIndex < 0) {
            String jar = "<name>.jar";
            try {
                File jarfile = new File(CLI.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
                jar = jarfile.getName();
            }
            catch (Exception jarfile) {
                // empty catch block
            }
            if (this.description != null && this.description.length() > 0) {
                System.err.println(String.valueOf(this.description) + "\n");
            }
            System.err.println("Available tools:\n");
            int i = 0;
            while (i < this.tools.length) {
                System.err.println("\t" + this.tools[i].getShortName() + " - " + this.tools[i].getToolName());
                ++i;
            }
            System.err.println();
            System.err.println("Syntax: java -jar " + jar + this.opt + " <toolname> [<parameter=value> ...]\n");
            System.err.println("Further info about the tools is given with\n\tjava -jar " + jar + this.opt + " <toolname> info\n");
            System.err.println("For tests of individual tools:\n\tjava -jar " + jar + this.opt + " <toolname> test [<verbose>]\n");
            System.err.println("Tool parameters are listed with\n\tjava -jar " + jar + this.opt + " <toolname>\n");
        } else if (args.length > 1 && args[1].equals("info") || this.tools.length == 1 && args.length > 0 && args[0].equals("info")) {
            int n2;
            System.err.println("\n" + CLI.parse(this.tools[toolIndex].getHelpText()));
            String[] ref = this.tools[toolIndex].getReferences();
            int n3 = n2 = ref == null ? 0 : ref.length;
            if (n2 > 0) {
                System.err.println("If you use this tool, please cite");
                int i = 0;
                while (i < n2) {
                    System.err.print("\n" + CLI.parse(ref[i]));
                    ++i;
                }
            }
        } else if (args.length > 1 && args[1].equals("test") || this.tools.length == 1 && args.length > 0 && args[0].equals("test")) {
            int i;
            System.err.println("\nRun tests for " + this.tools[toolIndex].getShortName() + ":");
            boolean verbose = false;
            int n4 = i = args.length > 1 && args[1].equals("test") ? 2 : 3;
            if (args.length >= i + 1) {
                verbose = Boolean.parseBoolean(args[i]);
            }
            File jarfile = new File(CLI.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            double val = JstacsTool.test(this.tools[toolIndex], jarfile.getParentFile().getAbsolutePath(), verbose);
            System.err.println("\nSummary: " + val + "\n");
        } else {
            Pair<String, Integer> pair = null;
            int threads = 1;
            try {
                pair = this.setToolParameters(this.configureThreads[toolIndex], this.tools.length == 1 ? 0 : 1, this.toolParameters[toolIndex], this.keyMap[toolIndex], args, protocol);
                outdir = pair.getFirstElement();
                threads = pair.getSecondElement();
            }
            catch (IllegalArgumentException e) {
                this.printToolParameters(toolIndex, protocol, outdir, 1);
                System.err.println("\n" + e.getMessage());
                return;
            }
            if (!this.toolParameters[toolIndex].hasDefaultOrIsSet()) {
                this.printToolParameters(toolIndex, protocol, outdir, threads);
                System.err.println("\nAt least one parameter has not been set (correctly).");
                String msg = this.toolParameters[toolIndex].getErrorMessage();
                if (msg != null) {
                    System.err.println(msg);
                }
                return;
            }
            this.printToolParameters(toolIndex, protocol, outdir, threads);
            protocol.flush();
            ToolResult results = this.tools[toolIndex].run(this.toolParameters[toolIndex], protocol, new ProgressUpdater(), threads);
            CLI.writeToolResults(results, protocol, outdir, this.tools[toolIndex], this.toolParameters[toolIndex]);
        }
    }

    public static void writeToolResults(ToolResult results, SysProtocol protocol, String outdir, JstacsTool tool, ToolParameterSet toolParameters) throws IOException {
        Result[] r;
        if (results != null) {
            ResultSet[] rs = results.getRawResult();
            r = new Result[rs[0].getNumberOfResults() + 1];
            int i = 0;
            while (i + 1 < r.length) {
                r[i] = rs[0].getResultAt(i);
                ++i;
            }
        } else {
            r = new Result[1];
        }
        r[r.length - 1] = new TextResult("protocol " + tool.getShortName(), "Result", new FileParameter.FileRepresentation("CLI-protocol.txt", protocol.getLog().toString()), "txt", tool.getToolName(), null, true);
        results = new ToolResult(results == null ? "" : results.getName(), results == null ? "" : results.getComment(), results == null ? null : results.getAnnotation(), new ResultSet(new Result[][]{r}), toolParameters, results == null ? "" : results.getToolName(), results == null ? new Date() : results.getFinishedDate());
        ResultSaver<?> saver = ResultSaverLibrary.getSaver(results.getClass());
        saver.writeOutput(results, new File(outdir));
    }

    private Pair<String, Integer> setToolParameters(boolean configureThreads, int off, ParameterSet parameterSet, HashMap<String, String> hashMap, String[] args, Protocol protocol) throws SimpleParameter.IllegalValueException, CloneNotSupportedException {
        HashMap<String, LinkedList<String>> valueMap = new HashMap<String, LinkedList<String>>();
        String outdir = ".";
        int threads = 1;
        boolean newLine = false;
        int i = off;
        while (i < args.length) {
            int idx = args[i].indexOf("=");
            if (idx < 0) {
                throw new SimpleParameter.IllegalValueException(null, "Parameter mis-specified in: " + args[i]);
            }
            String[] temp = new String[]{args[i].substring(0, idx), args[i].substring(idx + 1)};
            if ("outdir".equals(temp[0])) {
                outdir = temp[1];
            } else if (configureThreads && "threads".equals(temp[0])) {
                threads = Integer.parseInt(temp[1]);
            } else {
                LinkedList<String> v = valueMap.get(temp[0]);
                if (v == null) {
                    valueMap.put(temp[0], new LinkedList());
                }
                valueMap.get(temp[0]).add(temp[1]);
            }
            ++i;
        }
        if (newLine) {
            protocol.append("\n");
        }
        this.set("", parameterSet, hashMap, valueMap, protocol, 0);
        if (valueMap.size() > 0) {
            Iterator<String> it = valueMap.keySet().iterator();
            HashSet<String> h = new HashSet<String>();
            h.addAll(hashMap.values());
            while (it.hasNext()) {
                String k = it.next();
                if (!h.contains(k)) continue;
                throw new IllegalArgumentException("Parameter " + k + " specified multiple times or not applicable for current selection(s). Could not use value(s): " + valueMap.get(k));
            }
            throw new IllegalArgumentException("Unknown parameters: " + valueMap);
        }
        return new Pair<String, Integer>(outdir, threads);
    }

    private boolean set(String pathPrefix, ParameterSet parameters, HashMap<String, String> hashMap, HashMap<String, LinkedList<String>> valueMap, Protocol protocol, int exp) throws SimpleParameter.IllegalValueException, CloneNotSupportedException {
        boolean isExp = parameters instanceof ExpandableParameterSet;
        ParameterSet template = null;
        boolean intermediate = false;
        boolean set = false;
        ExpandableParameterSet eps = null;
        if (isExp) {
            eps = (ExpandableParameterSet)parameters;
            boolean bl = intermediate = eps.getNumberOfParameters() == 0;
            if (intermediate) {
                eps.addParameterToSet();
            }
            template = (ParameterSet)parameters.getParameterAt(0).getValue();
            if (++exp > 1) {
                throw new RuntimeException("Nested ExpandableParameterSets not implemented.");
            }
            pathPrefix = String.valueOf(pathPrefix) + ":?";
        }
        int n = (isExp ? template : parameters).getNumberOfParameters();
        int i = 0;
        while (i < n) {
            Parameter par = (isExp ? template : parameters).getParameterAt(i);
            String parKey = String.valueOf(pathPrefix) + ":" + par.getName();
            if (par.getDatatype() != DataType.PARAMETERSET || par instanceof AbstractSelectionParameter) {
                String key = hashMap.get(parKey);
                if (key == null) {
                    throw new IllegalArgumentException("Could not find a key for parameter: " + par.getName() + "\t" + parKey);
                }
                LinkedList<String> value = valueMap.get(key);
                if (value != null) {
                    if (isExp) {
                        int k = 0;
                        while (value.size() > 0) {
                            if (k >= parameters.getNumberOfParameters()) {
                                try {
                                    eps.addParameterToSet();
                                }
                                catch (CloneNotSupportedException doesnothappen) {
                                    doesnothappen.printStackTrace();
                                }
                            }
                            Parameter par2 = ((ParameterSet)parameters.getParameterAt(k).getValue()).getParameterAt(i);
                            this.setValue(par2, value.removeFirst());
                            set = true;
                            if (par2.getDatatype() == DataType.PARAMETERSET) {
                                set |= this.set(String.valueOf(pathPrefix) + ":" + i + (par2 instanceof SelectionParameter ? "-" + ((SelectionParameter)par2).getSelected() : ""), (ParameterSet)par2.getValue(), hashMap, valueMap, protocol, exp);
                            }
                            ++k;
                        }
                    } else {
                        this.setValue(par, value.removeFirst());
                        set = true;
                        if (par.getDatatype() == DataType.PARAMETERSET) {
                            set |= this.set(String.valueOf(pathPrefix) + ":" + i + (par instanceof SelectionParameter ? "-" + ((SelectionParameter)par).getSelected() : ""), (ParameterSet)par.getValue(), hashMap, valueMap, protocol, exp);
                        }
                    }
                } else if (par.getDatatype() == DataType.PARAMETERSET) {
                    set |= this.set(String.valueOf(pathPrefix) + ":" + i + (par instanceof SelectionParameter ? "-" + ((SelectionParameter)par).getSelected() : ""), (ParameterSet)par.getValue(), hashMap, valueMap, protocol, exp);
                }
                if (value != null && value.size() == 0) {
                    valueMap.remove(key);
                }
            } else {
                set |= this.set(String.valueOf(pathPrefix) + ":" + i, (ParameterSet)par.getValue(), hashMap, valueMap, protocol, exp);
            }
            ++i;
        }
        if (intermediate && !set) {
            eps.removeParameterFromSet();
        }
        return set;
    }

    private void setValue(Parameter par, String value) throws SimpleParameter.IllegalValueException {
        if (par instanceof FileParameter) {
            String mime;
            FileParameter fp = (FileParameter)par;
            String string = mime = fp.checkMimeType() ? fp.getAcceptedMimeType() : null;
            if (mime != null) {
                String[] mimes = mime.split(",");
                int i = 0;
                while (i < mimes.length && !value.endsWith("." + mimes[i])) {
                    ++i;
                }
                if (i == mimes.length) {
                    throw new SimpleParameter.IllegalValueException(fp.getName(), "Not correct mime type (" + mime + "): " + value);
                }
            }
        }
        par.setValue(value);
    }

    public static void print(String pathPrefix, HashMap<String, String> keyMap, ParameterSet parameters, String tabPrefix, Protocol protocol, String add) throws CloneNotSupportedException {
        boolean isExp = parameters instanceof ExpandableParameterSet;
        ExpandableParameterSet exp = null;
        boolean intermediate = false;
        if (isExp) {
            exp = (ExpandableParameterSet)parameters;
            boolean bl = intermediate = exp.getNumberOfParameters() == 0;
            if (intermediate) {
                exp.addParameterToSet();
            }
            parameters = (ParameterSet)parameters.getParameterAt(0).getValue();
            protocol.appendWarning(String.valueOf(tabPrefix) + "The following parameter(s) can be used " + (intermediate ? "zero or " : "") + "multiple times:\n");
            int n = exp.getNumberOfParameters();
            int k = 0;
            while (k < n) {
                ParameterSet ps2 = (ParameterSet)exp.getParameterAt(k).getValue();
                CLI.print(String.valueOf(pathPrefix) + ":?", keyMap, ps2, tabPrefix, protocol, n > 1 ? " (" + (k + 1) + ")" : "");
                ++k;
            }
        } else {
            int i = 0;
            while (i < parameters.getNumberOfParameters()) {
                String k;
                Parameter par = parameters.getParameterAt(i);
                String parKey = String.valueOf(pathPrefix) + ":" + par.getName();
                String string = k = keyMap == null ? "" : keyMap.get(parKey);
                if (par.getDatatype() != DataType.PARAMETERSET) {
                    protocol.appendWarning(String.valueOf(tabPrefix) + k + add + " - " + par.toString() + "\n");
                } else if (par instanceof AbstractSelectionParameter) {
                    if (k == null) {
                        throw new IllegalArgumentException("Could not find a key for parameter: " + par.getName() + "\t" + parKey);
                    }
                    protocol.appendWarning(String.valueOf(tabPrefix) + k + add + " - " + par.toString() + "\n");
                    ParameterSet incoll = ((AbstractSelectionParameter)par).getParametersInCollection();
                    char[] array = new char[k.length() + 3];
                    Arrays.fill(array, ' ');
                    String off = String.valueOf(tabPrefix) + new String(array);
                    int j = 0;
                    while (j < incoll.getNumberOfParameters()) {
                        ParameterSetContainer cont = (ParameterSetContainer)incoll.getParameterAt(j);
                        if (cont.getValue().getNumberOfParameters() > 0) {
                            protocol.appendWarning(String.valueOf(off) + "Parameters for selection \"" + cont.getName() + "\":\n");
                            CLI.print(String.valueOf(pathPrefix) + ":" + i + "-" + j, keyMap, cont.getValue(), String.valueOf(off) + "\t", protocol, add);
                        } else {
                            protocol.appendWarning(String.valueOf(off) + "No parameters for selection \"" + cont.getName() + "\"\n");
                        }
                        ++j;
                    }
                } else {
                    ParameterSet ps = (ParameterSet)par.getValue();
                    boolean b = ps instanceof ToolParameterSet;
                    if (b) {
                        protocol.appendWarning("\n" + ((ToolParameterSet)ps).getToolName() + " parameters" + "\n");
                    }
                    CLI.print(String.valueOf(pathPrefix) + ":" + i, keyMap, ps, String.valueOf(tabPrefix) + (!b ? "\t" : ""), protocol, add);
                    if (b) {
                        protocol.appendWarning("\n");
                    }
                }
                ++i;
            }
        }
        if (intermediate) {
            exp.removeParameterFromSet();
        }
    }

    private static void printTable(String prefix, HashMap<String, String> keyMap, ParameterSet parameters, StringBuffer out) throws CloneNotSupportedException {
        boolean isExp = parameters instanceof ExpandableParameterSet;
        boolean intermediate = false;
        ExpandableParameterSet e = null;
        if (isExp) {
            e = (ExpandableParameterSet)parameters;
            boolean bl = intermediate = e.getNumberOfParameters() == 0;
            if (intermediate) {
                e.addParameterToSet();
            }
            out.append("<tr><td colspan=3>The following parameter(s) can be used " + (intermediate ? "zero or " : "") + "multiple times:</td></tr>\n" + "<tr><td></td><td colspan=2><table border=0 cellpadding=0 align=\"center\" width=\"100%\">\n");
        }
        int i = 0;
        while (i < parameters.getNumberOfParameters()) {
            String add;
            Parameter par = parameters.getParameterAt(i);
            String parKey = String.valueOf(prefix) + ":" + par.getName();
            String string = add = isExp ? "?" : String.valueOf(i);
            if (par.getDatatype() == DataType.PARAMETERSET && !(par instanceof AbstractSelectionParameter)) {
                ParameterSet ps = (ParameterSet)par.getValue();
                CLI.printTable(String.valueOf(prefix) + ":" + add, keyMap, ps, out);
            } else {
                out.append("<tr style=\"vertical-align:top\">\n<td><font color=\"green\">" + keyMap.get(parKey) + "</font></td>\n");
                String s = par.toString();
                out.append("<td>" + s.substring(0, s.lastIndexOf(")\t= ") + 1) + "</td>\n");
                if (par.getDatatype() != DataType.PARAMETERSET) {
                    out.append("<td style=\"width:100px;\">" + (Object)((Object)par.getDatatype()) + "</td>\n</tr>\n");
                } else {
                    out.append("<td style=\"width:100px;\">STRING</td></tr>\n");
                    out.append("<tr><td></td><td colspan=2><table border=0 cellpadding=0 align=\"center\" width=\"100%\">\n");
                    ParameterSet incoll = ((AbstractSelectionParameter)par).getParametersInCollection();
                    int j = 0;
                    while (j < incoll.getNumberOfParameters()) {
                        ParameterSetContainer cont = (ParameterSetContainer)incoll.getParameterAt(j);
                        if (cont.getValue().getNumberOfParameters() > 0) {
                            out.append("<tr><td colspan=3><b>Parameters for selection &quot;" + cont.getName() + "&quot;:</b></td></tr>\n");
                            CLI.printTable(String.valueOf(prefix) + ":" + add + "-" + j, keyMap, cont.getValue(), out);
                        } else {
                            out.append("<tr><td colspan=3><b>No parameters for selection &quot;" + cont.getName() + "&quot;</b></td></tr>\n");
                        }
                        ++j;
                    }
                    out.append("</table></td></tr>\n");
                }
            }
            ++i;
        }
        if (isExp) {
            out.append("</table>\n</td></tr>\n");
            if (intermediate) {
                e.removeParameterFromSet();
            }
        }
    }

    private void printToolParameters(int toolIndex, Protocol protocol, String outdir, int threads) throws CloneNotSupportedException {
        ToolParameterSet ps = this.toolParameters[toolIndex];
        protocol.appendWarning("Parameters of tool \"" + this.tools[toolIndex].getToolName() + "\" (" + this.tools[toolIndex].getShortName() + ", version: " + this.tools[toolIndex].getToolVersion() + "):\n");
        CLI.print("", this.keyMap[toolIndex], ps, "", protocol, "");
        protocol.appendWarning("outdir - The output directory, defaults to the current working directory (.)\t= " + outdir + "\n");
        if (this.configureThreads[toolIndex]) {
            protocol.appendWarning("threads - The number of threads used for the tool, defaults to 1\t= " + threads + "\n");
        }
    }

    public void wiki() throws IOException {
        this.wiki("");
    }

    public void wiki(String home) {
        File h = new File(String.valueOf(home) + "/");
        h.mkdirs();
        int toolIndex = 0;
        while (toolIndex < this.keyMap.length) {
            try {
                StringBuffer old = null;
                File f = new File(String.valueOf(home) + "/" + this.tools[toolIndex].getShortName() + ".txt");
                if (f.exists()) {
                    old = FileManager.readFile(f);
                }
                StringBuffer current = this.wikiTable(toolIndex);
                if (old == null || !current.toString().equals(old.toString())) {
                    FileManager.writeFile(f, (CharSequence)current);
                    if (old != null) {
                        FileManager.writeFile(String.valueOf(home) + "/" + this.tools[toolIndex].getShortName() + ".bak", (CharSequence)old);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++toolIndex;
        }
    }

    private StringBuffer wikiTable(int toolIndex) throws CloneNotSupportedException {
        ToolParameterSet ps = this.toolParameters[toolIndex];
        StringBuffer current = new StringBuffer();
        current.append("<table border=0 cellpadding=10 align=\"center\" width=\"100%\">\n<tr>\n<td>name</td>\n<td>comment</td>\n<td>type</td>\n</tr>\n<tr><td colspan=3><hr></td></tr>\n");
        CLI.printTable("", this.keyMap[toolIndex], ps, current);
        current.append("<tr style=\"vertical-align:top\">\n<td><font color=\"green\">outdir</font></td>\n");
        current.append("<td>The output directory, defaults to the current working directory (.)</td>\n");
        current.append("<td>STRING</td>\n</tr>\n");
        if (this.configureThreads[toolIndex]) {
            current.append("<tr style=\"vertical-align:top\">\n<td><font color=\"green\">threads</font></td>\n");
            current.append("<td>The number of threads used for the tool, defaults to 1</td>\n");
            current.append("<td>INT</td>\n</tr>\n");
        }
        current.append("</table>");
        return current;
    }

    public StringBuffer wikiPage(String jarname) {
        StringBuffer all = new StringBuffer("== Tools ==\n\n");
        int toolIndex = 0;
        while (toolIndex < this.keyMap.length) {
            try {
                StringBuffer current = new StringBuffer();
                current.append("=== " + this.tools[toolIndex].getToolName() + " ===\n\n");
                current.append(this.parseHelpToWiki(this.tools[toolIndex]));
                current.append("\n");
                current.append("''" + this.tools[toolIndex].getToolName() + "'' may be called with\n\n" + " java -jar " + jarname + " " + this.tools[toolIndex].getShortName() + "\n\n" + "and has the following parameters\n\n");
                current.append(this.wikiTable(toolIndex));
                current.append("\n\n'''Example:'''\n\n ");
                StringBuffer cmd = new StringBuffer("java -jar " + jarname + " " + this.tools[toolIndex].getShortName());
                CLI.addRequiredParameters(this.keyMap[toolIndex], "", cmd, this.tools[toolIndex].getToolParameters());
                current.append(XMLParser.escape(cmd.toString()));
                current.append("\n\n\n");
                all.append(current);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++toolIndex;
        }
        return all;
    }

    private static void addRequiredParameters(HashMap<String, String> hashMap, String prefix, StringBuffer current, ParameterSet ps) {
        boolean isExp = ps instanceof ExpandableParameterSet;
        int i = 0;
        while (i < ps.getNumberOfParameters()) {
            Parameter par = ps.getParameterAt(i);
            String add = isExp ? "?" : String.valueOf(i);
            Object o = par.getValue();
            boolean isPS = o instanceof ParameterSet;
            if (par.isRequired() && !par.hasDefaultOrIsSet()) {
                String parKey = String.valueOf(prefix) + ":" + par.getName();
                if (!isPS) {
                    current.append(" " + hashMap.get(parKey) + "=<" + par.getName().replaceAll("\\s", "_") + ">");
                } else if (!(par instanceof AbstractSelectionParameter)) {
                    CLI.addRequiredParameters(hashMap, String.valueOf(prefix) + ":" + add, current, (ParameterSet)o);
                } else {
                    AbstractSelectionParameter asp = (AbstractSelectionParameter)par;
                    ParameterSet incoll = asp.getParametersInCollection();
                    int j = 0;
                    while (j < incoll.getNumberOfParameters()) {
                        if (asp.isSelected(j)) {
                            ParameterSetContainer cont = (ParameterSetContainer)incoll.getParameterAt(j);
                            CLI.addRequiredParameters(hashMap, String.valueOf(prefix) + ":" + add + "-" + j, current, cont.getValue());
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    private String parseHelpToWiki(JstacsTool tool) {
        String restruct = tool.getHelpText();
        String[] lines = restruct.split("\n");
        Pattern bold = Pattern.compile("\\*\\*(.+?)\\*\\*");
        Pattern italics = Pattern.compile("\\*(.+?)\\*");
        Pattern tt = Pattern.compile("\\`\\`(.+?)\\`\\`");
        Pattern amp = Pattern.compile("\"");
        Pattern link = Pattern.compile("^\\.\\.\\s+\\_(.*?)\\s*\\:\\s*(.*)$");
        HashMap<Pattern, String> linkTargets = new HashMap<Pattern, String>();
        boolean inVerbose = false;
        int i = 0;
        while (i < lines.length) {
            if (inVerbose && lines[i].startsWith("\t")) {
                lines[i] = " " + lines[i].substring(1);
            } else {
                if (inVerbose) {
                    inVerbose = false;
                }
                Matcher m = bold.matcher(lines[i]);
                lines[i] = m.replaceAll("'''$1'''");
                m = italics.matcher(lines[i]);
                lines[i] = m.replaceAll("''$1''");
                if (lines[i].endsWith("::")) {
                    lines[i] = lines[i].substring(0, lines[i].length() - 1);
                    inVerbose = true;
                }
                m = tt.matcher(lines[i]);
                lines[i] = m.replaceAll("<code>$1</code>");
                m = amp.matcher(lines[i]);
                lines[i] = m.replaceAll("&quot;");
                m = link.matcher(lines[i]);
                if (m.matches()) {
                    String key = m.group(1);
                    String target = m.group(2);
                    linkTargets.put(Pattern.compile("\\`?(" + key + ")\\`?\\_"), target);
                    lines[i] = "";
                } else {
                    lines[i] = lines[i];
                }
            }
            ++i;
        }
        i = 0;
        while (i < lines.length) {
            Set pats = linkTargets.keySet();
            for (Pattern pat : pats) {
                Matcher m = pat.matcher(lines[i]);
                lines[i] = m.replaceAll("[" + (String)linkTargets.get(pat) + " $1]");
            }
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < lines.length) {
            sb.append(lines[i2]);
            sb.append("\n");
            ++i2;
        }
        return sb.toString();
    }

    private static String parse(String restruct) {
        String[] lines = restruct.split("\n");
        Pattern bold = Pattern.compile("\\*\\*(.+?)\\*\\*");
        Pattern italics = Pattern.compile("\\*(.+?)\\*");
        Pattern tt = Pattern.compile("\\`\\`(.+?)\\`\\`");
        Pattern link = Pattern.compile("^\\.\\.\\s+\\_(.*?)\\s*\\:\\s*(.*)$");
        HashMap<Pattern, String> linkTargets = new HashMap<Pattern, String>();
        int i = 0;
        while (i < lines.length) {
            Matcher m = bold.matcher(lines[i]);
            lines[i] = m.replaceAll("\u00a7$1\u00a7");
            m = italics.matcher(lines[i]);
            lines[i] = m.replaceAll("'$1'");
            lines[i] = lines[i].replaceAll("\u00a7", "*");
            m = tt.matcher(lines[i]);
            lines[i] = m.replaceAll("$1");
            m = link.matcher(lines[i]);
            if (m.matches()) {
                String key = m.group(1);
                String target = m.group(2);
                linkTargets.put(Pattern.compile("\\`?(" + key + ")\\`?\\_"), target);
                lines[i] = "";
            }
            ++i;
        }
        i = 0;
        while (i < lines.length) {
            Set pats = linkTargets.keySet();
            for (Pattern pat : pats) {
                Matcher m = pat.matcher(lines[i]);
                lines[i] = m.replaceAll("$1 (" + (String)linkTargets.get(pat) + ")");
            }
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < lines.length) {
            sb.append(lines[i2]);
            sb.append("\n");
            ++i2;
        }
        return sb.toString();
    }

    public static class QuietSysProtocol
    extends SysProtocol {
        public QuietSysProtocol() {
            this.out = new PrintStream(SafeOutputStream.getSafeOutputStream(null));
            this.err = new PrintStream(SafeOutputStream.getSafeOutputStream(null));
        }
    }

    public static class SysProtocol
    implements Protocol {
        private StringBuffer log = new StringBuffer();
        protected PrintStream out = System.out;
        protected PrintStream err = System.err;

        @Override
        public void append(String str) {
            this.out.print(str);
            this.log.append(str);
        }

        @Override
        public void appendHeading(String heading) {
            this.out.print("* " + heading);
            this.log.append("* " + heading);
        }

        @Override
        public void appendWarning(String warning) {
            this.err.print(warning);
            this.log.append(warning);
        }

        public StringBuffer getLog() {
            return this.log;
        }

        @Override
        public void appendThrowable(Throwable th) {
            StringWriter str = new StringWriter();
            th.printStackTrace(new PrintWriter(str));
            String strstr = str.toString();
            this.err.println(strstr);
            this.log.append(strstr);
        }

        @Override
        public void appendVerbatim(String verbatim) {
            this.append(verbatim);
        }

        @Override
        public void flush() {
            this.err.flush();
            this.out.flush();
        }
    }
}

