/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index.linear;

import htsjdk.tribble.Feature;
import htsjdk.tribble.index.Block;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.TribbleIndexCreator;
import htsjdk.tribble.index.linear.LinearIndex;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;

public class LinearIndexCreator
extends TribbleIndexCreator {
    public static int DEFAULT_BIN_WIDTH = 8000;
    private int binWidth = DEFAULT_BIN_WIDTH;
    private final File inputFile;
    private final LinkedList<LinearIndex.ChrIndex> chrList = new LinkedList();
    private int longestFeature = 0;
    private final ArrayList<Block> blocks = new ArrayList();

    public LinearIndexCreator(File inputFile, int binSize) {
        this.inputFile = inputFile;
        this.binWidth = binSize;
    }

    public LinearIndexCreator(File inputFile) {
        this(inputFile, DEFAULT_BIN_WIDTH);
    }

    @Override
    public void addFeature(Feature feature, long filePosition) {
        if (this.chrList.isEmpty() || !this.chrList.getLast().getName().equals(feature.getChr())) {
            if (!this.chrList.isEmpty()) {
                for (int x = 0; x < this.blocks.size(); ++x) {
                    this.blocks.get(x).setEndPosition(x + 1 == this.blocks.size() ? filePosition : this.blocks.get(x + 1).getStartPosition());
                    this.chrList.getLast().addBlock(this.blocks.get(x));
                }
            }
            this.chrList.add(new LinearIndex.ChrIndex(feature.getChr(), this.binWidth));
            this.blocks.clear();
            this.blocks.add(new Block(filePosition, 0L));
            this.longestFeature = 0;
        }
        while (feature.getStart() > this.blocks.size() * this.binWidth) {
            this.blocks.add(new Block(filePosition, 0L));
        }
        if (feature.getEnd() - feature.getStart() + 1 > this.longestFeature) {
            this.longestFeature = feature.getEnd() - feature.getStart() + 1;
            this.chrList.getLast().updateLongestFeature(this.longestFeature);
        }
        this.chrList.getLast().incrementFeatureCount();
    }

    @Override
    public Index finalizeIndex(long finalFilePosition) {
        if (finalFilePosition == 0L) {
            throw new IllegalArgumentException("finalFilePosition != 0, -> " + finalFilePosition);
        }
        for (int x = 0; x < this.blocks.size(); ++x) {
            this.blocks.get(x).setEndPosition(x + 1 == this.blocks.size() ? finalFilePosition : this.blocks.get(x + 1).getStartPosition());
            this.chrList.getLast().addBlock(this.blocks.get(x));
        }
        this.blocks.clear();
        LinearIndex index = new LinearIndex(this.chrList, this.inputFile);
        index.addProperties(this.properties);
        index.finalizeIndex();
        return index.optimize();
    }

    public int defaultBinSize() {
        return DEFAULT_BIN_WIDTH;
    }

    public int getBinSize() {
        return this.binWidth;
    }
}

