/*
 * Decompiled with CFR 0.152.
 */
package projects.dimont.hts;

import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.utils.ComparableElement;
import java.util.Arrays;
import javax.naming.OperationNotSupportedException;
import projects.dimont.hts.DimontTool;

public enum HTS_KmerFilter {
    HUDDINGE_DISTANCE,
    MINIMUM_HAMMING_DISTANCE;


    /*
     * Enabled aggressive block sorting
     */
    static ComparableElement<String, Double>[] apply(int numWanted, ComparableElement<String, Double>[] kmersWithWeights, HTS_KmerFilter type) throws Exception {
        ComparableElement[] kmerSequenceStatistic = null;
        Arrays.sort(kmersWithWeights);
        if (numWanted > kmersWithWeights.length) {
            numWanted = kmersWithWeights.length;
        }
        kmerSequenceStatistic = new ComparableElement[numWanted];
        Sequence[] previouslyFoundKmers = new Sequence[numWanted];
        int nextKmerIndex = kmerSequenceStatistic.length - 1;
        switch (type) {
            case MINIMUM_HAMMING_DISTANCE: {
                int i = kmersWithWeights.length - 1;
                while (true) {
                    if (i < 0) {
                        return kmerSequenceStatistic;
                    }
                    String s = kmersWithWeights[i].getElement();
                    Sequence potentialTopKmer = Sequence.create(DNAAlphabetContainer.SINGLETON, s);
                    int j = kmerSequenceStatistic.length - 1;
                    while (true) {
                        if (j <= nextKmerIndex) {
                            kmerSequenceStatistic[nextKmerIndex] = kmersWithWeights[i];
                            previouslyFoundKmers[nextKmerIndex] = potentialTopKmer;
                            if (--nextKmerIndex >= 0) break;
                            return kmerSequenceStatistic;
                        }
                        Sequence previouslyFoundKmer = previouslyFoundKmers[j];
                        if (DimontTool.getMinimumHammingDistance(potentialTopKmer, previouslyFoundKmer) < 2) break;
                        --j;
                    }
                    --i;
                }
            }
            case HUDDINGE_DISTANCE: {
                int i = kmersWithWeights.length - 1;
                while (i >= 0) {
                    String s = kmersWithWeights[i].getElement();
                    Sequence potentialTopKmer = Sequence.create(DNAAlphabetContainer.SINGLETON, s);
                    int j = kmerSequenceStatistic.length - 1;
                    while (true) {
                        if (j <= nextKmerIndex) {
                            kmerSequenceStatistic[nextKmerIndex] = kmersWithWeights[i];
                            previouslyFoundKmers[nextKmerIndex] = potentialTopKmer;
                            if (--nextKmerIndex >= 0) break;
                            return kmerSequenceStatistic;
                        }
                        Sequence previouslyFoundKmer = previouslyFoundKmers[j];
                        if (HTS_KmerFilter.getHuddingeDistance(potentialTopKmer, previouslyFoundKmer) < 2) break;
                        --j;
                    }
                    --i;
                }
                return kmerSequenceStatistic;
            }
        }
        return kmerSequenceStatistic;
    }

    private static int getHuddingeDistance(Sequence seq1, Sequence seq2) throws OperationNotSupportedException {
        if (seq2.getLength() > seq1.getLength()) {
            Sequence helper = seq1;
            seq1 = seq2;
            seq2 = helper;
        }
        Sequence revComplement1 = seq1.reverseComplement();
        int minHammingDist = seq2.getLength();
        int lengthDiff = seq1.getLength() - seq2.getLength();
        int start1 = 0;
        while (start1 <= lengthDiff && minHammingDist > 0) {
            minHammingDist = HTS_KmerFilter.helper(seq1, seq2, start1, 0, minHammingDist);
            minHammingDist = HTS_KmerFilter.helper(revComplement1, seq2, start1, 0, minHammingDist);
            ++start1;
        }
        int shift = 1;
        while (shift < minHammingDist) {
            minHammingDist = shift + HTS_KmerFilter.helper(seq1, seq2, 0, shift, minHammingDist - shift);
            minHammingDist = shift + HTS_KmerFilter.helper(revComplement1, seq2, 0, shift, minHammingDist - shift);
            minHammingDist = shift + HTS_KmerFilter.helper(seq1, seq2, lengthDiff + shift, 0, minHammingDist - shift);
            minHammingDist = shift + HTS_KmerFilter.helper(revComplement1, seq2, lengthDiff + shift, 0, minHammingDist - shift);
            ++shift;
        }
        return minHammingDist + lengthDiff;
    }

    private static int helper(Sequence seq1, Sequence seq2, int start1, int start2, int currentDist) {
        int overlapLength = Math.min(seq1.getLength() - start1, seq2.getLength() - start2);
        int distance = 0;
        int i = 0;
        while (i < overlapLength && distance < currentDist) {
            distance += seq1.continuousVal(start1 + i) == seq2.continuousVal(start2 + i) ? 0 : 1;
            ++i;
        }
        return distance;
    }
}

