/*
 * Decompiled with CFR 0.152.
 */
package projects.encodedream;

import de.jstacs.utils.Pair;
import de.jstacs.utils.ToolBox;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import projects.encodedream.ObjectStream;

public class Pileup {
    public static byte[] map;
    public static char[] invMap;

    static {
        invMap = new char[]{'A', 'C', 'G', 'T', '+', '-'};
        map = new byte[256];
        Arrays.fill(map, (byte)-1);
        Pileup.map[65] = 0;
        Pileup.map[67] = 1;
        Pileup.map[71] = 2;
        Pileup.map[84] = 3;
    }

    public static void main(String[] args) throws IOException {
        ObjectStream ps = new ObjectStream(10000);
        new Thread(() -> {
            try {
                Pileup.pileup(args[0], ps, true, false);
                ps.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
        ps.print(System.out);
    }

    public static void pileup(String bam, ObjectStream<? extends CovPile> piles, boolean variants, boolean coverage) throws IOException {
        Pileup.pileup(bam, piles, variants, coverage, true);
    }

    public static void pileup(String bam, ObjectStream<? extends CovPile> piles, boolean variants, boolean coverage, boolean useClipping) throws IOException {
        SamReaderFactory srf = SamReaderFactory.makeDefault();
        srf.validationStringency(ValidationStringency.SILENT);
        SamReader sr = srf.open(new File(bam));
        SAMRecordIterator samIt = sr.iterator();
        samIt = samIt.assertSorted(SAMFileHeader.SortOrder.coordinate);
        byte[] map = new byte[256];
        Arrays.fill(map, (byte)-1);
        map[65] = 0;
        map[67] = 1;
        map[71] = 2;
        map[84] = 3;
        int[][] counts = null;
        HashMap<Integer, LinkedList<String>> insertions = null;
        if (variants) {
            counts = new int[10000][7];
            insertions = new HashMap<Integer, LinkedList<String>>();
        }
        int[] totalCount = null;
        if (coverage) {
            totalCount = new int[10000];
        }
        int refOff = 0;
        int maxEnd = 0;
        String oldChr = null;
        while (samIt.hasNext()) {
            int idx;
            SAMRecord rec = (SAMRecord)samIt.next();
            if (rec.getReadUnmappedFlag() || rec.getMappingQuality() <= 0) continue;
            int refStart = useClipping ? rec.getStart() : rec.getUnclippedStart();
            String chr = rec.getReferenceName();
            if (refStart < refOff && oldChr != null && chr.equals(oldChr)) {
                System.err.println("WARNING not sorted according to " + (useClipping ? "clipped" : "unclipped") + " coordinates: " + refStart + " <-> " + refOff);
                System.err.println(rec.getReadName());
            }
            if (oldChr != null && !chr.equals(oldChr)) {
                Pileup.collect(piles, counts, totalCount, oldChr, refOff, maxEnd, maxEnd, insertions);
                refOff = 0;
                maxEnd = 0;
                if (variants) {
                    counts = new int[10000][7];
                    insertions.clear();
                }
                if (coverage) {
                    totalCount = new int[10000];
                }
            }
            oldChr = chr;
            Pileup.collect(piles, counts, totalCount, chr, refOff, refStart, maxEnd, insertions);
            refOff = refStart;
            int refEnd = rec.getAlignmentEnd() + 1;
            int len = rec.getReadLength();
            byte[] bases = rec.getReadBases();
            int lastRefPos = -1;
            if (variants) {
                int i = 1;
                while (i <= len) {
                    int idx2;
                    int pos = rec.getReferencePositionAtReadPosition(i);
                    int insStart = i;
                    while (pos == 0 && i < len) {
                        pos = rec.getReferencePositionAtReadPosition(++i);
                    }
                    if (i > insStart) {
                        idx2 = lastRefPos - refOff;
                        int[] nArray = counts[idx2];
                        nArray[4] = nArray[4] + 1;
                        insertions.putIfAbsent(lastRefPos, new LinkedList());
                        insertions.get(lastRefPos).add(rec.getReadString().substring(insStart, i));
                    }
                    if (lastRefPos > -1 && pos - 1 != lastRefPos) {
                        int j = lastRefPos + 1;
                        while (j < pos) {
                            int idx3 = j - refOff;
                            int[] nArray = counts[idx3];
                            nArray[5] = nArray[5] + 1;
                            ++j;
                        }
                    }
                    idx2 = pos - refOff;
                    if (map[bases[i - 1]] >= 0) {
                        int[] nArray = counts[idx2];
                        byte by = map[bases[i - 1]];
                        nArray[by] = nArray[by] + 1;
                    } else {
                        int[] nArray = counts[idx2];
                        nArray[6] = nArray[6] + 1;
                    }
                    if (pos > 0) {
                        lastRefPos = pos;
                    }
                    ++i;
                }
            }
            if (coverage && !rec.getReadNegativeStrandFlag()) {
                int n = idx = (useClipping ? rec.getStart() : rec.getUnclippedStart()) - refOff;
                totalCount[n] = totalCount[n] + 1;
            } else if (coverage && rec.getReadNegativeStrandFlag()) {
                int n = idx = (useClipping ? rec.getEnd() : rec.getUnclippedEnd()) - refOff;
                totalCount[n] = totalCount[n] + 1;
            }
            if (refEnd <= maxEnd) continue;
            maxEnd = refEnd;
        }
        Pileup.collect(piles, counts, totalCount, oldChr, refOff, maxEnd, maxEnd, insertions);
        sr.close();
    }

    private static void collect(ObjectStream<CovPile> out, int[][] counts, int[] totalCounts, String chr, int refOff, int refStart, int maxEnd, HashMap<Integer, LinkedList<String>> inserts) {
        int i = refOff;
        while (i < Math.min(refStart, maxEnd)) {
            CovPile pile;
            int locIdx = i - refOff;
            HashMap<String, Integer> insMap = null;
            if (inserts != null && inserts.containsKey(i)) {
                insMap = new HashMap<String, Integer>();
                LinkedList<String> myIns = inserts.remove(i);
                for (String key : myIns) {
                    if (insMap.containsKey(key)) {
                        insMap.put(key, (Integer)insMap.get(key) + 1);
                        continue;
                    }
                    insMap.put(key, 1);
                }
            }
            if (counts != null) {
                pile = new Pile(chr, i, counts[locIdx][0], counts[locIdx][1], counts[locIdx][2], counts[locIdx][3], counts[locIdx][6], counts[locIdx][4], counts[locIdx][5], totalCounts != null ? totalCounts[locIdx] : -1, insMap);
                out.add(pile);
            } else if (totalCounts != null) {
                pile = new CovPile(chr, i, totalCounts[locIdx]);
                out.add(pile);
            }
            ++i;
        }
        if (counts != null) {
            if (refStart - refOff > 0 && refStart - refOff < counts.length) {
                System.arraycopy(counts, refStart - refOff, counts, 0, counts.length - (refStart - refOff));
            }
            i = Math.max(0, counts.length - (refStart - refOff));
            while (i < counts.length) {
                counts[i] = new int[counts[i].length];
                ++i;
            }
        }
        if (totalCounts != null) {
            if (refStart - refOff > 0 && refStart - refOff < totalCounts.length) {
                System.arraycopy(totalCounts, refStart - refOff, totalCounts, 0, totalCounts.length - (refStart - refOff));
            }
            i = Math.max(0, totalCounts.length - (refStart - refOff));
            while (i < totalCounts.length) {
                totalCounts[i] = 0;
                ++i;
            }
        }
    }

    public static class CovPile {
        String chr;
        int pos;
        int five_prime;

        public CovPile(String chr, int pos, int five_prime) {
            this.chr = chr;
            this.pos = pos;
            this.five_prime = five_prime;
        }

        public String toString() {
            return String.valueOf(this.chr) + "\t" + this.pos + "\t" + this.five_prime;
        }

        public String getChr() {
            return this.chr;
        }

        public int getFivePrime() {
            return this.five_prime;
        }

        public int getPos() {
            return this.pos;
        }
    }

    public static class Pile
    extends CovPile {
        int a;
        int c;
        int g;
        int t;
        int n;
        int in;
        int del;
        HashMap<String, Integer> inserts;

        public Pile(String chr, int pos, int a, int c, int g, int t, int n, int in, int del, int five_prime, HashMap<String, Integer> inserts) {
            super(chr, pos, five_prime);
            this.a = a;
            this.c = c;
            this.g = g;
            this.t = t;
            this.n = n;
            this.in = in;
            this.del = del;
            this.inserts = inserts;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + "\t" + this.a + "\t" + this.c + "\t" + this.g + "\t" + this.t + "\t" + this.in + "\t" + this.del + "\t" + (this.inserts == null ? "" : this.inserts.toString());
        }

        public int getCount(int cas) {
            switch (cas) {
                case 0: {
                    return this.a;
                }
                case 1: {
                    return this.c;
                }
                case 2: {
                    return this.g;
                }
                case 3: {
                    return this.t;
                }
                case 4: {
                    return this.in;
                }
                case 5: {
                    return this.del;
                }
                case 6: {
                    return this.n;
                }
            }
            return -1;
        }

        public int[] getVariants(int ref) {
            double[] temp = new double[]{this.a, this.c, this.g, this.t, -1.0, this.del};
            temp[ref] = -1.0;
            int[] o = ToolBox.order(temp, true);
            int[] o2 = new int[]{o[0], o[1]};
            return o2;
        }

        public int getSum() {
            return this.a + this.c + this.g + this.t + this.del + this.n;
        }

        public Pair<String, int[]> getMostFrequentInsert() {
            int nIns = 0;
            int n = 0;
            String insStr = null;
            if (this.inserts != null) {
                for (String key : this.inserts.keySet()) {
                    int val = this.inserts.get(key);
                    if (val > nIns) {
                        nIns = val;
                        insStr = key;
                    }
                    n += val;
                }
            }
            return new Pair<Object, int[]>(insStr, new int[]{nIns, n - nIns});
        }
    }
}

