/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma;

import de.jstacs.DataType;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import projects.gemoma.GeMoMaModule;

public class NCBIReferenceRetriever
extends GeMoMaModule {
    @Override
    public ToolParameterSet getToolParameters() {
        try {
            return new ToolParameterSet(this.getToolName(), new SimpleParameter(DataType.STRING, "reference directory", "the directory where the genome and annotation files of the reference organisms should be stored", true, "references/"), new SimpleParameter(DataType.INT, "number of tries", "the number of tries for downloading a reference file", true, new NumberValidator<Integer>(1, 100), 10), new FileParameter("reference list", "a list of reference organisms", "txt", true));
        }
        catch (ParameterException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads, String temp) throws Exception {
        String line;
        String base = "https://www.ncbi.nlm.nih.gov/genome/?term=";
        String outdir = (String)parameters.getParameterForName("reference directory").getValue();
        int max = (Integer)parameters.getParameterForName("number of tries").getValue();
        FileParameter fp = (FileParameter)parameters.getParameterForName("reference list");
        ArrayList<String> ref = new ArrayList<String>();
        BufferedReader re = new BufferedReader(new FileReader(fp.getValue().toString()));
        while ((line = re.readLine()) != null) {
            ref.add(line);
        }
        re.close();
        progress.setLast(ref.size() * 2);
        progress.setCurrent(0.0);
        BufferedReader buffer = null;
        ArrayList<String> needToBeDownloaded = new ArrayList<String>();
        ArrayList<String> downloaded = new ArrayList<String>();
        ArrayList<String> check = new ArrayList<String>();
        for (String r : ref) {
            String url = String.valueOf(base) + r.replaceAll(" ", "+");
            protocol.append(String.valueOf(r) + "\t" + url + "\n");
            buffer = new BufferedReader(new InputStreamReader(new URL(url).openStream(), "iso-8859-9"));
            StringBuffer builder = new StringBuffer();
            while ((line = buffer.readLine()) != null) {
                builder.append(String.valueOf(line) + "\n");
            }
            buffer.close();
            String genome = NCBIReferenceRetriever.getLink(builder, "Download sequences in FASTA format for");
            String annotation = NCBIReferenceRetriever.getLink(builder, "Download genome annotation in");
            if (genome.length() == 0 || annotation.length() == 0) {
                check.add(r);
            }
            NCBIReferenceRetriever.download(protocol, max, outdir, genome, downloaded, needToBeDownloaded);
            progress.add(1.0);
            NCBIReferenceRetriever.download(protocol, max, outdir, annotation, downloaded, needToBeDownloaded);
            progress.add(1.0);
            protocol.append("\n");
        }
        if (downloaded.size() > 0) {
            protocol.append("Downloaded " + downloaded.size() + " file(s):\n");
            for (String f : downloaded) {
                protocol.append(String.valueOf(f) + "\n");
            }
        }
        protocol.append("\n");
        if (needToBeDownloaded.size() == 0) {
            protocol.append("Nothing to download\n");
        } else {
            protocol.append("Please download " + needToBeDownloaded.size() + " file(s):\n");
            for (String f : needToBeDownloaded) {
                protocol.append(f);
            }
        }
        if (check.size() > 0) {
            protocol.append("\n");
            protocol.appendWarning("Please check the following " + check.size() + " reference species:\n");
            for (String f : check) {
                protocol.appendWarning(String.valueOf(f) + "\n");
            }
        }
        return null;
    }

    static String getLink(StringBuffer content, String pattern) {
        int idx = content.indexOf(pattern);
        if (idx >= 0) {
            idx += pattern.length();
            idx = content.indexOf("href=\"", idx) + 6;
            return content.substring(idx, content.indexOf("\"", idx));
        }
        return "";
    }

    static void download(Protocol protocol, int max, String outdir, String link, ArrayList<String> downloaded, ArrayList<String> needToBeDownloaded) throws URISyntaxException, IOException {
        if (link.length() != 0) {
            int idx = link.lastIndexOf("/");
            String check = String.valueOf(outdir) + link.substring(idx + 1);
            File f = new File(check);
            if (!f.exists()) {
                protocol.append(String.valueOf(link) + "\n");
                boolean successful = false;
                Exception myE = null;
                URL website = new URL(link);
                int i = 1;
                do {
                    protocol.append("try " + i++ + "\n");
                    try {
                        ReadableByteChannel rbc = Channels.newChannel(website.openStream());
                        FileOutputStream fos = new FileOutputStream(String.valueOf(outdir) + link.substring(link.lastIndexOf("/")));
                        fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                        fos.close();
                        rbc.close();
                        successful = true;
                    }
                    catch (Exception e) {
                        myE = e;
                    }
                    if (successful) break;
                    if (myE.getMessage().startsWith("sun.net.ftp.FtpProtocolException")) continue;
                    protocol.appendThrowable(myE);
                    break;
                } while (i < max);
                if (successful) {
                    downloaded.add(link);
                } else {
                    needToBeDownloaded.add(link);
                }
            }
        }
    }

    @Override
    public String getToolName() {
        return "NCBI Reference Retriever";
    }

    @Override
    public String getShortName() {
        return "NRR";
    }

    @Override
    public String getDescription() {
        return "downloads new assembly and annotation files of reference organisms";
    }

    @Override
    public String getHelpText() {
        return "This tool can be used to download or update assembly and annotation files of reference organsims from NCBI. This way it allows to easily collect all data necessary to start **GeMoMaPipeline** or **Extractor**." + MORE;
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }
}

