/*
 * Decompiled with CFR 0.152.
 */
package projects.gemorna;

import de.jstacs.utils.IntList;
import de.jstacs.utils.ToolBox;
import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMRecord;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import projects.gemoma.ExtractRNAseqEvidence;
import projects.gemorna.ReadGraph;

public class Region {
    private static Random r = new Random(113L);
    private double maxcov;
    private double sample;
    private LinkedList<SAMRecord> list = new LinkedList();
    private HashMap<Integer, Character> strands;
    private HashMap<String, Integer> idMap;
    private Integer regionStart = null;
    private Integer regionEnd = null;
    private String chrom = null;
    private double sampleProb = 1.0;
    private double nOut;
    private int[] coverageByBlocks;
    private Region revRegion;
    private char strand;

    public Region(double maxcov, double sample, char strand) {
        this.sample = sample;
        this.maxcov = maxcov;
        this.nOut = 0.0;
        this.strand = strand;
    }

    public char getStrand() {
        return this.strand;
    }

    public void setRevRegion(Region region) {
        this.revRegion = region;
    }

    public Region getRevRegion() {
        return this.revRegion;
    }

    public HashMap<Integer, Character> getStrands() {
        return this.strands;
    }

    public String getChrom() {
        return this.chrom;
    }

    public LinkedList<SAMRecord> getReads() {
        return this.list;
    }

    public int getTheoreticalNumberOfReads() {
        return (int)Math.round((double)this.list.size() / this.sampleProb);
    }

    public HashMap<String, Integer> getIDMap() {
        return this.idMap;
    }

    public int[] getCoverageByBlocks() {
        if (this.coverageByBlocks == null) {
            this.computeCoverageByBlocks();
        }
        return this.coverageByBlocks;
    }

    private int[] computeCoverageByReads() {
        int[] cov = new int[this.regionEnd - this.regionStart + 1];
        for (SAMRecord rec : this.list) {
            int i = rec.getAlignmentStart();
            while (i < rec.getAlignmentEnd()) {
                int n = i - this.regionStart;
                cov[n] = cov[n] + 1;
                ++i;
            }
        }
        return cov;
    }

    private void computeCoverageByBlocks() {
        int[] cov = new int[this.regionEnd - this.regionStart + 1];
        for (SAMRecord rec : this.list) {
            List<AlignmentBlock> blocks = rec.getAlignmentBlocks();
            for (AlignmentBlock block : blocks) {
                int i = block.getReferenceStart();
                while (i < block.getReferenceStart() + block.getLength()) {
                    int n = i - this.regionStart;
                    cov[n] = cov[n] + 1;
                    ++i;
                }
            }
        }
        this.coverageByBlocks = cov;
    }

    public Region[] splitByCov(int maxLen) {
        int[] cov = this.computeCoverageByReads();
        IntList splitPoints = new IntList();
        this.splitPoints(splitPoints, 0, cov.length, cov, maxLen);
        splitPoints.add(0);
        splitPoints.add(cov.length);
        splitPoints.sort();
        int[] sar = splitPoints.toArray();
        Region[] regions = new Region[splitPoints.length() - 1];
        int i = 0;
        while (i < regions.length) {
            regions[i] = new Region(this.maxcov, this.sample, this.strand);
            ++i;
        }
        block1: for (SAMRecord rec : this.list) {
            int astart = rec.getAlignmentStart() - this.regionStart;
            int aend = rec.getAlignmentEnd() - this.regionStart;
            int j = 1;
            while (j < sar.length) {
                if (astart >= sar[j - 1] && aend < sar[j]) {
                    regions[j - 1].addRead(rec);
                    continue block1;
                }
                ++j;
            }
        }
        return regions;
    }

    private void splitPoints(IntList splitPoints, int start, int end, int[] cov, int maxLen) {
        int len = end - start + 1;
        int idx = ToolBox.getMinIndex(start + (int)((double)len * 0.2), start + (int)((double)len * 0.8), cov);
        splitPoints.add(idx);
        if (idx - start > maxLen) {
            this.splitPoints(splitPoints, start, idx, cov, maxLen);
        }
        if (end - idx > maxLen) {
            this.splitPoints(splitPoints, idx, end, cov, maxLen);
        }
    }

    public void addRead(SAMRecord read) {
        if (this.sampleProb == 1.0 || r.nextDouble() < this.sampleProb) {
            this.list.add(read);
            if (this.chrom == null) {
                this.chrom = read.getReferenceName();
            } else if (!this.chrom.equals(read.getReferenceName())) {
                throw new RuntimeException();
            }
            if (this.regionStart == null || read.getAlignmentStart() < this.regionStart) {
                this.regionStart = read.getAlignmentStart();
            }
            if (this.regionEnd == null || read.getAlignmentEnd() > this.regionEnd) {
                this.regionEnd = read.getAlignmentEnd();
            }
        } else {
            this.nOut += 1.0;
        }
        if ((double)this.list.size() > this.maxcov * (double)(this.regionEnd - this.regionStart + 1)) {
            int before = this.list.size();
            System.out.print("#" + this.list.size());
            this.sampleProb *= this.sample;
            this.list.removeIf(new Predicate<SAMRecord>(){

                @Override
                public boolean test(SAMRecord t) {
                    return r.nextDouble() >= Region.this.sample;
                }
            });
            this.nOut += (double)(this.list.size() - before);
            System.out.println("->" + this.list.size());
        }
    }

    public double getScale() {
        return ((double)this.list.size() + this.nOut) / (double)this.list.size();
    }

    public Integer getReferenceIndex() {
        if (this.list.size() == 0) {
            return null;
        }
        return this.list.getLast().getReferenceIndex();
    }

    public Integer getRegionStart() {
        return this.regionStart;
    }

    public Integer getRegionEnd() {
        return this.regionEnd;
    }

    public String toString() {
        return String.valueOf(this.chrom) + " " + this.regionStart + "-" + this.regionEnd + ": " + this.list.size();
    }

    public ReadGraph buildGraph(int minIntronLength, int maxGapFilled, ExtractRNAseqEvidence.Stranded stranded, int maxMM) {
        ReadGraph sg = new ReadGraph(this.chrom, this.regionStart, this.regionEnd, minIntronLength);
        Iterator it = this.list.iterator();
        this.strands = new HashMap();
        this.idMap = new HashMap();
        while (it.hasNext()) {
            SAMRecord sr = (SAMRecord)it.next();
            char strand = '.';
            if (stranded == ExtractRNAseqEvidence.Stranded.FR_FIRST_STRAND) {
                strand = '-';
                if (sr.getReadPairedFlag() && sr.getFirstOfPairFlag() && sr.getReadNegativeStrandFlag()) {
                    strand = '+';
                } else if (sr.getReadPairedFlag() && sr.getSecondOfPairFlag() && sr.getMateNegativeStrandFlag()) {
                    strand = '+';
                } else if (!sr.getReadPairedFlag()) {
                    strand = sr.getReadNegativeStrandFlag() ? (char)'+' : '-';
                }
            } else if (stranded == ExtractRNAseqEvidence.Stranded.FR_SECOND_STRAND) {
                strand = '+';
                if (sr.getReadPairedFlag() && sr.getFirstOfPairFlag() && sr.getReadNegativeStrandFlag()) {
                    strand = '-';
                } else if (sr.getReadPairedFlag() && sr.getSecondOfPairFlag() && sr.getMateNegativeStrandFlag()) {
                    strand = '-';
                } else if (!sr.getReadPairedFlag()) {
                    strand = sr.getReadNegativeStrandFlag() ? (char)'-' : '+';
                }
            }
            int i = -1;
            String name = sr.getReadName();
            if (this.idMap.containsKey(name)) {
                i = this.idMap.get(name);
            } else {
                i = this.idMap.size();
                this.idMap.put(name, i);
            }
            this.strands.put(i, Character.valueOf(strand));
            sg.addRead(sr, maxMM);
        }
        sg.finalizeGaps(maxGapFilled);
        return sg;
    }

    public void join(Region revTemp) {
        if (!this.chrom.equals(revTemp.chrom)) {
            throw new RuntimeException("chromosomes do not match");
        }
        if (revTemp.getReads().size() == 0) {
            return;
        }
        if (this.idMap != null || revTemp.idMap != null) {
            throw new RuntimeException("too late");
        }
        if (this.sampleProb == revTemp.sampleProb) {
            this.regionStart = Math.min(this.regionStart, revTemp.regionStart);
            this.regionEnd = Math.max(this.regionEnd, revTemp.regionEnd);
            this.list.addAll(revTemp.list);
            this.nOut += revTemp.nOut;
        } else if (this.sampleProb <= revTemp.sampleProb) {
            double temp = this.sampleProb;
            this.sampleProb /= revTemp.sampleProb;
            for (SAMRecord sr : revTemp.list) {
                this.addRead(sr);
            }
            this.sampleProb = temp;
        } else {
            double temp = revTemp.sampleProb;
            revTemp.sampleProb /= this.sampleProb;
            for (SAMRecord sr : this.list) {
                revTemp.addRead(sr);
            }
            this.sampleProb = revTemp.sampleProb = temp;
            this.nOut = revTemp.nOut;
            this.regionStart = revTemp.regionStart;
            this.regionEnd = revTemp.regionEnd;
            this.list = revTemp.list;
        }
    }
}

