/*
 * Decompiled with CFR 0.152.
 */
package projects.gemorna;

import de.jstacs.DataType;
import de.jstacs.parameters.EnumParameter;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import de.jstacs.tools.ui.cli.CLI;
import de.jstacs.utils.IntList;
import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.stream.Collectors;
import projects.gemoma.Analyzer;
import projects.gemoma.ExtractRNAseqEvidence;
import projects.gemoma.GeMoMaAnnotationFilter;
import projects.gemoma.ReadStats;
import projects.gemorna.BAMReader;
import projects.gemorna.Genome;
import projects.gemorna.MergeGeMoMaGeMoRNA;
import projects.gemorna.PredictCDSFromGFF;
import projects.gemorna.ReadGraph;
import projects.gemorna.Region;
import projects.gemorna.SplicingGraph;

public class TranscriptPrediction
implements JstacsTool {
    public static void main(String[] args) throws Exception {
        boolean[] blArray = new boolean[5];
        blArray[0] = true;
        CLI cli = new CLI(blArray, new TranscriptPrediction(), new PredictCDSFromGFF(), new GeMoMaAnnotationFilter(), new Analyzer(), new MergeGeMoMaGeMoRNA());
        cli.run(args);
    }

    @Override
    public ToolParameterSet getToolParameters() {
        LinkedList<Parameter> pars = new LinkedList<Parameter>();
        pars.add(new FileParameter("Genome", "Genome sequence as FastA", "fa,fna,fasta", true));
        pars.add(new FileParameter("Mapped reads", "Mapped Reads in BAM format, coordinate sorted", "bam", true));
        try {
            pars.add(new EnumParameter(ExtractRNAseqEvidence.Stranded.class, "Library strandedness", true, ExtractRNAseqEvidence.Stranded.FR_UNSTRANDED.name()));
            pars.add(new SimpleParameter(DataType.INT, "Longest intron length", "Length of the longest intron reported", true, 100000));
            pars.add(new SimpleParameter(DataType.INT, "Shortest intron length", "Length of the shortest intron considered", true, 10));
            pars.add(new SimpleParameter(DataType.BOOLEAN, "Long reads", "Long-read mode", true, false));
            pars.add(new SimpleParameter(DataType.DOUBLE, "Minimum number of reads", "Minimum number of reads required for an edge in the read graph", true, 1.0));
            pars.add(new SimpleParameter(DataType.DOUBLE, "Minimum fraction of reads", "Minimum fraction of reads relative to adjacent exons that must support an intron in the enumeration", true, 0.01));
            pars.add(new SimpleParameter(DataType.DOUBLE, "Minimum number of intron reads", "Minimum number of reads required for an intron", true, 1.0));
            pars.add(new SimpleParameter(DataType.DOUBLE, "Minimum fraction of intron reads", "Minimum fraction of reads relative to adjacent exons for an intron to be considered", true, 0.01));
            pars.add(new SimpleParameter(DataType.DOUBLE, "Percent explained", "Percent of abundance that must be explained by transcript models after quantification", true, 0.9));
            pars.add(new SimpleParameter(DataType.DOUBLE, "Minimum reads per gene", "Minimum abundance required for a gene to be reported", true, 40.0));
            pars.add(new SimpleParameter(DataType.DOUBLE, "Minimum reads per transcript", "Minimum abundance required for a transcript to be reported", true, 20.0));
            pars.add(new SimpleParameter(DataType.DOUBLE, "Percent abundance", "Minimum relative abundance required for a transcript to be reported", true, 0.05));
            pars.add(new SimpleParameter(DataType.DOUBLE, "Successive fraction", "Factor of the drop in abundance between successive transcript models", true, 20.0));
            pars.add(new SimpleParameter(DataType.INT, "Maximum region length", "Maximum length of a region considered before it is split", true, 750000));
            pars.add(new SimpleParameter(DataType.INT, "Maximum filled gap length", "Maximum length of a gap filled by dummy reads", true, 50));
            pars.add(new SimpleParameter(DataType.INT, "Quality filter", "Minimum mapping quality required for a read to be considered", true, 40));
            pars.add(new SimpleParameter(DataType.INT, "Minimum protein length", "Minimum length of protein in AA", true, 70));
            pars.add(new SimpleParameter(DataType.STRING, "Gene prefix", "Prefix to add to all gene names", true, "G"));
            pars.add(new SimpleParameter(DataType.BOOLEAN, "Gene names with chromosome", "If true, gene names will be constructed as <Gene prefix><chr>.<geneNumber>. Gene numbers will be assigned successively across all chromosomes.", true, false));
        }
        catch (ParameterException ex) {
            ex.printStackTrace();
        }
        return new ToolParameterSet(this.getToolName(), pars);
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        String genome = ((FileParameter)parameters.getParameterForName("Genome")).getFileContents().getFilename();
        String bamFile = ((FileParameter)parameters.getParameterForName("Mapped reads")).getFileContents().getFilename();
        int minIntronLength = (Integer)parameters.getParameterForName("Shortest intron length").getValue();
        int maxIntronLength = (Integer)parameters.getParameterForName("Longest intron length").getValue();
        double maxCov = 100.0;
        double sample = 0.5;
        ExtractRNAseqEvidence.Stranded stranded = (ExtractRNAseqEvidence.Stranded)((EnumParameter)parameters.getParameterForName(ExtractRNAseqEvidence.Stranded.class.getSimpleName())).getValue();
        double minReads = (Double)parameters.getParameterForName("Minimum number of reads").getValue();
        double minFraction = (Double)parameters.getParameterForName("Minimum fraction of reads").getValue();
        double minIntronReads = (Double)parameters.getParameterForName("Minimum number of intron reads").getValue();
        double minIntronFraction = (Double)parameters.getParameterForName("Minimum fraction of intron reads").getValue();
        double maxNumTranscripts = 1000.0;
        double percentExplained = (Double)parameters.getParameterForName("Percent explained").getValue();
        double minReadsPerTranscript = (Double)parameters.getParameterForName("Minimum reads per transcript").getValue();
        double maxFraction = (Double)parameters.getParameterForName("Successive fraction").getValue();
        double percentAbundance = (Double)parameters.getParameterForName("Percent abundance").getValue();
        double scaleIntronReads = 5.0;
        double delta = 1.0E-4;
        int nIterations = 10000;
        double minReadsPerGene = (Double)parameters.getParameterForName("Minimum reads per gene").getValue();
        int minQuality = (Integer)parameters.getParameterForName("Quality filter").getValue();
        int maxLen = (Integer)parameters.getParameterForName("Maximum region length").getValue();
        int maxGap = (Integer)parameters.getParameterForName("Maximum filled gap length").getValue();
        int minProteinLength = (Integer)parameters.getParameterForName("Minimum protein length").getValue();
        boolean longReads = (Boolean)parameters.getParameterForName("Long reads").getValue();
        String geneBase = (String)parameters.getParameterForName("Gene prefix").getValue();
        boolean useChrPrefix = (Boolean)parameters.getParameterForName("Gene names with chromosome").getValue();
        ReadStats stats = new ReadStats(minIntronLength, 1.0, bamFile);
        Config config = new Config(minIntronLength, maxIntronLength, stranded, minReads, minFraction, minIntronReads, minIntronFraction, maxNumTranscripts, percentExplained, minReadsPerTranscript, minReadsPerGene, maxFraction, percentAbundance, scaleIntronReads, delta, nIterations, stats, minProteinLength, maxGap, longReads, geneBase, useChrPrefix);
        BAMReader reader = new BAMReader(maxIntronLength, bamFile, maxCov, sample, stranded, minQuality, maxLen, maxGap, longReads);
        Genome.init(genome);
        File out = File.createTempFile("predictions", ".temp", new File("."));
        out.deleteOnExit();
        PrintWriter wr = new PrintWriter(out);
        OutputSet outset = new OutputSet();
        WorkerPool pool = null;
        Worker worker = null;
        if (threads > 1) {
            pool = new WorkerPool(config, threads - 1);
        } else {
            worker = new Worker(null, config, 0);
        }
        int idx = 0;
        wr.println("##gff-version 3");
        while (reader.hasNext()) {
            Region region2 = reader.next();
            Object[] regions = new Region[]{region2};
            if (region2.getRegionEnd() - region2.getRegionStart() > maxLen) {
                regions = region2.splitByCov(maxLen);
                System.out.println("#split: " + region2.getChrom() + " " + Arrays.toString(regions));
                System.out.flush();
            }
            Object[] objectArray = regions;
            int n = regions.length;
            int n2 = 0;
            while (n2 < n) {
                Region region = objectArray[n2];
                if (pool == null) {
                    worker.compute(idx, region, outset);
                    outset.print(reader, wr, minReadsPerGene, config.minProteinLength, config.geneBase, config.useChrPrefix);
                } else {
                    worker = pool.getFree();
                    worker.setCompute(idx, region, outset);
                    worker = pool.getFree();
                    worker.setPrint(reader, wr, outset);
                }
                ++idx;
                ++n2;
            }
        }
        if (pool != null) {
            pool.stopAll();
        }
        outset.print(reader, wr, minReadsPerGene, config.minProteinLength, config.geneBase, config.useChrPrefix);
        wr.close();
        TextResult tr = new TextResult("Transcript Predictions", "Predictions in GFF format", new FileParameter.FileRepresentation(out.getAbsolutePath()), "gff3", this.getToolName(), null, true);
        return new ToolResult("Result of " + this.getToolName(), this.getToolName(), null, new ResultSet(tr), parameters, this.getToolName(), new Date(System.currentTimeMillis()));
    }

    @Override
    public String getToolName() {
        return "GeMoRNA";
    }

    @Override
    public String getToolVersion() {
        return "1.1";
    }

    @Override
    public String getShortName() {
        return "gemorna";
    }

    @Override
    public String getDescription() {
        return "transcript reconstruction from RNA-seq data";
    }

    @Override
    public String getHelpText() {
        return "";
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public String[] getReferences() {
        return null;
    }

    private static class Config {
        private int minIntronLength;
        private int maxIntronLength;
        private ExtractRNAseqEvidence.Stranded stranded;
        private double minReads;
        private double minFraction;
        private double minIntronReads;
        private double minIntronFraction;
        private double maxNumTranscripts;
        private double percentExplained;
        private double minReadsPerTranscript;
        private double minReadsPerGene;
        private double maxFraction;
        private double percentAbundance;
        private double scaleIntronReads;
        private double delta;
        private int nIterations;
        private ReadStats stats;
        private int minProteinLength;
        private double spilloverFactor;
        private int maxGapFilled;
        private int maxMM;
        private boolean doSplits;
        private boolean filterSpillover;
        private boolean longReads;
        private String geneBase;
        private boolean useChrPrefix;

        public Config(int minIntronLength, int maxIntronLength, ExtractRNAseqEvidence.Stranded stranded, double minReads, double minFraction, double minIntronReads, double minIntronFraction, double maxNumTranscripts, double percentExplained, double minReadsPerTranscript, double minReadsPerGene, double maxFraction, double percentAbundance, double scaleIntronReads, double delta, int nIterations, ReadStats stats, int minProteinLength, int maxGapFilled, boolean longReads, String geneBase, boolean useChrPrefix) {
            this.minIntronLength = minIntronLength;
            this.maxIntronLength = maxIntronLength;
            this.stranded = stranded;
            this.minReads = minReads;
            this.minFraction = minFraction;
            this.minIntronReads = minIntronReads;
            this.minIntronFraction = minIntronFraction;
            this.maxNumTranscripts = maxNumTranscripts;
            this.percentExplained = percentExplained;
            this.minReadsPerTranscript = minReadsPerTranscript;
            this.minReadsPerGene = minReadsPerGene;
            this.maxFraction = maxFraction;
            this.percentAbundance = percentAbundance;
            this.scaleIntronReads = scaleIntronReads;
            this.delta = delta;
            this.nIterations = nIterations;
            this.stats = stats;
            this.minProteinLength = minProteinLength;
            this.spilloverFactor = 10.0;
            this.maxGapFilled = maxGapFilled;
            this.longReads = longReads;
            this.maxMM = longReads ? Integer.MAX_VALUE : 3;
            this.doSplits = true;
            this.filterSpillover = true;
            this.geneBase = geneBase;
            this.useChrPrefix = useChrPrefix;
        }
    }

    private static class OutputSet {
        private TreeSet<Result> internal = new TreeSet();
        private int lastIdx = -1;
        private String lastChrom = "";
        private int n = 1;

        public synchronized void add(int idx, LinkedList<TranscriptResult> list) {
            this.internal.add(new Result(idx, list));
        }

        public synchronized void print(BAMReader reader, PrintWriter wr, double minReadsPerGene, int minProteinLength, String genePrefix, boolean useChrPrefix) {
            while (this.internal.size() > 0 && this.internal.first().idx == this.lastIdx + 1) {
                Result res = this.internal.pollFirst();
                LinkedList topList = res.list;
                for (TranscriptResult tres : topList) {
                    SplicingGraph sg = tres.sg;
                    LinkedList<SplicingGraph.Gene> genes = sg.finalize(tres.list, genePrefix, useChrPrefix, this.n, minReadsPerGene, minProteinLength);
                    if (genes.size() > 0) {
                        String chrom = genes.get(0).getChrom();
                        if (!this.lastChrom.contentEquals(chrom)) {
                            int len = reader.getSequenceLength(chrom);
                            wr.println("##sequence-region " + chrom + " 1 " + len);
                        }
                        this.lastChrom = chrom;
                    }
                    this.n += genes.size();
                    for (SplicingGraph.Gene g : genes) {
                        wr.print(g);
                    }
                    wr.flush();
                }
                this.lastIdx = res.idx;
            }
        }
    }

    private static class Result
    implements Comparable<Result> {
        private int idx;
        private LinkedList<TranscriptResult> list;

        public Result(int idx, LinkedList<TranscriptResult> list) {
            this.idx = idx;
            this.list = list;
        }

        @Override
        public int compareTo(Result o) {
            return Integer.compare(this.idx, o.idx);
        }
    }

    private static enum State {
        IDLE,
        COMP,
        PRINT;

    }

    private static class TranscriptResult {
        private LinkedList<SplicingGraph.Transcript> list;
        private SplicingGraph sg;

        public TranscriptResult(LinkedList<SplicingGraph.Transcript> list, SplicingGraph sg) {
            this.list = list;
            this.sg = sg;
        }
    }

    private static class Worker
    implements Runnable {
        private WorkerPool pool;
        private boolean run;
        private Config config;
        private State state;
        private BAMReader reader;
        private PrintWriter wr;
        private OutputSet outset;
        private int idx;
        private Region region;
        private int id;

        public Worker(WorkerPool pool, Config config, int id) {
            this.pool = pool;
            this.run = true;
            this.config = config;
            this.state = State.IDLE;
            this.id = id;
        }

        public synchronized State getState() {
            return this.state;
        }

        public synchronized void setPrint(BAMReader reader, PrintWriter wr, OutputSet outset) {
            this.state = State.PRINT;
            this.reader = reader;
            this.wr = wr;
            this.outset = outset;
            this.notify();
        }

        public synchronized void setCompute(int idx, Region region, OutputSet outset) {
            this.state = State.COMP;
            this.idx = idx;
            this.region = region;
            this.outset = outset;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.run) {
                Object object = this;
                synchronized (object) {
                    if (this.state == State.IDLE) {
                        try {
                            this.wait(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            return;
                        }
                    }
                }
                if (this.state == State.COMP) {
                    try {
                        this.compute(this.idx, this.region, this.outset);
                    }
                    catch (CloneNotSupportedException e) {
                        e.printStackTrace();
                        return;
                    }
                    this.state = State.IDLE;
                    object = this.pool;
                    synchronized (object) {
                        this.pool.notify();
                        continue;
                    }
                }
                if (this.state != State.PRINT) continue;
                this.outset.print(this.reader, this.wr, this.config.minReadsPerGene, this.config.minProteinLength, this.config.geneBase, this.config.useChrPrefix);
                this.state = State.IDLE;
                object = this.pool;
                synchronized (object) {
                    this.pool.notify();
                }
            }
        }

        private void compute(int idx, Region region, OutputSet outset) throws CloneNotSupportedException {
            boolean filterBefore = true;
            LinkedList<TranscriptResult> topList = new LinkedList<TranscriptResult>();
            double rpk = (double)region.getTheoreticalNumberOfReads() / (double)(region.getRegionEnd() - region.getRegionStart() + 1) * 1000.0;
            ReadGraph rg2 = region.buildGraph(this.config.minIntronLength, this.config.maxGapFilled, this.config.stranded, this.config.maxMM);
            rg2.pruneByAbsoluteNumberOfReads(this.config.minReads, false);
            if (rpk > 200.0) {
                rg2.pruneByAbsoluteNumberOfReads(this.config.minIntronReads * 2.0, true);
            } else {
                rg2.pruneByAbsoluteNumberOfReads(this.config.minIntronReads, true);
            }
            rg2.pruneByRelativeNumberOfReads(this.config.minIntronFraction, true);
            rg2.pruneBySplitLength(this.config.stats);
            if (this.config.longReads) {
                rg2.pruneAlternativeIntronsLong(5);
            }
            ReadGraph rg = null;
            LinkedList intronEdges = rg2.getIntronEdges().stream().map(e -> new ReadGraph.Edge(e.getRelStart(), e.getRelEnd(), e.getNumberOfReads())).collect(Collectors.toCollection(LinkedList::new));
            int edgeRegionStart = rg2.regionStart;
            while ((rg = rg2.nextSplit()) != null) {
                rg.condense();
                int[] proposedSplits = new int[]{};
                if (this.config.doSplits) {
                    proposedSplits = rg.proposeSplitByReadCoverage(200, 20);
                }
                SplicingGraph sg = new SplicingGraph(rg, region, this.config.minIntronLength, proposedSplits);
                LinkedList<SplicingGraph.Transcript> list = new LinkedList<SplicingGraph.Transcript>();
                sg.enumerateTranscripts2(list, this.config.minReads, this.config.minFraction, this.config.maxNumTranscripts);
                list.stream().forEach(e -> {
                    if (e.getStrand() == '.') {
                        e.setStrand(region.getStrand());
                    }
                });
                int sizeBefore = list.size();
                LinkedList<SplicingGraph.Transcript> sList = list;
                if (this.config.doSplits && proposedSplits.length > 0) {
                    sList = sg.testSplitByORF(sList, proposedSplits, this.config.minProteinLength);
                }
                if (this.config.doSplits && this.config.stranded == ExtractRNAseqEvidence.Stranded.FR_UNSTRANDED) {
                    sList = sg.testSplitBySpliceSitesAndORF(sList, this.config.minProteinLength);
                }
                if (this.config.doSplits && sList.size() == sizeBefore) {
                    sList = sg.testSplitByORF(sList, this.config.minProteinLength);
                }
                LinkedList<SplicingGraph.Transcript>[] sList2 = sg.splitByLocationAndMakeUnique(sList, this.config.minProteinLength, this.config.stranded);
                int i = 0;
                while (i < sList2.length) {
                    if (this.config.filterSpillover && filterBefore) {
                        sList2[i] = this.filterSpilloverTranscripts(sList2[i], region, this.config.spilloverFactor);
                        sList2[i] = this.filterSpilloverIntronTranscripts(sList2[i], intronEdges, edgeRegionStart, this.config.spilloverFactor);
                    }
                    list = sg.quantify(sList2[i], this.config.percentExplained, this.config.minReadsPerTranscript, this.config.maxFraction, this.config.percentAbundance, this.config.scaleIntronReads, this.config.delta, this.config.nIterations, region.getScale(), this.config.minIntronLength, this.config.longReads);
                    list = this.filterImplausibleTranscripts(list, this.config.stranded);
                    list = this.filterSingleExonGenes(list, this.config.minReadsPerTranscript);
                    if (this.config.filterSpillover && !filterBefore) {
                        list = this.filterSpilloverTranscripts(list, region, this.config.spilloverFactor);
                        list = this.filterSpilloverIntronTranscripts(list, intronEdges, rg2.regionStart, this.config.spilloverFactor);
                    }
                    topList.add(new TranscriptResult(list, sg));
                    ++i;
                }
            }
            outset.add(idx, topList);
        }

        private LinkedList<SplicingGraph.Transcript> filterSingleExonGenes(LinkedList<SplicingGraph.Transcript> list, double minReadsPerTranscript) {
            Iterator it = list.iterator();
            IntList li = new IntList();
            int i = 0;
            while (it.hasNext()) {
                double abundance;
                SplicingGraph.Transcript t = (SplicingGraph.Transcript)it.next();
                if (t.getNumberOfIntrons() == 0 && (abundance = t.getAbundance()) * (1.0 - t.getUTRFraction()) < minReadsPerTranscript) {
                    li.add(i);
                }
                ++i;
            }
            int j = li.length() - 1;
            while (j >= 0) {
                list.remove(li.get(j));
                --j;
            }
            return list;
        }

        private LinkedList<SplicingGraph.Transcript> filterSpilloverIntronTranscripts(LinkedList<SplicingGraph.Transcript> list, LinkedList<ReadGraph.Edge> intronEdges, int edgeRegionStart, double factor) {
            Iterator it = list.iterator();
            IntList li = new IntList();
            int i = 0;
            while (it.hasNext()) {
                SplicingGraph.Transcript t = (SplicingGraph.Transcript)it.next();
                if (t.getNumberOfIntrons() == 0 || t.percentCanonicalSpliceSites() < 0.75) {
                    double myCov = t.getMaximumNumberOfReads();
                    double intronCov = t.getMaximumNumberOfCoveringIntronReads(intronEdges, edgeRegionStart);
                    if (myCov * factor * (1.0 - t.getUTRFraction()) < intronCov) {
                        li.add(i);
                    }
                }
                ++i;
            }
            int j = li.length() - 1;
            while (j >= 0) {
                list.remove(li.get(j));
                --j;
            }
            return list;
        }

        private LinkedList<SplicingGraph.Transcript> filterSpilloverTranscripts(LinkedList<SplicingGraph.Transcript> list, Region region2, double factor) {
            if (region2.getRevRegion() != null) {
                Iterator it = list.iterator();
                IntList li = new IntList();
                int i = 0;
                while (it.hasNext()) {
                    SplicingGraph.Transcript t = (SplicingGraph.Transcript)it.next();
                    if (t.getNumberOfIntrons() < 1 || t.percentCanonicalSpliceSites() < 0.75) {
                        Region revRegion = region2.getRevRegion();
                        int[] covRegion = region2.getCoverageByBlocks();
                        int[] covRev = revRegion.getCoverageByBlocks();
                        double sumRegion = 0.0;
                        double sumRev = 0.0;
                        int j = t.getStart();
                        while (j < t.getEnd()) {
                            sumRegion += (double)covRegion[j - region2.getRegionStart()];
                            if (j - revRegion.getRegionStart() >= 0 && j - revRegion.getRegionStart() < covRev.length) {
                                sumRev += (double)covRev[j - revRegion.getRegionStart()];
                            }
                            ++j;
                        }
                        if (sumRegion * factor * (1.0 - t.getUTRFraction()) < sumRev) {
                            li.add(i);
                        }
                    }
                    ++i;
                }
                int j = li.length() - 1;
                while (j >= 0) {
                    list.remove(li.get(j));
                    --j;
                }
            }
            return list;
        }

        private LinkedList<SplicingGraph.Transcript> filterImplausibleTranscripts(LinkedList<SplicingGraph.Transcript> linkedList, ExtractRNAseqEvidence.Stranded stranded) {
            if (stranded != ExtractRNAseqEvidence.Stranded.FR_UNSTRANDED) {
                Iterator it = linkedList.iterator();
                IntList li = new IntList();
                int i = 0;
                while (it.hasNext()) {
                    char intronStrand;
                    SplicingGraph.Transcript t = (SplicingGraph.Transcript)it.next();
                    char strand = t.getStrand();
                    if (strand != '.' && (intronStrand = t.getStrandByIntrons()) != '.' && intronStrand != strand) {
                        li.add(i);
                    }
                    ++i;
                }
                int j = li.length() - 1;
                while (j >= 0) {
                    linkedList.remove(li.get(j));
                    --j;
                }
            }
            return linkedList;
        }
    }

    private static class WorkerPool {
        private Worker[] workers;
        private Config config;

        public WorkerPool(Config config, int numThreads) {
            this.config = config;
            this.workers = new Worker[numThreads];
            int i = 0;
            while (i < this.workers.length) {
                this.workers[i] = new Worker(this, config, i);
                new Thread(this.workers[i]).start();
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopAll() {
            while (true) {
                int stopped = 0;
                int i = 0;
                while (i < this.workers.length) {
                    if (this.workers[i].getState() == State.IDLE) {
                        this.workers[i].run = false;
                        Worker worker = this.workers[i];
                        synchronized (worker) {
                            this.workers[i].notify();
                        }
                        ++stopped;
                    }
                    ++i;
                }
                if (stopped == this.workers.length) {
                    return;
                }
                try {
                    WorkerPool workerPool = this;
                    synchronized (workerPool) {
                        this.wait(1000L);
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        public synchronized Worker getFree() {
            while (true) {
                int i = 0;
                while (i < this.workers.length) {
                    if (this.workers[i].getState() == State.IDLE) {
                        return this.workers[i];
                    }
                    ++i;
                }
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

