/*
 * Decompiled with CFR 0.152.
 */
package projects.ms;

import de.jstacs.utils.Pair;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import projects.ms.AlignmentSimilarity;
import projects.ms.CosineSimilarity;
import projects.ms.MatchSpectra;
import projects.ms.ModifiedCosineSimilarity;
import projects.ms.PPMDeviation;
import projects.ms.Peak;
import projects.ms.Spectrum;

public class MSMain {
    public static void main(String[] args) throws IOException {
        List list = Spectrum.parse(args[0]);
        String outdir = args[1];
        double absoluteFilter = 3.0;
        double relativeFilter = 0.01;
        double ppm = 10.0;
        MatchSpectra.UseIntensities useIntensities = MatchSpectra.UseIntensities.ALL;
        new File(outdir).mkdirs();
        String compDir = String.valueOf(outdir) + "/comps_abs" + absoluteFilter + "_rel" + relativeFilter + "_ppm" + ppm + "_useIntensities" + (Object)((Object)useIntensities);
        new File(compDir).mkdirs();
        list = list.stream().filter(e -> e.getMaxIntensity() > 1000.0).collect(Collectors.toCollection(ArrayList::new));
        list.stream().forEach(e -> e.filter(absoluteFilter));
        list.stream().forEach(e -> e.normalize());
        list.stream().forEach(e -> e.filter(relativeFilter));
        PrintWriter wr3 = new PrintWriter(String.valueOf(outdir) + "/" + "peaks_abs" + absoluteFilter + "_rel" + relativeFilter + ".txt");
        HashSet<Peak.PeakType> ori = new HashSet<Peak.PeakType>();
        ori.add(Peak.PeakType.ORIGINAL);
        list.stream().map(e -> e.getPeaksOfType(ori)).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll).forEach(e -> wr3.println(e.getMz()));
        wr3.close();
        PPMDeviation d = new PPMDeviation(ppm);
        int maxPeaks = list.stream().mapToInt(e -> e.getNumberOfPeaks()).max().getAsInt();
        System.out.println("maxPeaks: " + maxPeaks);
        for (Spectrum spec : list) {
            spec.addPseudoPeaks(d);
        }
        maxPeaks = list.stream().mapToInt(e -> e.getNumberOfPeaks()).max().getAsInt();
        System.out.println("maxPeaks: " + maxPeaks);
        MatchSpectra ms = new MatchSpectra(useIntensities, d, maxPeaks);
        CosineSimilarity cs = new CosineSimilarity();
        ModifiedCosineSimilarity mcs = new ModifiedCosineSimilarity();
        AlignmentSimilarity as = new AlignmentSimilarity();
        long time = System.currentTimeMillis();
        PrintWriter wr = new PrintWriter(String.valueOf(outdir) + "/" + "similarity_abs" + absoluteFilter + "_rel" + relativeFilter + "_ppm" + ppm + "_useIntensities" + (Object)((Object)useIntensities) + ".tsv");
        PrintWriter wr2 = new PrintWriter(String.valueOf(outdir) + "/" + "precursor_abs" + absoluteFilter + "_rel" + relativeFilter + "_ppm" + ppm + "_useIntensities" + (Object)((Object)useIntensities) + ".tsv");
        PrintWriter wr4 = new PrintWriter(String.valueOf(outdir) + "/" + "diffs_abs" + absoluteFilter + "_rel" + relativeFilter + "_ppm" + ppm + "_useIntensities" + (Object)((Object)useIntensities) + ".tsv");
        int i = 1;
        while (i < list.size()) {
            Spectrum spec1 = (Spectrum)list.get(i);
            System.out.println(i);
            int j = 0;
            while (j < i) {
                Spectrum spec2 = (Spectrum)list.get(j);
                MatchSpectra.Matching matching = ms.computeMatchesSequential(spec1, spec2, false, 2);
                wr.println(String.valueOf(i) + "\t" + j + "\t" + cs.getSimilarity(spec1, spec2, matching) + "\t" + mcs.getSimilarity(spec1, spec2, matching) + "\t" + as.getSimilarity(spec1, spec2, matching) + "\t" + spec1.getName() + "\t" + spec2.getName() + "\t" + spec1.getComment("PEAKID") + "\t" + spec2.getComment("PEAKID"));
                if (cs.getSimilarity(spec1, spec2, matching) >= 4.0 & cs.getSimilarity(spec1, spec2, matching) + 2.0 < mcs.getSimilarity(spec1, spec2, matching)) {
                    PrintWriter wr5 = new PrintWriter(String.valueOf(compDir) + "/" + "comp_" + spec1.getComment("PEAKID") + "_" + spec2.getComment("PEAKID") + ".tsv");
                    wr5.println(matching.forVisualization());
                    wr5.close();
                }
                ArrayList<Pair<Integer, Double>> dl = matching.getShiftsForDiffs(true);
                int k = 0;
                while (k < dl.size()) {
                    wr4.println(dl.get(k).getSecondElement() + "\t" + spec1.getPrecursor().getMz() + "\t" + spec2.getPrecursor().getMz() + "\t" + spec1.getName() + "\t" + spec2.getName() + "\t" + spec1.getComment("PEAKID") + "\t" + spec2.getComment("PEAKID"));
                    ++k;
                }
                dl = matching.getShiftsForPrecursors(true);
                k = 0;
                while (k < dl.size()) {
                    wr2.println(dl.get(k).getSecondElement() + "\t" + spec1.getPrecursor().getMz() + "\t" + spec2.getPrecursor().getMz() + "\t" + spec1.getName() + "\t" + spec2.getName() + "\t" + spec1.getComment("PEAKID") + "\t" + spec2.getComment("PEAKID"));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        System.out.println("time: " + (System.currentTimeMillis() - time));
        wr.close();
        wr2.close();
        wr4.close();
    }
}

