/*
 * Decompiled with CFR 0.152.
 */
package projects.sigma;

import de.jstacs.DataType;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.SimpleSequenceAnnotationParser;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.models.DifferentiableHigherOrderHMM;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import de.jstacs.tools.ui.cli.CLI;
import java.io.StringReader;
import java.util.Date;
import java.util.LinkedList;
import projects.sigma.SigmaHMM;

public class Predict
implements JstacsTool {
    public static void main(String[] args) throws Exception {
        CLI cli = new CLI(new boolean[1], new Predict());
        cli.run(args);
    }

    @Override
    public ToolParameterSet getToolParameters() {
        LinkedList<Parameter> pars = new LinkedList<Parameter>();
        pars.add(new FileParameter("Input sequences", "", "fasta,fas,fa", true));
        pars.add(new FileParameter("Model", "", "xml", true));
        try {
            pars.add(new SimpleParameter(DataType.INT, "First number of components", "", true, new NumberValidator<Integer>(0, 20), 3));
            pars.add(new SimpleParameter(DataType.INT, "First length", "", true, new NumberValidator<Integer>(3, 20), 10));
            pars.add(new SimpleParameter(DataType.INT, "Second number of components", "", true, new NumberValidator<Integer>(0, 20), 3));
            pars.add(new SimpleParameter(DataType.INT, "Second length", "", true, new NumberValidator<Integer>(3, 20), 10));
        }
        catch (ParameterException e) {
            e.printStackTrace();
        }
        return new ToolParameterSet(this.getShortName(), pars.toArray(new Parameter[0]));
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        DataSet data = new DataSet(DNAAlphabetContainer.SINGLETON, new SparseStringExtractor(new StringReader(((FileParameter)parameters.getParameterAt(0)).getFileContents().getContent()), '>', "", (SequenceAnnotationParser)new SimpleSequenceAnnotationParser()));
        DifferentiableHigherOrderHMM hmm = new DifferentiableHigherOrderHMM(new StringBuffer(((FileParameter)parameters.getParameterAt(1)).getFileContents().getContent()));
        int nComponentsFirst = (Integer)parameters.getParameterAt(2).getValue();
        int nFirst = (Integer)parameters.getParameterAt(3).getValue();
        int nComponentsSecond = (Integer)parameters.getParameterAt(4).getValue();
        int nSecond = (Integer)parameters.getParameterAt(5).getValue();
        LinkedList<Result> ress = SigmaHMM.evaluateJoint(this.getShortName(), hmm, nComponentsFirst, nComponentsSecond, nFirst, nSecond, data);
        return new ToolResult("Result of " + this.getToolName(), this.getToolName(), null, new ResultSet(ress), parameters, this.getToolName(), new Date(System.currentTimeMillis()));
    }

    @Override
    public String getToolName() {
        return "Prediction";
    }

    @Override
    public String getToolVersion() {
        return "0.1";
    }

    @Override
    public String getShortName() {
        return "predict";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public String getHelpText() {
        return "";
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public String[] getReferences() {
        return null;
    }
}

