/*
 * Decompiled with CFR 0.152.
 */
package projects.xanthogenomes;

import de.jstacs.algorithms.alignment.Alignment;
import de.jstacs.algorithms.alignment.PairwiseStringAlignment;
import de.jstacs.algorithms.alignment.cost.AffineCosts;
import de.jstacs.algorithms.alignment.cost.MatrixCosts;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DNADataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SimpleSequenceAnnotationParser;
import de.jstacs.tools.Protocol;
import java.io.FileWriter;
import java.io.PrintWriter;
import projects.xanthogenomes.TALE;
import projects.xanthogenomes.TALEConsensus;
import projects.xanthogenomes.Tools;

public class SplitTALEs {
    public static TALE[] split(String id, Sequence tale, Protocol protocol) throws Exception {
        PairwiseStringAlignment psa;
        AffineCosts costs = new AffineCosts(3.0, new MatrixCosts(Tools.Aligner.DEFAULT.getMatrix(), 2.0));
        Alignment align = new Alignment(costs);
        Tools.ProteinAlphabetContainer protAlph = Tools.ProteinAlphabetContainer.SINGLETON;
        Sequence prot = null;
        prot = tale.getAlphabetContainer().checkConsistency(protAlph) ? tale : Tools.Translator.DEFAULT.translate(tale, 0);
        int talelen = prot.getLength();
        Sequence repeat = TALEConsensus.repeat;
        Sequence lastRepeat = TALEConsensus.lastRepeat;
        Sequence start = TALEConsensus.start;
        Sequence end = TALEConsensus.end;
        int nreps = 0;
        StringBuffer first = new StringBuffer();
        first.append(start);
        String last = String.valueOf(lastRepeat.toString()) + end.toString();
        Sequence template = Sequence.create(protAlph, String.valueOf(first.toString()) + last);
        PairwiseStringAlignment bestAl = align.getAlignment(Alignment.AlignmentType.GLOBAL, template, prot);
        Double best = bestAl.getCost();
        while (!((psa = align.getAlignment(Alignment.AlignmentType.GLOBAL, template = Sequence.create(protAlph, String.valueOf(first.toString()) + repeat.toString() + last), prot)).getCost() > best)) {
            best = psa.getCost();
            bestAl = psa;
            ++nreps;
            first.append(repeat);
        }
        String al1 = bestAl.getAlignedString(0);
        String al2 = bestAl.getAlignedString(1);
        int alignmentIndex = 0;
        int index = 0;
        while (index < start.getLength()) {
            if (al1.charAt(alignmentIndex) != '-') {
                ++index;
            }
            ++alignmentIndex;
        }
        Sequence foundStart = prot.getSubSequence(0, al2.substring(0, alignmentIndex).replaceAll("-", "").length());
        int off = alignmentIndex;
        int origOff = foundStart.getLength();
        TALE.Repeat[] foundRepeats = new TALE.Repeat[nreps + 1];
        int j = 0;
        while (j < nreps) {
            index = 0;
            while (index < repeat.getLength()) {
                if (al1.charAt(alignmentIndex) != '-') {
                    ++index;
                }
                ++alignmentIndex;
            }
            int currL = al2.substring(off, alignmentIndex).replaceAll("-", "").length();
            foundRepeats[j] = new TALE.Repeat(prot.getSubSequence(origOff, currL));
            origOff += currL;
            off = alignmentIndex;
            ++j;
        }
        index = 0;
        while (index < lastRepeat.getLength()) {
            if (al1.charAt(alignmentIndex) != '-') {
                ++index;
            }
            ++alignmentIndex;
        }
        int currL = al2.substring(off, alignmentIndex).replaceAll("-", "").length();
        if (currL == 0) {
            TALE.Repeat[] reps2 = new TALE.Repeat[nreps];
            System.arraycopy(foundRepeats, 0, reps2, 0, reps2.length);
            foundRepeats = reps2;
        } else {
            foundRepeats[foundRepeats.length - 1] = new TALE.Repeat(prot.getSubSequence(origOff, currL));
        }
        off = alignmentIndex;
        origOff += currL;
        index = 0;
        while (index < end.getLength()) {
            if (al1.charAt(alignmentIndex) != '-') {
                ++index;
            }
            ++alignmentIndex;
        }
        currL = al2.substring(off, alignmentIndex).replaceAll("-", "").length();
        Sequence foundEnd = prot.getSubSequence(origOff, currL);
        TALE dnaTALE = null;
        if (tale.getAlphabetContainer().checkConsistency(DNAAlphabetContainer.SINGLETON)) {
            Sequence dnaStart = tale.getSubSequence(0, foundStart.getLength() * 3);
            off = foundStart.getLength();
            TALE.Repeat[] dnaRepeat = new TALE.Repeat[foundRepeats.length];
            int j2 = 0;
            while (j2 < dnaRepeat.length) {
                dnaRepeat[j2] = new TALE.Repeat(tale.getSubSequence(off * 3, foundRepeats[j2].getRepeat().getLength() * 3));
                off += foundRepeats[j2].getRepeat().getLength();
                ++j2;
            }
            Sequence dnaEnd = tale.getSubSequence(off * 3, foundEnd.getLength() * 3);
            dnaTALE = new TALE(id, dnaStart, dnaRepeat, dnaEnd, true);
        }
        TALE transl = null;
        if (dnaTALE != null) {
            try {
                transl = dnaTALE.getTranslatedTALE(Tools.Translator.DEFAULT);
            }
            catch (Exception e) {
                protocol.appendWarning("Translated version of TALE " + id + " could not be created. Reason\n" + e.getMessage() + "\n");
            }
        } else {
            try {
                transl = new TALE(id, foundStart, foundRepeats, foundEnd, true);
            }
            catch (Exception e) {
                protocol.appendWarning("Translated version of TALE " + id + " could not be created. Reason\n" + e.getMessage() + "\n");
            }
        }
        return new TALE[]{dnaTALE, transl};
    }

    public static void main(String[] args) throws Exception {
        AlphabetContainer protAlph = Tools.Translator.DEFAULT.getProteinAlphabet();
        Sequence repeat = TALEConsensus.repeat;
        Sequence lastRepeat = TALEConsensus.lastRepeat;
        Sequence start = TALEConsensus.start;
        Sequence end = TALEConsensus.end;
        DNADataSet ds = new DNADataSet(args[0], '>', new SimpleSequenceAnnotationParser());
        PrintWriter starts = new PrintWriter(new FileWriter(String.valueOf(args[0]) + "_starts.txt"));
        PrintWriter repeats = new PrintWriter(new FileWriter(String.valueOf(args[0]) + "_repeats.txt"));
        PrintWriter ends = new PrintWriter(new FileWriter(String.valueOf(args[0]) + "_ends.txt"));
        PrintWriter dnaStarts = new PrintWriter(new FileWriter(String.valueOf(args[0]) + "_dnastarts.txt"));
        PrintWriter dnaRepeats = new PrintWriter(new FileWriter(String.valueOf(args[0]) + "_dnarepeats.txt"));
        PrintWriter dnaEnds = new PrintWriter(new FileWriter(String.valueOf(args[0]) + "_dnaends.txt"));
        AffineCosts costs = new AffineCosts(3.0, new MatrixCosts(Tools.Aligner.DEFAULT.getMatrix(), 2.0));
        Alignment align = new Alignment(costs);
        int i = 0;
        while (i < ds.getNumberOfElements()) {
            Sequence template;
            PairwiseStringAlignment psa;
            Sequence dna = ds.getElementAt(i);
            Sequence prot = Tools.Translator.DEFAULT.translate(dna, 0);
            int talelen = prot.getLength();
            int nreps = 1;
            StringBuffer first = new StringBuffer();
            first.append(start);
            int j = 0;
            while (j < nreps) {
                first.append(repeat);
                ++j;
            }
            String last = String.valueOf(lastRepeat.toString()) + end.toString();
            Double best = Double.POSITIVE_INFINITY;
            PairwiseStringAlignment bestAl = null;
            while (!((psa = align.getAlignment(Alignment.AlignmentType.GLOBAL, template = Sequence.create(protAlph, String.valueOf(first.toString()) + repeat.toString() + last), prot)).getCost() > best)) {
                best = psa.getCost();
                bestAl = psa;
                ++nreps;
                first.append(repeat);
            }
            System.out.println(bestAl);
            String al1 = bestAl.getAlignedString(0);
            String al2 = bestAl.getAlignedString(1);
            int alignmentIndex = 0;
            int index = 0;
            while (index < start.getLength()) {
                if (al1.charAt(alignmentIndex) != '-') {
                    ++index;
                }
                ++alignmentIndex;
            }
            String foundStart = al2.substring(0, alignmentIndex).replaceAll("-", "");
            int off = alignmentIndex;
            String[] foundRepeats = new String[nreps];
            int j2 = 0;
            while (j2 < nreps) {
                index = 0;
                while (index < repeat.getLength()) {
                    if (al1.charAt(alignmentIndex) != '-') {
                        ++index;
                    }
                    ++alignmentIndex;
                }
                foundRepeats[j2] = al2.substring(off, alignmentIndex).replaceAll("-", "");
                off = alignmentIndex;
                ++j2;
            }
            index = 0;
            while (index < lastRepeat.getLength()) {
                if (al1.charAt(alignmentIndex) != '-') {
                    ++index;
                }
                ++alignmentIndex;
            }
            String foundLastRepeat = al2.substring(off, alignmentIndex).replaceAll("-", "");
            off = alignmentIndex;
            index = 0;
            while (index < end.getLength()) {
                if (al1.charAt(alignmentIndex) != '-') {
                    ++index;
                }
                ++alignmentIndex;
            }
            String foundEnd = al2.substring(off, alignmentIndex).replaceAll("-", "");
            String dnaStart = dna.toString().substring(0, foundStart.length() * 3);
            off = foundStart.length();
            String[] dnaRepeat = new String[foundRepeats.length];
            int j3 = 0;
            while (j3 < dnaRepeat.length) {
                dnaRepeat[j3] = dna.toString().substring(off * 3, (off + foundRepeats[j3].length()) * 3);
                off += foundRepeats[j3].length();
                ++j3;
            }
            String dnaLastRepeat = dna.toString().substring(off * 3, (off + foundLastRepeat.length()) * 3);
            String dnaEnd = dna.toString().substring((off += foundLastRepeat.length()) * 3, (off + foundEnd.length()) * 3);
            String id = (String)dna.getSequenceAnnotationByType("unparsed comment line", 0).getResultAt(0).getValue();
            starts.println(">" + id + "\n" + foundStart);
            dnaStarts.println(">" + id + "\n" + dnaStart);
            repeats.println(">" + id);
            dnaRepeats.println(">" + id);
            int j4 = 0;
            while (j4 < foundRepeats.length) {
                repeats.println(foundRepeats[j4]);
                dnaRepeats.println(dnaRepeat[j4]);
                ++j4;
            }
            repeats.println(foundLastRepeat);
            dnaRepeats.println(dnaLastRepeat);
            ends.println(">" + id + "\n" + foundEnd);
            dnaEnds.println(">" + id + "\n" + dnaEnd);
            ++i;
        }
        starts.close();
        dnaStarts.close();
        repeats.close();
        dnaRepeats.close();
        ends.close();
        dnaEnds.close();
    }
}

