/*
 * Decompiled with CFR 0.152.
 */
package projects.xanthogenomes.tools;

import de.jstacs.DataType;
import de.jstacs.clustering.distances.DistanceMetric;
import de.jstacs.clustering.hierachical.ClusterTree;
import de.jstacs.clustering.hierachical.Hclust;
import de.jstacs.io.FileManager;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.ListResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.PlotGeneratorResult;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.SimpleResult;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import de.jstacs.utils.NiceScale;
import de.jstacs.utils.graphics.GraphicsAdaptor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import projects.xanthogenomes.TALE;
import projects.xanthogenomes.TALEAligner;
import projects.xanthogenomes.TALEFamilyBuilder;
import projects.xanthogenomes.tools.TALEAnalysisTool;

public class ClassPresenceTool
implements JstacsTool {
    @Override
    public ToolParameterSet getToolParameters() {
        FileParameter builderFile = new FileParameter("Class builder", "TALE class builder definition", "xml", true);
        FileParameter exclude = new FileParameter("Excluded strains", "List of the names of strains to be excluded", "txt", true);
        FileParameter include = new FileParameter("Included strains", "List of the names of strains to be included", "txt", true);
        try {
            SimpleParameter cut = new SimpleParameter(DataType.DOUBLE, "Cut height", "The height at which the class tree is cut", true, new NumberValidator<Double>(0.0, (Double)Double.MAX_VALUE), 10.0);
            SelectionParameter sp = new SelectionParameter(DataType.PARAMETERSET, new String[]{"by class tree", "alphabetically"}, new ParameterSet[]{new SimpleParameterSet(cut), new SimpleParameterSet(new Parameter[0])}, "Arrangement of classes", "If the list of classes should be arranged by the order in the class tree or alphabetically", true);
            SelectionParameter inex = new SelectionParameter(DataType.PARAMETERSET, new String[]{"none", "include", "exclude"}, new ParameterSet[]{new SimpleParameterSet(new Parameter[0]), new SimpleParameterSet(include, new SimpleParameter(DataType.BOOLEAN, "Keep order in plots", "If selected, order of strains in the plot will be kept as in the include file", true, false)), new SimpleParameterSet(exclude)}, "Exclude/Include", "Choose wether to exclude or (exclusively) include specific strains", true);
            SimpleParameter bool = new SimpleParameter(DataType.BOOLEAN, "Strains by presence", "If selected, strains will be ordered by presence, otherwise by TALE distance", true, false);
            return new ToolParameterSet(this.getShortName(), builderFile, sp, inex, bool);
        }
        catch (ParameterException e) {
            return null;
        }
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        String[] parts;
        String cont;
        progress.setLast(1.0);
        progress.setCurrent(0.0);
        protocol.append("Loading class builder.\n");
        final TALEFamilyBuilder builder = new TALEFamilyBuilder(new StringBuffer(((FileParameter)parameters.getParameterAt(0)).getFileContents().getContent()));
        progress.setCurrent(0.4);
        double height2 = Double.MAX_VALUE;
        if (((SelectionParameter)parameters.getParameterAt(1)).getSelected() == 0) {
            height2 = (Double)((ParameterSet)parameters.getParameterAt(1).getValue()).getParameterAt(0).getValue();
        }
        double height = height2;
        SelectionParameter inex = (SelectionParameter)parameters.getParameterAt(2);
        boolean bool = (Boolean)parameters.getParameterAt(3).getValue();
        String[] strainOrder = null;
        HashSet<String> excluded = null;
        HashSet<String> included = null;
        if (inex.getSelected() == 2) {
            excluded = new HashSet<String>();
            if (((ParameterSet)inex.getValue()).getParameterAt(0).getValue() != null) {
                cont = ((FileParameter)((ParameterSet)inex.getValue()).getParameterAt(0)).getFileContents().getContent();
                parts = cont.split("\n");
                int i = 0;
                while (i < parts.length) {
                    parts[i] = parts[i].trim();
                    if (parts[i].length() > 0) {
                        excluded.add(parts[i]);
                    }
                    ++i;
                }
            }
        } else if (inex.getSelected() == 1) {
            included = new HashSet<String>();
            if (((ParameterSet)inex.getValue()).getParameterAt(0).getValue() != null) {
                cont = ((FileParameter)((ParameterSet)inex.getValue()).getParameterAt(0)).getFileContents().getContent();
                parts = cont.split("\n");
                LinkedList<String> order = new LinkedList<String>();
                int i = 0;
                while (i < parts.length) {
                    parts[i] = parts[i].trim();
                    if (parts[i].length() > 0) {
                        included.add(parts[i]);
                        order.add(parts[i]);
                    }
                    ++i;
                }
                boolean keepOrder = (Boolean)((SimpleParameter)((ParameterSet)inex.getValue()).getParameterAt(1)).getValue();
                if (keepOrder) {
                    strainOrder = order.toArray(new String[0]);
                }
            }
        }
        protocol.append("Clustering classes.\n");
        ClusterTree<TALEFamilyBuilder.TALEFamily> famTree = builder.clusterFamilies();
        progress.setCurrent(0.7);
        ClusterTree<TALEFamilyBuilder.TALEFamily>[] subtrees = Hclust.cutTree(height, famTree);
        HashSet<String> allStrains = new HashSet<String>();
        TALE[] tales = builder.getAllTALEs();
        int i = 0;
        while (i < tales.length) {
            if (excluded == null && included == null || excluded != null && !excluded.contains(tales[i].getStrain()) || included != null && included.contains(tales[i].getStrain())) {
                allStrains.add(tales[i].getStrain());
            }
            ++i;
        }
        System.out.println(allStrains);
        Object[] strains = allStrains.toArray(new String[0]);
        Arrays.sort(strains);
        final HashMap<Object, Integer> tempMap = new HashMap<Object, Integer>();
        int i2 = 0;
        while (i2 < strains.length) {
            tempMap.put(strains[i2], i2);
            ++i2;
        }
        protocol.append("Collecting class presence in strains.\n");
        final boolean[][][] present2 = new boolean[subtrees.length][][];
        final TALE[][][] presTALEs = new TALE[subtrees.length][][];
        int i3 = 0;
        while (i3 < subtrees.length) {
            ClusterTree<TALEFamilyBuilder.TALEFamily> curr = subtrees[i3];
            TALEFamilyBuilder.TALEFamily[] currFams = curr.getClusterElements();
            if (height == Double.MAX_VALUE) {
                Arrays.sort(currFams, new Comparator<TALEFamilyBuilder.TALEFamily>(){

                    @Override
                    public int compare(TALEFamilyBuilder.TALEFamily o1, TALEFamilyBuilder.TALEFamily o2) {
                        return o1.getFamilyId().compareTo(o2.getFamilyId());
                    }
                });
            }
            present2[i3] = new boolean[currFams.length][tempMap.size()];
            presTALEs[i3] = new TALE[currFams.length][tempMap.size()];
            int j = 0;
            while (j < currFams.length) {
                TALEFamilyBuilder.TALEFamily currFam = currFams[j];
                String famId = currFam.getFamilyId();
                TALE[] famTALEs = currFam.getFamilyMembers();
                int k = 0;
                while (k < famTALEs.length) {
                    String strain = famTALEs[k].getStrain();
                    if (tempMap.containsKey(strain)) {
                        present2[i3][j][((Integer)tempMap.get((Object)strain)).intValue()] = true;
                        presTALEs[i3][j][((Integer)tempMap.get((Object)strain)).intValue()] = famTALEs[k];
                    }
                    ++k;
                }
                ++j;
            }
            ++i3;
        }
        progress.setCurrent(0.8);
        protocol.append("Arranging strains by class presence.\n");
        DistanceMetric<String> metric = null;
        metric = bool ? new DistanceMetric<String>(){

            @Override
            public double getDistance(String o1, String o2) throws Exception {
                double dist = 0.0;
                int i = 0;
                while (i < present2.length) {
                    int j = 0;
                    while (j < present2[i].length) {
                        if (present2[i][j][(Integer)tempMap.get(o1)] != present2[i][j][(Integer)tempMap.get(o2)]) {
                            dist += 1.0;
                        }
                        ++j;
                    }
                    ++i;
                }
                return dist;
            }
        } : new DistanceMetric<String>(){

            @Override
            public double getDistance(String o1, String o2) throws Exception {
                double dist = 0.0;
                int i = 0;
                while (i < presTALEs.length) {
                    int j = 0;
                    while (j < presTALEs[i].length) {
                        double contrib = Double.POSITIVE_INFINITY;
                        TALE tal1 = presTALEs[i][j][(Integer)tempMap.get(o1)];
                        TALE tal2 = presTALEs[i][j][(Integer)tempMap.get(o2)];
                        if (tal1 == null && tal2 != null) {
                            tal1 = this.findBestMatch(presTALEs, tempMap, o1, o2, tal2);
                        } else if (tal1 != null && tal2 == null) {
                            tal2 = this.findBestMatch(presTALEs, tempMap, o2, o1, tal1);
                        }
                        if (tal1 != null && tal2 != null) {
                            contrib = TALEAligner.align(tal1, tal2, builder.getCosts(), builder.getAlignmentType(), builder.getExtraGapOpening(), builder.getExtraGapExtension()).getCost();
                        } else if (tal1 == null && tal2 == null) {
                            contrib = 0.0;
                        }
                        if (contrib > builder.getCut() * 1.2) {
                            contrib = builder.getCut() * 1.2;
                        }
                        dist += contrib;
                        ++j;
                    }
                    ++i;
                }
                return dist;
            }

            private TALE findBestMatch(TALE[][][] presTALEs2, HashMap<String, Integer> tempMap2, String o1, String o2, TALE origin) {
                double minDist = Double.POSITIVE_INFINITY;
                TALE bestMatch = null;
                int i = 0;
                while (i < presTALEs2.length) {
                    int j = 0;
                    while (j < presTALEs2[i].length) {
                        double temp;
                        int k2 = tempMap2.get(o2);
                        int k1 = tempMap2.get(o1);
                        if (presTALEs2[i][j][k1] != null && presTALEs2[i][j][k2] == null && (temp = TALEAligner.align(origin, presTALEs2[i][j][k1], builder.getCosts(), builder.getAlignmentType(), builder.getExtraGapOpening(), builder.getExtraGapExtension()).getCost()) < minDist) {
                            temp = minDist;
                            bestMatch = presTALEs2[i][j][k1];
                        }
                        ++j;
                    }
                    ++i;
                }
                return bestMatch;
            }
        };
        Hclust<String> clus = new Hclust<String>(metric, Hclust.Linkage.AVERAGE);
        double[][] distMat = DistanceMetric.getPairwiseDistanceMatrix(metric, strains);
        ListResult lr2 = this.getList(distMat, (String[])strains);
        ClusterTree<String> strainTree = clus.cluster(distMat, (String[])strains);
        System.out.println(strainTree);
        strainTree.leafOrder(distMat);
        String newick = strainTree.toNewick();
        TextResult tr = new TextResult("Strain tree", "Strain tree (average linkage) in newick format", new FileParameter.FileRepresentation("", newick), "txt", this.getToolName(), null, true);
        strains = strainTree.getClusterElements();
        if (strainOrder != null) {
            strains = strainOrder;
        }
        progress.setCurrent(0.9);
        int[] translate = new int[strains.length];
        int i4 = 0;
        while (i4 < strains.length) {
            translate[i4] = (Integer)tempMap.get(strains[i4]);
            ++i4;
        }
        boolean[][][] present = new boolean[subtrees.length][][];
        int i5 = 0;
        while (i5 < present.length) {
            present[i5] = new boolean[present2[i5].length][];
            int j = 0;
            while (j < present[i5].length) {
                present[i5][j] = new boolean[present2[i5][j].length];
                int k = 0;
                while (k < present[i5][j].length) {
                    present[i5][j][k] = present2[i5][j][translate[k]];
                    ++k;
                }
                ++j;
            }
            ++i5;
        }
        protocol.append("Drawing diagram of class presence.\n");
        ClassPresencePlotter cpp = new ClassPresencePlotter(subtrees, present, (String[])strains, height, height < Double.MAX_VALUE);
        PlotGeneratorResult pgr = new PlotGeneratorResult("Class presence plot", "", cpp, true);
        ListResult lr = this.getList(subtrees, present, (String[])strains);
        ResultSet rs = new ResultSet(new Result[][]{{pgr, lr, lr2, tr}});
        progress.setCurrent(1.0);
        return new ToolResult("Result of " + this.getToolName(), "", null, rs, parameters, this.getToolName(), new Date(System.currentTimeMillis()));
    }

    private ListResult getList(double[][] distMat, String[] strains) {
        LinkedList<ResultSet> ress = new LinkedList<ResultSet>();
        int i = 0;
        while (i < distMat.length) {
            LinkedList<SimpleResult> temp = new LinkedList<SimpleResult>();
            temp.add(new CategoricalResult("Strain", "", strains[i]));
            int j = 0;
            while (j < distMat.length) {
                if (j < i) {
                    temp.add(new NumericalResult(strains[j], "", distMat[i][j]));
                } else if (i < j) {
                    temp.add(new NumericalResult(strains[j], "", distMat[j][i]));
                } else {
                    temp.add(new NumericalResult(strains[j], "", 0.0));
                }
                ++j;
            }
            ResultSet res = new ResultSet(temp);
            ress.add(res);
            ++i;
        }
        return new ListResult("Distance matrix", "Distance matrix of strains", null, ress.toArray(new ResultSet[0]));
    }

    private ListResult getList(ClusterTree<TALEFamilyBuilder.TALEFamily>[] subtrees, boolean[][][] present, String[] strains) {
        LinkedList<ResultSet> ress = new LinkedList<ResultSet>();
        int i = 0;
        while (i < present.length) {
            TALEFamilyBuilder.TALEFamily[] fams = subtrees[i].getClusterElements();
            int k = 0;
            while (k < present[i].length) {
                boolean isTrue = false;
                int j = 0;
                while (j < present[i][k].length && !isTrue) {
                    isTrue |= present[i][k][j];
                    ++j;
                }
                if (isTrue) {
                    String name = fams[k].getFamilyId();
                    LinkedList<CategoricalResult> res = new LinkedList<CategoricalResult>();
                    res.add(new CategoricalResult("TALE class", "", name));
                    int j2 = 0;
                    while (j2 < strains.length) {
                        res.add(new CategoricalResult(strains[j2], "", present[i][k][j2] ? "y" : "n"));
                        ++j2;
                    }
                    ress.add(new ResultSet(res));
                }
                ++k;
            }
            ++i;
        }
        return new ListResult("Class presence table", "", null, ress.toArray(new ResultSet[0]));
    }

    @Override
    public String getToolName() {
        return "TALE Class Presence";
    }

    @Override
    public String getToolVersion() {
        return "1.1";
    }

    @Override
    public String getShortName() {
        return "presence";
    }

    @Override
    public String getDescription() {
        return "Inspect class presence in class builder";
    }

    @Override
    public String getHelpText() {
        try {
            return FileManager.readInputStream(TALEAnalysisTool.class.getClassLoader().getResourceAsStream("projects/xanthogenomes/tools/ClassPresenceTool.txt")).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public String[] getReferences() {
        return new String[]{"@article{grau16annotale,\n\ttitle = {{AnnoTALE}: bioinformatics tools for identification, annotation, and nomenclature of {TALEs} from \\emph{Xanthomonas} genomic sequences},\n\tauthor = {Grau, Jan and Reschke, Maik and Erkes, Annett and Streubel, Jana and Morgan, Richard D. and Wilson, Geoffrey G. and Koebnik, Ralf and Boch, Jens},\n\tjournal = {Scientific Reports},\n\tyear = {2016},\n\tvolume = {6},\n\tpages = {21077},\n\tdoi = {10.1038/srep21077}\n\t}\n", "@article{erkes17evolution,\n\ttitle = {Evolution of Transcription Activator-Like Effectors in \\emph{Xanthomonas oryzae}},\n\tauthor = {Erkes, Annett and Reschke, Maik and Boch, Jens and Grau, Jan},\n\tjournal = {Genome Biology and Evolution},\n\tyear = {2017},\n\tvolume = {9},\n\tnumber = {6},\n\tpages = {1599-1615},\n\tdoi = {10.1093/gbe/evx108}\n\t}\n"};
    }

    public static class ClassPresencePlotter
    implements PlotGeneratorResult.PlotGenerator {
        private ClusterTree<TALEFamilyBuilder.TALEFamily>[] subtrees;
        private boolean[][][] present;
        private String[] strains;
        private double maxDist;
        private boolean drawTrees;
        private int treeWidth = 200;
        private static int lineHeight = 30;
        protected static DecimalFormat format = new DecimalFormat();

        public ClassPresencePlotter(ClusterTree<TALEFamilyBuilder.TALEFamily>[] subtrees, boolean[][][] present, String[] strains, double maxDist, boolean drawTrees) {
            this.subtrees = subtrees;
            this.present = present;
            this.strains = strains;
            this.maxDist = maxDist;
            this.drawTrees = drawTrees;
            if (!drawTrees) {
                this.treeWidth = 0;
            }
        }

        public ClassPresencePlotter(StringBuffer xml) throws NonParsableException {
            xml = XMLParser.extractForTag(xml, "ClassPresencePlotter");
            this.subtrees = (ClusterTree[])XMLParser.extractObjectForTags(xml, "subtrees");
            this.present = (boolean[][][])XMLParser.extractObjectForTags(xml, "present");
            this.strains = (String[])XMLParser.extractObjectForTags(xml, "strains");
            this.maxDist = (Double)XMLParser.extractObjectForTags(xml, "maxDist");
            this.drawTrees = (Boolean)XMLParser.extractObjectForTags(xml, "drawTrees");
            this.treeWidth = (Integer)XMLParser.extractObjectForTags(xml, "treeWidth");
        }

        @Override
        public StringBuffer toXML() {
            StringBuffer xml = new StringBuffer();
            XMLParser.appendObjectWithTags(xml, this.subtrees, "subtrees");
            XMLParser.appendObjectWithTags(xml, this.present, "present");
            XMLParser.appendObjectWithTags(xml, this.strains, "strains");
            XMLParser.appendObjectWithTags(xml, this.maxDist, "maxDist");
            XMLParser.appendObjectWithTags(xml, this.drawTrees, "drawTrees");
            XMLParser.appendObjectWithTags(xml, this.treeWidth, "treeWidth");
            XMLParser.addTags(xml, "ClassPresencePlotter");
            return xml;
        }

        @Override
        public void generatePlot(GraphicsAdaptor ga) throws Exception {
            int minX;
            Graphics2D dummy = ga.getGraphics(10, 10);
            int[] dim = this.getDimension(dummy, this.subtrees, this.strains);
            Graphics2D graphics = ga.getGraphics(dim[0], dim[1]);
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, dim[0], dim[1]);
            graphics.setColor(Color.black);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setFont(new Font("SansSerif", 0, (int)((double)lineHeight * 1.5)));
            double[] fontDim = this.getIDFontDimensions(graphics, this.subtrees);
            int w = (int)(fontDim[0] * 1.2);
            int h = (int)fontDim[1];
            int yoff = (int)this.getStrainFontDimensions(graphics, this.strains)[0] + 2 * lineHeight;
            int i = 0;
            while (i < this.strains.length) {
                ClassPresencePlotter.drawRotate(graphics, (double)(this.treeWidth + w + lineHeight * 2 * i) + (double)lineHeight * 1.5 + (double)(lineHeight / 2), (double)yoff - fontDim[1] / 2.0, -50, this.strains[i]);
                graphics.drawLine(this.treeWidth + w + lineHeight * 2 * i + lineHeight / 2, yoff, this.treeWidth + w + lineHeight * 2 * i + lineHeight / 2, dim[1] - 4 * lineHeight);
                ++i;
            }
            graphics.drawLine(this.treeWidth + w + lineHeight * 2 * this.strains.length + lineHeight / 2, yoff, this.treeWidth + w + lineHeight * 2 * this.strains.length + lineHeight / 2, dim[1] - 4 * lineHeight);
            yoff += 2 * lineHeight;
            i = 0;
            while (i < this.subtrees.length) {
                yoff = this.plotSubtree(graphics, this.subtrees[i], this.present[i], yoff, w, h, this.drawTrees);
                ++i;
            }
            graphics.setStroke(new BasicStroke(2.0f));
            NiceScale scale = new NiceScale(0.0, this.maxDist);
            scale.setMaxTicks(4.0);
            double min = scale.getNiceMin();
            double max = scale.getNiceMax();
            double tick = scale.getTickSpacing();
            double rat = (double)this.treeWidth / this.maxDist;
            int maxX = minX = lineHeight + (int)Math.round((this.maxDist - min) * rat);
            double i2 = min;
            while (i2 <= max + tick / 2.0) {
                int x;
                if (i2 < 1.0E-6 && i2 > -1.0E-6) {
                    i2 = 0.0;
                }
                if ((x = lineHeight + (int)Math.round((this.maxDist - i2) * rat)) > lineHeight / 2) {
                    graphics.drawLine(x, yoff, x, yoff + lineHeight / 2);
                    maxX = x;
                    String label = format.format(i2);
                    int textCenter = (int)Math.round(graphics.getFontMetrics().getStringBounds(label, graphics).getCenterX());
                    graphics.drawString(label, x - textCenter, yoff + 2 * lineHeight - 5);
                }
                i2 += tick;
            }
            graphics.drawLine(minX, yoff, maxX, yoff);
        }

        public static void drawRotate(Graphics2D g2d, double x, double y, int angle, String text) {
            g2d.translate((float)x, (float)y);
            g2d.rotate(Math.toRadians(angle));
            g2d.drawString(text, 0, 0);
            g2d.rotate(-Math.toRadians(angle));
            g2d.translate(-((float)x), -((float)y));
        }

        public int[] getDimension(Graphics2D graphics, ClusterTree<TALEFamilyBuilder.TALEFamily>[] trees, String[] strains) {
            int fh;
            graphics = (Graphics2D)graphics.create();
            graphics.setFont(new Font("SansSerif", 0, (int)((double)lineHeight * 1.5)));
            double[] idDim = this.getIDFontDimensions(graphics, trees);
            int height = fh = (int)this.getStrainFontDimensions(graphics, strains)[0];
            int i = 0;
            while (i < trees.length) {
                TALEFamilyBuilder.TALEFamily[] fams = trees[i].getClusterElements();
                int j = 0;
                while (j < fams.length) {
                    boolean included = false;
                    TALE[] tales = fams[j].getFamilyMembers();
                    int k = 0;
                    block2: while (k < tales.length) {
                        int l = 0;
                        while (l < strains.length) {
                            if (strains[l].equals(tales[k].getStrain())) {
                                included = true;
                                break block2;
                            }
                            ++l;
                        }
                        ++k;
                    }
                    if (included) {
                        height += lineHeight * 2;
                    }
                    ++j;
                }
                ++i;
            }
            height += lineHeight * 2 * 2;
            int tw = this.treeWidth + (int)(idDim[0] * 1.2) + (strains.length + 1) * lineHeight * 2 + (int)((double)fh * 0.6);
            return new int[]{tw, height += lineHeight * 2};
        }

        private double[] getIDFontDimensions(Graphics2D graphics, ClusterTree<TALEFamilyBuilder.TALEFamily>[] trees) {
            double fontHeight = 0.0;
            double fontWidth = 0.0;
            int j = 0;
            while (j < trees.length) {
                TALEFamilyBuilder.TALEFamily[] members = trees[j].getClusterElements();
                int i = 0;
                while (i < members.length) {
                    String id = members[i].getFamilyId();
                    Rectangle2D rect = graphics.getFontMetrics().getStringBounds(id, graphics);
                    if (rect.getHeight() > fontHeight) {
                        fontHeight = rect.getHeight();
                    }
                    if (rect.getWidth() > fontWidth) {
                        fontWidth = rect.getWidth();
                    }
                    ++i;
                }
                ++j;
            }
            return new double[]{fontWidth, fontHeight};
        }

        private double[] getStrainFontDimensions(Graphics2D graphics, String[] strains) {
            double fontHeight = 0.0;
            double fontWidth = 0.0;
            int i = 0;
            while (i < strains.length) {
                String id = strains[i];
                Rectangle2D rect = graphics.getFontMetrics().getStringBounds(id, graphics);
                if (rect.getHeight() > fontHeight) {
                    fontHeight = rect.getHeight();
                }
                if (rect.getWidth() > fontWidth) {
                    fontWidth = rect.getWidth();
                }
                ++i;
            }
            return new double[]{fontWidth, fontHeight};
        }

        private int plotSubtree(Graphics2D graphics, ClusterTree<TALEFamilyBuilder.TALEFamily> subtree, boolean[][] present, int yoff, int idWidth, int idHeight, boolean drawTree) {
            graphics = (Graphics2D)graphics.create();
            int xoff = this.treeWidth + lineHeight / 2;
            int yoffBack = yoff;
            TALEFamilyBuilder.TALEFamily[] fams = subtree.getClusterElements();
            xoff += idWidth;
            yoff = yoffBack;
            int i = 0;
            while (i < present.length) {
                boolean isTrue = false;
                int j = 0;
                while (j < present[i].length && !isTrue) {
                    isTrue |= present[i][j];
                    ++j;
                }
                if (isTrue) {
                    graphics.drawString(fams[i].getFamilyId(), xoff - idWidth + (int)((double)lineHeight * 0.75), yoff - (lineHeight * 2 - idHeight));
                    graphics.drawLine(xoff, yoff - 2 * lineHeight, xoff + present[i].length * lineHeight * 2, yoff - 2 * lineHeight);
                    j = 0;
                    while (j < present[i].length) {
                        if (present[i][j]) {
                            graphics.setColor(new Color(0.0f, 0.0f, 0.5f, 0.6f));
                            graphics.fillRect(xoff + j * lineHeight * 2 + 2, yoff - 2 * lineHeight + 2, 2 * lineHeight - 4, 2 * lineHeight - 4);
                            graphics.setColor(Color.BLACK);
                        }
                        ++j;
                    }
                    yoff += 2 * lineHeight;
                }
                ++i;
            }
            graphics.drawLine(xoff, yoff - 2 * lineHeight, xoff + present[0].length * lineHeight * 2, yoff - 2 * lineHeight);
            graphics.setStroke(new BasicStroke(2.0f));
            if (drawTree) {
                this.drawTree(graphics, subtree, present, 0, yoffBack - 2 * lineHeight, 0);
            }
            return yoff;
        }

        private int drawTree(Graphics2D graphics, ClusterTree<TALEFamilyBuilder.TALEFamily> subtree, boolean[][] present, int off, int yoff, int level) {
            int n = 0;
            int i = off;
            while (i < off + subtree.getNumberOfElements()) {
                boolean isTrue = false;
                int j = 0;
                while (j < present[i].length && !isTrue) {
                    isTrue |= present[i][j];
                    ++j;
                }
                if (isTrue) {
                    ++n;
                }
                ++i;
            }
            int xoff = lineHeight + (int)((1.0 - subtree.getDistance() / this.maxDist) * (double)this.treeWidth);
            if (n > 1) {
                ClusterTree<TALEFamilyBuilder.TALEFamily> left = subtree.getSubTrees()[0];
                ClusterTree<TALEFamilyBuilder.TALEFamily> right = subtree.getSubTrees()[1];
                int numLeft = this.drawTree(graphics, left, present, off, yoff, level + 1);
                int numRight = this.drawTree(graphics, right, present, off + left.getNumberOfElements(), yoff + numLeft * 2 * lineHeight, level + 1);
                graphics.drawLine(xoff, yoff + numLeft * lineHeight, xoff, yoff + numLeft * 2 * lineHeight + numRight * lineHeight);
                int xoff2 = this.treeWidth + lineHeight;
                if (numLeft > 1) {
                    xoff2 = lineHeight + (int)((1.0 - left.getDistance() / this.maxDist) * (double)this.treeWidth);
                }
                graphics.drawLine(xoff, yoff + numLeft * lineHeight, xoff2, yoff + numLeft * lineHeight);
                xoff2 = this.treeWidth + lineHeight;
                if (numRight > 1) {
                    xoff2 = lineHeight + (int)((1.0 - right.getDistance() / this.maxDist) * (double)this.treeWidth);
                }
                graphics.drawLine(xoff, yoff + numLeft * 2 * lineHeight + numRight * lineHeight, xoff2, yoff + numLeft * 2 * lineHeight + numRight * lineHeight);
            } else if (n > 0) {
                // empty if block
            }
            return n;
        }
    }
}

