/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.discrepancy;

import umontreal.ssj.discrepancy.Discrepancy;
import umontreal.ssj.hups.Rank1Lattice;
import umontreal.ssj.util.Num;
import umontreal.ssj.util.PrintfFormat;

public class Palpha
extends Discrepancy {
    private double[] C;
    private int alpha;

    private void initFactor(int s, double[] Beta2, int alpha) {
        this.C = new double[s];
        for (int j = 1; j <= s; ++j) {
            this.C[j - 1] = Math.pow(Math.PI * 2 * Beta2[j], alpha) / Num.factorial(alpha);
        }
    }

    private void initA(int s, double[] bet, int alp) {
        if (null == bet) {
            Palpha.setONES(s);
            this.gamma = ONES;
        } else {
            this.gamma = bet;
        }
        this.alpha = alp;
    }

    public Palpha(double[][] points, int n, int s, double[] beta, int alpha) {
        super(points, n, s, beta);
        this.initA(s, beta, alpha);
    }

    public Palpha(double[][] points, int n, int s, int alpha) {
        super(points, n, s);
        this.initA(s, null, alpha);
    }

    public Palpha(int n, int s, double[] beta, int alpha) {
        super(n, s, beta);
        this.initA(s, beta, alpha);
    }

    public Palpha(int alpha) {
        this.alpha = alpha;
    }

    public Palpha(Rank1Lattice set, double[] beta, int alpha) {
        super(set);
        this.initA(set.getDimension(), beta, alpha);
    }

    @Override
    public double compute(double[][] points, int n, int s) {
        return this.compute(points, n, s, null, this.alpha);
    }

    @Override
    public double compute(double[][] points, int n, int s, double[] beta) {
        return this.compute(points, n, s, beta, this.alpha);
    }

    public double compute(double[][] points, int n, int s, int alpha) {
        return this.compute(points, n, s, null, alpha);
    }

    public double compute(double[][] points, int n, int s, double[] beta, int alpha) {
        this.initA(s, beta, alpha);
        this.initFactor(s, this.gamma, alpha);
        switch (alpha) {
            case 2: {
                return this.calcPalpha2(points, n, s, this.gamma);
            }
            case 4: {
                return this.calcPalpha4(points, n, s, this.gamma);
            }
            case 6: {
                return this.calcPalpha6(points, n, s, this.gamma);
            }
            case 8: {
                return this.calcPalpha8(points, n, s, this.gamma);
            }
        }
        throw new IllegalArgumentException("alpha must be one of {2, 4, 6, 8}");
    }

    private double calcPalpha2(double[][] points, int N, int s, double[] beta) {
        double sum = 0.0;
        for (int i = 0; i < N; ++i) {
            double prod = 1.0;
            for (int j = 0; j < s; ++j) {
                double u = this.Points[i][j];
                prod *= 1.0 + this.C[j] * (u * (u - 1.0) + 0.16666666666666666);
            }
            sum += prod;
        }
        return beta[0] * ((sum /= (double)N) - 1.0);
    }

    private double calcPalpha4(double[][] points, int N, int s, double[] beta) {
        double sum = 0.0;
        for (int i = 0; i < N; ++i) {
            double prod = 1.0;
            for (int j = 0; j < s; ++j) {
                double u = this.Points[i][j];
                prod *= 1.0 - this.C[j] * (((u - 2.0) * u + 1.0) * u * u - 0.03333333333333333);
            }
            sum += prod;
        }
        return beta[0] * ((sum /= (double)N) - 1.0);
    }

    private double calcPalpha6(double[][] points, int N, int s, double[] beta) {
        double sum = 0.0;
        for (int i = 0; i < N; ++i) {
            double prod = 1.0;
            for (int j = 0; j < s; ++j) {
                double u = this.Points[i][j];
                prod *= 1.0 + this.C[j] * ((((u - 3.0) * u + 2.5) * u * u - 0.5) * u * u + 0.023809523809523808);
            }
            sum += prod;
        }
        return beta[0] * ((sum /= (double)N) - 1.0);
    }

    private double calcPalpha8(double[][] points, int N, int s, double[] beta) {
        double sum = 0.0;
        for (int i = 0; i < N; ++i) {
            double prod = 1.0;
            for (int j = 0; j < s; ++j) {
                double u = this.Points[i][j];
                prod *= 1.0 - this.C[j] * (((((u - 4.0) * u + 4.666666666666667) * u * u - 2.3333333333333335) * u * u + 0.6666666666666666) * u * u - 0.03333333333333333);
            }
            sum += prod;
        }
        return beta[0] * ((sum /= (double)N) - 1.0);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(this.getName() + ":" + PrintfFormat.NEWLINE);
        sb.append("n = " + this.numPoints + ",   dim = " + this.dim + PrintfFormat.NEWLINE);
        sb.append("gamma = [");
        this.appendGamma(sb, this.gamma, this.dim + 1);
        sb.append(" ]" + PrintfFormat.NEWLINE);
        sb.append("alpha = " + this.alpha + PrintfFormat.NEWLINE);
        return sb.toString();
    }

    public void setBeta(double[] beta) {
        this.gamma = beta;
    }
}

