/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.probdist;

import optimization.Lmder_fcn;
import optimization.Minpack_f77;
import umontreal.ssj.probdist.ContinuousDistribution;
import umontreal.ssj.probdist.GammaDist;
import umontreal.ssj.probdist.NormalDist;
import umontreal.ssj.util.Num;

public class BetaDist
extends ContinuousDistribution {
    protected double alpha;
    protected double beta;
    protected double a;
    protected double b;
    protected double bminusa;
    protected double logFactor;
    protected double Beta;
    protected double logBeta;

    public BetaDist(double alpha, double beta) {
        this.setParams(alpha, beta, 0.0, 1.0);
    }

    public BetaDist(double alpha, double beta, double a, double b) {
        this.setParams(alpha, beta, a, b);
    }

    @Deprecated
    public BetaDist(double alpha, double beta, int d) {
        this.setParams(alpha, beta, 0.0, 1.0, d);
    }

    @Deprecated
    public BetaDist(double alpha, double beta, double a, double b, int d) {
        this.setParams(alpha, beta, a, b, d);
    }

    @Override
    public double density(double x) {
        if (x <= this.a || x >= this.b) {
            return 0.0;
        }
        double temp = (this.alpha - 1.0) * Math.log(x - this.a) + (this.beta - 1.0) * Math.log(this.b - x);
        return Math.exp(this.logFactor + temp);
    }

    @Override
    public double cdf(double x) {
        return BetaDist.cdf(this.alpha, this.beta, (x - this.a) / this.bminusa);
    }

    @Override
    public double barF(double x) {
        return BetaDist.barF(this.alpha, this.beta, (x - this.a) / this.bminusa);
    }

    @Override
    public double inverseF(double u) {
        return this.a + (this.b - this.a) * BetaDist.inverseF(this.alpha, this.beta, u);
    }

    @Override
    public double getMean() {
        return BetaDist.getMean(this.alpha, this.beta, this.a, this.b);
    }

    @Override
    public double getVariance() {
        return BetaDist.getVariance(this.alpha, this.beta, this.a, this.b);
    }

    @Override
    public double getStandardDeviation() {
        return BetaDist.getStandardDeviation(this.alpha, this.beta, this.a, this.b);
    }

    public static double density(double alpha, double beta, double x) {
        return BetaDist.density(alpha, beta, 0.0, 1.0, x);
    }

    public static double density(double alpha, double beta, double a, double b, double x) {
        if (a >= b) {
            throw new IllegalArgumentException("a >= b");
        }
        if (x <= a || x >= b) {
            return 0.0;
        }
        double z = -Num.lnBeta(alpha, beta) - (alpha + beta - 1.0) * Math.log(b - a) + (alpha - 1.0) * Math.log(x - a) + (beta - 1.0) * Math.log(b - x);
        return Math.exp(z);
    }

    static double beta_g(double x) {
        double term;
        if (x > 1.0) {
            return -BetaDist.beta_g(1.0 / x);
        }
        if (x < 1.0E-200) {
            return 1.0;
        }
        double y = 1.0 - x;
        if (x < 0.9) {
            return (1.0 - x * x + 2.0 * x * Math.log(x)) / (y * y);
        }
        if (x == 1.0) {
            return 0.0;
        }
        double EPS = 1.0E-12;
        double ypow = 1.0;
        double sum = 0.0;
        int j = 2;
        do {
            term = (ypow *= y) / (double)(j * (j + 1));
            ++j;
        } while (Math.abs(term / (sum += term)) > 1.0E-12);
        return 2.0 * sum;
    }

    private static double bolshev(double alpha, double beta, int d, double x) {
        double u;
        boolean flag = false;
        if (alpha < beta) {
            u = alpha;
            alpha = beta;
            beta = u;
            flag = false;
        } else {
            flag = true;
        }
        u = alpha + 0.5 * beta - 0.5;
        double temp = !flag ? x / (2.0 - x) : (1.0 - x) / (1.0 + x);
        double yd = 2.0 * u * temp;
        double gam = Math.exp(beta * Math.log(yd) - yd - Num.lnGamma(beta)) * (2.0 * yd * yd - (beta - 1.0) * yd - (beta * beta - 1.0)) / (24.0 * u * u);
        if (flag) {
            yd = GammaDist.barF(beta, d, yd);
            return Math.max(0.0, yd - gam);
        }
        yd = GammaDist.cdf(beta, d, yd);
        return yd + gam;
    }

    private static double peizer(double alpha, double beta, double x) {
        double h1 = alpha + beta - 1.0;
        double y = 1.0 - x;
        double temp = x > 1.0E-15 ? 1.0 + y * BetaDist.beta_g((alpha - 0.5) / (h1 * x)) : GammaDist.mybelog((alpha - 0.5) / (h1 * x));
        double h3 = Math.sqrt((temp + x * BetaDist.beta_g((beta - 0.5) / (h1 * y))) / ((h1 + 0.16666666666666666) * x * y)) * ((h1 + 0.3333333333333333 + 0.02 * (1.0 / alpha + 1.0 / beta + 1.0 / (alpha + beta))) * x - alpha + 0.3333333333333333 - 0.02 / alpha - 0.01 / (alpha + beta));
        return NormalDist.cdf01(h3);
    }

    private static double donato(double alpha, double beta, double x) {
        double tem;
        int m;
        double mid = (alpha + 1.0) / (alpha + beta + 2.0);
        if (x > mid) {
            return 1.0 - BetaDist.donato(beta, alpha, 1.0 - x);
        }
        int MMAX = 100;
        double[] Ta = new double[101];
        double[] Tb = new double[101];
        int M1 = 100;
        if (beta <= 100.0 && beta % 1.0 < 1.0E-100) {
            M1 = (int)beta;
        }
        Ta[1] = 1.0;
        for (m = 1; m < M1; ++m) {
            tem = alpha + (double)(2 * m) - 1.0;
            Ta[m + 1] = (alpha + (double)m - 1.0) * (alpha + beta + (double)m - 1.0) * (beta - (double)m) * (double)m * x * x / (tem * tem);
        }
        tem = alpha * (alpha + beta) / (alpha + 1.0);
        Tb[1] = alpha - tem * x;
        for (m = 1; m < M1; ++m) {
            tem = (alpha + (double)m) * (alpha + beta + (double)m) / (alpha + (double)(2 * m) + 1.0);
            double tem1 = (double)m * (beta - (double)m) / (alpha + (double)(2 * m) - 1.0);
            Tb[m + 1] = alpha + (double)(2 * m) + (tem1 - tem) * x;
        }
        while (0.0 == Tb[M1] && M1 > 1) {
            --M1;
        }
        double con = 0.0;
        for (m = M1; m > 0; --m) {
            con = Ta[m] / (Tb[m] + con);
        }
        tem = Num.lnBeta(alpha, beta) - alpha * Math.log(x) - beta * Math.log1p(-x);
        return con * Math.exp(-tem);
    }

    @Deprecated
    public static double cdf(double alpha, double beta, int d, double x) {
        return BetaDist.cdf(alpha, beta, x);
    }

    @Deprecated
    public static double cdf(double alpha, double beta, double a, double b, int d, double x) {
        return BetaDist.cdf(alpha, beta, d, (x - a) / (b - a));
    }

    @Deprecated
    public static double barF(double alpha, double beta, int d, double x) {
        return 1.0 - BetaDist.cdf(alpha, beta, d, x);
    }

    @Deprecated
    public static double barF(double alpha, double beta, double a, double b, int d, double x) {
        if (a >= b) {
            throw new IllegalArgumentException("a >= b");
        }
        return 1.0 - BetaDist.cdf(alpha, beta, d, (x - a) / (b - a));
    }

    public static double cdf(double alpha, double beta, double x) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= 1.0) {
            return 1.0;
        }
        if (1.0 == beta) {
            return Math.pow(x, alpha);
        }
        double ALPHABETAMAX = 10000.0;
        double ALPHABETALIM = 30.0;
        if (Math.max(alpha, beta) <= 10000.0) {
            return BetaDist.donato(alpha, beta, x);
        }
        if (alpha > 10000.0 && beta < 30.0 || beta > 10000.0 && alpha < 30.0) {
            return BetaDist.bolshev(alpha, beta, 12, x);
        }
        return BetaDist.peizer(alpha, beta, x);
    }

    public static double cdf(double alpha, double beta, double a, double b, double x) {
        return BetaDist.cdf(alpha, beta, (x - a) / (b - a));
    }

    public static double barF(double alpha, double beta, double x) {
        return BetaDist.cdf(beta, alpha, 1.0 - x);
    }

    public static double barF(double alpha, double beta, double a, double b, double x) {
        if (a >= b) {
            throw new IllegalArgumentException("a >= b");
        }
        return BetaDist.cdf(beta, alpha, (b - x) / (b - a));
    }

    @Deprecated
    public static double inverseF(double alpha, double beta, int d, double u) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d <= 0) {
            throw new IllegalArgumentException("d <= 0");
        }
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u <= 0.0) {
            return 0.0;
        }
        if (u >= 1.0) {
            return 1.0;
        }
        double MACHEP = 1.110223E-16f;
        double MAXLOG = 709.782712893384;
        double MINLOG = -708.3964185322641;
        boolean ihalve = false;
        boolean newt = false;
        double p = 0.0;
        double q = 0.0;
        double y0 = 0.0;
        double z = 0.0;
        double y = 0.0;
        double x = 0.0;
        double lgm = 0.0;
        double yp = 0.0;
        double di = 0.0;
        double dithresh = 0.0;
        double xt = 0.0;
        double x0 = 0.0;
        double yl = 0.0;
        double x1 = 1.0;
        double yh = 1.0;
        boolean nflg = false;
        boolean rflg = false;
        if (alpha <= 1.0 || beta <= 1.0) {
            dithresh = 1.0E-6;
            rflg = false;
            p = alpha;
            q = beta;
            y0 = u;
            x = p / (p + q);
            y = BetaDist.cdf(p, q, x);
            ihalve = true;
        } else {
            dithresh = 1.0E-4;
        }
        block0: while (true) {
            int i;
            if (ihalve) {
                ihalve = false;
                int dir = 0;
                di = 0.5;
                for (i = 0; i < 100; ++i) {
                    if (i != 0) {
                        x = x0 + di * (x1 - x0);
                        if (x == 1.0) {
                            x = 0.9999999999999999;
                        }
                        if (x == 0.0 && (x = x0 + (di = 0.5) * (x1 - x0)) == 0.0) {
                            return 0.0;
                        }
                        y = BetaDist.cdf(p, q, x);
                        yp = (x1 - x0) / (x1 + x0);
                        if (Math.abs(yp) < dithresh) {
                            newt = true;
                            continue block0;
                        }
                        yp = (y - y0) / y0;
                        if (Math.abs(yp) < dithresh) {
                            newt = true;
                            continue block0;
                        }
                    }
                    if (y < y0) {
                        x0 = x;
                        yl = y;
                        if (dir < 0) {
                            dir = 0;
                            di = 0.5;
                        } else {
                            di = dir > 3 ? 1.0 - (1.0 - di) * (1.0 - di) : (dir > 1 ? 0.5 * di + 0.5 : (y0 - y) / (yh - yl));
                        }
                        ++dir;
                        if (!(x0 > 0.75)) continue;
                        if (rflg) {
                            rflg = false;
                            p = alpha;
                            q = beta;
                            y0 = u;
                        } else {
                            rflg = true;
                            p = beta;
                            q = alpha;
                            y0 = 1.0 - u;
                        }
                        x = 1.0 - x;
                        y = BetaDist.cdf(p, q, x);
                        x0 = 0.0;
                        yl = 0.0;
                        x1 = 1.0;
                        yh = 1.0;
                        ihalve = true;
                        continue block0;
                    }
                    x1 = x;
                    if (rflg && x1 < (double)1.110223E-16f) {
                        x = 0.0;
                        break block0;
                    }
                    yh = y;
                    if (dir > 0) {
                        dir = 0;
                        di = 0.5;
                    } else {
                        di = dir < -3 ? (di *= di) : (dir < -1 ? 0.5 * di : (y - y0) / (yh - yl));
                    }
                    --dir;
                }
                if (x0 >= 1.0) {
                    x = 0.9999999999999999;
                    break;
                }
                if (x <= 0.0) {
                    return 0.0;
                }
                newt = true;
            }
            if (newt) {
                newt = false;
                if (nflg) break;
                nflg = true;
                lgm = Num.lnGamma(p + q) - Num.lnGamma(p) - Num.lnGamma(q);
                for (i = 0; i < 8; ++i) {
                    if (i != 0) {
                        y = BetaDist.cdf(p, q, x);
                    }
                    if (y < yl) {
                        x = x0;
                        y = yl;
                    } else if (y > yh) {
                        x = x1;
                        y = yh;
                    } else if (y < y0) {
                        x0 = x;
                        yl = y;
                    } else {
                        x1 = x;
                        yh = y;
                    }
                    if (x >= 1.0 || x <= 0.0) break;
                    z = (p - 1.0) * Math.log(x) + (q - 1.0) * Math.log1p(-x) + lgm;
                    if (z < -708.3964185322641) break block0;
                    if (z > 709.782712893384) break;
                    z = Math.exp(z);
                    xt = x - (z = (y - y0) / z);
                    if (xt <= x0 && (xt = x0 + 0.5 * (y = (x - x0) / (x1 - x0)) * (x - x0)) <= 0.0 || xt >= x1 && (xt = x1 - 0.5 * (y = (x1 - x) / (x1 - x0)) * (x1 - x)) >= 1.0) break;
                    x = xt;
                    if (Math.abs(z / x) < 1.4210854715202004E-14) break block0;
                }
                dithresh = 2.842170943040401E-14;
                ihalve = true;
                continue;
            }
            yp = -NormalDist.inverseF01(u);
            if (u > 0.5) {
                rflg = true;
                p = beta;
                q = alpha;
                y0 = 1.0 - u;
                yp = -yp;
            } else {
                rflg = false;
                p = alpha;
                q = beta;
                y0 = u;
            }
            lgm = (yp * yp - 3.0) / 6.0;
            x = 2.0 / (1.0 / (2.0 * p - 1.0) + 1.0 / (2.0 * q - 1.0));
            z = yp * Math.sqrt(x + lgm) / x - (1.0 / (2.0 * q - 1.0) - 1.0 / (2.0 * p - 1.0)) * (lgm + 0.8333333333333334 - 2.0 / (3.0 * x));
            z = 2.0 * z;
            if (z < -708.3964185322641) {
                x = 1.0;
                return 0.0;
            }
            x = p / (p + q * Math.exp(z));
            y = BetaDist.cdf(p, q, x);
            yp = (y - y0) / y0;
            if (Math.abs(yp) < 0.2) {
                newt = true;
                continue;
            }
            ihalve = true;
        }
        if (rflg) {
            x = x <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - x;
        }
        return x;
    }

    public static double inverseF(double alpha, double beta, double u) {
        return BetaDist.inverseF(alpha, beta, 12, u);
    }

    @Deprecated
    public static double inverseF(double alpha, double beta, double a, double b, int d, double u) {
        if (a >= b) {
            throw new IllegalArgumentException("a >= b");
        }
        return a + (b - a) * BetaDist.inverseF(alpha, beta, d, u);
    }

    public static double inverseF(double alpha, double beta, double a, double b, double u) {
        if (a >= b) {
            throw new IllegalArgumentException("a >= b");
        }
        return a + (b - a) * BetaDist.inverseF(alpha, beta, u);
    }

    public static double[] getMLE(double[] x, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double sum = 0.0;
        double a = 0.0;
        double b = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += x[i];
            a = x[i] > 0.0 ? (a += Math.log(x[i])) : (a -= 709.0);
            if (x[i] < 1.0) {
                b += Math.log1p(-x[i]);
                continue;
            }
            b -= 709.0;
        }
        double mean = sum / (double)n;
        sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += (x[i] - mean) * (x[i] - mean);
        }
        double var = sum / (double)(n - 1);
        Optim system = new Optim(a, b);
        double[] param = new double[3];
        param[1] = mean * (mean * (1.0 - mean) / var - 1.0);
        param[2] = (1.0 - mean) * (mean * (1.0 - mean) / var - 1.0);
        double[] fvec = new double[3];
        double[][] fjac = new double[3][3];
        int[] info = new int[2];
        int[] ipvt = new int[3];
        Minpack_f77.lmder1_f77((Lmder_fcn)system, (int)2, (int)2, (double[])param, (double[])fvec, (double[][])fjac, (double)1.0E-5, (int[])info, (int[])ipvt);
        double[] parameters = new double[]{param[1], param[2]};
        return parameters;
    }

    public static BetaDist getInstanceFromMLE(double[] x, int n) {
        double[] parameters = BetaDist.getMLE(x, n);
        return new BetaDist(parameters[0], parameters[1]);
    }

    public static double getMean(double alpha, double beta) {
        return BetaDist.getMean(alpha, beta, 0.0, 1.0);
    }

    public static double getMean(double alpha, double beta, double a, double b) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return (alpha * b + beta * a) / (alpha + beta);
    }

    public static double getVariance(double alpha, double beta) {
        return BetaDist.getVariance(alpha, beta, 0.0, 1.0);
    }

    public static double getVariance(double alpha, double beta, double a, double b) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return alpha * beta * (b - a) * (b - a) / ((alpha + beta) * (alpha + beta) * (alpha + beta + 1.0));
    }

    public static double getStandardDeviation(double alpha, double beta) {
        return Math.sqrt(BetaDist.getVariance(alpha, beta));
    }

    public static double getStandardDeviation(double alpha, double beta, double a, double b) {
        return Math.sqrt(BetaDist.getVariance(alpha, beta, a, b));
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    @Deprecated
    public void setParams(double alpha, double beta, double a, double b, int d) {
        this.setParams(alpha, beta, a, b);
    }

    public void setParams(double alpha, double beta, double a, double b) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (a >= b) {
            throw new IllegalArgumentException("a >= b");
        }
        this.alpha = alpha;
        this.beta = beta;
        this.supportA = this.a = a;
        this.supportB = this.b = b;
        this.bminusa = b - a;
        double temp = Num.lnGamma(alpha);
        temp = alpha == beta ? (temp *= 2.0) : (temp += Num.lnGamma(beta));
        this.logBeta = temp - Num.lnGamma(alpha + beta);
        this.Beta = Math.exp(this.logBeta);
        this.logFactor = -this.logBeta - Math.log(this.bminusa) * (alpha + beta - 1.0);
    }

    @Override
    public double[] getParams() {
        double[] retour = new double[]{this.alpha, this.beta, this.a, this.b};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : alpha = " + this.alpha + ", beta = " + this.beta;
    }

    private static class Optim
    implements Lmder_fcn {
        private double a;
        private double b;

        public Optim(double a, double b) {
            this.a = a;
            this.b = b;
        }

        public void fcn(int m, int n, double[] x, double[] fvec, double[][] fjac, int[] iflag) {
            if (x[1] <= 0.0 || x[2] <= 0.0) {
                double BIG = 1.0E100;
                fvec[1] = 1.0E100;
                fvec[2] = 1.0E100;
                fjac[1][1] = 1.0E100;
                fjac[1][2] = 0.0;
                fjac[2][1] = 0.0;
                fjac[2][2] = 1.0E100;
                return;
            }
            if (iflag[1] == 1) {
                double trig = Num.digamma(x[1] + x[2]);
                fvec[1] = Num.digamma(x[1]) - trig - this.a;
                fvec[2] = Num.digamma(x[2]) - trig - this.b;
            } else if (iflag[1] == 2) {
                double trig = Num.trigamma(x[1] + x[2]);
                fjac[1][1] = Num.trigamma(x[1]) - trig;
                fjac[1][2] = -trig;
                fjac[2][1] = -trig;
                fjac[2][2] = Num.trigamma(x[2]) - trig;
            }
        }
    }
}

