/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stochprocess;

import umontreal.ssj.probdist.InverseGaussianDist;
import umontreal.ssj.randvar.InverseGaussianGen;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.stochprocess.StochasticProcess;

public class InverseGaussianProcess
extends StochasticProcess {
    protected RandomStream stream;
    protected double delta;
    protected double gamma;
    protected double deltaOverGamma;
    protected double deltaSquare;
    protected double[] imu;
    protected double[] ilam;
    int numberOfRandomStreams;

    protected InverseGaussianProcess() {
    }

    public InverseGaussianProcess(double s0, double delta, double gamma, RandomStream stream) {
        this.x0 = s0;
        this.setParams(delta, gamma);
        this.stream = stream;
        this.numberOfRandomStreams = 1;
    }

    @Override
    public double[] generatePath() {
        double s = this.x0;
        for (int i = 0; i < this.d; ++i) {
            this.path[i + 1] = s += InverseGaussianGen.nextDouble(this.stream, this.imu[i], this.ilam[i]);
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    public double[] generatePath(double[] uniforms01) {
        double s = this.x0;
        for (int i = 0; i < this.d; ++i) {
            this.path[i + 1] = s += InverseGaussianDist.inverseF(this.imu[i], this.ilam[i], uniforms01[i]);
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    public double[] generatePath(double[] uniforms01, double[] uniforms01b) {
        throw new UnsupportedOperationException("Use generatePath with 1 stream.");
    }

    @Override
    public double nextObservation() {
        double s = this.path[this.observationIndex];
        ++this.observationIndex;
        this.observationCounter = this.observationIndex;
        this.path[this.observationIndex] = s += InverseGaussianGen.nextDouble(this.stream, this.imu[this.observationIndex], this.ilam[this.observationIndex]);
        return s;
    }

    public void setParams(double delta, double gamma) {
        this.delta = delta;
        this.gamma = gamma;
        this.deltaOverGamma = delta / gamma;
        this.deltaSquare = delta * delta;
        this.init();
    }

    public double getDelta() {
        return this.delta;
    }

    public double getGamma() {
        return this.gamma;
    }

    public double getAnalyticAverage(double time) {
        return this.delta * time / this.gamma;
    }

    public double getAnalyticVariance(double time) {
        return this.delta * this.delta * time * time;
    }

    @Override
    protected void init() {
        super.init();
        if (this.observationTimesSet) {
            this.path[0] = this.x0 = this.t[0];
            this.imu = new double[this.d];
            this.ilam = new double[this.d];
            for (int j = 0; j < this.d; ++j) {
                double temp = this.delta * (this.t[j + 1] - this.t[j]);
                this.imu[j] = temp / this.gamma;
                this.ilam[j] = temp * temp;
            }
        }
    }

    @Override
    public RandomStream getStream() {
        return this.stream;
    }

    @Override
    public void setStream(RandomStream stream) {
        this.stream = stream;
    }

    public int getNumberOfRandomStreams() {
        return this.numberOfRandomStreams;
    }
}

