/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.DifferentiableEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.Emission;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.LinkedList;
import javax.naming.OperationNotSupportedException;

public class DifferentiableSMWrapperEmission
implements DifferentiableEmission {
    private DifferentiableStatisticalModel model;
    private int pOffset;
    private int offset;
    private int l;
    private double logUniform;

    public DifferentiableSMWrapperEmission(int offset, DifferentiableStatisticalModel model) throws CloneNotSupportedException {
        if (!model.getAlphabetContainer().isSimple()) {
            throw new IllegalArgumentException("Possible only for simple AlphabetContainer");
        }
        if (model.getLength() == 0) {
            throw new IllegalArgumentException("Possible only for models with fixed length");
        }
        this.model = (DifferentiableStatisticalModel)model.clone();
        this.offset = offset;
        this.computeUniform();
    }

    private void computeUniform() {
        this.l = this.model.getLength();
        this.logUniform = (double)(-this.l) * Math.log(this.model.getAlphabetContainer().getAlphabetLengthAt(0));
    }

    public DifferentiableSMWrapperEmission(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, "DifferentiableSMWrapperEmission");
        this.model = (DifferentiableStatisticalModel)XMLParser.extractObjectForTags(xml, "model");
        this.offset = (Integer)XMLParser.extractObjectForTags(xml, "offset");
        this.pOffset = (Integer)XMLParser.extractObjectForTags(xml, "pOffset");
        this.computeUniform();
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.model, "model");
        XMLParser.appendObjectWithTags(xml, this.offset, "offset");
        XMLParser.appendObjectWithTags(xml, this.pOffset, "pOffset");
        XMLParser.addTags(xml, "DifferentiableSMWrapperEmission");
        return xml;
    }

    @Override
    public DifferentiableSMWrapperEmission clone() throws CloneNotSupportedException {
        DifferentiableSMWrapperEmission clone = (DifferentiableSMWrapperEmission)super.clone();
        clone.model = (DifferentiableStatisticalModel)this.model.clone();
        return clone;
    }

    @Override
    public AlphabetContainer getAlphabetContainer() {
        return this.model.getAlphabetContainer();
    }

    @Override
    public void initializeFunctionRandomly() {
        try {
            this.model.initializeFunctionRandomly(false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public double getLogProbFor(boolean forward, int startPos, int endPos, Sequence seq) throws OperationNotSupportedException {
        if (!forward) {
            throw new OperationNotSupportedException("Only forward allowed");
        }
        int s = startPos + this.offset;
        try {
            double logScore = s < 0 || s + this.l > seq.getLength() ? this.logUniform : this.model.getLogScoreFor(seq, s);
            return logScore;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    @Override
    public double getLogProbAndPartialDerivationFor(boolean forward, int startPos, int endPos, IntList indices, DoubleList partDer, Sequence seq) throws OperationNotSupportedException {
        if (!forward) {
            throw new OperationNotSupportedException("Only forward allowed");
        }
        int s = startPos + this.offset;
        try {
            int indStart = indices.length();
            double logScore = s < 0 || s + this.l > seq.getLength() ? this.logUniform : this.model.getLogScoreAndPartialDerivation(seq, s, indices, partDer);
            indices.addToValues(indStart, indices.length(), this.pOffset);
            return logScore;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public double getLogPriorTerm() {
        return this.model.getLogPriorTerm();
    }

    @Override
    public String getNodeShape(boolean forward) {
        return "\"box\"";
    }

    @Override
    public String getNodeLabel(double weight, String name, NumberFormat nf) {
        return "\"" + name + "\"";
    }

    @Override
    public String toString(NumberFormat nf) {
        return "offset=" + this.offset + "\nmodel:\n" + this.model.toString(nf);
    }

    @Override
    public void fillCurrentParameter(double[] params) {
        try {
            double[] p = this.model.getCurrentParameterValues();
            System.arraycopy(p, 0, params, this.pOffset, p.length);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setParameter(double[] params, int offset) {
        this.model.setParameters(params, offset + this.pOffset);
    }

    @Override
    public int setParameterOffset(int offset) {
        this.pOffset = offset;
        return this.pOffset + this.getNumberOfParameters();
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int offset) {
        try {
            this.model.addGradientOfLogPriorTerm(grad, offset);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getNumberOfParameters() {
        return this.model.getNumberOfParameters();
    }

    @Override
    public int getSizeOfEventSpace() {
        return (int)Math.pow(this.getAlphabetContainer().getAlphabetLengthAt(0), this.l);
    }

    @Override
    public void setParameters(Emission t) throws IllegalArgumentException {
        DifferentiableSMWrapperEmission d = (DifferentiableSMWrapperEmission)t;
        try {
            this.model.setParameters(d.model.getCurrentParameterValues(), 0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void fillSamplingGroups(int parameterOffset, LinkedList<int[]> list) {
        throw new RuntimeException("DifferentiableSMWrapperEmission");
    }

    @Override
    public void resetStatistic() {
        throw new RuntimeException("DifferentiableSMWrapperEmission");
    }

    @Override
    public void addToStatistic(boolean forward, int startPos, int endPos, double weight, Sequence seq) throws OperationNotSupportedException {
        throw new RuntimeException("DifferentiableSMWrapperEmission");
    }

    @Override
    public void joinStatistics(Emission ... emissions) {
        throw new RuntimeException("DifferentiableSMWrapperEmission");
    }

    @Override
    public void estimateFromStatistic() {
        throw new RuntimeException("DifferentiableSMWrapperEmission");
    }

    public void initializeUniformly() throws Exception {
        this.model.initializeFunctionRandomly(false);
        double[] params = this.model.getCurrentParameterValues();
        Arrays.fill(params, 0.0);
        this.model.setParameters(params, 0);
    }

    public void initializeFunction(int index, boolean freeParams, DataSet[] data, double[][] weights) throws Exception {
        this.model.initializeFunction(index, freeParams, data, weights);
    }

    public int getLength() {
        return this.l;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public boolean isNormalized() {
        return this.model.isNormalized();
    }
}

