/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.seekablestream;

import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class SeekablePathStream
extends SeekableStream {
    private static final Log LOG = Log.getInstance(SeekablePathStream.class);
    private static final Collection<SeekablePathStream> ALL_INSTANCES = Collections.synchronizedCollection(new HashSet());
    private final Path path;
    private final SeekableByteChannel sbc;
    private final ByteBuffer oneByteBuf = ByteBuffer.allocate(1);

    public SeekablePathStream(Path path) throws IOException {
        this.path = path;
        this.sbc = Files.newByteChannel(path, new OpenOption[0]);
        ALL_INSTANCES.add(this);
    }

    @Override
    public long length() {
        try {
            return this.sbc.size();
        }
        catch (IOException e) {
            LOG.error("Cannot find length of path: " + this.path, e);
            return 0L;
        }
    }

    @Override
    public boolean eof() throws IOException {
        return this.length() == this.position();
    }

    @Override
    public void seek(long position) throws IOException {
        this.sbc.position(position);
    }

    @Override
    public long position() throws IOException {
        return this.sbc.position();
    }

    @Override
    public long skip(long n) throws IOException {
        long initPos = this.position();
        this.sbc.position(initPos + n);
        return this.position() - initPos;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int n;
        int count;
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        ByteBuffer buf = ByteBuffer.wrap(buffer, offset, length);
        for (n = 0; n < length; n += count) {
            count = this.sbc.read(buf);
            if (count >= 0) continue;
            if (n > 0) {
                return n;
            }
            return count;
        }
        return n;
    }

    @Override
    public int read() throws IOException {
        this.oneByteBuf.clear();
        int n = this.sbc.read(this.oneByteBuf);
        return n == 1 ? this.oneByteBuf.array()[0] & 0xFF : n;
    }

    @Override
    public String getSource() {
        return this.path.toAbsolutePath().toString();
    }

    @Override
    public void close() throws IOException {
        ALL_INSTANCES.remove(this);
        this.sbc.close();
    }

    public static synchronized void closeAllInstances() {
        HashSet<SeekablePathStream> clonedInstances = new HashSet<SeekablePathStream>();
        clonedInstances.addAll(ALL_INSTANCES);
        for (SeekablePathStream sfs : clonedInstances) {
            try {
                sfs.close();
            }
            catch (IOException e) {
                LOG.error("Error closing SeekablePathStream", e);
            }
        }
        ALL_INSTANCES.clear();
    }
}

