/*
 * Decompiled with CFR 0.152.
 */
package projects.dream2016;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.ContinuousAlphabet;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.alphabets.DoubleSymbolException;
import de.jstacs.data.sequences.ArbitrarySequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.sequenceScores.differentiable.DifferentiableSequenceScore;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.ToolBox;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;

public class DataParser {
    private int skip;
    private int columns;
    private ParserEntry[] entries;
    private Alphabet[] regionAlphabets;
    private AlphabetContainer regionContainer;
    private DiscreteAlphabet strandAlph;
    private DiscreteAlphabet chrAlph = null;

    public static ArrayList<String> getConf(String file) throws IOException {
        String str;
        ArrayList<String> conf = new ArrayList<String>();
        BufferedReader read = new BufferedReader(new FileReader(file));
        while ((str = read.readLine()) != null) {
            if (str.charAt(0) == '#') continue;
            conf.add(str);
        }
        read.close();
        return conf;
    }

    public DataParser(String formatFile) throws IOException, IllegalArgumentException, DoubleSymbolException {
        this(DataParser.getConf(formatFile).toArray(new String[0]));
    }

    public DataParser(String[] lines) throws IOException, IllegalArgumentException, DoubleSymbolException {
        String[] parts = lines[0].split("\t");
        this.skip = Integer.parseInt(parts[0]);
        this.columns = Integer.parseInt(parts[1]);
        ArrayList<ParserEntry> temp = new ArrayList<ParserEntry>();
        int i = 1;
        while (i < lines.length) {
            parts = lines[i].split("\t");
            FeatureType ft = FeatureType.valueOf(parts[0]);
            Collection coll = Collection.valueOf(parts[2]);
            Bins bins = Bins.valueOf(parts[3]);
            parts = parts[1].split(",");
            int[] cols = new int[parts.length];
            int j = 0;
            while (j < cols.length) {
                cols[j] = Integer.parseInt(parts[j]);
                ++j;
            }
            temp.add(new ParserEntry(ft, coll, bins, cols));
            ++i;
        }
        this.entries = temp.toArray(new ParserEntry[0]);
        this.regionAlphabets = new Alphabet[]{new DiscreteAlphabet(false, "S", "-"), new DiscreteAlphabet(false, "C", "-"), new DiscreteAlphabet(false, "U", "-"), new DiscreteAlphabet(false, "E", "-"), new DiscreteAlphabet(false, "T", "-"), new DiscreteAlphabet(false, "s", "-"), new DiscreteAlphabet(false, "c", "-"), new DiscreteAlphabet(false, "u", "-"), new DiscreteAlphabet(false, "e", "-"), new DiscreteAlphabet(false, "t", "-")};
        this.regionContainer = new AlphabetContainer(this.regionAlphabets);
        this.strandAlph = new DiscreteAlphabet(false, "+", "-", ".");
    }

    public String toString() {
        return String.valueOf(Arrays.toString(this.entries)) + "\n" + this.columns + " " + this.skip;
    }

    public int getNumberOfColumns() {
        return this.columns;
    }

    public DifferentiableSequenceScore[] getScores() {
        return null;
    }

    public DataSet parseData(String filename) throws Exception {
        return this.parseData(filename, -1);
    }

    public DataSet parseData(String filename, double acceptProb) throws Exception {
        BufferedReader read = new BufferedReader(new FileReader(filename));
        String str = null;
        AlphabetContainer cont = null;
        LinkedList<Sequence> seqs = new LinkedList<Sequence>();
        Random r = new Random();
        while ((str = read.readLine()) != null) {
            if (!(r.nextDouble() <= acceptProb)) continue;
            try {
                seqs.add(this.parse(cont, str.split("\t")));
            }
            catch (StringIndexOutOfBoundsException ex) {
                System.out.println(str);
                System.exit(1);
            }
            if (cont != null) continue;
            cont = ((Sequence)seqs.get(0)).getAlphabetContainer();
        }
        read.close();
        return new DataSet(String.valueOf(filename) + (acceptProb == 1.0 ? "" : " randomly selected ~" + acceptProb * 100.0 + "%"), seqs);
    }

    private DataSet parseData(String filename, int max) throws Exception {
        BufferedReader read = new BufferedReader(new FileReader(filename));
        String str = null;
        AlphabetContainer cont = null;
        LinkedList<Sequence> seqs = new LinkedList<Sequence>();
        while ((str = read.readLine()) != null && (max < 0 || seqs.size() < max)) {
            try {
                seqs.add(this.parse(cont, str.split("\t")));
            }
            catch (StringIndexOutOfBoundsException ex) {
                System.out.println(str);
                System.exit(1);
            }
            if (cont != null) continue;
            cont = ((Sequence)seqs.get(0)).getAlphabetContainer();
        }
        read.close();
        return new DataSet(String.valueOf(filename) + (max > 0 ? ": first " + max + " sequences" : ""), seqs);
    }

    public ArbitrarySequence parse(AlphabetContainer cont, String[] parts) throws Exception {
        if (cont == null) {
            cont = this.getAlphabets(parts.length);
        }
        int numCols = (parts.length - this.skip) / this.columns;
        DoubleList vals = new DoubleList();
        if (this.chrAlph != null) {
            vals.add(this.chrAlph.getCode(parts[0]));
        }
        int i = 0;
        while (i < this.entries.length) {
            int numInOne = this.entries[i].ft == FeatureType.Region ? this.regionAlphabets.length : this.entries[i].columns.length;
            numInOne = this.entries[i].ft == FeatureType.StrandStrandPos ? 3 : numInOne;
            numInOne = this.entries[i].ft == FeatureType.Seq ? 50 : numInOne;
            double[][] temp = new double[numInOne][numCols];
            int j = 0;
            while (j < this.entries[i].columns.length) {
                int k = 0;
                while (k < numCols) {
                    String str = parts[this.skip + k * this.columns + this.entries[i].columns[j]];
                    switch (this.entries[i].ft) {
                        case Seq: {
                            Sequence dnaSeq = Sequence.create(DNAAlphabetContainer.SINGLETON, str);
                            int l = 0;
                            while (l < dnaSeq.getLength()) {
                                temp[l][k] = dnaSeq.discreteVal(l);
                                ++l;
                            }
                            break;
                        }
                        case Region: {
                            Sequence tempSeq = Sequence.create(this.regionContainer, str);
                            int l = 0;
                            while (l < tempSeq.getLength()) {
                                temp[l][k] = tempSeq.discreteVal(l);
                                ++l;
                            }
                            break;
                        }
                        case Score: {
                            if (str.charAt(0) == 'I') {
                                temp[j][k] = Double.NEGATIVE_INFINITY;
                                break;
                            }
                            temp[j][k] = -Double.parseDouble(str);
                            break;
                        }
                        case Percent: {
                            if (str.charAt(0) == 'I') {
                                temp[j][k] = Double.POSITIVE_INFINITY;
                                break;
                            }
                            double a = Double.parseDouble(str);
                            double b = 1.0 - a + 1.0E-10;
                            temp[j][k] = (a += 1.0E-10) / (a + b);
                            break;
                        }
                        case Distance: {
                            if (str.length() == 0) {
                                temp[j][k] = 1000000.0;
                            } else {
                                temp[j][k] = Double.parseDouble(str);
                                if (temp[j][k] < 0.0) {
                                    double[] dArray = temp[j];
                                    int n = k;
                                    dArray[n] = dArray[n] * -1.0;
                                }
                            }
                            temp[j][k] = Math.log1p(temp[j][k]);
                            break;
                        }
                        case StrandStrandPos: {
                            temp[0][k] = this.strandAlph.getCode(str.substring(0, 1));
                            temp[1][k] = this.strandAlph.getCode(str.substring(1, 2));
                            temp[2][k] = Double.parseDouble(str.substring(2));
                            break;
                        }
                        case Coverage: {
                            try {
                                if (str.charAt(0) == 'I') {
                                    temp[j][k] = Double.POSITIVE_INFINITY;
                                    break;
                                }
                                temp[j][k] = Math.log1p(Double.parseDouble(str));
                                break;
                            }
                            catch (NumberFormatException ex) {
                                System.out.println(Arrays.toString(parts));
                                throw ex;
                            }
                        }
                        default: {
                            temp[j][k] = Double.parseDouble(str);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            j = 0;
            while (j < temp.length) {
                int m = (temp[j].length - 1) / 2;
                switch (this.entries[i].bins) {
                    case Center: {
                        temp[j] = new double[]{temp[j][m]};
                        break;
                    }
                    case Center3: {
                        temp[j] = new double[]{temp[j][m - 1], temp[j][m], temp[j][m + 1]};
                        break;
                    }
                    case MeanCenter3: {
                        temp[j] = new double[]{ToolBox.mean(m - 1, m + 2, temp[j])};
                        break;
                    }
                    case MinCenter3: {
                        temp[j] = new double[]{ToolBox.min(m - 1, m + 2, temp[j])};
                        break;
                    }
                    case MinCenter5: {
                        temp[j] = new double[]{ToolBox.min(m - 2, m + 3, temp[j])};
                        break;
                    }
                    case MaxCenter3: {
                        temp[j] = new double[]{ToolBox.max(m - 1, m + 2, temp[j])};
                        break;
                    }
                    case MaxCenter5: {
                        temp[j] = new double[]{ToolBox.max(m - 2, m + 3, temp[j])};
                        break;
                    }
                    case Max: {
                        temp[j] = new double[]{ToolBox.max(temp[j])};
                        break;
                    }
                    case Mean: {
                        temp[j] = new double[]{ToolBox.mean(0, temp[j].length, temp[j])};
                        break;
                    }
                    case Median: {
                        temp[j] = new double[]{ToolBox.median(temp[j])};
                        break;
                    }
                    case Min: {
                        temp[j] = new double[]{ToolBox.min(temp[j])};
                        break;
                    }
                    case LogSum: {
                        temp[j] = new double[]{Normalisation.getLogSum(temp[j])};
                        break;
                    }
                    case LogSumCenter3: {
                        temp[j] = new double[]{Normalisation.getLogSum(m - 1, m + 2, temp[j])};
                    }
                }
                ++j;
            }
            double[][] temp2 = ToolBox.transpose(temp);
            switch (this.entries[i].coll) {
                case Each: 
                case Mix: {
                    int j2 = 0;
                    while (j2 < temp2.length) {
                        int k = 0;
                        while (k < temp2[j2].length) {
                            vals.add(temp2[j2][k]);
                            ++k;
                        }
                        ++j2;
                    }
                    break;
                }
                case Max: {
                    int j2 = 0;
                    while (j2 < temp2.length) {
                        vals.add(ToolBox.max(temp2[j2]));
                        ++j2;
                    }
                    break;
                }
                case Mean: {
                    int j2 = 0;
                    while (j2 < temp2.length) {
                        vals.add(ToolBox.mean(0, temp2[j2].length, temp2[j2]));
                        ++j2;
                    }
                    break;
                }
                case Median: {
                    int j2 = 0;
                    while (j2 < temp2.length) {
                        vals.add(ToolBox.median(temp2[j2]));
                        ++j2;
                    }
                    break;
                }
                case Min: {
                    int j2 = 0;
                    while (j2 < temp2.length) {
                        vals.add(ToolBox.min(temp2[j2]));
                        ++j2;
                    }
                    break;
                }
            }
            ++i;
        }
        double[] d = vals.toArray();
        int i2 = 0;
        while (i2 < d.length) {
            if (Double.isInfinite(d[i2])) {
                d[i2] = cont.getAlphabetLengthAt(i2) == 1.0 ? 0.5 : 100.0;
            }
            ++i2;
        }
        return new ArbitrarySequence(cont, d);
    }

    private static String toString(String[] parts) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < parts.length) {
            sb.append(String.valueOf(i > 0 ? "\t" : "") + parts[i]);
            ++i;
        }
        return sb.toString();
    }

    public AlphabetContainer getAlphabets(int length) throws IllegalArgumentException, DoubleSymbolException {
        int num = (length -= this.skip) / this.columns;
        ArrayList<Alphabet> alphabets = new ArrayList<Alphabet>();
        if (this.chrAlph != null) {
            alphabets.add(this.chrAlph);
        }
        int i = 0;
        while (i < this.entries.length) {
            int j;
            Alphabet[] template;
            int numTotal;
            int numSingle;
            int numCols = this.entries[i].columns.length;
            switch (this.entries[i].coll) {
                case Each: 
                case Mix: {
                    numSingle = numCols;
                    break;
                }
                default: {
                    numSingle = 1;
                }
            }
            switch (this.entries[i].bins) {
                case Each: {
                    numTotal = numSingle * num;
                    break;
                }
                default: {
                    numTotal = numSingle;
                }
            }
            switch (this.entries[i].ft) {
                case Seq: {
                    template = new Alphabet[this.entries[i].bins == Bins.Center3 ? 150 : 50];
                    j = 0;
                    while (j < template.length) {
                        template[j] = DNAAlphabet.SINGLETON;
                        ++j;
                    }
                    break;
                }
                case Entropy: 
                case Coverage: {
                    template = new Alphabet[]{new ContinuousAlphabet(0.0, Double.MAX_VALUE)};
                    break;
                }
                case Distance: 
                case Length: {
                    template = new Alphabet[]{new ContinuousAlphabet(0.0, 2.147483647E9)};
                    break;
                }
                case Percent: {
                    template = new Alphabet[]{new ContinuousAlphabet(0.0, 1.0)};
                    break;
                }
                case Region: {
                    template = this.regionAlphabets;
                    break;
                }
                case Score: {
                    template = new Alphabet[]{new ContinuousAlphabet()};
                    break;
                }
                case StrandStrandPos: {
                    template = new Alphabet[]{this.strandAlph, this.strandAlph, new ContinuousAlphabet(0.0, 2.147483647E9)};
                    break;
                }
                default: {
                    throw new RuntimeException("Not implemented");
                }
            }
            j = 0;
            while (j < numTotal) {
                int k = 0;
                while (k < template.length) {
                    alphabets.add(template[k]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        Alphabet[] abc = alphabets.toArray(new Alphabet[0]);
        HashMap<Alphabet, Integer> nonRed = new HashMap<Alphabet, Integer>();
        int[] assignment = new int[abc.length];
        int i2 = 0;
        int ref = 0;
        while (i2 < abc.length) {
            Iterator it = nonRed.keySet().iterator();
            Integer a = null;
            while (it.hasNext()) {
                Alphabet temp = (Alphabet)it.next();
                if (temp.compareTo(abc[i2]) != 0) continue;
                a = (Integer)nonRed.get(temp);
            }
            if (a == null) {
                a = ref++;
                nonRed.put(abc[i2], a);
            }
            assignment[i2] = a;
            ++i2;
        }
        Alphabet[] abc2 = new Alphabet[nonRed.size()];
        for (Map.Entry e : nonRed.entrySet()) {
            abc2[((Integer)e.getValue()).intValue()] = (Alphabet)e.getKey();
        }
        return new AlphabetContainer(abc2, assignment);
    }

    public static double[][] getStats(DataSet ... d) throws WrongAlphabetException {
        AlphabetContainer con = d[0].getAlphabetContainer();
        int n = d[0].getNumberOfElements();
        int i = 1;
        while (i < d.length) {
            if (!con.checkConsistency(d[i].getAlphabetContainer())) {
                throw new WrongAlphabetException();
            }
            n += d[i].getNumberOfElements();
            ++i;
        }
        double[][] stats = new double[d[0].getElementLength()][];
        double[] values = null;
        int p = 0;
        while (p < stats.length) {
            if (!con.isDiscreteAt(p)) {
                int c = 0;
                if (values == null) {
                    values = new double[n];
                }
                int i2 = 0;
                while (i2 < d.length) {
                    int j = 0;
                    while (j < d[i2].getNumberOfElements()) {
                        values[c] = d[i2].getElementAt(j).continuousVal(p);
                        ++j;
                        ++c;
                    }
                    ++i2;
                }
                stats[p] = new double[2];
                stats[p][0] = ToolBox.median(values);
                double[] v = new double[values.length];
                int k = 0;
                while (k < values.length) {
                    v[k] = Math.abs(values[k] - stats[p][0]);
                    ++k;
                }
                stats[p][1] = ToolBox.median(v) * 1.4826;
                if (stats[p][1] == 0.0) {
                    System.out.println("SD" + p);
                    stats[p][1] = ToolBox.sd(0, values.length, values);
                }
                System.out.println(String.valueOf(p) + "\t" + Arrays.toString(stats[p]));
            }
            ++p;
        }
        return stats;
    }

    public static DataSet zTransform(DataSet d, double[][] stats) throws Exception {
        AlphabetContainer con = DataParser.zTransform(d.getAlphabetContainer(), stats);
        ArrayList<Sequence> seqs = new ArrayList<Sequence>();
        int j = 0;
        while (j < d.getNumberOfElements()) {
            seqs.add(DataParser.zTransform(d.getElementAt(j), stats, con));
            ++j;
        }
        return new DataSet("normalized " + d.getAnnotation(), seqs);
    }

    public static AlphabetContainer zTransform(AlphabetContainer con, double[][] stats) {
        int[] assign = new int[stats.length];
        HashMap<Integer, Integer> a = new HashMap<Integer, Integer>();
        ArrayList<Alphabet> list = new ArrayList<Alphabet>();
        int set = -1;
        int v = 0;
        int i = 0;
        while (i < stats.length) {
            if (stats[i] != null) {
                if (set < 0) {
                    set = v++;
                    list.add(new ContinuousAlphabet());
                }
                assign[i] = set;
            } else {
                Integer k = (Integer)a.get(con.getAlphabetIndexForPosition(i));
                if (k == null) {
                    k = v++;
                    a.put(con.getAlphabetIndexForPosition(i), k);
                    list.add(con.getAlphabetAt(i));
                }
                assign[i] = k;
            }
            ++i;
        }
        return new AlphabetContainer(list.toArray(new Alphabet[0]), assign);
    }

    public static Sequence zTransform(Sequence s, double[][] stats, AlphabetContainer con) throws WrongAlphabetException, WrongSequenceTypeException {
        double[] values = new double[s.getLength()];
        int p = 0;
        while (p < stats.length) {
            values[p] = s.continuousVal(p);
            if (stats[p] != null) {
                values[p] = (values[p] - stats[p][0]) / stats[p][1];
            }
            ++p;
        }
        return new ArbitrarySequence(con, values);
    }

    public static void main(String[] args) throws Exception {
        DataParser pars = new DataParser(args[0]);
        DataSet set = pars.parseData(args[1]);
        System.out.println(set);
        System.out.println();
        double[][] stats = DataParser.getStats(set);
        int i = 0;
        while (i < stats.length) {
            System.out.println(String.valueOf(i) + "\t" + (stats[i] == null ? null : Arrays.toString(stats[i])));
            ++i;
        }
        set = DataParser.zTransform(set, stats);
        System.out.println();
        System.out.println(set);
    }

    public static double[] getWeights(String fName, Weighting w) throws IOException {
        String line;
        DoubleList vals = new DoubleList();
        BufferedReader r = new BufferedReader(new FileReader(fName));
        while ((line = r.readLine()) != null) {
            vals.add(Double.parseDouble(line));
        }
        r.close();
        double[] res = vals.toArray();
        switch (w) {
            case DIRECT: {
                break;
            }
            case ONE: {
                Arrays.fill(res, 1.0);
                break;
            }
            case SIGNAL: {
                double min = ToolBox.min(res);
                double max = ToolBox.max(res);
                double delta = max - min;
                int i = 0;
                while (i < res.length) {
                    res[i] = (2.0 + (res[i] - min) / delta) / 3.0;
                    ++i;
                }
                break;
            }
            case RANK: {
                int[] rank = ToolBox.rank(res, ToolBox.TiedRanks.SPORTS);
                double m = res.length;
                int i = 0;
                while (i < res.length) {
                    res[i] = (2.0 + (m - (double)rank[i]) / m) / 3.0;
                    ++i;
                }
                break;
            }
        }
        return res;
    }

    public static enum Bins {
        Each,
        Center3,
        Center,
        Min,
        Max,
        Mean,
        Median,
        MinCenter3,
        MinCenter5,
        MeanCenter3,
        MaxCenter3,
        MaxCenter5,
        LogSum,
        LogSumCenter3;

    }

    public static enum Collection {
        Each,
        Min,
        Max,
        Mean,
        Median,
        Mix;

    }

    public static enum FeatureType {
        Region,
        Distance,
        Length,
        Percent,
        Entropy,
        Score,
        Coverage,
        StrandStrandPos,
        Seq;

    }

    private static class ParserEntry {
        private FeatureType ft;
        private Collection coll;
        private Bins bins;
        private int[] columns;

        public ParserEntry(FeatureType ft, Collection coll, Bins bins, int ... columns) {
            this.ft = ft;
            this.coll = coll;
            this.bins = bins;
            this.columns = (int[])columns.clone();
        }

        public String toString() {
            return (Object)((Object)this.ft) + " " + (Object)((Object)this.coll) + " " + (Object)((Object)this.bins) + " " + Arrays.toString(this.columns);
        }
    }

    public static enum Weighting {
        ONE,
        DIRECT,
        SIGNAL,
        RANK;

    }
}

