/*
 * Decompiled with CFR 0.152.
 */
package projects.dream2016;

import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.IntList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class PeakStat2Interval {
    public static void main(String[] args) throws FileNotFoundException, IOException {
        HashMap<String, ArrayList<ComparableElement<double[], Integer>>> conservative = PeakStat2Interval.getPeaks(String.valueOf(args[0]) + ".conservative.narrowPeak.gz");
        HashMap<String, ArrayList<ComparableElement<double[], Integer>>> relaxed = PeakStat2Interval.getPeaks(String.valueOf(args[0]) + ".relaxed.narrowPeak.gz");
        GZIPInputStream stream = new GZIPInputStream(new FileInputStream(args[1]));
        BufferedReader read = new BufferedReader(new InputStreamReader(stream));
        String chr = null;
        try (FileOutputStream output = new FileOutputStream(String.valueOf(args[0]) + "-DNase-peakStat2interval.txt.gz");){
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(output), "UTF-8"));
            ArrayList<ComparableElement<double[], Integer>> re = null;
            ArrayList<ComparableElement<double[], Integer>> co = null;
            ArrayList<ComparableElement<double[], Integer>> currCo = new ArrayList<ComparableElement<double[], Integer>>();
            ArrayList<ComparableElement<double[], Integer>> currRe = new ArrayList<ComparableElement<double[], Integer>>();
            int b = 0;
            int c = 0;
            int r = 0;
            try {
                String line;
                while ((line = read.readLine()) != null) {
                    if (line.startsWith("[")) {
                        System.out.println(line);
                        w.append(line);
                        w.newLine();
                        chr = line.substring(1, line.length() - 1);
                        co = conservative.get(chr);
                        re = relaxed.get(chr);
                        currCo.clear();
                        currRe.clear();
                        r = 0;
                        c = 0;
                        b = 0;
                        continue;
                    }
                    double coStat1 = 0.0;
                    double coStat2 = 0.0;
                    if (co != null) {
                        while (c < co.size() && (Integer)((ComparableElement)co.get(c)).getWeight() <= b + 50) {
                            currCo.add(co.get(c));
                            ++c;
                        }
                        int i = currCo.size() - 1;
                        while (i >= 0) {
                            if (((double[])((ComparableElement)currCo.get(i)).getElement())[1] < (double)b) {
                                currCo.remove(i);
                            }
                            --i;
                        }
                        if (currCo.size() > 0) {
                            i = 0;
                            while (i < currCo.size()) {
                                double[] curr = (double[])((ComparableElement)currCo.get(i)).getElement();
                                int start = Math.max(b, (int)curr[0]);
                                int end = Math.min(b + 50, (int)curr[1]);
                                coStat1 += curr[2] * (double)(end - start);
                                coStat2 += curr[3] * (double)(end - start);
                                ++i;
                            }
                            coStat1 /= (double)(currCo.size() * 50);
                            coStat2 /= (double)(currCo.size() * 50);
                        }
                    }
                    double reStat1 = 0.0;
                    double reStat2 = 0.0;
                    if (re != null) {
                        while (r < re.size() && (Integer)((ComparableElement)re.get(r)).getWeight() <= b + 50) {
                            currRe.add(re.get(r));
                            ++r;
                        }
                        int i = currRe.size() - 1;
                        while (i >= 0) {
                            if (((double[])((ComparableElement)currRe.get(i)).getElement())[1] < (double)b) {
                                currRe.remove(i);
                            }
                            --i;
                        }
                        if (currRe.size() > 0) {
                            i = 0;
                            while (i < currRe.size()) {
                                double[] curr = (double[])((ComparableElement)currRe.get(i)).getElement();
                                int start = Math.max(b, (int)curr[0]);
                                int end = Math.min(b + 50, (int)curr[1]);
                                reStat1 += curr[2] * (double)(end - start);
                                reStat2 += curr[3] * (double)(end - start);
                                ++i;
                            }
                            reStat1 /= (double)(currRe.size() * 50);
                            reStat2 /= (double)(currRe.size() * 50);
                        }
                    }
                    w.append(String.valueOf(coStat1) + "\t" + reStat1 + "\t" + coStat2 + "\t" + reStat2);
                    w.newLine();
                    b += 50;
                }
            }
            finally {
                w.close();
            }
        }
        read.close();
        stream.close();
    }

    public static HashMap<String, ArrayList<ComparableElement<double[], Integer>>> getPeaks(String fileName) throws FileNotFoundException, IOException {
        ArrayList current;
        String line;
        HashMap<String, ArrayList<ComparableElement<double[], Integer>>> res = new HashMap<String, ArrayList<ComparableElement<double[], Integer>>>();
        GZIPInputStream stream = new GZIPInputStream(new FileInputStream(fileName));
        BufferedReader r = new BufferedReader(new InputStreamReader(stream));
        while ((line = r.readLine()) != null) {
            String[] split = line.split("\t");
            current = (ArrayList)res.get(split[0]);
            if (current == null) {
                current = new ArrayList();
                res.put(split[0], current);
            }
            int start = Integer.parseInt(split[1]);
            int end = Integer.parseInt(split[2]);
            double stat = Double.parseDouble(split[7]);
            double stat2 = Double.parseDouble(split[6]);
            ComparableElement<double[], Integer> el = new ComparableElement<double[], Integer>(new double[]{start, end, stat2, stat}, start);
            current.add(el);
        }
        r.close();
        IntList il = new IntList();
        il.sort();
        int i = 0;
        int a = 0;
        Iterator it = res.keySet().iterator();
        while (it.hasNext()) {
            current = (ArrayList)res.get(it.next());
            Collections.sort(current);
            ++i;
            a += current.size();
        }
        System.out.println(String.valueOf(fileName) + "\t" + i + "\t" + a);
        return res;
    }
}

