/*
 * Decompiled with CFR 0.152.
 */
package projects.encodedream;

import de.jstacs.Storable;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;

public class ClassifiersWithInfo
implements Storable {
    private GenDisMixClassifier[] classifiers;
    private int numBins;
    private int binWidth;
    private int numMotifs;
    private int binsBefore;
    private int binsAfter;

    public ClassifiersWithInfo(GenDisMixClassifier[] classifiers, int numBins, int binWidth, int binsBefore, int binsAfter, int numMotifs) {
        this.classifiers = classifiers;
        this.numBins = numBins;
        this.binWidth = binWidth;
        this.numMotifs = numMotifs;
        this.binsBefore = binsBefore;
        this.binsAfter = binsAfter;
    }

    public ClassifiersWithInfo(StringBuffer xml) throws NonParsableException {
        this.classifiers = (GenDisMixClassifier[])XMLParser.extractObjectForTags(xml, "classifiers");
        this.numBins = (Integer)XMLParser.extractObjectForTags(xml, "numBins");
        this.binWidth = (Integer)XMLParser.extractObjectForTags(xml, "binWidth");
        this.numMotifs = (Integer)XMLParser.extractObjectForTags(xml, "numMotifs");
        this.binsBefore = (Integer)XMLParser.extractObjectForTags(xml, "binsBefore");
        this.binsAfter = (Integer)XMLParser.extractObjectForTags(xml, "binsAfter");
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.classifiers, "classifiers");
        XMLParser.appendObjectWithTags(xml, this.numBins, "numBins");
        XMLParser.appendObjectWithTags(xml, this.binWidth, "binWidth");
        XMLParser.appendObjectWithTags(xml, this.numMotifs, "numMotifs");
        XMLParser.appendObjectWithTags(xml, this.binsBefore, "binsBefore");
        XMLParser.appendObjectWithTags(xml, this.binsAfter, "binsAfter");
        return xml;
    }

    public int getBinsBefore() {
        return this.binsBefore;
    }

    public int getBinsAfter() {
        return this.binsAfter;
    }

    public GenDisMixClassifier[] getClassifiers() {
        return this.classifiers;
    }

    public int getNumBins() {
        return this.numBins;
    }

    public int getBinWidth() {
        return this.binWidth;
    }

    public int getNumberOfMotifs() {
        return this.numMotifs;
    }

    public void limitClassifiers(Integer numClass) {
        if (numClass > 0) {
            GenDisMixClassifier[] temp = new GenDisMixClassifier[numClass.intValue()];
            int i = 0;
            while (i < temp.length) {
                temp[i] = this.classifiers[i];
                ++i;
            }
            this.classifiers = temp;
        } else {
            GenDisMixClassifier[] temp = new GenDisMixClassifier[-numClass.intValue()];
            int i = 0;
            while (i < temp.length) {
                temp[i] = this.classifiers[this.classifiers.length - i - 1];
                ++i;
            }
            this.classifiers = temp;
        }
    }
}

