/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma;

import de.jstacs.tools.Protocol;
import de.jstacs.tools.ui.cli.CLI;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import projects.gemoma.Tools;

public class CDSFilter {
    private static String par = "Parent=";

    public static void main(String[] args) throws IOException {
        CDSFilter.reformat(args[0], new CLI.SysProtocol());
    }

    public static void reformat(String input, Protocol protocol) throws IOException {
        String line;
        String[] split = null;
        BufferedReader r = Tools.openGzOrPlain(input);
        HashMap<String, HashSet<String>> geneTrans = new HashMap<String, HashSet<String>>();
        HashMap<String, ArrayList<String[]>> transCDS = new HashMap<String, ArrayList<String[]>>();
        block10: while ((line = r.readLine()) != null) {
            if (line.equalsIgnoreCase("##FASTA")) {
                protocol.append("Stop reading the annotation file because of '##FASTA'\n");
                break;
            }
            if (line.length() == 0 || line.startsWith("#")) continue;
            split = line.split("\t");
            if (split.length != 9) {
                throw new IllegalArgumentException("This line does not seem to be a valid (tab-delimited) line of the annotation with 9 columns: " + line);
            }
            switch (split[2]) {
                case "CDS": {
                    String tr;
                    String[] tra;
                    int idx;
                    if (split[8].indexOf(par) < 0) {
                        idx = split[8].indexOf("ID=");
                        if (idx >= 0) {
                            split[8] = split[8].replace("ID=", par);
                        } else {
                            throw new IllegalArgumentException("The line does not contain ID or Parent: " + line);
                        }
                    }
                    idx = split[8].indexOf(par) + par.length();
                    int h = split[8].indexOf(59, idx);
                    String[] stringArray = tra = split[8].substring(idx, h).split(",");
                    int n = tra.length;
                    int n2 = 0;
                    while (n2 < n) {
                        tr = stringArray[n2];
                        CDSFilter.addCDSPart(tr, split, transCDS);
                        ++n2;
                    }
                    continue block10;
                }
                case "transcript": 
                case "mRNA": 
                case "prediction": {
                    int idx = split[8].indexOf("ID=") + 3;
                    int h = split[8].indexOf(59, idx);
                    String tr = split[8].substring(idx, h > 0 ? h : split[8].length());
                    idx = split[8].indexOf(par);
                    if (idx >= 0) {
                        h = split[8].indexOf(59, idx += par.length());
                    }
                    String geneID = idx < 0 ? String.valueOf(tr) + ".gene" : split[8].substring(idx, h > 0 ? h : split[8].length());
                    CDSFilter.addTranscript(geneID, tr, geneTrans);
                }
            }
        }
        r.close();
        Iterator genes = geneTrans.keySet().iterator();
        StringBuffer gOut = new StringBuffer();
        while (genes.hasNext()) {
            String geneId = (String)genes.next();
            gOut.delete(0, gOut.length());
            int gStart = Integer.MAX_VALUE;
            int gEnd = 0;
            Iterator trans = ((HashSet)geneTrans.get(geneId)).iterator();
            StringBuffer tOut = new StringBuffer();
            while (trans.hasNext()) {
                String transId = (String)trans.next();
                tOut.delete(0, tOut.length());
                int start = Integer.MAX_VALUE;
                int end = 0;
                ArrayList cds = (ArrayList)transCDS.get(transId);
                if (cds.size() <= 0) continue;
                int i = 0;
                while (i < cds.size()) {
                    split = (String[])cds.get(i);
                    int j = 0;
                    while (j < split.length) {
                        tOut.append(String.valueOf(split[j]) + (j + 1 == split.length ? "\n" : "\t"));
                        ++j;
                    }
                    start = Math.min(start, Integer.parseInt(split[3]));
                    end = Math.max(end, Integer.parseInt(split[4]));
                    ++i;
                }
                gOut.append(String.valueOf(split[0]) + "\tderived\ttranscript\t" + start + "\t" + end + "\t.\t" + split[6] + "\t.\tID=" + transId + ";Parent=" + geneId + "\n");
                gOut.append(tOut);
                gStart = Math.min(start, gStart);
                gEnd = Math.max(end, gEnd);
            }
            System.out.print(String.valueOf(split[0]) + "\tderived\tgene\t" + gStart + "\t" + gEnd + "\t.\t" + split[6] + "\t.\tID=" + geneId + "\n");
            System.out.print(gOut);
        }
    }

    public static void addCDSPart(String transID, String[] split, HashMap<String, ArrayList<String[]>> transCDS) {
        ArrayList<Object> cds = transCDS.get(transID);
        if (cds == null) {
            cds = new ArrayList();
            transCDS.put(transID, cds);
        }
        cds.add(split);
    }

    public static void addTranscript(String geneID, String transID, HashMap<String, HashSet<String>> geneTrans) {
        HashSet<String> trans = geneTrans.get(geneID);
        if (trans == null) {
            trans = new HashSet();
            geneTrans.put(geneID, trans);
        }
        trans.add(transID);
    }
}

