/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.File;
import java.util.Iterator;
import java.util.List;

public class ReadStats {
    private double meanSplit;
    private double sdSplit;
    private double meanReadLen;
    private double factor;

    public ReadStats(int minIntronLength, double factor, String ... bams) {
        this.factor = factor;
        SamReaderFactory srf = SamReaderFactory.makeDefault();
        srf.validationStringency(ValidationStringency.SILENT);
        double sum = 0.0;
        double sumSq = 0.0;
        double n = 0.0;
        double lenSum = 0.0;
        double lenN = 0.0;
        int i = 0;
        while (i < bams.length) {
            SamReader reader = srf.open(new File(bams[i]));
            for (SAMRecord curr : reader) {
                lenSum += (double)curr.getReadLength();
                lenN += 1.0;
                List<AlignmentBlock> li = curr.getAlignmentBlocks();
                if (li.size() <= 1) continue;
                Iterator<AlignmentBlock> it = li.iterator();
                AlignmentBlock al = it.next();
                while (it.hasNext()) {
                    AlignmentBlock ne = it.next();
                    double diff = Math.abs(ne.getReferenceStart() - al.getReferenceStart() - al.getLength()) + 1;
                    if (diff > (double)minIntronLength) {
                        sum += diff;
                        sumSq += diff * diff;
                        n += 1.0;
                    }
                    al = ne;
                }
            }
            ++i;
        }
        this.meanSplit = sum / n;
        this.sdSplit = Math.sqrt(sumSq / n - this.meanSplit * this.meanSplit);
        this.meanReadLen = lenSum / lenN;
    }

    public double getSdSplitLength() {
        return this.sdSplit;
    }

    public double getMeanSplitLength() {
        return this.meanSplit;
    }

    public double getMeanReadLength() {
        return this.meanReadLen;
    }

    public boolean isOK(int len, int num) {
        double min = this.factor * ((double)len - this.getMeanSplitLength()) / this.getSdSplitLength();
        return (double)num >= min;
    }
}

