/*
 * Decompiled with CFR 0.152.
 */
package projects.gemorna;

import java.util.HashMap;
import projects.gemoma.Tools;

public class Genome {
    public static Genome genome;
    public static HashMap<String, Character> code;
    public static boolean[][][] isStart;
    public static boolean[][][] isStop;
    private HashMap<String, char[]> chromosomes;

    public static void init(String path) throws Exception {
        genome = new Genome(path);
        code = Tools.getCode(Genome.class.getClassLoader().getResourceAsStream("projects/gemorna/genetic_code.txt"));
        code.put("NNN", Character.valueOf('X'));
        int maxIdx = 256;
        isStart = new boolean[maxIdx][maxIdx][maxIdx];
        isStop = new boolean[maxIdx][maxIdx][maxIdx];
        for (String key : code.keySet()) {
            char[] keys;
            Character val = code.get(key);
            if (val.charValue() == '*') {
                keys = key.toCharArray();
                Genome.isStop[keys[0]][keys[1]][keys[2]] = true;
                continue;
            }
            if (val.charValue() != 'M') continue;
            keys = key.toCharArray();
            Genome.isStart[keys[0]][keys[1]][keys[2]] = true;
        }
    }

    public String[] getChromosomeNames() {
        return this.chromosomes.keySet().toArray(new String[0]);
    }

    private Genome(String path) throws Exception {
        HashMap<String, String> temp = Tools.getFasta(path, 5, ".*");
        this.chromosomes = new HashMap();
        for (String key : temp.keySet()) {
            this.chromosomes.put(key, temp.get(key).toCharArray());
        }
    }

    public char[] getChromosome(String id) {
        return this.chromosomes.get(id);
    }
}

