/*
 * Decompiled with CFR 0.152.
 */
package projects.methyl;

import de.jstacs.DataType;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.results.PlotGeneratorResult;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.tools.DataColumnParameter;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import de.jstacs.utils.PFMComparator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Date;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import projects.dimont.ThresholdedStrandChIPper;
import projects.methyl.MLogoPlotter;

public class MethylationSensitivity
implements JstacsTool {
    public static void main(String[] args) throws NonParsableException, IOException, CloneNotSupportedException, IllegalArgumentException, WrongAlphabetException {
    }

    private static double getScore(DifferentiableStatisticalModel motif, String mg) throws IllegalArgumentException, WrongAlphabetException {
        Sequence seq = Sequence.create(motif.getAlphabetContainer(), mg);
        return motif.getLogScoreFor(seq);
    }

    @Override
    public ToolParameterSet getToolParameters() {
        LinkedList<Parameter> parameters = new LinkedList<Parameter>();
        parameters.add(new FileParameter("Model", "The XML file containing the model", "xml", true));
        FileParameter fp = new FileParameter("Predictions", "The file containing the predictions from the training run", "tsv", true);
        parameters.add(fp);
        try {
            parameters.add(new DataColumnParameter(fp.getName(), "Sequence column", "The column of the predictions file containing the sequences in adjusted strand orientation", true, 8));
            parameters.add(new SimpleParameter(DataType.BOOLEAN, "Verbose", "Output MpH sensitivity profile for every input sequence", true, false));
        }
        catch (SimpleParameter.DatatypeNotValidException | SimpleParameter.IllegalValueException e) {
            throw new RuntimeException(e);
        }
        return new ToolParameterSet(this.getToolName(), parameters);
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        FileParameter.FileRepresentation clFile = ((FileParameter)parameters.getParameterAt(0)).getFileContents();
        FileParameter.FileRepresentation predFile = ((FileParameter)parameters.getParameterAt(1)).getFileContents();
        int seqcol = (Integer)parameters.getParameterAt(2).getValue() - 1;
        boolean verbose = (Boolean)parameters.getParameterAt(3).getValue();
        GenDisMixClassifier cl = new GenDisMixClassifier(new StringBuffer(clFile.getContent()));
        ThresholdedStrandChIPper model = (ThresholdedStrandChIPper)cl.getDifferentiableSequenceScore(0);
        DifferentiableStatisticalModel motif = model.getFunction(0);
        BufferedReader read = null;
        read = new File(predFile.getFilename()).exists() ? new BufferedReader(new FileReader(predFile.getFilename())) : new BufferedReader(new StringReader(predFile.getContent()));
        Pattern pat = Pattern.compile("CG");
        double[] cpgs = null;
        double[] mgs = null;
        double[] chs = null;
        double[] mhs = null;
        PrintWriter wr = null;
        File tempFile = null;
        if (verbose) {
            tempFile = File.createTempFile("mhprof", ".tsv");
            tempFile.deleteOnExit();
            wr = new PrintWriter(tempFile);
            wr.print("sequence");
            int i = 0;
            while (i < motif.getLength()) {
                wr.print("\tP" + (i + 1));
                ++i;
            }
            wr.println();
        }
        LinkedList<Sequence> seqs = new LinkedList<Sequence>();
        String str = null;
        int n = 0;
        while ((str = read.readLine()) != null) {
            if (str.startsWith("#")) continue;
            String[] parts = str.split("\t");
            String seqstr = parts[seqcol];
            seqs.add(Sequence.create(motif.getAlphabetContainer(), seqstr));
            if (cpgs == null) {
                cpgs = new double[seqstr.length()];
                mgs = new double[seqstr.length()];
                chs = new double[seqstr.length()];
                mhs = new double[seqstr.length()];
            }
            double[] mhl = new double[seqstr.length()];
            seqstr = seqstr.replaceAll("M", "C").replaceAll("H", "G");
            double base = MethylationSensitivity.getScore(motif, seqstr);
            Matcher m = pat.matcher(seqstr);
            while (m.find()) {
                int start = m.start();
                int end = m.end();
                String mg = String.valueOf(seqstr.substring(0, start)) + "MG" + seqstr.substring(end);
                String ch = String.valueOf(seqstr.substring(0, start)) + "CH" + seqstr.substring(end);
                String mh = String.valueOf(seqstr.substring(0, start)) + "MH" + seqstr.substring(end);
                double mgVal = MethylationSensitivity.getScore(motif, mg);
                double chVal = MethylationSensitivity.getScore(motif, ch);
                double mhVal = MethylationSensitivity.getScore(motif, mh);
                int n2 = start;
                cpgs[n2] = cpgs[n2] + 1.0;
                int n3 = start;
                mgs[n3] = mgs[n3] + (mgVal - base);
                int n4 = start;
                chs[n4] = chs[n4] + (chVal - base);
                int n5 = start;
                mhs[n5] = mhs[n5] + (mhVal - base);
                mhl[start] = mhVal - base;
            }
            ++n;
            if (!verbose) continue;
            wr.print(seqstr);
            int i = 0;
            while (i < mhl.length) {
                wr.print("\t");
                wr.print(mhl[i]);
                ++i;
            }
            wr.println();
        }
        read.close();
        LinkedList<Result> resll = new LinkedList<Result>();
        if (verbose) {
            wr.close();
            TextResult fr = new TextResult("MH profile", "", new FileParameter.FileRepresentation(tempFile.getAbsolutePath()), true, "tsv", this.getToolName(), null, true);
            resll.add(fr);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Position\tCpG\tMG\tCH\tMH\n");
        int i = 0;
        while (i < cpgs.length - 1) {
            int n6 = i;
            cpgs[n6] = cpgs[n6] / (double)n;
            int n7 = i;
            mhs[n7] = mhs[n7] / (double)n;
            sb.append(String.valueOf(i + 1) + "\t" + cpgs[i] + "\t" + mgs[i] / (double)n + "\t" + chs[i] / (double)n + "\t" + mhs[i] + "\n");
            ++i;
        }
        TextResult tr = new TextResult("Average methylation sensitivity", "Methylation sensitivity averaged over all input sequences per content", new FileParameter.FileRepresentation("", sb.toString()), "tsv", this.getToolName(), null, true);
        resll.add(tr);
        DataSet data = new DataSet("", seqs);
        double[][] pwm = PFMComparator.getPWM(data, 0, data.getNumberOfElements());
        PlotGeneratorResult pgr = new PlotGeneratorResult("Methylation sensitivity", "Plot of a sequence logo and corresponding MpH sensitivity profile", new MLogoPlotter.MLogoPlotGenerator(pwm, cpgs, mhs, 1000), true);
        resll.add(pgr);
        return new ToolResult("Result of " + this.getToolName(), "", null, new ResultSet(resll), parameters, this.getToolName(), new Date());
    }

    @Override
    public String getToolName() {
        return "Methylation Sensitivity";
    }

    @Override
    public String getToolVersion() {
        return "0.2";
    }

    @Override
    public String getShortName() {
        return "msens";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public String getHelpText() {
        return "**" + this.getToolName() + "** determines average methylation sensitivity profiles for CpG dinucleotides converted to MpG, CpH, and MpH. As input, it needs a model XML as generated by \"Methyl SlimDimont\", " + "and a prediction file as output from the corresponding training run.\n\n" + "Optionally, Methylation Sensitivity also generates per-sequence methylation sensitivity profiles for the MpH context.\n\n" + "If you experience problems using " + this.getToolName() + ", please contact_ us.\n" + "\n" + ".. _contact: mailto:grau@informatik.uni-halle.de";
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public String[] getReferences() {
        return null;
    }
}

