/*
 * Decompiled with CFR 0.152.
 */
package projects.sigma;

import de.jstacs.DataType;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.SimpleSequenceAnnotationParser;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.DataSetResult;
import de.jstacs.results.ListResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.models.HigherOrderHMM;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import de.jstacs.tools.ui.cli.CLI;
import java.io.StringReader;
import java.util.Date;
import java.util.LinkedList;
import projects.sigma.SigmaIter;

public class PredictIter
implements JstacsTool {
    public static void main(String[] args) throws Exception {
        CLI cli = new CLI(new boolean[1], new PredictIter());
        cli.run(args);
    }

    @Override
    public ToolParameterSet getToolParameters() {
        LinkedList<Parameter> pars = new LinkedList<Parameter>();
        pars.add(new FileParameter("Input sequences", "", "fasta,fas,fa", true));
        try {
            pars.add(new SimpleParameter(DataType.INT, "Length", "", true, new NumberValidator<Integer>(3, 20), 10));
        }
        catch (ParameterException e) {
            e.printStackTrace();
        }
        try {
            pars.add(new ParameterSetContainer(new ExpandableParameterSet(new SimpleParameterSet(new FileParameter("Model", "", "xml", true)), "Models", "")));
        }
        catch (CloneNotSupportedException e1) {
            e1.printStackTrace();
        }
        return new ToolParameterSet(this.getShortName(), pars.toArray(new Parameter[0]));
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        DataSet data;
        SimpleSequenceAnnotationParser parser = new SimpleSequenceAnnotationParser();
        DataSet orig = data = new DataSet(DNAAlphabetContainer.SINGLETON, new SparseStringExtractor(new StringReader(((FileParameter)parameters.getParameterAt(0)).getFileContents().getContent()), '>', "", (SequenceAnnotationParser)parser));
        int length = (Integer)parameters.getParameterAt(1).getValue();
        ExpandableParameterSet eps = (ExpandableParameterSet)parameters.getParameterAt(2).getValue();
        int nModels = eps.getNumberOfParameters();
        HigherOrderHMM[] models = new HigherOrderHMM[nModels];
        int i = 0;
        while (i < models.length) {
            HigherOrderHMM hmm;
            models[i] = hmm = new HigherOrderHMM(new StringBuffer(((FileParameter)((ParameterSetContainer)eps.getParameterAt(i)).getValue().getParameterAt(0)).getFileContents().getContent()));
            ++i;
        }
        int off = 1;
        LinkedList<Result> ress = new LinkedList<Result>();
        int[] idx = new int[data.getNumberOfElements()];
        int i2 = 0;
        while (i2 < idx.length) {
            idx[i2] = i2;
            ++i2;
        }
        ResultSet[] rs = new ResultSet[data.getNumberOfElements()];
        int m = 0;
        while (m < models.length) {
            HigherOrderHMM hmm = models[m];
            SigmaIter.IntermediateResult ir = SigmaIter.evaluateModel(data, hmm, idx, length, off, rs);
            DataSet inSet = new DataSet("", ir.in);
            DataSetResult dsr = new DataSetResult("Sequences for model " + off, "", inSet);
            dsr.setParser(parser);
            ress.add(dsr);
            if (ir.out.size() == 0) break;
            data = new DataSet("", ir.out);
            idx = ir.idx.toArray();
            ++off;
            ++m;
        }
        int i3 = 0;
        while (i3 < rs.length) {
            if (rs[i3] == null) {
                rs[i3] = new ResultSet(new Result[][]{{new NumericalResult("Index", "", i3), new NumericalResult("start", "", -1), new CategoricalResult("seq", "", "NA"), new NumericalResult("Score", "", Double.NEGATIVE_INFINITY), new NumericalResult("component", "", -1), new NumericalResult("LLR", "", Double.NEGATIVE_INFINITY), new CategoricalResult("annotation", "", (String)orig.getElementAt(i3).getAnnotation()[0].getResultAt(0).getValue())}});
            }
            ++i3;
        }
        ress.add(new ListResult("Predictions", "", null, rs));
        return new ToolResult("Result of " + this.getToolName(), this.getToolName(), null, new ResultSet(ress), parameters, this.getToolName(), new Date(System.currentTimeMillis()));
    }

    @Override
    public String getToolName() {
        return "Prediction";
    }

    @Override
    public String getToolVersion() {
        return "0.1";
    }

    @Override
    public String getShortName() {
        return "predict";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public String getHelpText() {
        return "";
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public String[] getReferences() {
        return null;
    }
}

