/*
 * Decompiled with CFR 0.152.
 */
package projects.tals.epigenetic;

import de.jstacs.io.FileManager;
import de.jstacs.parameters.FileParameter;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import de.jstacs.tools.ui.cli.CLI;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Date;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class BismarkConvertToPromoterSearch
implements JstacsTool {
    public static void main(String[] args) throws Exception {
        CLI cli = new CLI(new BismarkConvertToPromoterSearch());
        cli.run(args);
    }

    @Override
    public ToolParameterSet getToolParameters() {
        FileParameter bismarkFile = new FileParameter("Bismark file", "Methylationinformation in bismark format", "cov.gz,cov", true);
        FileParameter promotorFasta = new FileParameter("Promoter fasta file", "Promoter fastA file", "fa,fasta", true);
        return new ToolParameterSet(this.getShortName(), bismarkFile, promotorFasta);
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        progress.setLast(1.0);
        progress.setCurrent(0.0);
        String bismarkFile = parameters.getParameterAt(0).getValue().toString();
        BufferedReader BR = null;
        BR = bismarkFile.endsWith("gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(new File(bismarkFile))))) : new BufferedReader(new InputStreamReader(new FileInputStream(new File(bismarkFile))));
        String promotorFasta = parameters.getParameterAt(1).getValue().toString();
        BufferedReader FA = new BufferedReader(new FileReader(promotorFasta));
        File out = File.createTempFile("bimark.promoter", ".temp.cov.gz", new File("."));
        out.deleteOnExit();
        GZIPOutputStream os = new GZIPOutputStream(new FileOutputStream(out));
        PrintStream os_ps = new PrintStream(os);
        HashMap<String, HashMap> tempBismark = new HashMap<String, HashMap>();
        String line = "";
        while ((line = BR.readLine()) != null) {
            String[] splitLine = line.split("\t");
            HashMap temp = null;
            temp = tempBismark.containsKey(splitLine[0]) ? (HashMap)tempBismark.get(splitLine[0]) : new HashMap();
            temp.put(Integer.parseInt(splitLine[1]), line);
            tempBismark.put(splitLine[0], temp);
        }
        BR.close();
        line = "";
        String gene = "";
        String chrom = "";
        int startPos = -1;
        int endPos = -1;
        int startBismark = -1;
        while ((line = FA.readLine()) != null) {
            if (!line.startsWith(">")) continue;
            String[] splitHeader = line.split(" ");
            String[] splitArea = splitHeader[2].split(":");
            boolean strand = splitArea[2].equals("+");
            String[] splitPos = splitArea[1].split("-");
            gene = line.substring(1).trim();
            int idx = gene.indexOf(" ");
            if (idx > 0) {
                gene = gene.substring(0, idx);
            }
            chrom = splitArea[0];
            startPos = Integer.parseInt(splitPos[0]);
            endPos = Integer.parseInt(splitPos[1]);
            int k = 0;
            int pos = -1;
            int i = startPos;
            while (i < endPos) {
                String[] splitBismark;
                if (strand && tempBismark.containsKey(chrom) && ((HashMap)tempBismark.get(chrom)).containsKey(i + 1)) {
                    splitBismark = ((String)((HashMap)tempBismark.get(chrom)).get(i + 1)).split("\t");
                    startBismark = Integer.parseInt(splitBismark[1]) - startPos;
                    os_ps.print(String.valueOf(gene) + "\t" + startBismark + "\t" + startBismark + "\t" + splitBismark[3] + "\t" + splitBismark[4] + "\t" + splitBismark[5] + "\n");
                }
                if (!strand) {
                    pos = endPos - k;
                    if (tempBismark.containsKey(chrom) && ((HashMap)tempBismark.get(chrom)).containsKey(pos)) {
                        splitBismark = ((String)((HashMap)tempBismark.get(chrom)).get(pos)).split("\t");
                        startBismark = k + 1;
                        os_ps.print(String.valueOf(gene) + "\t" + startBismark + "\t" + startBismark + "\t" + splitBismark[3] + "\t" + splitBismark[4] + "\t" + splitBismark[5] + "\n");
                    }
                }
                ++k;
                ++i;
            }
        }
        FA.close();
        os.close();
        TextResult tr = new TextResult("Bismark promoter file", "Bismark file in promoter region", new FileParameter.FileRepresentation(out.getAbsolutePath()), "cov.gz", this.getToolName(), null, true);
        return new ToolResult("Result of " + this.getToolName(), this.getToolName(), null, new ResultSet(tr), parameters, this.getToolName(), new Date(System.currentTimeMillis()));
    }

    @Override
    public String getToolName() {
        return "BismarkConvertToPromoter";
    }

    @Override
    public String getToolVersion() {
        return "0.1";
    }

    @Override
    public String getShortName() {
        return "bis2prom";
    }

    @Override
    public String getDescription() {
        return "Creates Bismark file in promoter region";
    }

    @Override
    public String getHelpText() {
        try {
            return FileManager.readInputStream(BismarkConvertToPromoterSearch.class.getClassLoader().getResourceAsStream("projects/tals/epigenetic/toolHelpFiles/BismarkConvertToPromoterSearch.txt")).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public String[] getReferences() {
        return null;
    }
}

