/*
 * Decompiled with CFR 0.152.
 */
package projects.tals.epigenetic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import projects.tals.epigenetic.PileupCoverageprofil;

public class PileupCoverageprofilHashMap {
    private HashMap<String, PileupCoverageprofil> pileupCoverageProfiles = new HashMap();

    public PileupCoverageprofilHashMap(String faiPath, String PathtoFile) throws Exception {
        this(faiPath, PathtoFile, 300, 50, false);
    }

    public PileupCoverageprofilHashMap(HashMap<String, Integer> chromLengthHash, String PathtoFile, int before, int after, boolean calculateAlwaysOnCompleteSeq) throws Exception {
        float[] covValue;
        int[][] numberOfCoveragePositions;
        BufferedReader BR = PathtoFile.endsWith("gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(new File(PathtoFile))))) : new BufferedReader(new InputStreamReader(new FileInputStream(new File(PathtoFile))));
        String line = "";
        HashMap<String, float[]> covValueHash = new HashMap<String, float[]>();
        HashMap<String, int[][]> numberOfCoveragePositionsHash = new HashMap<String, int[][]>();
        for (String chrom : chromLengthHash.keySet()) {
            numberOfCoveragePositions = new int[2][chromLengthHash.get(chrom).intValue()];
            covValue = new float[chromLengthHash.get(chrom).intValue()];
            Arrays.fill(numberOfCoveragePositions[0], 0);
            Arrays.fill(numberOfCoveragePositions[1], 0);
            Arrays.fill(covValue, 0.0f);
            numberOfCoveragePositionsHash.put(chrom, (int[][])numberOfCoveragePositions.clone());
            covValueHash.put(chrom, (float[])covValue.clone());
        }
        while ((line = BR.readLine()) != null) {
            String[] splitLine2 = line.split("\t");
            String chrom = splitLine2[0];
            covValue = (float[])covValueHash.get(chrom);
            covValue[Integer.parseInt((String)splitLine2[1]) - 1] = Float.parseFloat(splitLine2[2]);
            covValueHash.put(chrom, covValue);
        }
        BR.close();
        for (String chrom : chromLengthHash.keySet()) {
            numberOfCoveragePositions = (int[][])numberOfCoveragePositionsHash.get(chrom);
            covValue = (float[])covValueHash.get(chrom);
            int chromLength = chromLengthHash.get(chrom);
            if (calculateAlwaysOnCompleteSeq) {
                int tempNumberOfCoveragePositions = 0;
                int i = 0;
                while (i < chromLength) {
                    if (covValue[i] > 0.0f) {
                        ++tempNumberOfCoveragePositions;
                    }
                    ++i;
                }
                Arrays.fill(numberOfCoveragePositions[0], tempNumberOfCoveragePositions);
                Arrays.fill(numberOfCoveragePositions[1], tempNumberOfCoveragePositions);
            } else {
                int s;
                int windowend;
                int windowStart;
                int lastPos = chromLengthHash.get(chrom) - 1;
                boolean isFirst = true;
                int i = 0;
                while (i < chromLength) {
                    windowStart = i - before < 0 ? 0 : i - before;
                    int n = windowend = i + after > lastPos ? lastPos : i + after;
                    if (isFirst) {
                        s = windowStart;
                        while (s <= windowend) {
                            if (covValue[s] > 0.0f) {
                                int[] nArray = numberOfCoveragePositions[0];
                                int n2 = i;
                                nArray[n2] = nArray[n2] + 1;
                            }
                            ++s;
                        }
                    } else {
                        if (covValue[windowStart] > 0.0f) {
                            int[] nArray = numberOfCoveragePositions[0];
                            int n3 = i;
                            nArray[n3] = nArray[n3] - 1;
                        }
                        if (covValue[windowend - 1] > 0.0f) {
                            int[] nArray = numberOfCoveragePositions[0];
                            int n4 = i;
                            nArray[n4] = nArray[n4] + 1;
                        }
                    }
                    ++i;
                }
                isFirst = true;
                i = 0;
                while (i < chromLength) {
                    windowStart = i - after < 0 ? 0 : i - after;
                    int n = windowend = i + before > lastPos ? lastPos : i + before;
                    if (isFirst) {
                        s = windowStart;
                        while (s <= windowend) {
                            if (covValue[s] > 0.0f) {
                                int[] nArray = numberOfCoveragePositions[1];
                                int n5 = i;
                                nArray[n5] = nArray[n5] + 1;
                            }
                            ++s;
                        }
                    } else {
                        if (covValue[windowStart] > 0.0f) {
                            int[] nArray = numberOfCoveragePositions[1];
                            int n6 = i;
                            nArray[n6] = nArray[n6] - 1;
                        }
                        if (covValue[windowend - 1] > 0.0f) {
                            int[] nArray = numberOfCoveragePositions[1];
                            int n7 = i;
                            nArray[n7] = nArray[n7] + 1;
                        }
                    }
                    ++i;
                }
            }
            numberOfCoveragePositionsHash.put(chrom, numberOfCoveragePositions);
            this.pileupCoverageProfiles.put(chrom, new PileupCoverageprofil(chrom, chromLengthHash.get(chrom), (int[][])numberOfCoveragePositionsHash.get(chrom), before, after, calculateAlwaysOnCompleteSeq));
        }
    }

    public PileupCoverageprofilHashMap(String faiPath, String PathtoFile, int before, int after, boolean calculateAlwaysOnCompleteSeq) throws Exception {
        float[] covValue;
        int[][] numberOfCoveragePositions;
        HashMap<String, Integer> chromLengthHash = new HashMap<String, Integer>();
        BufferedReader readFai = new BufferedReader(new FileReader(faiPath));
        String line = "";
        int chromLength = -1;
        while ((line = readFai.readLine()) != null) {
            String[] splitLine = line.split("\t");
            chromLength = Integer.parseInt(splitLine[1]);
            chromLengthHash.put(splitLine[0], chromLength);
        }
        readFai.close();
        BufferedReader BR = new BufferedReader(new InputStreamReader(new FileInputStream(new File(PathtoFile))));
        line = "";
        HashMap<String, float[]> covValueHash = new HashMap<String, float[]>();
        HashMap<String, int[][]> numberOfCoveragePositionsHash = new HashMap<String, int[][]>();
        for (String chrom : chromLengthHash.keySet()) {
            numberOfCoveragePositions = new int[2][((Integer)chromLengthHash.get(chrom)).intValue()];
            covValue = new float[((Integer)chromLengthHash.get(chrom)).intValue()];
            Arrays.fill(numberOfCoveragePositions[0], 0);
            Arrays.fill(numberOfCoveragePositions[1], 0);
            Arrays.fill(covValue, 0.0f);
            numberOfCoveragePositionsHash.put(chrom, (int[][])numberOfCoveragePositions.clone());
            covValueHash.put(chrom, (float[])covValue.clone());
        }
        while ((line = BR.readLine()) != null) {
            String[] splitLine2 = line.split("\t");
            String chrom = splitLine2[0];
            covValue = (float[])covValueHash.get(chrom);
            covValue[Integer.parseInt((String)splitLine2[1]) - 1] = Float.parseFloat(splitLine2[2]);
            covValueHash.put(chrom, covValue);
        }
        BR.close();
        for (String chrom : chromLengthHash.keySet()) {
            numberOfCoveragePositions = (int[][])numberOfCoveragePositionsHash.get(chrom);
            covValue = (float[])covValueHash.get(chrom);
            chromLength = (Integer)chromLengthHash.get(chrom);
            if (calculateAlwaysOnCompleteSeq) {
                int tempNumberOfCoveragePositions = 0;
                int i = 0;
                while (i < chromLength) {
                    if (covValue[i] > 0.0f) {
                        ++tempNumberOfCoveragePositions;
                    }
                    ++i;
                }
                Arrays.fill(numberOfCoveragePositions[0], tempNumberOfCoveragePositions);
                Arrays.fill(numberOfCoveragePositions[1], tempNumberOfCoveragePositions);
            } else {
                int s;
                int windowend;
                int windowStart;
                int lastPos = (Integer)chromLengthHash.get(chrom) - 1;
                boolean isFirst = true;
                int i = 0;
                while (i < chromLength) {
                    windowStart = i - before < 0 ? 0 : i - before;
                    int n = windowend = i + after > lastPos ? lastPos : i + after;
                    if (isFirst) {
                        s = windowStart;
                        while (s <= windowend) {
                            if (covValue[s] > 0.0f) {
                                int[] nArray = numberOfCoveragePositions[0];
                                int n2 = i;
                                nArray[n2] = nArray[n2] + 1;
                            }
                            ++s;
                        }
                    } else {
                        if (covValue[windowStart] > 0.0f) {
                            int[] nArray = numberOfCoveragePositions[0];
                            int n3 = i;
                            nArray[n3] = nArray[n3] - 1;
                        }
                        if (covValue[windowend - 1] > 0.0f) {
                            int[] nArray = numberOfCoveragePositions[0];
                            int n4 = i;
                            nArray[n4] = nArray[n4] + 1;
                        }
                    }
                    ++i;
                }
                isFirst = true;
                i = 0;
                while (i < chromLength) {
                    windowStart = i - after < 0 ? 0 : i - after;
                    int n = windowend = i + before > lastPos ? lastPos : i + before;
                    if (isFirst) {
                        s = windowStart;
                        while (s <= windowend) {
                            if (covValue[s] > 0.0f) {
                                int[] nArray = numberOfCoveragePositions[1];
                                int n5 = i;
                                nArray[n5] = nArray[n5] + 1;
                            }
                            ++s;
                        }
                    } else {
                        if (covValue[windowStart] > 0.0f) {
                            int[] nArray = numberOfCoveragePositions[1];
                            int n6 = i;
                            nArray[n6] = nArray[n6] - 1;
                        }
                        if (covValue[windowend - 1] > 0.0f) {
                            int[] nArray = numberOfCoveragePositions[1];
                            int n7 = i;
                            nArray[n7] = nArray[n7] + 1;
                        }
                    }
                    ++i;
                }
            }
            numberOfCoveragePositionsHash.put(chrom, numberOfCoveragePositions);
            this.pileupCoverageProfiles.put(chrom, new PileupCoverageprofil(chrom, (Integer)chromLengthHash.get(chrom), (int[][])numberOfCoveragePositionsHash.get(chrom), before, after, calculateAlwaysOnCompleteSeq));
        }
    }

    public PileupCoverageprofil getPileupCoverageprofil(String chrom) {
        return this.pileupCoverageProfiles.get(chrom);
    }
}

