/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.functionfit;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.QRDecomposition;
import cern.colt.matrix.linalg.SingularValueDecomposition;

public class LeastSquares {
    private static double[] solution(DoubleMatrix2D X, DoubleMatrix2D Y, int k) {
        QRDecomposition qr = new QRDecomposition(X);
        if (qr.hasFullRank()) {
            DoubleMatrix2D B = qr.solve(Y);
            return B.viewColumn(0).toArray();
        }
        DoubleMatrix1D Y0 = Y.viewColumn(0);
        SingularValueDecomposition svd = new SingularValueDecomposition(X);
        DoubleMatrix2D S = svd.getS();
        DoubleMatrix2D V = svd.getV();
        DoubleMatrix2D U = svd.getU();
        Algebra alg = new Algebra();
        DoubleMatrix2D Ut = alg.transpose(U);
        DoubleMatrix1D g = alg.mult(Ut, Y0);
        for (int j = 0; j < k; ++j) {
            double x = S.getQuick(j, j);
            if (x > 0.0) {
                x = g.getQuick(j) / x;
                g.setQuick(j, x);
                continue;
            }
            g.setQuick(j, 0.0);
        }
        DoubleMatrix1D beta = alg.mult(V, g);
        return beta.toArray();
    }

    public static double[] calcCoefficients(double[] X, double[] Y) {
        if (X.length != Y.length) {
            throw new IllegalArgumentException("Lengths of X and Y are not equal");
        }
        int n = X.length;
        double[][] Xa = new double[n][1];
        for (int i = 0; i < n; ++i) {
            Xa[i][0] = X[i];
        }
        return LeastSquares.calcCoefficients0(Xa, Y);
    }

    public static double[] calcCoefficients(double[] X, double[] Y, int deg) {
        int j;
        int n = X.length;
        if (n != Y.length) {
            throw new IllegalArgumentException("Lengths of X and Y are not equal");
        }
        if (n < deg + 1) {
            throw new IllegalArgumentException("Not enough points");
        }
        double[] xSums = new double[2 * deg + 1];
        double[] xySums = new double[deg + 1];
        xSums[0] = n;
        for (int i = 0; i < n; ++i) {
            double xv = X[i];
            xySums[0] = xySums[0] + Y[i];
            for (j = 1; j <= 2 * deg; ++j) {
                int n2 = j;
                xSums[n2] = xSums[n2] + xv;
                if (j <= deg) {
                    int n3 = j;
                    xySums[n3] = xySums[n3] + xv * Y[i];
                }
                xv *= X[i];
            }
        }
        DenseDoubleMatrix2D A = new DenseDoubleMatrix2D(deg + 1, deg + 1);
        DenseDoubleMatrix2D B = new DenseDoubleMatrix2D(deg + 1, 1);
        for (int i = 0; i <= deg; ++i) {
            for (j = 0; j <= deg; ++j) {
                int d = i + j;
                ((DoubleMatrix2D)A).setQuick(i, j, xSums[d]);
            }
            ((DoubleMatrix2D)B).setQuick(i, 0, xySums[i]);
        }
        return LeastSquares.solution(A, B, deg + 1);
    }

    public static double[] calcCoefficients0(double[][] X, double[] Y) {
        if (X.length != Y.length) {
            throw new IllegalArgumentException("Lengths of X and Y are not equal");
        }
        if (Y.length <= X[0].length + 1) {
            throw new IllegalArgumentException("Not enough points");
        }
        int n = Y.length;
        int k = X[0].length;
        DenseDoubleMatrix2D Xa = new DenseDoubleMatrix2D(n, k + 1);
        DenseDoubleMatrix2D Ya = new DenseDoubleMatrix2D(n, 1);
        for (int i = 0; i < n; ++i) {
            ((DoubleMatrix2D)Xa).setQuick(i, 0, 1.0);
            for (int j = 1; j <= k; ++j) {
                ((DoubleMatrix2D)Xa).setQuick(i, j, X[i][j - 1]);
            }
            ((DoubleMatrix2D)Ya).setQuick(i, 0, Y[i]);
        }
        return LeastSquares.solution(Xa, Ya, k + 1);
    }

    public static double[] calcCoefficients(double[][] X, double[] Y) {
        if (X.length != Y.length) {
            throw new IllegalArgumentException("Lengths of X and Y are not equal");
        }
        if (Y.length <= X[0].length + 1) {
            throw new IllegalArgumentException("Not enough points");
        }
        int n = Y.length;
        int k = X[0].length;
        DenseDoubleMatrix2D Xa = new DenseDoubleMatrix2D(n, k);
        DenseDoubleMatrix2D Ya = new DenseDoubleMatrix2D(n, 1);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < k; ++j) {
                ((DoubleMatrix2D)Xa).setQuick(i, j, X[i][j]);
            }
            ((DoubleMatrix2D)Ya).setQuick(i, 0, Y[i]);
        }
        return LeastSquares.solution(Xa, Ya, k);
    }
}

