/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.clustering.hierachical;

import de.jstacs.clustering.distances.DistanceMetric;
import de.jstacs.clustering.hierachical.ClusterTree;
import de.jstacs.io.ArrayHandler;
import java.util.Iterator;
import java.util.LinkedList;

public class Hclust<T> {
    private DistanceMetric<T> metric;
    private Linkage linkage;

    public Hclust(DistanceMetric<T> metric, Linkage linkage) {
        this.metric = metric;
        this.linkage = linkage;
    }

    public ClusterTree<T> cluster(T ... objects) throws Exception {
        double[][] distMat = DistanceMetric.getPairwiseDistanceMatrix(this.metric, objects);
        return this.cluster(distMat, objects);
    }

    public ClusterTree<Integer> cluster(double[][] distMat, LinkedList<ClusterTree<Integer>> list, int indexOff) {
        int oi = -indexOff - 1;
        while (list.size() > 1) {
            Iterator it = list.iterator();
            int mini = -1;
            int minj = -2;
            double min = Double.POSITIVE_INFINITY;
            int i = 0;
            while (it.hasNext()) {
                ClusterTree tree = (ClusterTree)it.next();
                Iterator it2 = list.iterator();
                int j = 0;
                while (j < i) {
                    ClusterTree tree2 = (ClusterTree)it2.next();
                    double dist = Hclust.getDistance(this.linkage, distMat, tree, tree2);
                    if (dist < min) {
                        min = dist;
                        mini = i;
                        minj = j;
                    }
                    ++j;
                }
                ++i;
            }
            ClusterTree nt = new ClusterTree(min, oi, list.get(mini), list.get(minj));
            --oi;
            list.remove(mini);
            list.remove(minj);
            list.add(nt);
        }
        return list.get(0);
    }

    public ClusterTree<T> cluster(int indexOff, double[][] distMat, ClusterTree<T>[] leaves) {
        LinkedList<ClusterTree<Integer>> list = new LinkedList<ClusterTree<Integer>>();
        Object[] objects = new Object[leaves.length];
        double[][] subMat = new double[leaves.length][leaves.length];
        int i = 0;
        while (i < leaves.length) {
            list.add(new ClusterTree<Integer>(i, leaves[i].getOriginalIndex()));
            objects[i] = leaves[i].getClusterElements()[0];
            int j = 0;
            while (j < leaves.length) {
                subMat[i][j] = distMat[leaves[i].getOriginalIndex()][leaves[j].getOriginalIndex()];
                ++j;
            }
            ++i;
        }
        ClusterTree<Integer> tree = this.cluster(subMat, list, indexOff);
        return this.createTree(tree, objects);
    }

    public ClusterTree<T> cluster(double[][] distMat, T ... objects) {
        LinkedList<ClusterTree<Integer>> list = new LinkedList<ClusterTree<Integer>>();
        int i = 0;
        while (i < objects.length) {
            list.add(new ClusterTree<Integer>(i, i));
            ++i;
        }
        ClusterTree<Integer> tree = this.cluster(distMat, list, 0);
        return this.createTree(tree, objects);
    }

    public static <T> T[][] cutTree(ClusterTree<T> tree, double distance) {
        LinkedList<T[]> list = new LinkedList<T[]>();
        Hclust.fillCutTree(tree, distance, list);
        return (Object[][])ArrayHandler.cast(list.toArray((T[])new Object[0][]));
    }

    private static <T> void fillCutTree(ClusterTree<T> tree, double distance, LinkedList<T[]> list) {
        if (tree.getDistance() <= distance) {
            list.add(tree.getClusterElements());
        } else {
            ClusterTree<T>[] subs = tree.getSubTrees();
            int i = 0;
            while (i < subs.length) {
                Hclust.fillCutTree(subs[i], distance, list);
                ++i;
            }
        }
    }

    public static <T> ClusterTree<T>[] cutTree(double distance, ClusterTree<T> tree) {
        LinkedList<ClusterTree<ClusterTree>> list = new LinkedList<ClusterTree<ClusterTree>>();
        Hclust.fillCutTree(tree, list, distance);
        return list.toArray(new ClusterTree[0]);
    }

    private static <T> void fillCutTree(ClusterTree<T> tree, LinkedList<ClusterTree<T>> list, double distance) {
        if (tree.getDistance() <= distance) {
            list.add(tree);
        } else {
            ClusterTree<T>[] subs = tree.getSubTrees();
            int i = 0;
            while (i < subs.length) {
                Hclust.fillCutTree(subs[i], list, distance);
                ++i;
            }
        }
    }

    public ClusterTree<T> createTree(ClusterTree<Integer> intTree, T ... objects) {
        ClusterTree<Integer>[] intSubs = intTree.getSubTrees();
        if (intSubs == null) {
            return new ClusterTree<T>(objects[intTree.getClusterElements()[0]], intTree.getOriginalIndex());
        }
        ClusterTree[] subs = new ClusterTree[intSubs.length];
        int i = 0;
        while (i < subs.length) {
            subs[i] = this.createTree(intSubs[i], objects);
            ++i;
        }
        return new ClusterTree(intTree.getDistance(), intTree.getOriginalIndex(), subs);
    }

    public static double getDistance(Linkage linkage, double[][] distMat, ClusterTree<Integer> tree, ClusterTree<Integer> tree2) {
        double dist = linkage == Linkage.SINGLE ? Double.POSITIVE_INFINITY : (linkage == Linkage.AVERAGE ? 0.0 : Double.NEGATIVE_INFINITY);
        Integer[] el1 = tree.getClusterElements();
        Integer[] el2 = tree2.getClusterElements();
        int i = 0;
        while (i < el1.length) {
            int j = 0;
            while (j < el2.length) {
                double d = distMat[Math.max(el1[i], el2[j])][Math.min(el1[i], el2[j])];
                if (linkage == Linkage.SINGLE) {
                    if (d < dist) {
                        dist = d;
                    }
                } else if (linkage == Linkage.AVERAGE) {
                    dist += d / (double)(el1.length * el2.length);
                } else if (linkage == Linkage.COMPLETE) {
                    if (d > dist) {
                        dist = d;
                    }
                } else {
                    throw new RuntimeException("Linkage not supported");
                }
                ++j;
            }
            ++i;
        }
        return dist;
    }

    public static enum Linkage {
        SINGLE,
        AVERAGE,
        COMPLETE;

    }
}

