/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.results;

import de.jstacs.DataType;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.results.Result;

public abstract class SimpleResult
extends Result
implements Comparable<SimpleResult> {
    protected Comparable result;

    protected SimpleResult(String name, String comment, DataType datatype) {
        super(name, comment, datatype);
    }

    protected SimpleResult(StringBuffer rep) throws NonParsableException {
        super(rep);
    }

    @Override
    protected void appendFurtherInfos(StringBuffer buf) {
        XMLParser.appendObjectWithTags(buf, this.result.toString(), "result");
    }

    @Override
    protected void extractFurtherInfos(StringBuffer representation) throws NonParsableException {
        Class c;
        switch (this.datatype) {
            case STRING: {
                c = String.class;
                break;
            }
            case BOOLEAN: {
                c = Boolean.TYPE;
                break;
            }
            case INT: {
                c = Integer.TYPE;
                break;
            }
            case LONG: {
                c = Long.TYPE;
                break;
            }
            case DOUBLE: {
                c = Double.TYPE;
                break;
            }
            default: {
                throw new NonParsableException("Result not of expected datatype");
            }
        }
        this.result = (Comparable)((Object)XMLParser.extractObjectForTags(representation, "result", c));
    }

    @Deprecated
    void setResult(Comparable newValue) throws SimpleParameter.IllegalValueException {
        this.set(newValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void set(Comparable result) throws SimpleParameter.IllegalValueException {
        if (this.datatype == DataType.DOUBLE && (result instanceof Double || result instanceof Float)) {
            this.result = result instanceof Float ? new Double(((Float)result).doubleValue()) : result;
            return;
        } else if (this.datatype == DataType.INT && (result instanceof Integer || result instanceof Byte || result instanceof Short)) {
            this.result = result instanceof Byte ? new Integer(((Byte)result).intValue()) : (result instanceof Short ? new Integer(((Short)result).intValue()) : result);
            return;
        } else if (this.datatype == DataType.LONG && result instanceof Long) {
            this.result = result;
            return;
        } else if (this.datatype == DataType.BOOLEAN && result instanceof Boolean) {
            this.result = result;
            return;
        } else if (this.datatype == DataType.STRING && result instanceof String) {
            this.result = result;
            return;
        } else {
            if (!(result instanceof String)) throw new SimpleParameter.IllegalValueException(this.name, "Value not of the expected datatype!");
            if (this.datatype == DataType.DOUBLE) {
                this.result = new Double((String)((Object)result));
                return;
            } else if (this.datatype == DataType.INT) {
                this.result = new Integer((String)((Object)result));
                return;
            } else if (this.datatype == DataType.BOOLEAN) {
                this.result = new Boolean((String)((Object)result));
                return;
            } else {
                if (this.datatype != DataType.LONG) throw new SimpleParameter.IllegalValueException(this.name, "Value not of the expected datatype!");
                this.result = new Long((String)((Object)result));
            }
        }
    }

    @Override
    public Comparable getValue() {
        return this.result;
    }

    public String toString() {
        return String.valueOf(this.name) + ": " + this.result.toString();
    }

    @Override
    public int compareTo(SimpleResult r) {
        if (this.datatype != r.datatype) {
            return this.datatype.ordinal() - r.datatype.ordinal();
        }
        int c = this.name.compareTo(r.name);
        if (c != 0) {
            return c;
        }
        c = this.comment.compareTo(r.comment);
        if (c != 0) {
            return c;
        }
        return this.result.compareTo(r.result);
    }

    @Override
    public boolean equals(Object arg) {
        if (arg instanceof SimpleResult) {
            return this.compareTo((SimpleResult)arg) == 0;
        }
        return false;
    }
}

