/*
 * Decompiled with CFR 0.152.
 */
package projects.encodedream;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;

public class DeriveLabels {
    private static HashMap<String, ArrayList<Peak>> readPeaks(String file) throws IOException {
        BufferedReader peaks = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String str = null;
        HashMap<String, ArrayList<Peak>> list = new HashMap<String, ArrayList<Peak>>();
        while ((str = peaks.readLine()) != null) {
            String[] parts = str.split("\t");
            Peak p = null;
            p = parts.length < 10 ? new Peak(Integer.parseInt(parts[1]), Integer.parseInt(parts[2])) : new Peak(Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[9]));
            list.putIfAbsent(parts[0], new ArrayList());
            list.get(parts[0]).add(p);
        }
        peaks.close();
        for (String key : list.keySet()) {
            list.get(key).sort((a, b) -> Integer.compare(((Peak)a).start, ((Peak)b).start));
        }
        return list;
    }

    public static void run(String consFile, String relFile, String faiFile, PrintWriter wr, int bin, int region, boolean bySummit) throws FileNotFoundException, IOException {
        HashMap<String, ArrayList<Peak>> relaxed = DeriveLabels.readPeaks(relFile);
        HashMap<String, ArrayList<Peak>> conservative = DeriveLabels.readPeaks(consFile);
        BufferedReader faidx = new BufferedReader(new InputStreamReader(new FileInputStream(faiFile)));
        String str = null;
        while ((str = faidx.readLine()) != null) {
            String[] parts = str.split("\t");
            String chr = parts[0];
            int len = Integer.parseInt(parts[1]);
            ArrayList<Peak> li_relaxed = relaxed.get(chr);
            ArrayList<Peak> li_conservative = conservative.get(chr);
            int i = 0;
            while (i + bin <= len) {
                int start = i;
                int end = i + bin;
                int endRegion = i + region;
                char label = DeriveLabels.getLabel(start, end, endRegion, li_relaxed, li_conservative, bySummit);
                wr.println(String.valueOf(chr) + "\t" + start + "\t" + label);
                i += bin;
            }
        }
        faidx.close();
    }

    private static char getLabel(int start, int end, int endRegion, ArrayList<Peak> li_relaxed, ArrayList<Peak> li_conservative, boolean bySummit) {
        char label = 'U';
        if (DeriveLabels.overlaps(start, endRegion, li_relaxed, 1, false)) {
            label = 'A';
        }
        if (DeriveLabels.overlaps(start, endRegion, li_conservative, (end - start) / 2, bySummit)) {
            label = 'B';
        }
        if (DeriveLabels.overlaps(start, end, li_conservative, (end - start) / 2, true)) {
            label = 'S';
        }
        return label;
    }

    private static boolean overlaps(int start, int end, ArrayList<Peak> li, int minOverlap, boolean bySummit) {
        if (li == null) {
            return false;
        }
        int i = 0;
        while (i < li.size()) {
            Peak p = li.get(i);
            if (bySummit) {
                if (start <= p.start + p.summit && p.start + p.summit <= end) {
                    return true;
                }
            } else {
                int locStart = Math.max(start, p.start);
                int locEnd = Math.min(end, p.end);
                if (locEnd - locStart >= minOverlap) {
                    return true;
                }
            }
            if (p.start > end) break;
            ++i;
        }
        return false;
    }

    private static class Label {
        private int start;
        private int end;
        private char label;

        public Label(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }

    private static class Peak {
        private int start;
        private int end;
        private int summit;

        public Peak(int start, int end) {
            this(start, end, (end - start) / 2);
        }

        public Peak(int start, int end, int summit) {
            this.start = start;
            this.end = end;
            this.summit = summit;
        }
    }
}

