/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma;

import de.jstacs.DataType;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.FileExistsValidator;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.parameters.validation.RegExpValidator;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import de.jstacs.utils.DoubleList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import projects.gemoma.GeMoMa;
import projects.gemoma.GeMoMaModule;
import projects.gemoma.Tools;

public class Analyzer
extends GeMoMaModule {
    static final String ALL = "ALL";
    HashSet<String> chr = new HashSet();
    StringBuffer tBuff = new StringBuffer();

    static int getPartsBeforePos(int pos, ArrayList<int[]> list) {
        int anz = 0;
        int i = 0;
        while (i < list.size() && list.get(i)[1] < pos) {
            ++i;
            ++anz;
        }
        return anz;
    }

    static int getPartsAfterPos(int pos, ArrayList<int[]> list) {
        int anz = 0;
        int i = list.size() - 1;
        while (i >= 0 && pos < list.get(i)[0]) {
            --i;
            ++anz;
        }
        return anz;
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads, String temp) throws Exception {
        FileParameter fp = (FileParameter)parameters.getParameterForName("truth");
        String truth = fp.getValue();
        boolean cds = (Boolean)parameters.getParameterForName("CDS").getValue();
        String feature = cds ? "CDS" : "exon";
        protocol.append("selected feature: " + feature + "\n\n");
        SimpleParameterSet ps = (SimpleParameterSet)parameters.getParameterForName("write").getValue();
        boolean write = ps.getNumberOfParameters() > 0;
        double threshold = write ? (Double)ps.getParameterForName("common attributes").getValue() : 0.0;
        ps = (SimpleParameterSet)parameters.getParameterForName("reliable").getValue();
        String filter = Tools.prepareFilter(ps.getNumberOfParameters() == 0 ? null : (String)ps.getParameterForName("filter").getValue());
        ScriptEngineManager mgr = new ScriptEngineManager();
        ScriptEngine engine = mgr.getEngineByName("nashorn");
        boolean onlyIntrons = (Boolean)this.getParameter(parameters, "only introns").getValue();
        String sep = "\t";
        String eol = "\n";
        protocol.append("reading true annotation and removing duplicate transcripts\n");
        HashMap<String, int[]> attributesTruth = new HashMap<String, int[]>();
        attributesTruth.put(ALL, new int[1]);
        ArrayList<String> attTruth = new ArrayList<String>();
        HashMap<String, HashMap<String, Transcript>> res = this.readGFF(feature, truth, protocol, attributesTruth, attTruth);
        HashMap<String, Gene[]> genes = this.toGenes(res, engine, filter, protocol, onlyIntrons);
        ArrayList<String> n = new ArrayList<String>();
        ArrayList<GFFCompareStat> stats = new ArrayList<GFFCompareStat>();
        ArrayList<TextResult> tr = new ArrayList<TextResult>();
        ExpandableParameterSet eps = (ExpandableParameterSet)parameters.getParameterForName("prediction").getValue();
        int i = 0;
        while (i < eps.getNumberOfParameters()) {
            SimpleParameterSet sps = (SimpleParameterSet)eps.getParameterAt(i).getValue();
            String predicted = (String)sps.getParameterForName("predicted annotation").getValue();
            String name = (String)sps.getParameterForName("name").getValue();
            if (name == null || name.length() == 1) {
                name = predicted;
            }
            n.add(name);
            protocol.append("reading predicted annotation: " + name + "\n");
            HashMap<String, int[]> attributesPrediction = new HashMap<String, int[]>();
            attributesPrediction.put(ALL, new int[1]);
            ArrayList<String> attPrediction = new ArrayList<String>();
            HashMap<String, HashMap<String, Transcript>> prediction = this.readGFF(feature, predicted, protocol, attributesPrediction, attPrediction);
            prediction = Analyzer.genesToTranscripts(this.toGenes(prediction, engine, "", protocol, onlyIntrons));
            protocol.append("comparing true and predicted annotation\n");
            HashMap<String, Transcript[]> noOverlap = this.compare(genes, prediction, protocol, filter.length() > 0, stats, onlyIntrons);
            if (write) {
                tr.add(this.write("Comparison " + i, genes, noOverlap, attributesTruth, attTruth, attributesPrediction, attPrediction, temp, threshold, filter, cds));
            }
            protocol.append("\n");
            ++i;
        }
        Analyzer.write(protocol, filter.length() > 0, n, stats, sep, eol, cds, onlyIntrons);
        if (tr.size() > 0) {
            return new ToolResult("", "", null, new ResultSet(tr), parameters, this.getToolName(), new Date());
        }
        return null;
    }

    public TextResult write(String name, HashMap<String, Gene[]> genes, HashMap<String, Transcript[]> noOverlap, HashMap<String, int[]> attributesTruth, ArrayList<String> attTruth, HashMap<String, int[]> attributesPrediction, ArrayList<String> attPrediction, String temp, double threshold, String filter, boolean cds) throws IOException {
        boolean rel;
        File out = Tools.createTempFile("Analyzer", temp);
        BufferedWriter b = new BufferedWriter(new FileWriter(out));
        String feature = cds ? "CDS" : "transcript";
        Object[] chrom = this.chr.toArray(new String[0]);
        Arrays.sort(chrom);
        Gene[] both = new Gene[2];
        int[] index = new int[2];
        b.append("chr\tstrand\tgeneId\tgene bestF1\t#" + feature + "s\t" + feature + "Id");
        boolean bl = rel = filter.length() > 0;
        if (rel) {
            b.append("\treliable (" + filter + ")");
        }
        b.append("\t" + feature + " start position\t" + feature + " end position");
        double all = attributesTruth.get(ALL)[0];
        int anzTruth = 0;
        int i = 0;
        while (i < attTruth.size()) {
            if ((double)attributesTruth.get(attTruth.get(i))[1] / all >= threshold) {
                b.append("\t" + feature + " " + attTruth.get(i));
                ++anzTruth;
            }
            ++i;
        }
        b.append("\t" + feature + " bestF1\t" + feature + " F1" + "\tstart\tend\tfeature difference\tfirst feature\tlast feature\ttp\tfn\tfp" + "\tadditional upstream features truth\tadditional internal features truth\tadditional downstream features truth" + "\tadditional upstream features prediction\tadditional internal features prediction\tadditional downstream features prediction" + "\tintron retention in truth\tintron retention in prediction" + "\tperfect features\tacceptor\tdonor" + "\tpredictionId\tprediction start position\tprediction end position");
        all = attributesPrediction.get(ALL)[0];
        i = 0;
        while (i < attPrediction.size()) {
            if ((double)attributesPrediction.get(attPrediction.get(i))[1] / all >= threshold) {
                b.append("\tprediction " + attPrediction.get(i));
            }
            ++i;
        }
        b.newLine();
        i = 0;
        while (i < chrom.length) {
            Gene[] pos = genes.get(String.valueOf(chrom[i]) + "+");
            Gene[] neg = genes.get(String.valueOf(chrom[i]) + "-");
            Transcript[] noOv = noOverlap.get(chrom[i]);
            Arrays.fill(index, 0);
            int pos_max = pos == null ? 0 : pos.length;
            int neg_max = neg == null ? 0 : neg.length;
            int noOv_j = 0;
            int noOv_max = noOv == null ? 0 : noOv.length;
            while (index[0] < pos_max || index[1] < neg_max || noOv_j < noOv_max) {
                Transcript o;
                both[0] = index[0] < pos_max ? pos[index[0]] : null;
                both[1] = index[1] < neg_max ? neg[index[1]] : null;
                Transcript transcript = o = noOv_j < noOv_max ? noOv[noOv_j] : null;
                int best = both[0] == null && both[1] == null ? -1 : (both[0] != null && both[1] != null && both[0].compareTo(both[1]) < 0 || both[1] == null ? 0 : 1);
                if (o == null || best >= 0 && o != null && both[best].min < o.min) {
                    both[best].write(attributesTruth, attTruth, attributesPrediction, attPrediction, b, threshold, rel);
                    int n = best;
                    index[n] = index[n] + 1;
                    continue;
                }
                ++noOv_j;
                this.tBuff.delete(0, this.tBuff.length());
                this.tBuff.append(String.valueOf(o.chr) + "\t" + o.strand + "\t\tNA\t\t\t\t" + (rel ? "\t" : ""));
                int j = 0;
                while (j < anzTruth) {
                    this.tBuff.append("\t");
                    ++j;
                }
                this.tBuff.append("\tNA\tNA");
                int k = 0;
                while (k < 19) {
                    this.tBuff.append("\t");
                    ++k;
                }
                o.appendAttributes(this.tBuff, attributesPrediction, attPrediction, threshold, false);
                b.append(this.tBuff.toString());
                b.newLine();
            }
            ++i;
        }
        b.close();
        return new TextResult(name, "Result", new FileParameter.FileRepresentation(out.getAbsolutePath()), "tabular", this.getToolName(), null, true);
    }

    public HashMap<String, Transcript[]> compare(HashMap<String, Gene[]> genes, HashMap<String, HashMap<String, Transcript>> prediction, Protocol protocol, boolean rel, ArrayList<GFFCompareStat> stats, boolean onlyIntrons) {
        Iterator f;
        HashMap<String, Transcript[]> noOverlap = new HashMap<String, Transcript[]>();
        ArrayList<Object> current = new ArrayList<Object>();
        Iterator<String> it = this.chr.iterator();
        BitSet predictedRegion = new BitSet();
        BitSet trueRegion = new BitSet();
        BitSet help = new BitSet();
        GFFCompareStat stat = new GFFCompareStat();
        HashMap<String, Double> predGenes = new HashMap<String, Double>();
        HashMap<String, Boolean> predGenesOI = new HashMap<String, Boolean>();
        while (it.hasNext()) {
            String chrom = it.next();
            protocol.append(String.valueOf(chrom) + "\n");
            current.clear();
            int i = 0;
            while (i < 2) {
                String c = String.valueOf(chrom) + (i == 0 ? "+" : "-");
                Gene[] g = genes.get(c);
                HashMap<String, Transcript> pred = prediction.get(c);
                if (g != null) {
                    int j = 0;
                    while (j < g.length) {
                        stat.anzTruth += g[j].t.size();
                        boolean r = false;
                        int k = 0;
                        while (k < g[j].t.size()) {
                            Transcript t = g[j].t.get(k);
                            t.clear();
                            if (t.reliable) {
                                ++stat.anzRTruth;
                                r = true;
                            }
                            ++k;
                        }
                        if (r) {
                            ++stat.anzRTruthG;
                        }
                        ++j;
                    }
                    stat.anzTruthG += g.length;
                }
                if (pred != null) {
                    stat.anzPrediction += pred.size();
                    Iterator<Transcript> iter = pred.values().iterator();
                    while (iter.hasNext()) {
                        if (onlyIntrons) {
                            predGenesOI.put(iter.next().parent, false);
                            continue;
                        }
                        predGenes.put(iter.next().parent, 0.0);
                    }
                    if (g != null) {
                        Object[] predictions = pred.values().toArray(new Transcript[0]);
                        Arrays.sort(predictions);
                        int[] cumGEnd = new int[g.length];
                        int last = -1000;
                        int j = 0;
                        while (j < g.length) {
                            last = cumGEnd[j] = Math.max(last, g[j].max);
                            ++j;
                        }
                        int gIndex = 0;
                        int j2 = 0;
                        while (j2 < predictions.length) {
                            ((Transcript)predictions[j2]).sortParts();
                            while (gIndex < cumGEnd.length && cumGEnd[gIndex] < ((Transcript)predictions[j2]).min) {
                                ++gIndex;
                            }
                            double bestF1 = -1.0;
                            boolean bestOI = false;
                            int bestG = -1;
                            int bestT = -1;
                            int idx = gIndex;
                            while (idx < g.length && g[idx].min < ((Transcript)predictions[j2]).max) {
                                int k = 0;
                                while (k < g[idx].t.size()) {
                                    Transcript currentTranscript = g[idx].t.get(k);
                                    int start = Math.min(((Transcript)predictions[j2]).min, currentTranscript.min) - 1;
                                    ((Transcript)predictions[j2]).set(predictedRegion, start);
                                    currentTranscript.set(trueRegion, start);
                                    double tp = Analyzer.count(help, predictedRegion, trueRegion, false);
                                    double fn = Analyzer.count(help, predictedRegion, trueRegion, true);
                                    double fp = Analyzer.count(help, trueRegion, predictedRegion, true);
                                    double f1 = 2.0 * tp / (2.0 * tp + fn + fp);
                                    if (f1 > 0.0) {
                                        currentTranscript.setOverlap(f1);
                                    }
                                    if (onlyIntrons) {
                                        boolean oi;
                                        int[] res = currentTranscript.spliceSites((Transcript)predictions[j2]);
                                        boolean bl = oi = res[0] > 1 && res[0] == res[1] && res[0] == res[2];
                                        if (!bestOI) {
                                            if (oi) {
                                                bestOI = oi;
                                                bestF1 = f1;
                                                bestG = idx;
                                                bestT = k;
                                            } else if (bestF1 < f1) {
                                                bestF1 = f1;
                                                bestG = idx;
                                                bestT = k;
                                            }
                                        }
                                    } else if (f1 > bestF1) {
                                        bestF1 = f1;
                                        bestG = idx;
                                        bestT = k;
                                    }
                                    ++k;
                                }
                                ++idx;
                            }
                            if (onlyIntrons) {
                                if (bestOI && !((Boolean)predGenesOI.get(((Transcript)predictions[j2]).parent)).booleanValue()) {
                                    predGenesOI.put(((Transcript)predictions[j2]).parent, bestOI);
                                }
                            } else if ((Double)predGenes.get(((Transcript)predictions[j2]).parent) < bestF1) {
                                predGenes.put(((Transcript)predictions[j2]).parent, bestF1);
                            }
                            if (bestF1 <= 0.0) {
                                current.add(predictions[j2]);
                            } else {
                                Transcript currentT = g[bestG].t.get(bestT);
                                int start = Math.min(((Transcript)predictions[j2]).min, currentT.min) - 1;
                                ((Transcript)predictions[j2]).set(predictedRegion, start);
                                currentT.set(trueRegion, start);
                                double tp = Analyzer.count(help, predictedRegion, trueRegion, false);
                                double fn = Analyzer.count(help, predictedRegion, trueRegion, true);
                                double fp = Analyzer.count(help, trueRegion, predictedRegion, true);
                                boolean wasComplete = currentT.isComplete(onlyIntrons);
                                int[] res = currentT.spliceSites((Transcript)predictions[j2]);
                                currentT.set((Transcript)predictions[j2], bestF1, tp, fn, fp, res);
                                if (onlyIntrons ? bestOI : bestF1 == 1.0) {
                                    stat.anzPerfect += 1.0;
                                    if (!wasComplete) {
                                        stat.anzTPerfect += 1.0;
                                        if (currentT.reliable) {
                                            stat.anzRPerfect += 1.0;
                                        }
                                    }
                                }
                            }
                            ++j2;
                        }
                        j2 = 0;
                        while (j2 < g.length) {
                            if (g[j2].anyComplete(onlyIntrons)) {
                                stat.anzPerfectG += 1.0;
                            }
                            if (rel) {
                                boolean r = false;
                                int k = 0;
                                while (k < g[j2].t.size()) {
                                    Transcript t = g[j2].t.get(k);
                                    if (t.reliable && t.isComplete(onlyIntrons)) {
                                        r = true;
                                    }
                                    ++k;
                                }
                                if (r) {
                                    stat.anzRPerfectG += 1.0;
                                }
                            }
                            ++j2;
                        }
                    } else {
                        current.addAll(pred.values());
                    }
                }
                ++i;
            }
            Collections.sort(current);
            noOverlap.put(chrom, current.toArray(new Transcript[0]));
        }
        stat.anzPredG = (onlyIntrons ? predGenesOI : predGenes).size();
        if (onlyIntrons) {
            f = predGenesOI.values().iterator();
            while (f.hasNext()) {
                if (!((Boolean)f.next()).booleanValue()) continue;
                stat.anzPerfectG2 += 1.0;
            }
        } else {
            f = predGenes.values().iterator();
            while (f.hasNext()) {
                if ((Double)f.next() != 1.0) continue;
                stat.anzPerfectG2 += 1.0;
            }
        }
        stats.add(stat);
        return noOverlap;
    }

    static void write(Protocol protocol, boolean rel, ArrayList<String> name, ArrayList<GFFCompareStat> list, String sep, String eol, boolean cds, boolean onlyIntrons) {
        String feature;
        Locale l = Locale.US;
        int prec = 2;
        NumberFormat nf1 = NumberFormat.getInstance(l);
        nf1.setMinimumFractionDigits(prec);
        nf1.setMaximumFractionDigits(prec);
        NumberFormat nf2 = NumberFormat.getInstance(l);
        nf2.setMaximumFractionDigits(0);
        String string = feature = cds ? "CDS" : "transcript";
        if (onlyIntrons) {
            feature = String.valueOf(feature) + " intron-structure";
        }
        protocol.append("number of true " + feature + "s");
        int val = list.get((int)0).anzTruth;
        for (GFFCompareStat stat : list) {
            if (val == stat.anzTruth) continue;
            throw new IllegalArgumentException("anzTruth corrupted");
        }
        protocol.append(String.valueOf(sep) + nf2.format(val) + eol);
        protocol.append("number of true genes");
        int val2 = list.get((int)0).anzTruthG;
        for (GFFCompareStat stat : list) {
            if (val2 == stat.anzTruthG) continue;
            throw new IllegalArgumentException("anzTruthG corrupted");
        }
        protocol.append(String.valueOf(sep) + nf2.format(val2) + eol);
        protocol.append("number of true " + feature + "s per true gene" + sep + nf1.format((double)val / (double)val2) + eol);
        if (rel) {
            protocol.append("number of reliable true " + feature + "s");
            val = list.get((int)0).anzRTruth;
            for (GFFCompareStat stat : list) {
                if (val == stat.anzRTruth) continue;
                throw new IllegalArgumentException("anzRTruthG corrupted");
            }
            protocol.append(String.valueOf(sep) + nf2.format(val) + " (" + nf1.format((double)val / (double)list.get((int)0).anzTruth * 100.0) + "%)" + eol);
            protocol.append("number of reliable true genes");
            val = list.get((int)0).anzRTruthG;
            for (GFFCompareStat stat : list) {
                if (val == stat.anzRTruthG) continue;
                throw new IllegalArgumentException("anzRTruthG corrupted");
            }
            protocol.append(String.valueOf(sep) + nf2.format(val) + " (" + nf1.format((double)val / (double)list.get((int)0).anzTruthG * 100.0) + "%)" + eol);
        }
        protocol.append(String.valueOf(eol) + eol + "category");
        for (String n : name) {
            protocol.append(String.valueOf(sep) + n);
        }
        protocol.append(String.valueOf(eol) + eol);
        protocol.append("number of predicted " + feature + "s");
        for (GFFCompareStat stat : list) {
            protocol.append(String.valueOf(sep) + nf2.format(stat.anzPrediction));
        }
        protocol.append(eol);
        protocol.append("number of predicted genes");
        for (GFFCompareStat stat : list) {
            protocol.append(String.valueOf(sep) + nf2.format(stat.anzPredG));
        }
        protocol.append(eol);
        protocol.append("number of predicted " + feature + "s per predicted gene");
        for (GFFCompareStat stat : list) {
            protocol.append(String.valueOf(sep) + nf1.format((double)stat.anzPrediction / (double)stat.anzPredG));
        }
        protocol.append(eol);
        protocol.append(String.valueOf(eol) + "number of non-redundant perfectly predicted " + feature + "s");
        for (GFFCompareStat stat : list) {
            protocol.append(String.valueOf(sep) + nf2.format(stat.anzTPerfect));
        }
        protocol.append(String.valueOf(eol) + "number of perfectly predicted " + feature + "s");
        for (GFFCompareStat stat : list) {
            protocol.append(String.valueOf(sep) + nf2.format(stat.anzPerfect));
        }
        protocol.append(eol);
        if (rel) {
            protocol.append("number of perfectly predicted non-redundant reliable true " + feature + "s");
            for (GFFCompareStat stat : list) {
                protocol.append(String.valueOf(sep) + nf2.format(stat.anzRPerfect));
            }
            protocol.append(eol);
        }
        protocol.append(String.valueOf(eol) + "number of true genes with at least one perfectly predicted " + feature);
        for (GFFCompareStat stat : list) {
            protocol.append(String.valueOf(sep) + nf2.format(stat.anzPerfectG));
        }
        protocol.append(eol);
        protocol.append("number of predicted genes with at least one perfectly predicted " + feature);
        for (GFFCompareStat stat : list) {
            protocol.append(String.valueOf(sep) + nf2.format(stat.anzPerfectG2));
        }
        protocol.append(eol);
        if (rel) {
            protocol.append("number of reliable true genes with at least one perfectly predicted " + feature);
            for (GFFCompareStat stat : list) {
                protocol.append(String.valueOf(sep) + nf2.format(stat.anzRPerfectG));
            }
            protocol.append(eol);
        }
        protocol.append(String.valueOf(eol) + feature + " sensitivity");
        for (GFFCompareStat stat : list) {
            protocol.append(String.valueOf(sep) + nf1.format(stat.anzTPerfect / (double)stat.anzTruth * 100.0));
        }
        protocol.append(String.valueOf(eol) + feature + " precision");
        for (GFFCompareStat stat : list) {
            protocol.append(String.valueOf(sep) + nf1.format(stat.anzPerfect / (double)stat.anzPrediction * 100.0));
        }
        protocol.append(String.valueOf(eol) + feature + " F1");
        for (GFFCompareStat stat : list) {
            double sn = stat.anzTPerfect / (double)stat.anzTruth;
            double pr = stat.anzPerfect / (double)stat.anzPrediction;
            protocol.append(String.valueOf(sep) + nf1.format(2.0 * sn * pr / (sn + pr)));
        }
        if (rel) {
            protocol.append(String.valueOf(eol) + "reliable " + feature + " sensitivity");
            for (GFFCompareStat stat : list) {
                protocol.append(String.valueOf(sep) + nf1.format(stat.anzRPerfect / (double)stat.anzRTruth * 100.0));
            }
        }
        protocol.append(eol);
        protocol.append(String.valueOf(eol) + "gene sensitivity");
        for (GFFCompareStat stat : list) {
            protocol.append(String.valueOf(sep) + nf1.format(stat.anzPerfectG / (double)stat.anzTruthG * 100.0));
        }
        protocol.append(String.valueOf(eol) + "gene precision");
        for (GFFCompareStat stat : list) {
            protocol.append(String.valueOf(sep) + nf1.format(stat.anzPerfectG2 / (double)stat.anzPredG * 100.0));
        }
        protocol.append(eol);
        if (rel) {
            protocol.append("reliable gene sensitivity");
            for (GFFCompareStat stat : list) {
                protocol.append(String.valueOf(sep) + nf1.format(stat.anzRPerfectG / (double)stat.anzRTruthG * 100.0));
            }
            protocol.append(eol);
        }
    }

    private static int count(BitSet help, BitSet b1, BitSet b2, boolean flipFirst) {
        help.clear();
        help.or(b1);
        if (flipFirst) {
            help.flip(0, help.size());
        }
        help.and(b2);
        return help.cardinality();
    }

    public HashMap<String, Gene[]> toGenes(HashMap<String, HashMap<String, Transcript>> res, ScriptEngine engine, String filter, Protocol protocol, boolean onlyIntrons) throws ScriptException {
        Iterator<String> it = res.keySet().iterator();
        HashMap<String, Gene> g = new HashMap<String, Gene>();
        HashMap<String, Gene[]> sortedGenes = new HashMap<String, Gene[]>();
        int duplicate = 0;
        while (it.hasNext()) {
            String key = it.next();
            HashMap<String, Transcript> current = res.get(key);
            g.clear();
            for (String tkey : current.keySet()) {
                Gene gene;
                Transcript t = current.get(tkey);
                if (t.parts.size() <= 0) continue;
                if (filter.length() > 0) {
                    t.reliable = Tools.filter(engine, filter, t.hash);
                }
                t.sortParts();
                if (t.parent == null) {
                    t.parent = String.valueOf(t.id) + ".gene";
                }
                if ((gene = (Gene)g.get(t.parent)) == null) {
                    gene = new Gene(t.parent);
                    g.put(t.parent, gene);
                }
                gene.addTranscript(t);
            }
            Object[] gArray = g.values().toArray(new Gene[0]);
            Arrays.sort(gArray);
            ArrayList<Object> dedup = new ArrayList<Object>();
            int i = 0;
            while (i < gArray.length) {
                duplicate += ((Gene)gArray[i]).eliminateDuplicates(onlyIntrons);
                if (((Gene)gArray[i]).t.size() > 0) {
                    dedup.add(gArray[i]);
                    Collections.sort(((Gene)gArray[i]).t, TranscriptNameComparator.SINGLETON);
                }
                ++i;
            }
            sortedGenes.put(key, dedup.toArray(new Gene[0]));
        }
        if (duplicate > 0) {
            protocol.append("removed " + duplicate + " duplicates" + (onlyIntrons ? " and single-exon features" : "") + "\n\n");
        }
        return sortedGenes;
    }

    public static HashMap<String, HashMap<String, Transcript>> genesToTranscripts(HashMap<String, Gene[]> genes) {
        HashMap<String, HashMap<String, Transcript>> transcripts = new HashMap<String, HashMap<String, Transcript>>();
        for (String chr : genes.keySet()) {
            Gene[] g = genes.get(chr);
            HashMap<String, Transcript> current = new HashMap<String, Transcript>();
            Gene[] geneArray = g;
            int n = g.length;
            int n2 = 0;
            while (n2 < n) {
                Gene gene = geneArray[n2];
                for (Transcript t : gene.t) {
                    current.put(t.id, t);
                }
                ++n2;
            }
            transcripts.put(chr, current);
        }
        return transcripts;
    }

    public HashMap<String, HashMap<String, Transcript>> readGFF(String feature, String fName, Protocol protocol, HashMap<String, int[]> attributes, ArrayList<String> att) throws IOException {
        Transcript t;
        String line;
        BufferedReader r = new BufferedReader(Tools.openGzOrPlain(fName));
        HashMap<String, HashMap<String, Transcript>> res = new HashMap<String, HashMap<String, Transcript>>();
        HashMap<Object, Object> current = new HashMap();
        boolean first = true;
        boolean isGtf = false;
        while ((line = r.readLine()) != null) {
            int idx2;
            int idx1;
            boolean relevant;
            if (!isGtf && line.equalsIgnoreCase("##FASTA")) {
                protocol.append("Stop reading the annotation file because of '##FASTA'\n");
                break;
            }
            if (line.length() == 0 || line.startsWith("#")) continue;
            String[] split = line.split("\t");
            if (split.length != 9) {
                throw new IllegalArgumentException("This line does not seem to be a valid (tab-delimited) line of the annotation with 9 columns: " + line);
            }
            if (first) {
                isGtf = split[8].indexOf(61) < 0;
                protocol.append("detected annotation format: " + (isGtf ? "GTF" : "GFF") + "\n");
                first = false;
            }
            if (!(relevant = split[2].equals(feature)) && !split[2].equals("mRNA") && !split[2].equals("transcript")) continue;
            this.chr.add(split[0]);
            current = res.get(String.valueOf(split[0]) + split[6]);
            if (current == null) {
                current = new HashMap();
                res.put(String.valueOf(split[0]) + split[6], current);
            }
            if (relevant) {
                if (isGtf) {
                    idx1 = split[8].indexOf("transcript_id ") + 14;
                    idx2 = split[8].indexOf(59, idx1);
                } else {
                    idx1 = split[8].indexOf("Parent=") + 7;
                    idx2 = split[8].indexOf(59, idx1);
                }
                if (idx2 < 0) {
                    idx2 = split[8].length();
                }
            } else {
                if (isGtf) {
                    idx1 = split[8].indexOf("transcript_id ") + 14;
                    idx2 = split[8].indexOf(59, idx1);
                } else {
                    idx1 = split[8].indexOf("ID=") + 3;
                    idx2 = split[8].indexOf(59, idx1);
                }
                if (idx2 < 0) {
                    idx2 = split[8].length();
                }
            }
            if (idx1 < 0 || idx2 < 0) {
                throw new IllegalArgumentException(line);
            }
            String tID = split[8].substring(idx1, idx2);
            if (isGtf) {
                tID = tID.trim().replaceAll("^\"", "").replaceAll("\"$", "");
            }
            if ((t = (Transcript)current.get(tID)) == null) {
                t = new Transcript(split[0], split[6], tID);
                current.put(tID, t);
            }
            if (relevant) {
                t.addFeature(split[3], split[4]);
                continue;
            }
            t.addInfo(split[8], attributes, att, isGtf);
        }
        r.close();
        int empty = 0;
        Iterator it = res.keySet().iterator();
        while (it.hasNext()) {
            current = res.get(it.next());
            String[] ids = current.keySet().toArray(new String[0]);
            int i = 0;
            while (i < ids.length) {
                t = (Transcript)current.get(ids[i]);
                if (t.parts.size() == 0) {
                    ++empty;
                    current.remove(ids[i]);
                }
                ++i;
            }
        }
        if (empty > 0) {
            protocol.append("removed " + empty + " empty transcripts\n");
        }
        return res;
    }

    @Override
    public ToolParameterSet getToolParameters() {
        try {
            return new ToolParameterSet(this.getToolName(), new FileParameter("truth", "the true annotation", "gff,gff3,gtf,gff.gz,gff3.gz,gtf.gz", true, new FileExistsValidator()), new ParameterSetContainer("prediction", "", new ExpandableParameterSet(new SimpleParameterSet(new SimpleParameter(DataType.STRING, "name", "can be used to distinguish different predictions", false, new RegExpValidator("\\S*")), new FileParameter("predicted annotation", "GFF/GTF file containing the predicted annotation", "gff,gff3,gtf,gff.gz,gff3.gz,gtf.gz", true, new FileExistsValidator(), true)), "gene annotations", "", 1)), new SimpleParameter(DataType.BOOLEAN, "CDS", "if true CDS features are used otherwise exon features", true, true), new SimpleParameter(DataType.BOOLEAN, "only introns", "if true only intron borders (=splice sites) are evaluated", true, false), new SelectionParameter(DataType.PARAMETERSET, new String[]{"NO", "YES"}, new Object[]{new SimpleParameterSet(new Parameter[0]), new SimpleParameterSet(new SimpleParameter(DataType.DOUBLE, "common attributes", "Only gff attributes of mRNAs are included in the result table, that can be found in the given portion of all mRNAs. Attributes and their portion are handled independently for truth and prediction. This parameter allows to choose between a more informative table or compact table.", true, new NumberValidator<Double>(0.0, 1.0), 0.5))}, "write", "write detailed table comparing the true and the predicted annotation", true), new SelectionParameter(DataType.PARAMETERSET, new String[]{"NO", "YES"}, new Object[]{new SimpleParameterSet(new Parameter[0]), new SimpleParameterSet(new SimpleParameter(DataType.STRING, "filter", "A filter for deciding which transcript from the truth are reliable or not. The filter is applied to the GFF attributes of the truth. You probably need to run AnnotationEvidence on the truth GFF. The default filter decides based on the completeness of the prediction (start=='M' and stop=='*'), no premature stop codons (nps==0), RNA-seq coverage (tpc==1) and intron evidence (isNaN(tie) or tie==1).", false, new RegExpValidator("[a-zA-Z 0-9\\.()><=!'\\-\\+\\*\\/]*"), "start=='M' and stop=='*' and nps==0 and (tpc==1 and (isNaN(tie) or tie==1))"))}, "reliable", "additionally evaluate sensitivity for reliable transcripts", true));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    @Override
    public String getToolName() {
        return this.getShortName();
    }

    @Override
    public String getShortName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getDescription() {
        return "compares true and predicted annotation";
    }

    @Override
    public String getHelpText() {
        return "This tools allows to compare true annotation with predicted annotation as it is frequently done in benchmark studies. Furthermore, it can return a detailed table comparing true annotation and predicted annotation which might help to identify systematical errors or biases in the predictions. Hence, this tool might help to detect weaknesses of the prediction algorithm.\n\nTrue and predicted transcripts are evaluated based on nucleotide F1 measure. For each predicted transcript, the true transcript with highest nucleotide F1 measure is listed. A negative value in a F1 measure column indicates that there is a predicted transcript that matches the true transcript with a F1 measure value that is the absolute value of this entry, but there is another true transcript that matches this predicted transcript with an even better F1. Also true and predicted transcripts are listed that do not overlap with any transcript from the predicted and true annotation, respectively. The table contains the attributes of the true and the predicted annotation besides some additional columns allowing to easily filter interesting examples and to do statistics.\n\nThe evaluation can be based on CDS (default) or exon features. The tool also reports sensitivity and precision for the categories gene and transcript." + MORE;
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }

    class GFFCompareStat {
        int anzTruth = 0;
        int anzRTruth = 0;
        int anzPrediction = 0;
        int anzTruthG = 0;
        int anzRTruthG = 0;
        int anzPredG;
        double anzPerfect = 0.0;
        double anzRPerfect = 0.0;
        double anzPerfectG = 0.0;
        double anzPerfectG2 = 0.0;
        double anzRPerfectG = 0.0;
        double anzTPerfect = 0.0;

        GFFCompareStat() {
        }
    }

    class Gene
    implements Comparable<Gene> {
        String id;
        int min;
        int max;
        ArrayList<Transcript> t;

        Gene(String id) {
            this.id = id;
            this.t = new ArrayList();
            this.min = Integer.MAX_VALUE;
            this.max = -100;
        }

        public int eliminateDuplicates(boolean onlyIntrons) {
            Comparator<Transcript> comp = onlyIntrons ? TranscriptIntronComparator.SINGLETON : TranscriptComparator.SINGLETON;
            int dupl = 0;
            Collections.sort(this.t, comp);
            int i = this.t.size() - 1;
            while (i >= 0) {
                Transcript next;
                Transcript current = this.t.get(i);
                if (onlyIntrons && current.parts.size() == 1) {
                    this.t.remove(i);
                    ++dupl;
                } else if (i - 1 >= 0 && comp.compare(current, next = this.t.get(i - 1)) == 0) {
                    if (TranscriptNameComparator.SINGLETON.compare(current, next) > 0) {
                        this.t.remove(i);
                        next.id = String.valueOf(next.id) + "," + current.id;
                    } else {
                        this.t.remove(i - 1);
                        current.id = String.valueOf(current.id) + "," + next.id;
                    }
                    ++dupl;
                }
                --i;
            }
            return dupl;
        }

        void addTranscript(Transcript transcript) {
            if (!transcript.parent.equals(this.id)) {
                throw new IllegalArgumentException(String.valueOf(this.id) + "\t" + transcript.parent);
            }
            this.t.add(transcript);
            this.min = Math.min(this.min, transcript.min);
            this.max = Math.max(this.max, transcript.max);
        }

        @Override
        public int compareTo(Gene g) {
            return Integer.compare(this.min, g.min);
        }

        public boolean anyComplete(boolean onlyIntrons) {
            int i = 0;
            while (i < this.t.size()) {
                if (this.t.get(i).isComplete(onlyIntrons)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public double getBestF1() {
            double bestF1 = -2.0;
            int i = 0;
            while (i < this.t.size()) {
                bestF1 = Math.max(bestF1, this.t.get(i).bestF1());
                ++i;
            }
            return bestF1;
        }

        public void write(HashMap<String, int[]> attributesTruth, ArrayList<String> attTruth, HashMap<String, int[]> attributesPrediction, ArrayList<String> attPrediction, BufferedWriter b, double threshold, boolean rel) throws IOException {
            double bestF1 = this.getBestF1();
            int i = 0;
            while (i < this.t.size()) {
                Transcript trans = this.t.get(i);
                trans.write(Analyzer.this.tBuff, this.id, bestF1, this.t.size(), attributesTruth, attTruth, attributesPrediction, attPrediction, threshold, rel);
                b.append(Analyzer.this.tBuff.toString());
                ++i;
            }
        }
    }

    public class Transcript
    implements Comparable<Transcript> {
        String chr;
        String id;
        String parent;
        char strand;
        HashMap<String, String> hash;
        ArrayList<int[]> parts;
        int min;
        int max;
        ArrayList<Transcript> overlap;
        DoubleList overlapF1;
        ArrayList<String> overlapInfo;
        double bestF1;
        boolean reliable;
        boolean bestOI;

        Transcript(String chr, String strand, String id) {
            this.chr = chr;
            this.strand = strand.charAt(0);
            this.id = id;
            this.parent = null;
            this.hash = null;
            this.parts = new ArrayList();
            this.min = Integer.MAX_VALUE;
            this.max = -100;
            this.clear();
            this.reliable = true;
        }

        public String getChromosome() {
            return this.chr;
        }

        public String getID() {
            return this.id;
        }

        public String getParent() {
            return this.parent;
        }

        public char getStrand() {
            return this.strand;
        }

        public int getNumberOfParts() {
            return this.parts.size();
        }

        public int[] getPart(int idx) {
            return this.parts.get(idx);
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public HashMap<String, String> getInfos() {
            return this.hash;
        }

        public void sortParts() {
            Collections.sort(this.parts, GeMoMa.IntArrayComparator.comparator[2]);
        }

        public void set(BitSet region, int start) {
            region.clear();
            int i = 0;
            while (i < this.parts.size()) {
                int[] interval = this.parts.get(i);
                region.set(interval[0] - start, interval[1] - start + 1);
                ++i;
            }
        }

        public void clear() {
            this.bestF1 = 0.0;
            this.bestOI = false;
            if (this.overlap != null) {
                this.overlap.clear();
            }
            if (this.overlapF1 != null) {
                this.overlapF1.clear();
            }
            if (this.overlapInfo != null) {
                this.overlapInfo.clear();
            }
        }

        public void set(Transcript transcript, double f1, double tp, double fn, double fp, int[] res) {
            if (this.overlap == null) {
                this.overlap = new ArrayList();
                this.overlapF1 = new DoubleList();
                this.overlapInfo = new ArrayList();
            }
            this.overlap.add(transcript);
            this.overlapF1.add(f1);
            String s = this.strand == '+' ? String.valueOf(this.min == transcript.min) + "\t" + (this.max == transcript.max) : String.valueOf(this.max == transcript.max) + "\t" + (this.min == transcript.min);
            s = String.valueOf(s) + "\t" + (this.parts.size() - transcript.parts.size());
            s = this.strand == '+' ? String.valueOf(s) + "\t" + (GeMoMa.IntArrayComparator.comparator[0].compare(this.parts.get(0), transcript.parts.get(0)) == 0) + "\t" + (GeMoMa.IntArrayComparator.comparator[0].compare(this.parts.get(this.parts.size() - 1), transcript.parts.get(transcript.parts.size() - 1)) == 0) : String.valueOf(s) + "\t" + (GeMoMa.IntArrayComparator.comparator[0].compare(this.parts.get(this.parts.size() - 1), transcript.parts.get(transcript.parts.size() - 1)) == 0) + "\t" + (GeMoMa.IntArrayComparator.comparator[0].compare(this.parts.get(0), transcript.parts.get(0)) == 0);
            s = String.valueOf(s) + "\t" + tp + "\t" + fn + "\t" + fp;
            int a = Analyzer.getPartsBeforePos(transcript.parts.get(0)[0], this.parts);
            int b = Analyzer.getPartsAfterPos(transcript.parts.get(transcript.parts.size() - 1)[1], this.parts);
            int aa = Analyzer.getPartsBeforePos(this.parts.get(0)[0], transcript.parts);
            int bb = Analyzer.getPartsAfterPos(this.parts.get(this.parts.size() - 1)[1], transcript.parts);
            int i = 0;
            int j = 0;
            int intronRetentionTruth = 0;
            int intronRetentionPrediction = 0;
            int addIntFeatureTruth = 0;
            int addIntFeaturePrediction = 0;
            while (i < this.parts.size() && j < transcript.parts.size()) {
                int[] pred;
                int[] tru = this.parts.get(i);
                if (tru[1] < (pred = transcript.parts.get(j))[0]) {
                    if (j > 0 && transcript.parts.get(j - 1)[1] < tru[0]) {
                        ++addIntFeatureTruth;
                    }
                    ++i;
                    continue;
                }
                if (pred[1] < tru[0]) {
                    if (i > 0 && this.parts.get(i - 1)[1] < pred[0]) {
                        ++addIntFeaturePrediction;
                    }
                    ++j;
                    continue;
                }
                if (pred[1] < tru[1]) {
                    if (j + 1 < transcript.parts.size() && transcript.parts.get(j + 1)[0] < tru[1]) {
                        ++intronRetentionTruth;
                    }
                    ++j;
                    continue;
                }
                if (tru[1] < pred[1]) {
                    if (i + 1 < this.parts.size() && this.parts.get(i + 1)[0] < pred[1]) {
                        ++intronRetentionPrediction;
                    }
                    ++i;
                    continue;
                }
                ++i;
                ++j;
            }
            s = this.strand == '+' ? String.valueOf(s) + "\t" + a + "\t" + addIntFeatureTruth + "\t" + b + "\t" + aa + "\t" + addIntFeaturePrediction + "\t" + bb : String.valueOf(s) + "\t" + b + "\t" + addIntFeatureTruth + "\t" + a + "\t" + bb + "\t" + addIntFeaturePrediction + "\t" + aa;
            s = String.valueOf(s) + "\t" + intronRetentionTruth + "\t" + intronRetentionPrediction;
            j = 0;
            i = 0;
            int anz = 0;
            while (i < this.parts.size() && j < transcript.parts.size()) {
                int comp = GeMoMa.IntArrayComparator.comparator[0].compare(this.parts.get(i), transcript.parts.get(j));
                if (comp == 0) {
                    ++i;
                    ++j;
                    ++anz;
                    continue;
                }
                if (comp < 0) {
                    ++i;
                    continue;
                }
                ++j;
            }
            s = String.valueOf(s) + "\t" + anz;
            double n = res[0];
            s = n > 0.0 ? String.valueOf(s) + "\t" + (double)res[1] / n + "\t" + (double)res[2] / n : String.valueOf(s) + "\tNA\tNA";
            if (!this.bestOI) {
                this.bestOI = res[0] > 1 && res[0] == res[1] && res[0] == res[2];
            }
            this.overlapInfo.add(s);
        }

        public int[] spliceSites(Transcript transcript) {
            int[] res = new int[3];
            res[0] = transcript.parts.size() - 1;
            if (res[0] > 0) {
                int i = 0;
                int j = 0;
                while (i < this.parts.size() && j < transcript.parts.size()) {
                    int[] p2;
                    int[] p1 = this.parts.get(i);
                    if (p1[0] == (p2 = transcript.parts.get(j))[0] && i > 0 && j > 0) {
                        res[1] = res[1] + 1;
                    }
                    if (p1[1] == p2[1] && i + 1 < this.parts.size() && j + 1 < transcript.parts.size()) {
                        res[2] = res[2] + 1;
                    }
                    if (p1[1] == p2[1]) {
                        ++i;
                        ++j;
                        continue;
                    }
                    if (p1[1] < p2[1]) {
                        ++i;
                        continue;
                    }
                    ++j;
                }
            }
            return res;
        }

        public void setOverlap(double f1) {
            if (this.bestF1 < f1) {
                this.bestF1 = f1;
            }
        }

        public double bestF1() {
            if (this.overlap == null || this.overlap.size() == 0) {
                if (this.bestF1 > 0.0) {
                    return -this.bestF1;
                }
                return 0.0;
            }
            return this.overlapF1.max(0, this.overlapF1.length());
        }

        public void addInfo(String attributes, HashMap<String, int[]> attributesHash, ArrayList<String> att, boolean isGtf) {
            if (this.hash != null || this.parent != null) {
                throw new IllegalArgumentException("Could not set attributes (" + this.hash + ") or parent (" + this.parent + "): " + attributes);
            }
            int[] nArray = attributesHash.get(Analyzer.ALL);
            nArray[0] = nArray[0] + 1;
            String[] split = attributes.split(";");
            this.hash = new HashMap();
            String[] stringArray = split;
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if ((s = s.trim()).length() != 0) {
                    int[] h;
                    int index;
                    int n3 = index = isGtf ? s.indexOf(32) : s.indexOf(61);
                    if (index < 0) {
                        throw new IllegalArgumentException("Illegal attributes: " + s);
                    }
                    String key = s.substring(0, index);
                    String value = s.substring(index + 1);
                    if (isGtf) {
                        value = value.trim().replaceAll("^\"", "").replaceAll("\"$", "");
                        if (!key.equals("transcript_id")) {
                            if (key.equals("gene_id")) {
                                this.parent = value;
                            } else {
                                h = attributesHash.get(key);
                                if (h == null) {
                                    int[] nArray2 = new int[2];
                                    nArray2[0] = att.size();
                                    h = nArray2;
                                    attributesHash.put(key, h);
                                    att.add(key);
                                }
                                h[1] = h[1] + 1;
                                this.hash.put(key, value);
                            }
                        }
                    } else if (!key.equals("ID") && key.charAt(0) != '#') {
                        if (key.equals("Parent")) {
                            this.parent = value;
                        } else {
                            h = attributesHash.get(key);
                            if (h == null) {
                                int[] nArray3 = new int[2];
                                nArray3[0] = att.size();
                                h = nArray3;
                                attributesHash.put(key, h);
                                att.add(key);
                            }
                            h[1] = h[1] + 1;
                            this.hash.put(key, value);
                        }
                    }
                }
                ++n2;
            }
        }

        public void addFeature(String start, String end) {
            int s = Integer.parseInt(start);
            int e = Integer.parseInt(end);
            this.parts.add(new int[]{s, e});
            this.min = Math.min(this.min, s);
            this.max = Math.max(this.max, e);
        }

        public void write(StringBuffer res, String geneID, double bestF1, int size, HashMap<String, int[]> attributesTruth, ArrayList<String> attTruth, HashMap<String, int[]> attributesPredcition, ArrayList<String> attPredcition, double threshold, boolean rel) {
            res.delete(0, res.length());
            res.append(String.valueOf(this.chr) + "\t" + this.strand + "\t" + geneID + "\t" + bestF1 + "\t" + size);
            this.appendAttributes(res, attributesTruth, attTruth, threshold, rel);
            res.append("\t" + this.bestF1());
            String prefix = res.toString();
            if (this.overlap != null && this.overlap.size() > 0) {
                int i = 0;
                while (i < this.overlap.size()) {
                    if (i > 0) {
                        res.append(prefix);
                    }
                    res.append("\t" + this.overlapF1.get(i) + "\t" + this.overlapInfo.get(i));
                    this.overlap.get(i).appendAttributes(res, attributesPredcition, attPredcition, threshold, false);
                    res.append("\n");
                    ++i;
                }
            } else {
                res.append("\tNA\n");
            }
        }

        public void appendAttributes(StringBuffer res, HashMap<String, int[]> attributes, ArrayList<String> att, double threshold, boolean rel) {
            res.append("\t" + this.id + (rel ? "\t" + this.reliable : "") + "\t" + this.min + "\t" + this.max);
            double all = attributes.get(Analyzer.ALL)[0];
            int i = 0;
            while (i < att.size()) {
                String key = att.get(i);
                if ((double)attributes.get(key)[1] / all > threshold) {
                    String info = this.hash == null ? null : this.hash.get(key);
                    res.append("\t" + (info == null ? "" : info));
                }
                ++i;
            }
        }

        @Override
        public int compareTo(Transcript t) {
            int d = Integer.compare(this.min, t.min);
            if (d == 0 && (d = Integer.compare(this.max, t.max)) == 0) {
                d = this.id.compareTo(t.id);
            }
            return d;
        }

        public boolean isComplete(boolean onlyIntrons) {
            return onlyIntrons ? this.bestOI : this.bestF1() == 1.0;
        }
    }

    public static class TranscriptComparator
    implements Comparator<Transcript> {
        public static final TranscriptComparator SINGLETON = new TranscriptComparator();

        @Override
        public int compare(Transcript a, Transcript b) {
            int diff = a.parts.size() - b.parts.size();
            if (diff == 0) {
                int i = 0;
                while (i < a.parts.size() && (diff = GeMoMa.IntArrayComparator.comparator[0].compare(a.parts.get(i), b.parts.get(i))) == 0) {
                    ++i;
                }
            }
            return diff;
        }
    }

    public static class TranscriptIntronComparator
    implements Comparator<Transcript> {
        public static final TranscriptIntronComparator SINGLETON = new TranscriptIntronComparator();

        @Override
        public int compare(Transcript a, Transcript b) {
            int diff = a.parts.size() - b.parts.size();
            if (diff == 0 && a.parts.size() > 1 && (diff = a.parts.get(0)[1] - b.parts.get(0)[1]) == 0) {
                int i = 1;
                int n = a.parts.size() - 1;
                while (i < n && (diff = GeMoMa.IntArrayComparator.comparator[0].compare(a.parts.get(i), b.parts.get(i))) == 0) {
                    ++i;
                }
                if (diff == 0) {
                    diff = a.parts.get(i)[0] - b.parts.get(i)[0];
                }
            }
            return diff;
        }
    }

    static class TranscriptNameComparator
    implements Comparator<Transcript> {
        public static final TranscriptNameComparator SINGLETON = new TranscriptNameComparator();

        TranscriptNameComparator() {
        }

        @Override
        public int compare(Transcript a, Transcript b) {
            return a.id.compareTo(b.id);
        }
    }
}

