/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma;

import de.jstacs.DataType;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import projects.gemoma.GeMoMa;
import projects.gemoma.GeMoMaModule;
import projects.gemoma.Tools;

public class CheckIntrons
extends GeMoMaModule {
    @Override
    public ToolParameterSet getToolParameters() {
        try {
            return new ToolParameterSet(this.getShortName(), new FileParameter("target genome", "The target genome file (FASTA), i.e., the target sequences in the blast run. Should be in IUPAC code", "fasta", true), new ParameterSetContainer("introns", "", new ExpandableParameterSet(new SimpleParameterSet(new FileParameter("introns", "Introns (GFF), which might be obtained from RNA-seq", "gff", true)), "introns", "", 1)), new SimpleParameter(DataType.BOOLEAN, "verbose", "A flag which allows to output a wealth of additional information per transcript", true, false));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads, String temp) throws Exception {
        boolean verbose = (Boolean)parameters.getParameterForName("verbose").getValue();
        String targetGenome = (String)parameters.getParameterForName("target genome").getValue();
        int reads = 1;
        ExpandableParameterSet introns = (ExpandableParameterSet)((ParameterSetContainer)parameters.getParameterAt(1)).getValue();
        HashMap<String, String> seqs = Tools.getFasta(targetGenome, 20, ".*");
        ArrayList<String> fName = new ArrayList<String>();
        int i = 0;
        while (i < introns.getNumberOfParameters()) {
            Parameter y = ((ParameterSet)introns.getParameterAt(i).getValue()).getParameterAt(0);
            if (y.isSet()) {
                fName.add(y.getValue().toString());
            }
            ++i;
        }
        if (fName.size() > 0) {
            HashMap<String, int[]> diNucl = new HashMap<String, int[]>();
            HashMap<String, int[][][]>[] res = GeMoMa.readIntrons(reads, protocol, verbose, seqs, diNucl, fName.toArray(new String[fName.size()]));
            Object[] keys = diNucl.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            int i2 = 0;
            while (i2 < keys.length) {
                int[] v = diNucl.get(keys[i2]);
                protocol.append(String.valueOf(keys[i2]) + "\t" + v[0] + "\t" + v[1] + "\n");
                ++i2;
            }
        }
        return null;
    }

    @Override
    public String getToolName() {
        return "CheckIntrons";
    }

    @Override
    public String getShortName() {
        return this.getToolName();
    }

    @Override
    public String getDescription() {
        return "creates statistics for introns";
    }

    @Override
    public String getHelpText() {
        return "The tool checks the distribution of introns on the strands and the dinucleotide distribution at splice sites." + MORE;
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }
}

