/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma;

import de.jstacs.tools.Protocol;
import de.jstacs.tools.ui.cli.CLI;
import de.jstacs.utils.IntList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

public class CombineIntronFiles {
    public static void main(String[] args) throws IOException {
        String[] in = new String[args.length - 1];
        System.arraycopy(args, 1, in, 0, in.length);
        CombineIntronFiles.combine(new CLI.SysProtocol(), new File(args[0]), in);
    }

    public static void combine(Protocol protocol, File out, String ... in) throws IOException {
        int[] stat;
        String line;
        protocol.append("files: " + in.length + "\n");
        BufferedWriter w = new BufferedWriter(new FileWriter(out));
        BufferedReader[] r = new BufferedReader[in.length];
        Intron[] intron = new Intron[in.length];
        int i = 0;
        while (i < in.length) {
            protocol.append(String.valueOf(i) + "\t" + in[i] + "\n");
            r[i] = new BufferedReader(new FileReader(in[i]));
            while ((line = r[i].readLine()) != null && line.charAt(0) == '#') {
                if (i != 0) continue;
                w.append(line);
                w.newLine();
            }
            if (line != null) {
                intron[i] = new Intron(line);
            }
            ++i;
        }
        HashMap<Integer, int[]> intronL = new HashMap<Integer, int[]>();
        long anz = 0L;
        IntList same = new IntList();
        do {
            same.clear();
            int a = 0;
            int i2 = 0;
            while (i2 < in.length) {
                if (intron[i2] != null) {
                    if (same.length() == 0) {
                        same.add(i2);
                    } else {
                        int comp = intron[same.get(0)].compareTo(intron[i2]);
                        if (comp >= 0) {
                            if (comp > 0) {
                                same.clear();
                            }
                            same.add(i2);
                        }
                    }
                    ++a;
                }
                ++i2;
            }
            if (same.length() <= 0) continue;
            Intron rep = intron[same.get(0)];
            String[] split = rep.split;
            int l = rep.end - rep.start;
            stat = (int[])intronL.get(l);
            if (stat == null) {
                stat = new int[1];
                intronL.put(l, stat);
            }
            stat[0] = stat[0] + 1;
            ++anz;
            int sum = 0;
            int j = 0;
            while (j < same.length()) {
                int i3 = same.get(j);
                sum += Integer.parseInt(intron[i3].split[5]);
                line = r[i3].readLine();
                intron[i3] = line != null ? new Intron(line) : null;
                ++j;
            }
            split[5] = "" + sum;
            j = 0;
            while (j < split.length) {
                w.write(String.valueOf(j == 0 ? "" : "\t") + split[j]);
                ++j;
            }
            w.newLine();
        } while (same.length() > 0);
        w.close();
        protocol.append("\n");
        Object[] il = new Integer[intronL.size()];
        intronL.keySet().toArray(il);
        Arrays.sort(il);
        double all = 0.0;
        int j = 0;
        while (j < il.length) {
            stat = (int[])intronL.get(il[j]);
            protocol.append(il[j] + "\t" + stat[0] + "\t" + (all += (double)stat[0]) / (double)anz + "\n");
            ++j;
        }
    }

    static class Intron
    implements Comparable<Intron> {
        String[] split;
        int start;
        int end;

        Intron(String line) {
            this.split = line.split("\t");
            this.start = Integer.parseInt(this.split[3]);
            this.end = Integer.parseInt(this.split[4]);
        }

        @Override
        public int compareTo(Intron o) {
            int diff = this.split[0].compareTo(o.split[0]);
            if (diff == 0 && (diff = this.split[6].compareTo(o.split[6])) == 0 && (diff = Integer.compare(this.start, o.start)) == 0) {
                diff = Integer.compare(this.end, o.end);
            }
            return diff;
        }
    }
}

