/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma;

import de.jstacs.DataType;
import de.jstacs.io.FileManager;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.RegExFilenameFilter;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.AbstractSelectionParameter;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.FileExistsValidator;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.parameters.validation.RegExpValidator;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import de.jstacs.tools.ui.cli.CLI;
import de.jstacs.tools.ui.galaxy.Galaxy;
import de.jstacs.utils.Time;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import projects.FastaSplitter;
import projects.gemoma.AnnotationEvidence;
import projects.gemoma.AnnotationFinalizer;
import projects.gemoma.DenoiseIntrons;
import projects.gemoma.ExtractRNAseqEvidence;
import projects.gemoma.Extractor;
import projects.gemoma.GeMoMa;
import projects.gemoma.GeMoMaAnnotationFilter;
import projects.gemoma.GeMoMaModule;
import projects.gemoma.SyntenyChecker;
import projects.gemoma.Tools;

public class GeMoMaPipeline
extends GeMoMaModule {
    static int maxSize;
    static long timeOut;
    static long maxTimeOut;
    String home;
    String target;
    int threads;
    int gapOpen;
    int gapExt;
    double eValue;
    boolean rnaSeq;
    boolean stop;
    boolean all;
    GeMoMaPipelineParameterSet parameters;
    GeMoMaPipelineParameterSet oldParameters = null;
    ToolParameterSet denoiseParams;
    ToolParameterSet extractorParams;
    ToolParameterSet gemomaParams;
    ToolParameterSet gafParams;
    ToolParameterSet afParams;
    ToolParameterSet aePars;
    ExecutorService queue;
    ExecutorCompletionService ecs;
    ArrayList<String> speciesName;
    ArrayList<Species> species;
    int speciesCounter;
    RNASeq rnaSeqData;
    ArrayList<Process> process;
    ArrayList<FlaggedRunnable> list;
    HashMap<String, String> selected;
    StringBuffer[] timeOutWarning;
    Time t;
    private static String buscoPath;
    private static FilenameFilter dirFilter;
    ArrayList<Result> res;
    Protocol pipelineProtocol;
    int phase;
    Thread killer;
    static String mmseqs;
    static String search_path;
    Warning[] w = new Warning[]{new Warning("Warning: [tblastn] .*: Warning: Could not calculate ungapped Karlin-Altschul parameters due to an invalid query sequence or its translation. Please verify the query sequence(s) and/or filtering options ")};
    Matcher[] m;
    static final int WARNING_THRESHOLD = 3;
    boolean[] compute;
    int finished;
    Throwable tr;
    static final String OPTIONAL = "<OPTIONAL>";

    static {
        try {
            File jarfile = new File(Galaxy.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            File ini = new File(String.valueOf(jarfile.getParentFile().getAbsolutePath()) + File.separator + "GeMoMa.ini.xml");
            StringBuffer xml = FileManager.readFile(ini);
            maxSize = XMLParser.extractObjectForTags(xml, "maxSize", Integer.class);
            timeOut = XMLParser.extractObjectForTags(xml, "timeOut", Long.class);
            maxTimeOut = XMLParser.extractObjectForTags(xml, "maxTimeOut", Long.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            maxSize = -1;
            timeOut = 3600L;
            maxTimeOut = 604800L;
        }
        buscoPath = "BUSCO-references" + File.separator;
        dirFilter = new RegExFilenameFilter("", RegExFilenameFilter.Directory.REQUIRED, true, ".*");
    }

    public ParameterSet getRelevantParameters(ParameterSet params, String ... remove) {
        HashSet<String> removeNames = new HashSet<String>();
        String[] stringArray = remove;
        int n = remove.length;
        int n2 = 0;
        while (n2 < n) {
            String r = stringArray[n2];
            removeNames.add(r);
            ++n2;
        }
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        int i = 0;
        while (i < params.getNumberOfParameters()) {
            Parameter p = params.getParameterAt(i);
            if (!removeNames.contains(p.getName())) {
                if (p instanceof SelectionParameter) {
                    SelectionParameter sel = (SelectionParameter)p;
                    int selected = sel.getSelected();
                    ParameterSet ps = sel.getParametersInCollection();
                    try {
                        int j = 0;
                        while (j < ps.getNumberOfParameters()) {
                            Parameter q = ps.getParameterAt(j);
                            if (q instanceof ParameterSetContainer) {
                                ParameterSetContainer psc = (ParameterSetContainer)q;
                                psc.setValue(this.getRelevantParameters(psc.getValue(), remove));
                                sel.setValue(q);
                            }
                            ++j;
                        }
                        sel.setValue(ps.getParameterAt(selected).getName());
                    }
                    catch (SimpleParameter.IllegalValueException e) {
                        System.out.println(p.getName());
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
                list.add(p);
            }
            ++i;
        }
        if (params instanceof ToolParameterSet) {
            ToolParameterSet tps = (ToolParameterSet)params;
            return new ToolParameterSet(tps.getToolName(), list.toArray(new Parameter[0]));
        }
        return new SimpleParameterSet(list.toArray(new Parameter[0]));
    }

    @Override
    public GeMoMaPipelineParameterSet getToolParameters() {
        ParameterSet ere = this.getRelevantParameters(new ExtractRNAseqEvidence().getToolParameters(), "target genome");
        ParameterSet denoise = this.getRelevantParameters(new DenoiseIntrons().getToolParameters(), "introns", "coverage");
        ParameterSet ex = this.getRelevantParameters(new Extractor(maxSize).getToolParameters(), "annotation", "genome", "selected", "verbose", "genetic code", "long fasta comment", Extractor.name[2], Extractor.name[3], Extractor.name[4], Extractor.name[5], Extractor.name[6]);
        ParameterSet gem = this.getRelevantParameters(new GeMoMa(maxSize, timeOut, maxTimeOut).getToolParameters(), "search results", "target genome", "cds parts", "assignment", "selected", "genetic code", "tag", "coverage", "introns", "sort", "prefix");
        ParameterSet gaf = this.getRelevantParameters(new GeMoMaAnnotationFilter().getToolParameters(), "predicted annotation", "tag", "intermediate result");
        ParameterSet af = this.getRelevantParameters(new AnnotationFinalizer().getToolParameters(), "genome", "annotation", "tag", "introns", "reads", "coverage");
        try {
            ex.getParameterForName("Ambiguity").setDefault((Object)Tools.Ambiguity.AMBIGUOUS);
            gem.getParameterForName(GeMoMa.Score.class.getSimpleName()).setDefault((Object)GeMoMa.Score.ReAlign);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("own");
        keys.add("pre-extracted");
        try {
            ArrayList<SimpleParameterSet> values = new ArrayList<SimpleParameterSet>();
            values.add(new SimpleParameterSet(new SimpleParameter(DataType.STRING, "ID", "ID to distinguish the different reference species", false, new RegExpValidator("\\w*")), new FileParameter("annotation", "Reference annotation file (GFF or GTF), which contains gene models annotated in the reference genome", "gff,gff3,gtf,gff.gz,gff3.gz,gtf.gz", true, new FileExistsValidator(), true), new FileParameter("genome", "Reference genome file (FASTA)", "fasta,fa,fas,fna,fasta.gz,fa.gz,fas.gz,fna.gz", true, new FileExistsValidator(), true), new SimpleParameter(DataType.DOUBLE, "weight", "the weight can be used to prioritize predictions from different input files; each prediction will get an additional attribute sumWeight that can be used in the filter", false, new NumberValidator<Double>(0.0, 1000.0), 1.0), new FileParameter("annotation info", "annotation information of the reference, tab-delimted file containing at least the columns transcriptName, GO and .*defline", "tabular", false, new FileExistsValidator())));
            values.add(new SimpleParameterSet(new SimpleParameter(DataType.STRING, "ID", "ID to distinguish the different reference species", false, new RegExpValidator("\\w*")), new FileParameter("cds parts", "The query CDS parts file (protein FASTA), i.e., the CDS parts that have been searched in the target genome using for instance BLAST or mmseqs", "fasta,fa,fas,fna", true, new FileExistsValidator(), true), new FileParameter("assignment", "The assignment file, which combines CDS parts to proteins", "tabular", false, new FileExistsValidator()), new SimpleParameter(DataType.DOUBLE, "weight", "the weight can be used to prioritize predictions from different input files; each prediction will get an additional attribute sumWeight that can be used in the filter", false, new NumberValidator<Double>(0.0, 1000.0), 1.0), new FileParameter("annotation info", "annotation information of the reference, tab-delimited file containing at least the columns transcriptName, GO and .*defline", "tabular", false, new FileExistsValidator())));
            return new GeMoMaPipelineParameterSet(this.getShortName(), new FileParameter("target genome", "Target genome file (FASTA)", "fasta,fa,fas,fna,fasta.gz,fa.gz,fas.gz,fna.gz", true, new FileExistsValidator(), true), new ParameterSetContainer("reference species", "", new ExpandableParameterSet(new SimpleParameterSet(new SelectionParameter(DataType.PARAMETERSET, keys.toArray(new String[0]), values.toArray(new SimpleParameterSet[0]), "species", "data for reference species", true)), "reference", "", 0)), new ParameterSetContainer("external annotations", "", new ExpandableParameterSet(new SimpleParameterSet(new SimpleParameter(DataType.STRING, "ID", "ID to distinguish the different external annotations of the target organism", false, new RegExpValidator("\\w+")), new FileParameter("external annotation", "External annotation file (GFF,GTF) of the target organism, which contains gene models from an external source (e.g., ab initio gene prediction) and will be integrated in the module GAF", "gff,gff3,gtf", true, new FileExistsValidator(), true), new SimpleParameter(DataType.DOUBLE, "weight", "the weight can be used to prioritize predictions from different input files in the module GAF; each prediction will get an additional attribute sumWeight that can be used in the filter", false, new NumberValidator<Double>(0.0, 1000.0), 1.0), new SimpleParameter(DataType.BOOLEAN, "annotation evidence", "run AnnotationEvidence on this external annotation", true, true)), "external", "", 0)), new FileParameter("selected", "The path to list file, which allows to make only a predictions for the contained transcript ids. The first column should contain transcript IDs as given in the annotation. Remaining columns can be used to determine a target region that should be overlapped by the prediction, if columns 2 to 5 contain chromosome, strand, start and end of region", "tabular,txt", maxSize > -1, new FileExistsValidator()), new FileParameter("genetic code", "optional user-specified genetic code", "tabular", false, new FileExistsValidator()), new SimpleParameter(DataType.BOOLEAN, "tblastn", "if *true* tblastn is used as search algorithm, otherwise mmseqs is used. Tblastn and mmseqs need to be installed to use the corresponding option", true, false), new SimpleParameter(DataType.STRING, "tag", "A user-specified tag for transcript predictions in the third column of the returned gff. It might be beneficial to set this to a specific value for some genome browsers.", true, "mRNA"), new SelectionParameter(DataType.PARAMETERSET, new String[]{"NO", "MAPPED", "EXTRACTED"}, new Object[]{new SimpleParameterSet(new Parameter[0]), ere, new SimpleParameterSet(new ParameterSetContainer("introns", "", new ExpandableParameterSet(new SimpleParameterSet(new FileParameter("introns", "Introns (GFF), which might be obtained from RNA-seq", "gff,gff3", true, new FileExistsValidator(), true)), "introns", "", 1)), new ParameterSetContainer("coverage", "", new ExpandableParameterSet(new SimpleParameterSet(new SelectionParameter(DataType.PARAMETERSET, new String[]{"UNSTRANDED", "STRANDED"}, new Object[]{new SimpleParameterSet(new FileParameter("coverage_unstranded", "The coverage file contains the unstranded coverage of the genome per interval. Intervals with coverage 0 (zero) can be left out.", "bedgraph", true, new FileExistsValidator())), new SimpleParameterSet(new FileParameter("coverage_forward", "The coverage file contains the forward coverage of the genome per interval. Intervals with coverage 0 (zero) can be left out.", "bedgraph", true, new FileExistsValidator()), new FileParameter("coverage_reverse", "The coverage file contains the reverse coverage of the genome per interval. Intervals with coverage 0 (zero) can be left out.", "bedgraph", true, new FileExistsValidator()))}, "coverage", "experimental coverage (RNA-seq)", true)), "coverage", "", 0)))}, "RNA-seq evidence", "data for RNA-seq evidence", true), new SelectionParameter(DataType.PARAMETERSET, new String[]{"DENOISE", "RAW"}, new Object[]{denoise, new SimpleParameterSet(new Parameter[0])}, "denoise", "removing questionable introns that have been extracted by ERE", true), new ParameterSetContainer("Extractor parameter set", "parameters for the Extrator module of GeMoMa", ex), new ParameterSetContainer("GeMoMa parameter set", "parameters for the GeMoMa", gem), new ParameterSetContainer("GAF parameter set", "parameters for the GAF module of GeMoMa", gaf), new ParameterSetContainer("AnnotationFinalizer parameter set", "parameters for the AnnotationFinalizer module of GeMoMa", af), new SimpleParameter(DataType.BOOLEAN, "synteny check", "run SyntenyChecker if possible", true, true), new SimpleParameter(DataType.BOOLEAN, "predicted proteins", "If *true*, returns the predicted proteins of the target organism as fastA file", true, true), new SimpleParameter(DataType.BOOLEAN, "predicted CDSs", "If *true*, returns the predicted CDSs of the target organism as fastA file", true, false), new SimpleParameter(DataType.BOOLEAN, "predicted genomic regions", "If *true*, returns the genomic regions of predicted gene models of the target organism as fastA file", true, false), new SimpleParameter(DataType.BOOLEAN, "output individual predictions", "If *true*, returns the predictions for each reference species", true, false), new SimpleParameter(DataType.BOOLEAN, "debug", "If *false* removes all temporary files even if the jobs exits unexpected", true, true), new SimpleParameter(DataType.BOOLEAN, "restart", "can be used to restart the latest GeMoMaPipeline run, which was finished without results, with very similar parameters, e.g., after an exception was thrown (cf. parameter debug)", true, false), new SimpleParameter(DataType.STRING, "BLAST_PATH", "allows to set a path to the blast binaries if not set in the environment", false, ""), new SimpleParameter(DataType.STRING, "MMSEQS_PATH", "allows to set a path to the blast binaries if not set in the environment", false, ""));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    static void setParameters(ParameterSet given, ParameterSet toBeSet) throws SimpleParameter.IllegalValueException, CloneNotSupportedException {
        if (given instanceof ExpandableParameterSet) {
            int n = ((ExpandableParameterSet)given).getNumberOfParameters();
            ExpandableParameterSet eTBS = (ExpandableParameterSet)toBeSet;
            while (eTBS.getNumberOfParameters() < n) {
                eTBS.addParameterToSet();
            }
        }
        int i = 0;
        while (i < given.getNumberOfParameters()) {
            Parameter p = given.getParameterAt(i);
            Parameter q = toBeSet.getParameterForName(p.getName());
            if (q == null) {
                System.err.println("WARNING: Cannot set paremeter " + p.getName());
            } else if (p instanceof ParameterSetContainer) {
                GeMoMaPipeline.setParameters(((ParameterSetContainer)p).getValue(), ((ParameterSetContainer)q).getValue());
            } else if (p instanceof FileParameter) {
                if (p.getValue() != null) {
                    q.setValue(((FileParameter)p).getFileContents());
                } else {
                    q.reset();
                }
            } else if (p instanceof AbstractSelectionParameter && ((AbstractSelectionParameter)p).getDatatype() == DataType.PARAMETERSET) {
                AbstractSelectionParameter a = (AbstractSelectionParameter)p;
                ParameterSet ps = (ParameterSet)a.getValue();
                AbstractSelectionParameter b = (AbstractSelectionParameter)q;
                if (b != null) {
                    if (b instanceof SelectionParameter) {
                        int idx = ((SelectionParameter)a).getSelected();
                        b.setValue(((SelectionParameter)b).getParametersInCollection().getParameterAt(idx));
                    }
                    GeMoMaPipeline.setParameters(ps, (ParameterSet)b.getValue());
                }
            } else {
                q.setValue(p.getValue());
            }
            ++i;
        }
    }

    void setRNASeqParams(ToolParameterSet p) throws SimpleParameter.IllegalValueException, CloneNotSupportedException {
        SelectionParameter sel;
        ExpandableParameterSet exp = (ExpandableParameterSet)((ParameterSetContainer)p.getParameterForName("introns")).getValue();
        int i = 0;
        while (i < this.rnaSeqData.introns.size()) {
            String current;
            if (exp.getNumberOfParameters() <= i) {
                exp.addParameterToSet();
            }
            if ((current = this.rnaSeqData.introns.get(i)) != null) {
                ((ParameterSetContainer)exp.getParameterAt(i)).getValue().getParameterAt(0).setValue(current);
            }
            ++i;
        }
        exp = (ExpandableParameterSet)((ParameterSetContainer)p.getParameterForName("coverage")).getValue();
        i = 0;
        int j = 0;
        while (j < this.rnaSeqData.coverageUn.size()) {
            if (exp.getNumberOfParameters() <= i) {
                exp.addParameterToSet();
            }
            sel = (SelectionParameter)((SimpleParameterSet)exp.getParameterAt(i).getValue()).getParameterAt(0);
            sel.setValue("UNSTRANDED");
            ((SimpleParameterSet)sel.getValue()).getParameterAt(0).setValue(this.rnaSeqData.coverageUn.get(j));
            ++j;
            ++i;
        }
        j = 0;
        while (j < this.rnaSeqData.coverageFwd.size()) {
            if (exp.getNumberOfParameters() <= i) {
                exp.addParameterToSet();
            }
            sel = (SelectionParameter)((SimpleParameterSet)exp.getParameterAt(i).getValue()).getParameterAt(0);
            sel.setValue("STRANDED");
            ((SimpleParameterSet)sel.getValue()).getParameterAt(0).setValue(this.rnaSeqData.coverageFwd.get(j));
            ((SimpleParameterSet)sel.getValue()).getParameterAt(1).setValue(this.rnaSeqData.coverageRC.get(j));
            ++j;
            ++i;
        }
    }

    private void addNewPhase() {
        String s = "starting phase " + ++this.phase + " (" + this.t.getElapsedTime() + "s)";
        int l = s.length();
        s = String.valueOf(s) + "\n";
        int i = 0;
        while (i < l) {
            s = String.valueOf(s) + "=";
            ++i;
        }
        this.pipelineProtocol.append("\n" + s + "\n");
    }

    private static void setParameters(ParameterSet global, String key, ToolParameterSet ... local) throws SimpleParameter.IllegalValueException {
        Object o = global.getParameterForName(key).getValue();
        if (o != null) {
            int i = 0;
            while (i < local.length) {
                if (local[i] != null) {
                    local[i].getParameterForName(key).setValue(o);
                }
                ++i;
            }
        }
    }

    private static boolean equals(ParameterSet original, ParameterSet other, String ... keys) {
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            boolean res;
            String key = stringArray[n2];
            Object o1 = original.getParameterForName(key).getValue();
            Object o2 = other.getParameterForName(key).getValue();
            boolean bl = res = o1 == null && o2 == null;
            if (!res) {
                if (!o1.getClass().getName().equals(o2.getClass().getName())) {
                    return false;
                }
                if (o1 instanceof ParameterSet || o1 instanceof ParameterSetContainer) {
                    ParameterSet p2;
                    ParameterSet p1;
                    if (o1 instanceof ParameterSet) {
                        p1 = (ParameterSet)o1;
                        p2 = (ParameterSet)o2;
                    } else {
                        p1 = ((ParameterSetContainer)o1).getValue();
                        p2 = ((ParameterSetContainer)o2).getValue();
                    }
                    if (p1.getNumberOfParameters() != p2.getNumberOfParameters()) {
                        return false;
                    }
                    res = GeMoMaPipeline.equals(p1, p2, p1.getAllParameterNames());
                } else {
                    res = o1.equals(o2);
                }
            }
            if (!res) {
                return res;
            }
            ++n2;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCompute(String info, ParameterSet p1, ParameterSet p2, String ... keys) {
        boolean[] blArray = this.compute;
        synchronized (this.compute) {
            boolean e;
            if (!this.compute[0] && !(e = GeMoMaPipeline.equals(p1, p2, keys))) {
                this.pipelineProtocol.append("Set compute=true (" + info + ")\n");
                this.compute[0] = true;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    private void updateComputeBySubset(String key) {
        if (this.oldParameters != null) {
            ParameterSet current = ((ParameterSetContainer)this.parameters.getParameterForName(key)).getValue();
            this.updateCompute(key, current, ((ParameterSetContainer)this.oldParameters.getParameterForName(key)).getValue(), current.getAllParameterNames());
        }
    }

    private void prepare(String temp) throws IOException {
        File dir = Files.createTempDirectory(new File(temp).toPath(), "GeMoMaPipeline-", new FileAttribute[0]).toFile();
        dir.mkdirs();
        this.home = String.valueOf(dir.toString()) + File.separator;
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.parameters, "PipelineParameters");
        XMLParser.appendObjectWithTags(xml, this.threads, "threads");
        XMLParser.appendObjectWithTags(xml, this.getToolVersion(), "version");
        FileManager.writeFile(String.valueOf(this.home) + "parameters.xml", (CharSequence)xml);
        this.pipelineProtocol.append("run new GeMoMaPipeline job\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ToolResult run(ToolParameterSet pars, Protocol protocol, ProgressUpdater progress, int threads, String temp) throws Exception {
        block96: {
            block95: {
                block93: {
                    block94: {
                        block92: {
                            block87: {
                                this.speciesCounter = 0;
                                this.finished = 0;
                                this.phase = 0;
                                this.parameters = (GeMoMaPipelineParameterSet)pars;
                                this.threads = threads;
                                this.queue = Executors.newFixedThreadPool(threads);
                                this.ecs = new ExecutorCompletionService<V>(this.queue);
                                this.process = new ArrayList<E>();
                                this.list = new ArrayList<E>();
                                this.killer = new Thread(){

                                    @Override
                                    public void run() {
                                        GeMoMaPipeline.this.queue.shutdown();
                                        try {
                                            if (!GeMoMaPipeline.this.queue.awaitTermination(10L, TimeUnit.MILLISECONDS)) {
                                                GeMoMaPipeline.this.queue.shutdownNow();
                                            }
                                        }
                                        catch (InterruptedException e) {
                                            e.printStackTrace();
                                        }
                                        int i = 0;
                                        while (i < GeMoMaPipeline.this.process.size()) {
                                            Process p = GeMoMaPipeline.this.process.get(i);
                                            if (p.isAlive()) {
                                                p.destroyForcibly();
                                            }
                                            ++i;
                                        }
                                    }
                                };
                                Runtime.getRuntime().addShutdownHook(this.killer);
                                gemoma = null;
                                ae = null;
                                this.res = new ArrayList<E>();
                                this.pipelineProtocol = protocol;
                                this.t = Time.getTimeInstance(null);
                                usedSpec = -1;
                                try {
                                    block90: {
                                        Thread.sleep(1000L);
                                        restart = this.parameters.getParameterForName("restart");
                                        this.compute = new boolean[1];
                                        v0 = this.compute[0] = restart == null || (Boolean)restart.getValue() == false;
                                        if (this.compute[0]) break block90;
                                        this.pipelineProtocol.append("Re-start broken GeMoMaPipeline job\n");
                                        broken = new File(temp).listFiles(new RegExFilenameFilter("folder", RegExFilenameFilter.Directory.REQUIRED, true, new String[]{"GeMoMaPipeline-.*"}));
                                        if (broken == null || broken.length == 0) {
                                            this.pipelineProtocol.append("There is no broken GeMoMaPipeline job in " + temp + "\n");
                                            System.exit(0);
                                        }
                                        idx = 0;
                                        latest = broken[0].lastModified();
                                        if (broken.length <= 1) break block87;
                                        this.pipelineProtocol.append("There are " + broken.length + " broken GeMoMaPipeline runs.\n");
                                        i = 1;
                                        if (true) ** GOTO lbl149
                                    }
                                    this.prepare(temp);
lbl37:
                                    // 4 sources

                                    while (true) {
                                        this.all = (Boolean)this.parameters.getParameterForName("output individual predictions").getValue();
                                        this.stop = false;
                                        os = System.getProperty("os.name");
                                        GeMoMaPipeline.mmseqs = os.startsWith("Windows") != false ? "mmseqs.bat" : "mmseqs";
                                        this.pipelineProtocol.append("Running the GeMoMaPipeline with " + threads + " threads\n\n");
                                        blast = (Boolean)this.parameters.getParameterForName("tblastn").getValue();
                                        GeMoMaPipeline.search_path = (String)this.parameters.getParameterForName(blast != false ? "BLAST_PATH" : "MMSEQS_PATH").getValue();
                                        if (GeMoMaPipeline.search_path.length() > 0 && GeMoMaPipeline.search_path.charAt(GeMoMaPipeline.search_path.length() - 1) != File.separatorChar) {
                                            GeMoMaPipeline.search_path = String.valueOf(GeMoMaPipeline.search_path) + File.separator;
                                        }
                                        cmd = blast != false ? new String[][]{{String.valueOf(GeMoMaPipeline.search_path) + "tblastn", "-version"}, {String.valueOf(GeMoMaPipeline.search_path) + "makeblastdb", "-version"}} : new String[][]{{String.valueOf(GeMoMaPipeline.search_path) + GeMoMaPipeline.mmseqs, "version"}};
                                        this.pipelineProtocol.append("search algorithm:\n");
                                        i = 0;
lbl50:
                                        // 2 sources

                                        while (true) {
                                            block88: {
                                                if (i >= cmd.length) {
                                                    this.target = this.parameters.getParameterForName("target genome").getValue().toString();
                                                    denoise = new DenoiseIntrons();
                                                    extractor = new Extractor(GeMoMaPipeline.maxSize);
                                                    gemoma = new GeMoMa(GeMoMaPipeline.maxSize, GeMoMaPipeline.timeOut, GeMoMaPipeline.maxTimeOut);
                                                }
                                                pb = new ProcessBuilder(cmd[i]);
                                                pb.redirectErrorStream(true);
                                                pr = pb.start();
                                                br = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                                                line = null;
                                                if (true) ** GOTO lbl174
                                                pa = (ParameterSet)this.parameters.getParameterForName("RNA-seq evidence").getValue();
                                                this.rnaSeq = pa.getNumberOfParameters() > 0;
                                                dps = (ParameterSet)this.parameters.getParameterForName("denoise").getValue();
                                                if (this.rnaSeq && dps.getNumberOfParameters() > 0) {
                                                    this.denoiseParams = denoise.getToolParameters();
                                                    GeMoMaPipeline.setParameters(dps, this.denoiseParams);
                                                } else {
                                                    this.denoiseParams = null;
                                                }
                                                this.extractorParams = extractor.getToolParameters();
                                                GeMoMaPipeline.setParameters(((ParameterSetContainer)this.parameters.getParameterForName("Extractor parameter set")).getValue(), this.extractorParams);
                                                this.gafParams = new GeMoMaAnnotationFilter().getToolParameters();
                                                GeMoMaPipeline.setParameters(((ParameterSetContainer)this.parameters.getParameterForName("GAF parameter set")).getValue(), this.gafParams);
                                                this.gemomaParams = gemoma.getToolParameters();
                                                this.gemomaParams.getParameterForName("target genome").setValue(this.target);
                                                GeMoMaPipeline.setParameters(((ParameterSetContainer)this.parameters.getParameterForName("GeMoMa parameter set")).getValue(), this.gemomaParams);
                                                this.afParams = new AnnotationFinalizer().getToolParameters();
                                                this.afParams.getParameterForName("genome").setValue(this.target);
                                                ap = ((ParameterSetContainer)this.parameters.getParameterForName("AnnotationFinalizer parameter set")).getValue();
                                                GeMoMaPipeline.setParameters(ap, this.afParams);
                                                selP = (SelectionParameter)ap.getParameterForName("UTR");
                                                clear = this.rnaSeq != false && selP.getParametersInCollection().getParameterAt(selP.getSelected()).getName().equals("NO") != false;
                                                key = new String[]{"selected", "genetic code"};
                                                i = 0;
                                                while (true) {
                                                    if (i >= key.length) {
                                                        GeMoMaPipeline.setParameters(this.parameters, "tag", new ToolParameterSet[]{this.gemomaParams, this.gafParams, this.afParams});
                                                        this.selected = Tools.getSelection((String)this.parameters.getParameterForName(key[0]).getValue(), GeMoMaPipeline.maxSize, protocol);
                                                        this.eValue = (Double)this.gemomaParams.getParameterForName("e-value").getValue();
                                                        this.gapOpen = (Integer)this.gemomaParams.getParameterForName("gap opening").getValue();
                                                        this.gapExt = (Integer)this.gemomaParams.getParameterForName("gap extension").getValue();
                                                        this.addNewPhase();
                                                        ref = this.parameters.getExpandablePS("reference species");
                                                        sp = ref.getNumberOfParameters();
                                                        if (sp != 0) break;
                                                        this.pipelineProtocol.append("No reference species given. Hence, no homology-based gene prediction will be made with GeMoMa.\n");
                                                        break block88;
                                                    }
                                                    GeMoMaPipeline.setParameters(this.parameters, key[i], new ToolParameterSet[]{this.extractorParams, this.gemomaParams});
                                                    ++i;
                                                }
                                                if (blast) {
                                                    this.add(new JMakeBlastDB());
                                                } else {
                                                    this.add(new JMmseqsCreateDB());
                                                }
                                            }
                                            this.species = new ArrayList<E>();
                                            this.speciesName = new ArrayList<E>();
                                            this.updateComputeBySubset("Extractor parameter set");
                                            s = 0;
                                            while (true) {
                                                block91: {
                                                    if (s < sp) break block91;
                                                    this.timeOutWarning = new StringBuffer[this.species.size()];
                                                    i = 0;
                                                    if (true) ** GOTO lbl186
                                                }
                                                sel = (SelectionParameter)((ParameterSetContainer)ref.getParameterAt(s)).getValue().getParameterAt(0);
                                                currentRef = (SimpleParameterSet)sel.getValue();
                                                switch (currentRef.getNumberOfParameters()) {
                                                    case 1: {
                                                        path = String.valueOf(GeMoMaPipeline.buscoPath) + currentRef.getParameterAt(0).getValue() + "/";
                                                        clade = new File(path);
                                                        speciesDirs = clade.list(GeMoMaPipeline.dirFilter);
                                                        i = 0;
                                                        while (i < speciesDirs.length) {
                                                            this.add(new JExtractorAndSplit(speciesDirs[i], null, String.valueOf(path) + speciesDirs[i] + File.separator + Extractor.name[0] + "." + Extractor.type[0], String.valueOf(path) + speciesDirs[i] + File.separator + Extractor.name[1] + "." + Extractor.type[1], blast, null));
                                                            ++i;
                                                        }
                                                        break;
                                                    }
                                                    case 5: {
                                                        if (currentRef.getParameterForName("annotation") != null) {
                                                            this.add(new JExtractorAndSplit((String)currentRef.getParameterForName("ID").getValue(), (Double)currentRef.getParameterForName("weight").getValue(), currentRef.getParameterForName("annotation").getValue().toString(), currentRef.getParameterForName("genome").getValue().toString(), (String)currentRef.getParameterForName("annotation info").getValue(), blast));
                                                            break;
                                                        }
                                                        this.add(new JExtractorAndSplit((String)currentRef.getParameterForName("ID").getValue(), (Double)currentRef.getParameterForName("weight").getValue(), currentRef.getParameterForName("cds parts").getValue().toString(), (String)currentRef.getParameterForName("assignment").getValue(), blast, (String)currentRef.getParameterForName("annotation info").getValue()));
                                                        break;
                                                    }
                                                    default: {
                                                        throw new UnsupportedOperationException();
                                                    }
                                                }
                                                ++s;
                                            }
                                            break;
                                        }
                                        break;
                                    }
                                }
                                catch (Exception e) {
                                    Thread.sleep(1000L);
                                    this.tr = e;
                                    break block89;
                                }
                                do {
                                    if (latest < (last = broken[i].lastModified())) {
                                        idx = i;
                                        latest = last;
                                    }
                                    ++i;
lbl149:
                                    // 2 sources

                                } while (i < broken.length);
                            }
                            this.home = String.valueOf(broken[idx].getAbsolutePath()) + File.separator;
                            this.pipelineProtocol.append("Try to re-run " + this.home + "\n");
                            xml = FileManager.readFile(String.valueOf(this.home) + "parameters.xml");
                            try {
                                version = (String)XMLParser.extractObjectForTags(xml, "version");
                            }
                            catch (NonParsableException npe) {
                                version = "NA";
                            }
                            if (!version.equals(this.getToolVersion())) {
                                throw new RuntimeException("Restarting not possible. The tool versions differ (" + version + " vs. " + this.getToolVersion() + ").");
                            }
                            this.oldParameters = (GeMoMaPipelineParameterSet)XMLParser.extractObjectForTags(xml, "PipelineParameters");
                            if (GeMoMaPipeline.equals(this.parameters, this.oldParameters, new String[]{"target genome"}) && GeMoMaPipeline.equals(this.parameters, this.oldParameters, new String[]{"selected"}) && GeMoMaPipeline.equals(this.parameters, this.oldParameters, new String[]{"genetic code"}) && GeMoMaPipeline.equals(this.parameters, this.oldParameters, new String[]{"tblastn"}) && GeMoMaPipeline.equals(this.parameters, this.oldParameters, new String[]{"tag"}) && GeMoMaPipeline.equals(this.parameters, this.oldParameters, new String[]{"output individual predictions"}) && GeMoMaPipeline.equals(this.parameters, this.oldParameters, new String[]{"BLAST_PATH"}) && GeMoMaPipeline.equals(this.parameters, this.oldParameters, new String[]{"MMSEQS_PATH"}) && GeMoMaPipeline.equals(this.parameters, this.oldParameters, new String[]{"reference species"}) && GeMoMaPipeline.equals(this.parameters, this.oldParameters, new String[]{"RNA-seq evidence"}) && GeMoMaPipeline.equals(this.parameters, this.oldParameters, new String[]{"denoise"})) break block92;
                            this.pipelineProtocol.append("Basic parameters differ. Hence, it is not meaningful to restart the old GeMoMaPipeline run. Instead a new (independent) GeMoMaPipeline run will be started\n");
                            this.prepare(temp);
                            this.compute[0] = true;
                            ** GOTO lbl37
                        }
                        oldThreads = threads;
                        if (oldThreads == (threads = ((Integer)XMLParser.extractObjectForTags(xml, "threads")).intValue())) ** GOTO lbl37
                        this.pipelineProtocol.append("Changing the number of threads from " + oldThreads + " (=given) to " + threads + " (=originally used).\n");
                        ** while (true)
                        do {
                            this.pipelineProtocol.appendWarning("[" + cmd[i][0] + "]: " + line.trim() + "\n");
lbl174:
                            // 2 sources

                        } while ((line = br.readLine()) != null);
                        br.close();
                        pr.waitFor();
                        if (pr.exitValue() != 0) {
                            System.out.println(String.valueOf(cmd[i][0]) + " not available!");
                            System.exit(1);
                        }
                        ++i;
                        ** while (true)
                        do {
                            this.timeOutWarning[i] = new StringBuffer();
                            ++i;
lbl186:
                            // 2 sources

                        } while (i < this.species.size());
                        this.rnaSeqData = new RNASeq();
                        if (!this.rnaSeq) break block93;
                        p = pa.getParameterForName("introns");
                        if (p == null) break block94;
                        exp = (ExpandableParameterSet)p.getValue();
                        i = 0;
                        if (true) ** GOTO lbl209
                    }
                    ereParams = new ExtractRNAseqEvidence().getToolParameters();
                    GeMoMaPipeline.setParameters(pa, ereParams);
                    par = (ParameterSet)ereParams.getParameterForName("filter by intron mismatches").getValue();
                    if (par.getNumberOfParameters() > 0) {
                        par.getParameterForName("target genome").setValue(this.target);
                    }
                    ere = new JEREAndFill(ereParams);
                    break block95;
                }
                ere = new JEREAndFill();
                break block95;
                do {
                    this.rnaSeqData.introns.add((String)((SimpleParameterSet)exp.getParameterAt(i).getValue()).getParameterAt(0).getValue());
                    ++i;
lbl209:
                    // 2 sources

                } while (i < exp.getNumberOfParameters());
                exp = (ExpandableParameterSet)pa.getParameterForName("coverage").getValue();
                i = 0;
                while (i < exp.getNumberOfParameters()) {
                    ps = (SimpleParameterSet)exp.getParameterAt(i).getValue();
                    ps = (SimpleParameterSet)ps.getParameterAt(0).getValue();
                    switch (ps.getNumberOfParameters()) {
                        case 1: {
                            this.rnaSeqData.coverageUn.add((String)ps.getParameterAt(0).getValue());
                            break;
                        }
                        case 2: {
                            this.rnaSeqData.coverageFwd.add((String)ps.getParameterAt(0).getValue());
                            this.rnaSeqData.coverageRC.add((String)ps.getParameterAt(1).getValue());
                            break;
                        }
                    }
                    ++i;
                }
                ere = new JEREAndFill();
            }
            this.add(ere);
            this.waitPhase();
            usedSpec = 0;
            if (this.species.size() <= 0) ** GOTO lbl302
            s = 0;
            while (s < this.speciesCounter) {
                current = this.species.get(s);
                if (current.hasCDS) {
                    ++usedSpec;
                }
                ++s;
            }
            if (usedSpec <= 0) break block96;
            if (this.queue.isShutdown()) ** GOTO lbl281
            this.addNewPhase();
            s = this.compute;
            synchronized (this.compute) {
                if (!this.compute[0]) {
                    pName = "e-value";
                    eVal = (Double)((ParameterSetContainer)this.parameters.getParameterForName("GeMoMa parameter set")).getValue().getParameterForName(pName).getValue();
                    if (eVal > (oldEVal = ((Double)((ParameterSetContainer)this.oldParameters.getParameterForName("GeMoMa parameter set")).getValue().getParameterForName(pName).getValue()).doubleValue())) {
                        this.pipelineProtocol.append("Set compute=true (" + pName + ")\n");
                        this.compute[0] = true;
                    }
                }
                // ** MonitorExit[s] (shouldn't be in output)
                s = 0;
                if (true) ** GOTO lbl279
            }
        }
        protocol.appendWarning("No gene model was extracted from the references.\n");
        ** GOTO lbl302
        {
            block103: {
                block102: {
                    block101: {
                        block100: {
                            block99: {
                                block89: {
                                    do {
                                        block97: {
                                            block98: {
                                                current = this.species.get(s);
                                                if (!current.hasCDS) break block97;
                                                if (!blast) break block98;
                                                this.pipelineProtocol.append("species " + s + ": " + current.cds_parts.length + " splits\n");
                                                p = 0;
                                                if (true) ** GOTO lbl276
                                            }
                                            this.addMmseqsAndDummies(s);
                                            break block97;
                                            do {
                                                this.add(new JTblastn(s, p));
                                                ++p;
lbl276:
                                                // 2 sources

                                            } while (p < current.cds_parts.length);
                                        }
                                        ++s;
lbl279:
                                        // 2 sources

                                    } while (s < this.speciesCounter);
                                    this.waitPhase();
lbl281:
                                    // 2 sources

                                    header = true;
                                    i = 0;
                                    while (i < this.timeOutWarning.length) {
                                        if (this.timeOutWarning[i].length() > 0) {
                                            if (header) {
                                                protocol.append("\ntime-out warning:\n");
                                            }
                                            header = false;
                                            protocol.append("species " + i + " (" + this.species.get((int)i).name + "): " + this.timeOutWarning[i] + "\n");
                                        }
                                        ++i;
                                    }
                                    if (!header) {
                                        protocol.append("\n");
                                    }
                                    if (!this.queue.isShutdown()) {
                                        this.addNewPhase();
                                        s = 0;
                                        while (s < this.speciesCounter) {
                                            current = this.species.get(s);
                                            if (current.hasCDS) {
                                                this.add(new JCat(s));
                                            }
                                            ++s;
                                        }
                                    }
lbl302:
                                    // 5 sources

                                    if (!this.queue.isShutdown()) {
                                        ext = this.parameters.getExpandablePS("external annotations");
                                        sp = ext.getNumberOfParameters();
                                        if (sp == 0) {
                                            this.pipelineProtocol.append("No external annotation given.\n");
                                        } else {
                                            ae = new AnnotationEvidence();
                                            this.aePars = ae.getToolParameters();
                                            s = 0;
                                            while (s < sp) {
                                                currentExt = (SimpleParameterSet)((ParameterSetContainer)ext.getParameterAt(s)).getValue();
                                                dummySpecies = new Species(this.speciesCounter, (String)currentExt.getParameterForName("ID").getValue(), (Double)currentExt.getParameterForName("weight").getValue(), null);
                                                this.species.add(dummySpecies);
                                                dummySpecies.setExt(s);
                                                dummySpecies.hasCDS = true;
                                                dummySpecies.anno = (String)currentExt.getParameterForName("external annotation").getValue();
                                                if (((Boolean)currentExt.getParameterForName("annotation evidence").getValue()).booleanValue()) {
                                                    this.add(new JAnnotationEvidence(this.speciesCounter));
                                                }
                                                ++usedSpec;
                                                ++this.speciesCounter;
                                                ++s;
                                            }
                                        }
                                    }
                                    if (usedSpec > 0) {
                                        this.waitPhase();
                                        if (!this.queue.isShutdown()) {
                                            this.addNewPhase();
                                            this.add(new JGAF());
                                            this.waitPhase();
                                        }
                                        if (!this.queue.isShutdown()) {
                                            this.addNewPhase();
                                            this.add(new JAnnotationFinalizer(clear));
                                            this.waitPhase();
                                        }
                                        shouldWait = false;
                                        if (((Boolean)this.parameters.getParameterForName("synteny check").getValue()).booleanValue()) {
                                            syn = new SyntenyChecker().getToolParameters();
                                            a = 0;
                                            eps = (ExpandableParameterSet)syn.getParameterForName("references").getValue();
                                            for (Species current : this.species) {
                                                if (current.assignment.equals("<OPTIONAL>")) continue;
                                                if (a == eps.getNumberOfParameters()) {
                                                    eps.addParameterToSet();
                                                }
                                                sps = (SimpleParameterSet)eps.getParameterAt(a).getValue();
                                                if (current.id != null) {
                                                    sps.getParameterForName("prefix").setValue(current.id);
                                                }
                                                sps.getParameterForName("assignment").setValue(current.assignment);
                                                ++a;
                                            }
                                            if (a > 0 && !this.queue.isShutdown()) {
                                                this.add(new JSyntenyChecker(syn));
                                                shouldWait = true;
                                            }
                                        }
                                        cds = (Boolean)this.parameters.getParameterForName("predicted CDSs").getValue();
                                        protein = (Boolean)this.parameters.getParameterForName("predicted proteins").getValue();
                                        genomic = (Boolean)this.parameters.getParameterForName("predicted genomic regions").getValue();
                                        if (this.queue.isShutdown() == false & (cds | protein | genomic)) {
                                            this.addNewPhase();
                                            this.add(new JExtractor(cds, protein, genomic));
                                            shouldWait = true;
                                        }
                                        if (shouldWait) {
                                            this.waitPhase();
                                        }
                                    }
                                }
                                if (!this.queue.isShutdown()) {
                                    this.queue.shutdown();
                                    this.queue.awaitTermination(0x7FFFFFFFFFFFFFFFL, TimeUnit.NANOSECONDS);
                                }
                                stat = new HashMap<String, int[]>();
                                anz = 0;
                                i = 0;
                                while (i < this.list.size()) {
                                    f = this.list.get(i);
                                    if (!(f instanceof JSleep)) {
                                        val = (int[])stat.get(f.getClass().getName());
                                        if (val == null) {
                                            val = new int[JobStatus.values().length];
                                            stat.put(f.getClass().getName(), val);
                                        }
                                        v2 = f.status.ordinal();
                                        val[v2] = val[v2] + 1;
                                        ++anz;
                                    }
                                    ++i;
                                }
                                this.pipelineProtocol.append("\nStatistics:\n");
                                a = 0;
                                i = 0;
                                while (i < this.w.length) {
                                    if (this.w[i].anz > 0) {
                                        if (a == 0) {
                                            this.pipelineProtocol.append("occurrence\twarning\n");
                                            this.pipelineProtocol.append("-----------------------\n");
                                        }
                                        this.pipelineProtocol.append(String.valueOf(this.w[i].anz) + "\t\"" + this.w[i].regex + "\"\n");
                                        ++a;
                                    }
                                    ++i;
                                }
                                if (a > 0) {
                                    this.pipelineProtocol.append("\n");
                                }
                                this.pipelineProtocol.append("Job");
                                st = JobStatus.values();
                                i = 0;
                                while (i < st.length) {
                                    this.pipelineProtocol.append("\t" + (Object)st[i]);
                                    ++i;
                                }
                                this.pipelineProtocol.append("\n");
                                this.pipelineProtocol.append("---------------------------------------------------------\n");
                                keys = stat.keySet().toArray(new String[0]);
                                Arrays.sort(keys, JobComparator.DEFAULT);
                                success = 0;
                                j = 0;
                                while (j < keys.length) {
                                    name = keys[j];
                                    o = JobComparator.getOrdinal(name);
                                    val = (int[])stat.get(name);
                                    idx = name.lastIndexOf("$");
                                    name = idx > 0 ? name.substring(idx + 2) : name;
                                    this.pipelineProtocol.append(name);
                                    i = 0;
                                    while (i < val.length) {
                                        this.pipelineProtocol.append("\t" + val[i]);
                                        ++i;
                                    }
                                    this.pipelineProtocol.append("\n");
                                    success += val[4];
                                    ++j;
                                }
                                this.pipelineProtocol.append("\n");
                                result = null;
                                if (usedSpec <= 0 || success != anz || this.tr != null) break block99;
                                this.pipelineProtocol.append("No errors detected.\n");
                                if (!this.all) break block100;
                                i = 0;
                                if (true) ** GOTO lbl450
                            }
                            if (anz - success > 0) {
                                this.pipelineProtocol.appendWarning(String.valueOf(anz - success) + " jobs did not finish as expected. Please check the output carefully.\n");
                            }
                            break block101;
                            do {
                                current = this.species.get(i);
                                if (current.hasCDS) {
                                    unfiltered = current.anno;
                                    fr = new FileParameter.FileRepresentation(unfiltered);
                                    if (current.ext < 0) {
                                        this.res.add(new TextResult("unfiltered predictions from species " + i, "Result", fr, "gff", gemoma.getToolName(), null, true));
                                    } else {
                                        this.res.add(new TextResult("external annotation " + current.ext + " with evidence", "Result", fr, "gff", ae.getToolName(), null, true));
                                    }
                                }
                                ++i;
lbl450:
                                // 2 sources

                            } while (i < this.speciesCounter);
                        }
                        result = new ToolResult("", "", null, new ResultSet(this.res), this.parameters, this.getToolName(), new Date());
                    }
                    i = 0;
                    while (i < this.res.size()) {
                        r = this.res.get(i);
                        if (r instanceof TextResult && (oldLink = (fr = (tr = (TextResult)r).getValue()).getFilename()) != null) {
                            newLink = File.createTempFile(System.getProperty("java.io.tmpdir"), "-" + oldLink.substring(oldLink.lastIndexOf(File.separatorChar) + 1));
                            newLink.deleteOnExit();
                            fr.moveFile(newLink.getAbsolutePath());
                        }
                        ++i;
                    }
                    debug = (Boolean)this.parameters.getParameterForName("debug").getValue();
                    if (result == null && debug) break block102;
                    io = new ArrayList<E>();
                    Files.walkFileTree(new File(this.home).toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
                        RegExFilenameFilter filter = new RegExFilenameFilter("only relevant files", RegExFilenameFilter.Directory.ALLOWED, true, "parameters.xml", "GeMoMa-.*\\.temp", ".*fasta", ".*gff", ".*txt", ".*tabular", ".*bedgraph", ".*gff3", "blastdb.*", "mmseqsdb.*", "t_orfs.*", "pref_.*", "aln.*", "translated_search\\.sh", "blastp\\.sh", "latest");

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            return this.delete(file);
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                            return this.delete(dir);
                        }

                        FileVisitResult delete(Path p) throws IOException {
                            block3: {
                                File f = p.toFile();
                                if (this.filter.accept(f)) {
                                    try {
                                        Files.delete(p);
                                    }
                                    catch (IOException e) {
                                        io.add(e);
                                        if (!f.isDirectory()) break block3;
                                        System.out.println(String.valueOf(p.toString()) + "\t" + Arrays.toString(p.toFile().list()));
                                    }
                                }
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    if (io.size() <= 0) break block103;
                    protocol.appendWarning("Could not delete all temporary files.\n\n");
                    fr = io.iterator();
                    if (true) ** GOTO lbl479
                }
                protocol.appendWarning("Did not delete temporary files allowing to debug.\n\n");
                break block103;
                do {
                    e = (IOException)fr.next();
                    protocol.appendWarning(String.valueOf(e.getClass().getSimpleName()) + ": " + e.getMessage() + "\n");
lbl479:
                    // 2 sources

                } while (fr.hasNext());
            }
            ti = Math.round(this.t.getElapsedTime());
            protocol.append("Elapsed time: " + ti + " seconds");
            s = (int)(ti % 60L);
            m = (int)((ti /= 60L) % 60L);
            protocol.append("\t(" + (ti /= 60L) + "h " + m + "m " + s + "s)\n");
            if (result != null) {
                return result;
            }
            this.pipelineProtocol.flush();
            Thread.sleep(1000L);
            r = new RuntimeException("Did not finish as intended. " + (this.tr == null ? "" : String.valueOf(this.tr.getClass().getName()) + ": " + this.tr.getMessage()));
            if (this.tr != null) {
                r.setStackTrace(this.tr.getStackTrace());
            }
            throw r;
        }
    }

    void add(FlaggedRunnable f) {
        if (!this.queue.isShutdown()) {
            this.list.add(f);
            this.ecs.submit(f, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    void waitPhase() throws InterruptedException, ExecutionException {
        if (!this.stop) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            this.ecs.take();
            if (this.stop) break;
            ++this.finished;
lbl7:
            // 2 sources

            ** while (this.finished < this.list.size())
        }
lbl8:
        // 2 sources

    }

    static String escape(String s) {
        if (s.indexOf(32) < 0) {
            return s;
        }
        return "\\\"" + s + "\\\"";
    }

    void addMmseqsAndDummies(int species) throws SimpleParameter.IllegalValueException, CloneNotSupportedException {
        JMmseqs mmseqs = new JMmseqs(species);
        this.add(mmseqs);
        int i = 1;
        while (i < this.threads) {
            this.add(new JSleep(mmseqs, i));
            ++i;
        }
    }

    @Override
    public String getToolName() {
        return "GeMoMa pipeline";
    }

    @Override
    public String getShortName() {
        return "GeMoMaPipeline";
    }

    @Override
    public String getDescription() {
        return "runs the complete GeMoMa pipeline for one target species and multiple reference species";
    }

    @Override
    public String getHelpText() {
        return "This tool can be used to run the complete GeMoMa pipeline. The tool is multi-threaded and can utilize all compute cores on one machine, but not distributed as for instance in a compute cluster. It basically runs: **Extract RNA-seq evidence (ERE)**, **DenoiseIntrons**, **Extractor**, external search (tblastn or mmseqs), **Gene Model Mapper (GeMoMa)**, **GeMoMa Annotation Filter (GAF)**, and **AnnnotationFinalizer**." + MORE;
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return new JstacsTool.ResultEntry[]{new JstacsTool.ResultEntry(TextResult.class, "gff", "final_annotation")};
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        try {
            return new ToolResult[]{new ToolResult(FileManager.readFile(String.valueOf(path) + File.separator + "tests" + File.separator + "gemoma" + File.separator + "xml" + File.separator + "gemomapipeline-test.xml")), new ToolResult(FileManager.readFile(String.valueOf(path) + File.separator + "tests" + File.separator + "gemoma" + File.separator + "xml" + File.separator + "gemomapipeline-test2.xml")), new ToolResult(FileManager.readFile(String.valueOf(path) + File.separator + "tests" + File.separator + "gemoma" + File.separator + "xml" + File.separator + "gemomapipeline-test3.xml"))};
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    abstract class FlaggedRunnable
    implements Runnable {
        JobStatus status;
        ArrayList<String> results;
        String name;

        public FlaggedRunnable(String name) {
            this.name = name;
            this.results = new ArrayList();
            this.status = JobStatus.WAITING;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            this.status = JobStatus.RUNNING;
            boolean[] blArray = GeMoMaPipeline.this.compute;
            synchronized (GeMoMaPipeline.this.compute) {
                boolean e;
                if (!GeMoMaPipeline.this.compute[0] && !(e = this.exists())) {
                    GeMoMaPipeline.this.pipelineProtocol.append("Set compute=true (" + this.getClass().getSimpleName() + ")\n");
                    GeMoMaPipeline.this.compute[0] = true;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                if (GeMoMaPipeline.this.compute[0]) {
                    if (this.name != null) {
                        GeMoMaPipeline.this.pipelineProtocol.append("Starting: " + this.name + " (" + GeMoMaPipeline.this.t.getElapsedTime() + "s)\n");
                    }
                    try {
                        this.doJob();
                        if (this.name != null) {
                            GeMoMaPipeline.this.pipelineProtocol.append("Finished: " + this.name + " (" + GeMoMaPipeline.this.t.getElapsedTime() + "s)\n");
                        }
                        if (this.status == JobStatus.RUNNING) {
                            this.postProcessing();
                        }
                    }
                    catch (InterruptedException e2) {
                        this.status = JobStatus.INTERRUPTED;
                    }
                    catch (Throwable e3) {
                        GeMoMaPipeline.this.pipelineProtocol.appendThrowable(e3);
                        GeMoMaPipeline.this.tr = e3;
                        this.status = JobStatus.FAILED;
                    }
                    if (this.status == JobStatus.FAILED && !GeMoMaPipeline.this.queue.isShutdown()) {
                        GeMoMaPipeline.this.queue.shutdown();
                        GeMoMaPipeline.this.stop = true;
                        GeMoMaPipeline.this.killer.run();
                    }
                } else {
                    if (this.name != null) {
                        GeMoMaPipeline.this.pipelineProtocol.append("Using pre-existing files: " + this.name + "\n");
                    }
                    try {
                        this.postProcessing();
                    }
                    catch (InterruptedException e4) {
                        this.status = JobStatus.INTERRUPTED;
                    }
                    catch (Throwable e5) {
                        GeMoMaPipeline.this.pipelineProtocol.appendThrowable(e5);
                        GeMoMaPipeline.this.tr = e5;
                        this.status = JobStatus.FAILED;
                    }
                }
                if (this.status == JobStatus.RUNNING) {
                    this.status = JobStatus.SUCCEEDED;
                } else {
                    GeMoMaPipeline.this.queue.shutdown();
                    GeMoMaPipeline.this.stop = true;
                    GeMoMaPipeline.this.killer.run();
                    this.clean();
                }
                return;
            }
        }

        public void postProcessing() throws Exception {
        }

        public boolean exists() {
            if (this.results == null || this.results.size() == 0) {
                return true;
            }
            int i = 0;
            while (i < this.results.size()) {
                String fName = this.results.get(i);
                if (!fName.equals(GeMoMaPipeline.OPTIONAL) && !new File(fName).exists()) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public void clean() {
            if (this.results != null) {
                int i = 0;
                while (i < this.results.size()) {
                    try {
                        Files.deleteIfExists(Paths.get(this.results.get(i), new String[0]));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
        }

        public abstract void doJob() throws Exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int runProcess(String ... cmd) throws Exception {
            ProcessBuilder pb = new ProcessBuilder(cmd);
            pb.redirectErrorStream(true);
            Process p = pb.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = null;
            while ((line = br.readLine()) != null) {
                boolean out = true;
                int i = 0;
                while (i < GeMoMaPipeline.this.w.length) {
                    Warning warning = GeMoMaPipeline.this.w[i];
                    synchronized (warning) {
                        if (GeMoMaPipeline.this.w[i].matches(line)) {
                            if (GeMoMaPipeline.this.w[i].anz > 3) {
                                out = false;
                            }
                            break;
                        }
                    }
                    ++i;
                }
                if (!out) continue;
                GeMoMaPipeline.this.pipelineProtocol.appendWarning("[" + cmd[0] + "]: " + line + "\n");
            }
            br.close();
            GeMoMaPipeline.this.process.add(p);
            p.waitFor();
            return p.exitValue();
        }
    }

    public static class GeMoMaPipelineParameterSet
    extends ToolParameterSet {
        public GeMoMaPipelineParameterSet(String name, Parameter ... pars) {
            super(name, pars);
        }

        public GeMoMaPipelineParameterSet(StringBuffer representation) throws NonParsableException {
            super(representation);
        }

        @Override
        public boolean hasDefaultOrIsSet() {
            boolean res = super.hasDefaultOrIsSet();
            if (res) {
                int anz = this.getExpandablePS("reference species").getNumberOfParameters() + this.getExpandablePS("external annotations").getNumberOfParameters();
                if (anz == 0) {
                    this.errorMessage = "You need to specify at least one reference species or one external annotation.";
                    return false;
                }
                this.errorMessage = null;
            }
            return res;
        }

        public ExpandableParameterSet getExpandablePS(String s) {
            return (ExpandableParameterSet)((ParameterSetContainer)this.getParameterForName(s)).getValue();
        }
    }

    class JAnnotationEvidence
    extends FlaggedRunnable {
        int speciesIndex;

        public JAnnotationEvidence(int speciesIndex) {
            super("AnnotationEvidence for external annotation " + GeMoMaPipeline.this.species.get((int)speciesIndex).name);
            this.speciesIndex = speciesIndex;
            this.results.add(String.valueOf(GeMoMaPipeline.this.home) + speciesIndex + File.separator + "annotation_with_attributes.gff");
        }

        @Override
        public void doJob() throws Exception {
            ToolResult res;
            Species sp = GeMoMaPipeline.this.species.get(this.speciesIndex);
            AnnotationEvidence ae = new AnnotationEvidence();
            ToolParameterSet pars = GeMoMaPipeline.this.aePars.clone();
            pars.getParameterForName("annotation").setValue(sp.anno);
            CLI.QuietSysProtocol protocol = new CLI.QuietSysProtocol();
            String outDir = String.valueOf(GeMoMaPipeline.this.home) + this.speciesIndex + File.separator;
            try {
                res = ae.run(pars, protocol, new ProgressUpdater(), 1, outDir);
            }
            catch (Exception ex) {
                GeMoMaPipeline.this.pipelineProtocol.append("AnnotationEvidence for external annotation " + sp.name + " throws an Exception (" + GeMoMaPipeline.this.t.getElapsedTime() + "s)\n");
                throw ex;
            }
            CLI.writeToolResults(res, protocol, outDir, ae, pars);
            sp.anno = String.valueOf(outDir) + "annotation_with_attributes.gff";
        }
    }

    class JAnnotationFinalizer
    extends FlaggedRunnable {
        boolean clear;

        public JAnnotationFinalizer(boolean clear) {
            super("AnnotationFinalizer");
            this.clear = clear;
            this.results.add(String.valueOf(GeMoMaPipeline.this.home) + "final_annotation.gff");
            GeMoMaPipeline.this.updateComputeBySubset("AnnotationFinalizer parameter set");
        }

        @Override
        public void doJob() throws Exception {
            CLI.QuietSysProtocol protocol = new CLI.QuietSysProtocol();
            AnnotationFinalizer af = new AnnotationFinalizer();
            if (this.clear) {
                af.clear();
            }
            GeMoMaPipeline.this.afParams.getParameterForName("annotation").setValue(String.valueOf(GeMoMaPipeline.this.home) + "filtered_predictions.gff");
            ToolResult tr = af.run(GeMoMaPipeline.this.afParams, protocol, new ProgressUpdater(), 1, GeMoMaPipeline.this.parameters, GeMoMaPipeline.this.getToolVersion(), GeMoMaPipeline.this.home);
            GeMoMaPipeline.this.pipelineProtocol.append(protocol.getLog().toString());
            GeMoMaPipeline.this.res.add(tr.getRawResult()[0].getResultAt(0));
            CLI.writeToolResults(tr, protocol, GeMoMaPipeline.this.home, af, GeMoMaPipeline.this.gafParams);
        }
    }

    class JCat
    extends FlaggedRunnable {
        int speciesIndex;

        JCat(int speciesIndex) {
            super("cat for species " + GeMoMaPipeline.this.species.get((int)speciesIndex).name);
            this.speciesIndex = speciesIndex;
            Species current = GeMoMaPipeline.this.species.get(speciesIndex);
            current.anno = String.valueOf(GeMoMaPipeline.this.home) + speciesIndex + File.separator + "unfiltered-predictions.gff";
            this.results.add(current.anno);
        }

        @Override
        public void doJob() throws Exception {
            Species current = GeMoMaPipeline.this.species.get(this.speciesIndex);
            BufferedWriter w = new BufferedWriter(new FileWriter(current.anno));
            int sp = 0;
            while (sp < GeMoMaPipeline.this.species.get((int)this.speciesIndex).searchResults.length) {
                String line;
                BufferedReader r = new BufferedReader(new FileReader(String.valueOf(GeMoMaPipeline.this.home) + this.speciesIndex + File.separator + sp + File.separator + "predicted_annotation.gff"));
                while ((line = r.readLine()) != null) {
                    if (line.charAt(0) == '#' && sp != 0) continue;
                    w.append(line);
                    w.newLine();
                }
                r.close();
                ++sp;
            }
            w.close();
        }
    }

    class JEREAndFill
    extends FlaggedRunnable {
        ToolParameterSet params;

        JEREAndFill() {
            this((ToolParameterSet)null);
        }

        JEREAndFill(ToolParameterSet ps) {
            boolean cov;
            super("EREAndFill");
            this.params = ps;
            if (this.params != null) {
                GeMoMaPipeline.this.rnaSeqData.introns.add(String.valueOf(GeMoMaPipeline.this.home) + "introns.gff");
                cov = (Boolean)this.params.getParameterForName("coverage").getValue();
                if (cov) {
                    if ((ExtractRNAseqEvidence.Stranded)((Object)this.params.getParameterForName("Stranded").getValue()) == ExtractRNAseqEvidence.Stranded.FR_UNSTRANDED) {
                        this.results.add(String.valueOf(GeMoMaPipeline.this.home) + "coverage.bedgraph");
                        GeMoMaPipeline.this.rnaSeqData.coverageUn.add(String.valueOf(GeMoMaPipeline.this.home) + File.separator + "coverage.bedgraph");
                    } else {
                        this.results.add(String.valueOf(GeMoMaPipeline.this.home) + "coverage_forward.bedgraph");
                        this.results.add(String.valueOf(GeMoMaPipeline.this.home) + "coverage_reverse.bedgraph");
                        GeMoMaPipeline.this.rnaSeqData.coverageFwd.add(String.valueOf(GeMoMaPipeline.this.home) + "coverage_forward.bedgraph");
                        GeMoMaPipeline.this.rnaSeqData.coverageRC.add(String.valueOf(GeMoMaPipeline.this.home) + "coverage_reverse.bedgraph");
                    }
                }
            } else {
                boolean bl = cov = GeMoMaPipeline.this.rnaSeqData.coverageUn.size() > 0 || GeMoMaPipeline.this.rnaSeqData.coverageFwd.size() > 0 || GeMoMaPipeline.this.rnaSeqData.coverageRC.size() > 0;
            }
            if (GeMoMaPipeline.this.rnaSeqData.introns.size() > 0) {
                if (GeMoMaPipeline.this.denoiseParams != null && cov) {
                    this.results.add(String.valueOf(GeMoMaPipeline.this.home) + "denoised_introns.gff");
                } else if (this.params != null) {
                    this.results.addAll(GeMoMaPipeline.this.rnaSeqData.introns);
                }
            }
        }

        @Override
        public void doJob() throws Exception {
            ToolResult res;
            Protocol protocol;
            Protocol protocol2 = protocol = GeMoMaPipeline.this.threads > 1 ? new CLI.QuietSysProtocol() : GeMoMaPipeline.this.pipelineProtocol;
            if (this.params != null) {
                ExtractRNAseqEvidence ere = new ExtractRNAseqEvidence();
                GeMoMaPipeline.this.pipelineProtocol.append("starting ERE\n");
                res = ere.run(this.params, protocol, new ProgressUpdater(), 1, GeMoMaPipeline.this.home);
                CLI.writeToolResults(res, protocol, GeMoMaPipeline.this.home, ere, this.params);
            }
            if (GeMoMaPipeline.this.denoiseParams != null && GeMoMaPipeline.this.rnaSeqData.introns.size() > 0 && (GeMoMaPipeline.this.rnaSeqData.coverageUn.size() > 0 || GeMoMaPipeline.this.rnaSeqData.coverageFwd.size() > 0 || GeMoMaPipeline.this.rnaSeqData.coverageRC.size() > 0)) {
                GeMoMaPipeline.this.setRNASeqParams(GeMoMaPipeline.this.denoiseParams);
                DenoiseIntrons denoise = new DenoiseIntrons();
                GeMoMaPipeline.this.pipelineProtocol.append("starting Denoise\n");
                res = denoise.run(GeMoMaPipeline.this.denoiseParams, protocol, new ProgressUpdater(), 1, GeMoMaPipeline.this.home);
                CLI.writeToolResults(res, protocol, GeMoMaPipeline.this.home, denoise, GeMoMaPipeline.this.denoiseParams);
                GeMoMaPipeline.this.rnaSeqData.introns.clear();
                GeMoMaPipeline.this.rnaSeqData.introns.add(String.valueOf(GeMoMaPipeline.this.home) + "denoised_introns.gff");
            }
        }

        @Override
        public void postProcessing() throws Exception {
            GeMoMaPipeline.this.setRNASeqParams(GeMoMaPipeline.this.gemomaParams);
            GeMoMa.fill(GeMoMaPipeline.this.pipelineProtocol, false, maxSize, (String)GeMoMaPipeline.this.gemomaParams.getParameterForName("target genome").getValue(), (String)GeMoMaPipeline.this.gemomaParams.getParameterForName("selected").getValue(), (Integer)GeMoMaPipeline.this.gemomaParams.getParameterForName("reads").getValue(), (ExpandableParameterSet)((ParameterSetContainer)GeMoMaPipeline.this.gemomaParams.getParameterForName("introns")).getValue(), (ExpandableParameterSet)((ParameterSetContainer)GeMoMaPipeline.this.gemomaParams.getParameterForName("coverage")).getValue());
        }
    }

    class JExtractor
    extends FlaggedRunnable {
        Extractor extractor;
        ToolParameterSet params;

        JExtractor(boolean cds, boolean protein, boolean genomic) throws SimpleParameter.IllegalValueException, CloneNotSupportedException {
            super("Extractor for final prediction");
            this.extractor = new Extractor(-1);
            this.params = this.extractor.getToolParameters();
            this.params.getParameterForName("annotation").setValue(String.valueOf(GeMoMaPipeline.this.home) + "final_annotation.gff");
            this.params.getParameterForName("genome").setValue(GeMoMaPipeline.this.target);
            this.params.getParameterForName("Ambiguity").setValue("AMBIGUOUS");
            this.params.getParameterForName("full-length").setValue("false");
            this.params.getParameterForName("discard pre-mature stop").setValue("false");
            this.params.getParameterForName("long fasta comment").setValue("true");
            this.params.getParameterForName(Extractor.name[2]).setValue(protein);
            this.params.getParameterForName(Extractor.name[3]).setValue(cds);
            this.params.getParameterForName(Extractor.name[4]).setValue(genomic);
        }

        @Override
        public void doJob() throws Exception {
            CLI.QuietSysProtocol protocol = new CLI.QuietSysProtocol();
            ToolResult tr = this.extractor.run(this.params, protocol, new ProgressUpdater(), 1, GeMoMaPipeline.this.home);
            ResultSet raw = tr.getRawResult()[0];
            int i = 2;
            while (i < raw.getNumberOfResults()) {
                TextResult sub = (TextResult)raw.getResultAt(i);
                GeMoMaPipeline.this.res.add(new TextResult("predicted " + sub.getName(), sub.getComment(), sub.getValue(), sub.getMime(), (String)sub.getProducer(), sub.getExtendedType(), sub.getExport()));
                ++i;
            }
            CLI.writeToolResults(tr, protocol, GeMoMaPipeline.this.home, this.extractor, this.params);
        }
    }

    class JExtractorAndSplit
    extends FlaggedRunnable {
        int speciesIndex;
        ToolParameterSet params;
        boolean split;

        private JExtractorAndSplit(String specName, Double w, String annotationInfo, boolean split) {
            super(null);
            Species sp = new Species(GeMoMaPipeline.this.speciesCounter, specName, w, annotationInfo);
            GeMoMaPipeline.this.species.add(sp);
            this.name = "Extractor for species " + sp.name;
            this.speciesIndex = GeMoMaPipeline.this.speciesCounter++;
            this.params = null;
            this.split = split;
        }

        JExtractorAndSplit(String specName, Double w, String annotation, String genome, String annotationInfo, boolean split) throws SimpleParameter.IllegalValueException, CloneNotSupportedException {
            this(specName, w, annotationInfo, split);
            this.params = geMoMaPipeline.extractorParams.clone();
            this.params.getParameterForName("annotation").setValue(annotation);
            this.params.getParameterForName("genome").setValue(genome);
            Species sp = geMoMaPipeline.species.get(this.speciesIndex);
            String outDir = String.valueOf(geMoMaPipeline.home) + this.speciesIndex + File.separator;
            sp.cds = String.valueOf(outDir) + Extractor.name[0] + "." + Extractor.type[0];
            sp.assignment = String.valueOf(outDir) + Extractor.name[1] + "." + Extractor.type[1];
            this.addResults();
        }

        JExtractorAndSplit(String specName, Double w, String cds_parts, String assignment, boolean split, String annotationInfo) {
            this(specName, w, annotationInfo, split);
            Species sp = geMoMaPipeline.species.get(this.speciesIndex);
            sp.cds = cds_parts;
            sp.assignment = assignment == null ? GeMoMaPipeline.OPTIONAL : assignment;
            this.addResults();
        }

        void addResults() {
            Species sp = GeMoMaPipeline.this.species.get(this.speciesIndex);
            this.results.add(sp.cds);
            this.results.add(sp.assignment);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doJob() throws Exception {
            Species sp = GeMoMaPipeline.this.species.get(this.speciesIndex);
            String outDir = String.valueOf(GeMoMaPipeline.this.home) + this.speciesIndex + File.separator;
            File home = new File(outDir);
            home.mkdirs();
            if (this.params != null) {
                ToolResult res;
                CLI.QuietSysProtocol protocol = GeMoMaPipeline.this.threads == 1 && GeMoMaPipeline.this.pipelineProtocol instanceof CLI.SysProtocol ? (CLI.SysProtocol)GeMoMaPipeline.this.pipelineProtocol : new CLI.QuietSysProtocol();
                Extractor extractor = new Extractor(maxSize);
                try {
                    res = extractor.run(this.params, protocol, new ProgressUpdater(), 1, outDir);
                }
                catch (Exception e) {
                    GeMoMaPipeline.this.pipelineProtocol.append("Extractor for species " + sp.name + " throws an Exception (" + GeMoMaPipeline.this.t.getElapsedTime() + "s)\n");
                    throw e;
                }
                if (protocol != GeMoMaPipeline.this.pipelineProtocol) {
                    Protocol e = GeMoMaPipeline.this.pipelineProtocol;
                    synchronized (e) {
                        GeMoMaPipeline.this.pipelineProtocol.append("Extractor log for species " + sp.name + ":\n" + extractor.shortInfo);
                    }
                }
                CLI.writeToolResults(res, protocol, outDir, extractor, this.params);
            } else if (GeMoMaPipeline.this.selected != null) {
                String line;
                BufferedReader r = new BufferedReader(new FileReader(sp.assignment));
                HashSet<String> genes = new HashSet<String>();
                while ((line = r.readLine()) != null) {
                    String[] split;
                    if (line.charAt(0) == '#' || !GeMoMaPipeline.this.selected.containsKey((split = line.split("\t"))[1])) continue;
                    genes.add(split[0]);
                }
                r.close();
                r = new BufferedReader(new FileReader(sp.cds));
                sp.cds = String.valueOf(outDir) + Extractor.name[0] + "." + Extractor.type[0];
                BufferedWriter w = new BufferedWriter(new FileWriter(sp.cds));
                boolean keep = false;
                while ((line = r.readLine()) != null) {
                    if (line.length() == 0) continue;
                    if (line.charAt(0) == '>') {
                        int idx = line.lastIndexOf("_");
                        if (idx < 0) {
                            idx = line.length();
                        }
                        String id = line.substring(1, idx);
                        keep = genes.contains(id);
                    }
                    if (!keep) continue;
                    w.append(line);
                    w.newLine();
                }
                r.close();
                w.close();
            }
        }

        @Override
        public void postProcessing() throws IOException {
            Species sp = GeMoMaPipeline.this.species.get(this.speciesIndex);
            String outDir = String.valueOf(GeMoMaPipeline.this.home) + this.speciesIndex + File.separator;
            File f = new File(sp.cds);
            boolean bl = sp.hasCDS = f.exists() && f.length() > 0L;
            if (sp.hasCDS) {
                if (this.split && sp.hasCDS) {
                    FastaSplitter.main(new String[]{sp.cds, "" + GeMoMaPipeline.this.threads, "_", outDir});
                    RegExFilenameFilter filter = new RegExFilenameFilter("splits", RegExFilenameFilter.Directory.FORBIDDEN, true, "split-.*fasta");
                    File d = new File(outDir);
                    File[] h = d.listFiles(filter);
                    sp.cds_parts = new String[h.length];
                    int i = 0;
                    while (i < h.length) {
                        sp.cds_parts[i] = h[i].getAbsolutePath();
                        ++i;
                    }
                    sp.searchResults = new String[sp.cds_parts.length];
                }
            } else {
                GeMoMaPipeline.this.pipelineProtocol.append("Did not extract any gene model from species " + sp.name + "\n");
            }
        }
    }

    class JGAF
    extends FlaggedRunnable {
        public JGAF() {
            super("GAF");
            this.results.add(String.valueOf(GeMoMaPipeline.this.home) + "filtered_predictions.gff");
            GeMoMaPipeline.this.updateComputeBySubset("GAF parameter set");
        }

        @Override
        public void doJob() throws Exception {
            CLI.QuietSysProtocol protocol = GeMoMaPipeline.this.threads == 1 && GeMoMaPipeline.this.pipelineProtocol instanceof CLI.SysProtocol ? (CLI.SysProtocol)GeMoMaPipeline.this.pipelineProtocol : new CLI.QuietSysProtocol();
            GeMoMaAnnotationFilter gaf = new GeMoMaAnnotationFilter();
            ExpandableParameterSet eps = (ExpandableParameterSet)GeMoMaPipeline.this.gafParams.getParameterForName("predicted annotation").getValue();
            int i = 0;
            int s = 0;
            while (s < GeMoMaPipeline.this.speciesCounter) {
                Species current = GeMoMaPipeline.this.species.get(s);
                if (current.hasCDS) {
                    if (i > 0) {
                        eps.addParameterToSet();
                    }
                    ParameterSet ps = ((ParameterSetContainer)eps.getParameterAt(i++)).getValue();
                    if (current.id != null && !current.set) {
                        ps.getParameterForName("prefix").setValue(current.id);
                    }
                    ps.getParameterForName("gene annotation file").setValue(current.anno);
                    if (current.weight != null) {
                        ps.getParameterForName("weight").setValue(current.weight);
                    }
                    if (current.annotationInfo != null) {
                        ps.getParameterForName("annotation info").setValue(current.annotationInfo);
                    }
                }
                ++s;
            }
            Exception caught = null;
            ToolResult tr = null;
            try {
                tr = gaf.run(GeMoMaPipeline.this.gafParams, protocol, new ProgressUpdater(), 1, GeMoMaPipeline.this.home);
            }
            catch (Exception ex) {
                caught = ex;
            }
            if (protocol != GeMoMaPipeline.this.pipelineProtocol) {
                GeMoMaPipeline.this.pipelineProtocol.append(protocol.getLog().toString());
            }
            if (caught != null) {
                throw caught;
            }
            CLI.writeToolResults(tr, protocol, GeMoMaPipeline.this.home, gaf, GeMoMaPipeline.this.gafParams);
        }
    }

    class JGeMoMa
    extends FlaggedRunnable {
        int speciesIndex;
        int split;

        JGeMoMa(int speciesIndex, int split) {
            super("GeMoMa split=" + split + " for species " + GeMoMaPipeline.this.species.get((int)speciesIndex).name);
            this.speciesIndex = speciesIndex;
            this.split = split;
            this.results.add(String.valueOf(GeMoMaPipeline.this.home) + speciesIndex + File.separator + split + File.separator + "predicted annotation".replace(' ', '_') + ".gff");
            GeMoMaPipeline.this.updateComputeBySubset("GeMoMa parameter set");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doJob() throws Exception {
            ToolResult res;
            Species sp = GeMoMaPipeline.this.species.get(this.speciesIndex);
            ToolParameterSet params = GeMoMaPipeline.this.gemomaParams.clone();
            if (sp.id != null && sp.id.length() > 0) {
                params.getParameterForName("prefix").setValue(String.valueOf(sp.id) + "_");
                sp.set = true;
            }
            params.getParameterForName("search results").setValue(sp.searchResults[this.split]);
            params.getParameterForName("cds parts").setValue(sp.cds);
            if (!sp.assignment.equals(GeMoMaPipeline.OPTIONAL)) {
                params.getParameterForName("assignment").setValue(sp.assignment);
            }
            CLI.QuietSysProtocol protocol = GeMoMaPipeline.this.threads == 1 && GeMoMaPipeline.this.pipelineProtocol instanceof CLI.SysProtocol ? (CLI.SysProtocol)GeMoMaPipeline.this.pipelineProtocol : new CLI.QuietSysProtocol();
            GeMoMa gemoma = new GeMoMa(maxSize, timeOut, maxTimeOut);
            String outDir = String.valueOf(GeMoMaPipeline.this.home) + this.speciesIndex + File.separator + this.split + File.separator;
            try {
                res = gemoma.run(params, protocol, new ProgressUpdater(), 1, outDir);
            }
            catch (Exception e) {
                GeMoMaPipeline.this.pipelineProtocol.append("GeMoMa for species " + sp.name + " split=" + this.split + " throws an Exception (" + GeMoMaPipeline.this.t.getElapsedTime() + "s)\n");
                throw e;
            }
            StringBuffer e = GeMoMaPipeline.this.timeOutWarning[this.speciesIndex];
            synchronized (e) {
                if (gemoma.timeOutWarning.length() > 0) {
                    GeMoMaPipeline.this.timeOutWarning[this.speciesIndex].append(String.valueOf(GeMoMaPipeline.this.timeOutWarning[this.speciesIndex].length() > 0 ? ", " : "") + gemoma.timeOutWarning);
                }
            }
            ResultSet[] r = res.getRawResult();
            CLI.writeToolResults(res, protocol, outDir, gemoma, params);
        }
    }

    class JMakeBlastDB
    extends FlaggedRunnable {
        public JMakeBlastDB() {
            super("makeblastdb");
            this.results.add(String.valueOf(GeMoMaPipeline.this.home) + "blastdb");
        }

        @Override
        public void doJob() throws Exception {
            String line;
            int exitCode = this.runProcess(String.valueOf(search_path) + "makeblastdb", "-out", GeMoMaPipeline.escape(String.valueOf(GeMoMaPipeline.this.home) + "blastdb"), "-hash_index", "-in", GeMoMaPipeline.escape(GeMoMaPipeline.this.target), "-title", "target", "-dbtype", "nucl", "-logfile", String.valueOf(GeMoMaPipeline.this.home) + "blastdb-logfile");
            BufferedReader r = new BufferedReader(new FileReader(String.valueOf(GeMoMaPipeline.this.home) + "blastdb-logfile"));
            StringBuffer log = new StringBuffer();
            HashMap<String, int[]> problems = new HashMap<String, int[]>();
            while ((line = r.readLine()) != null) {
                if (line.startsWith("Error:")) {
                    int[] num = (int[])problems.get(line = line.replaceAll("about ..%", "about xx%"));
                    if (num == null) {
                        num = new int[1];
                        problems.put(line, num);
                    }
                    num[0] = num[0] + 1;
                    continue;
                }
                log.append(String.valueOf(line) + "\n");
            }
            r.close();
            Iterator it = problems.entrySet().iterator();
            if (it.hasNext()) {
                log.append("\nproblems:\n");
                while (it.hasNext()) {
                    Map.Entry e = it.next();
                    int num = ((int[])e.getValue())[0];
                    if (num == 1) {
                        log.append("once: " + (String)e.getKey() + "\n");
                        continue;
                    }
                    log.append(String.valueOf(num) + " times: " + (String)e.getKey() + "\n");
                }
            }
            GeMoMaPipeline.this.pipelineProtocol.append(log.toString());
            if (exitCode > 0) {
                this.status = JobStatus.FAILED;
            }
        }
    }

    class JMmseqs
    extends FlaggedRunnable {
        int speciesIndex;
        CountDownLatch latch;

        JMmseqs(int speciesIndex) throws SimpleParameter.IllegalValueException, CloneNotSupportedException {
            super("mmseqs for species " + GeMoMaPipeline.this.species.get((int)speciesIndex).name);
            this.speciesIndex = speciesIndex;
            this.latch = new CountDownLatch(1);
            this.results.add(String.valueOf(GeMoMaPipeline.this.home) + speciesIndex + File.separator + "mmseqs.tabular");
        }

        @Override
        public void doJob() throws Exception {
            Species sp = GeMoMaPipeline.this.species.get(this.speciesIndex);
            int exitCode = 0;
            exitCode = this.runProcess(String.valueOf(search_path) + mmseqs, "createdb", GeMoMaPipeline.escape(sp.cds), GeMoMaPipeline.escape(String.valueOf(GeMoMaPipeline.this.home) + this.speciesIndex + File.separator + "mmseqsdb"), "-v", "2");
            String tmp = String.valueOf(GeMoMaPipeline.this.home) + this.speciesIndex + File.separator + "mmseqsdb_tmp";
            File t = new File(tmp);
            t.mkdirs();
            if (exitCode == 0) {
                exitCode = this.runProcess(String.valueOf(search_path) + mmseqs, "search", GeMoMaPipeline.escape(String.valueOf(GeMoMaPipeline.this.home) + this.speciesIndex + File.separator + "mmseqsdb"), GeMoMaPipeline.escape(String.valueOf(GeMoMaPipeline.this.home) + "mmseqsdb"), GeMoMaPipeline.escape(String.valueOf(GeMoMaPipeline.this.home) + this.speciesIndex + File.separator + "mmseqsdb_align.out"), GeMoMaPipeline.escape(tmp), "-e", "100.0", "--threads", "" + GeMoMaPipeline.this.threads, "-s", "8.5", "-a", "--comp-bias-corr", "0", "--max-seqs", "500", "--mask", "0", "--orf-start-mode", "1", "-v", "2");
            }
            if (exitCode == 0) {
                exitCode = this.runProcess(String.valueOf(search_path) + mmseqs, "convertalis", GeMoMaPipeline.escape(String.valueOf(GeMoMaPipeline.this.home) + this.speciesIndex + File.separator + "mmseqsdb"), GeMoMaPipeline.escape(String.valueOf(GeMoMaPipeline.this.home) + "mmseqsdb"), GeMoMaPipeline.escape(String.valueOf(GeMoMaPipeline.this.home) + this.speciesIndex + File.separator + "mmseqsdb_align.out"), GeMoMaPipeline.escape(String.valueOf(GeMoMaPipeline.this.home) + this.speciesIndex + File.separator + "mmseqs.tabular"), "--threads", "" + GeMoMaPipeline.this.threads, "--format-output", "query,target,pident,alnlen,mismatch,gapopen,qstart,qend,tstart,tend,evalue,bits,empty,raw,nident,empty,empty,empty,qframe,tframe,qaln,taln,qlen,tlen", "-v", "2");
            }
            this.latch.countDown();
            if (exitCode != 0) {
                this.status = JobStatus.FAILED;
            }
        }

        @Override
        public void postProcessing() throws Exception {
            Species sp = GeMoMaPipeline.this.species.get(this.speciesIndex);
            File[] parts = Tools.externalSort(String.valueOf(GeMoMaPipeline.this.home) + this.speciesIndex + File.separator + "mmseqs.tabular", 500000, GeMoMaPipeline.this.threads, new CLI.QuietSysProtocol(), !sp.assignment.equals(GeMoMaPipeline.OPTIONAL), String.valueOf(GeMoMaPipeline.this.home) + this.speciesIndex + File.separator);
            sp.searchResults = new String[parts.length];
            int i = 0;
            while (i < sp.searchResults.length) {
                sp.searchResults[i] = parts[i].getAbsolutePath();
                ++i;
            }
            i = 0;
            while (i < sp.searchResults.length) {
                if (!GeMoMaPipeline.this.queue.isShutdown()) {
                    GeMoMaPipeline.this.add(new JGeMoMa(this.speciesIndex, i));
                }
                ++i;
            }
        }
    }

    class JMmseqsCreateDB
    extends FlaggedRunnable {
        public JMmseqsCreateDB() {
            super("mmseqs createDB");
            this.results.add(String.valueOf(GeMoMaPipeline.this.home) + "mmseqsdb");
        }

        @Override
        public void doJob() throws Exception {
            int exitCode = this.runProcess(String.valueOf(search_path) + mmseqs, "createdb", GeMoMaPipeline.escape(GeMoMaPipeline.this.target), GeMoMaPipeline.escape(String.valueOf(GeMoMaPipeline.this.home) + "mmseqsdb"), "-v", "2");
            if (exitCode > 0) {
                this.status = JobStatus.FAILED;
            }
        }
    }

    class JSleep
    extends FlaggedRunnable {
        JMmseqs mmseqs;
        int i;

        JSleep(JMmseqs mmseqs, int i) {
            super(null);
            this.mmseqs = mmseqs;
            this.i = i;
        }

        @Override
        public void doJob() throws Exception {
            this.mmseqs.latch.await();
        }
    }

    class JSyntenyChecker
    extends FlaggedRunnable {
        ToolParameterSet params;

        JSyntenyChecker(ToolParameterSet par) throws SimpleParameter.IllegalValueException {
            super("SyntenyChecker");
            par.getParameterForName("tag").setValue(GeMoMaPipeline.this.parameters.getParameterForName("tag").getValue());
            par.getParameterForName("gene annotation file").setValue(String.valueOf(GeMoMaPipeline.this.home) + "final_annotation.gff");
            this.params = par;
        }

        @Override
        public void doJob() throws Exception {
            CLI.QuietSysProtocol protocol = new CLI.QuietSysProtocol();
            SyntenyChecker syn = new SyntenyChecker();
            ToolResult tr = syn.run(this.params, protocol, new ProgressUpdater(), 1, GeMoMaPipeline.this.home);
            ResultSet raw = tr.getRawResult()[0];
            int i = 0;
            GeMoMaPipeline.this.res.add(raw.getResultAt(i));
            CLI.writeToolResults(tr, protocol, GeMoMaPipeline.this.home, syn, this.params);
        }
    }

    class JTblastn
    extends FlaggedRunnable {
        int speciesIndex;
        int split;

        JTblastn(int speciesIndex, int split) throws SimpleParameter.IllegalValueException, CloneNotSupportedException {
            super("tblastn split=" + split + " for species " + GeMoMaPipeline.this.species.get((int)speciesIndex).name);
            this.speciesIndex = speciesIndex;
            this.split = split;
            this.results.add(String.valueOf(GeMoMaPipeline.this.home) + speciesIndex + File.separator + "tblastn-" + split + ".txt");
        }

        @Override
        public void doJob() throws Exception {
            Species current = GeMoMaPipeline.this.species.get(this.speciesIndex);
            int exitCode = this.runProcess(String.valueOf(search_path) + "tblastn", "-query", current.cds_parts[this.split], "-db", GeMoMaPipeline.escape(String.valueOf(GeMoMaPipeline.this.home) + "blastdb"), "-evalue", "" + GeMoMaPipeline.this.eValue, "-out", String.valueOf(GeMoMaPipeline.this.home) + this.speciesIndex + File.separator + "tblastn-" + this.split + ".txt", "-outfmt", "6 std sallseqid score nident positive gaps ppos qframe sframe qseq sseq qlen slen salltitles", "-db_gencode", "1", "-matrix", "BLOSUM62", "-seg", "no", "-word_size", "3", "-comp_based_stats", "F", "-gapopen", "" + GeMoMaPipeline.this.gapOpen, "-gapextend", "" + GeMoMaPipeline.this.gapExt, "-num_threads", "1");
            current.searchResults[this.split] = String.valueOf(GeMoMaPipeline.this.home) + this.speciesIndex + File.separator + "tblastn-" + this.split + ".txt";
            if (exitCode > 1) {
                this.status = JobStatus.FAILED;
            }
        }

        @Override
        public void postProcessing() {
            if (!GeMoMaPipeline.this.queue.isShutdown()) {
                GeMoMaPipeline.this.add(new JGeMoMa(this.speciesIndex, this.split));
            }
        }
    }

    static class JobComparator
    implements Comparator<String> {
        static JobComparator DEFAULT = new JobComparator();
        static HashMap<String, Integer> ordinal;

        private JobComparator() {
            ordinal = new HashMap();
            int i = 0;
            ordinal.put("MakeBlastDB", i);
            ordinal.put("MmseqsCreateDB", i);
            ordinal.put("EREAndFill", ++i);
            ordinal.put("ExtractorAndSplit", ++i);
            ordinal.put("Tblastn", ++i);
            ordinal.put("Mmseqs", i);
            ordinal.put("GeMoMa", ++i);
            ordinal.put("Cat", ++i);
            ordinal.put("AnnotationEvidence", ++i);
            ordinal.put("GAF", ++i);
            ordinal.put("AnnotationFinalizer", ++i);
            ordinal.put("Extractor", ++i);
        }

        static int getOrdinal(String s) {
            int idx = s.lastIndexOf("$");
            s = idx > 0 ? s.substring(idx + 2) : s;
            Integer i = ordinal.get(s);
            return i == null ? Integer.MAX_VALUE : i;
        }

        @Override
        public int compare(String o1, String o2) {
            return Integer.compare(JobComparator.getOrdinal(o1), JobComparator.getOrdinal(o2));
        }
    }

    static enum JobStatus {
        WAITING,
        RUNNING,
        INTERRUPTED,
        FAILED,
        SUCCEEDED;

    }

    private class RNASeq {
        ArrayList<String> introns = new ArrayList();
        ArrayList<String> coverageUn = new ArrayList();
        ArrayList<String> coverageFwd = new ArrayList();
        ArrayList<String> coverageRC = new ArrayList();

        private RNASeq() {
        }
    }

    private class Species {
        String id;
        String cds;
        String assignment;
        String name;
        String anno;
        String annotationInfo;
        Double weight;
        String[] cds_parts;
        String[] searchResults;
        boolean hasCDS;
        boolean set;
        int ext;

        Species(int idx, String id, double weight, String annotationInfo) {
            this.id = id;
            this.name = String.valueOf(idx) + (id == null || id.length() == 0 ? "" : " (" + id + ")");
            this.weight = weight;
            this.annotationInfo = annotationInfo;
            this.ext = -1;
            this.set = false;
        }

        void setExt(int ext) {
            this.ext = ext;
            this.name = String.valueOf(ext) + (this.id == null || this.id.length() == 0 ? "" : " (" + this.id + ")");
        }
    }

    static class Warning {
        String regex;
        Matcher m;
        int anz;

        Warning(String regex) {
            this.regex = regex.replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)");
            this.m = Pattern.compile(this.regex).matcher("");
            this.anz = 0;
        }

        boolean matches(String w) {
            this.m.reset(w);
            if (this.m.matches()) {
                ++this.anz;
                return true;
            }
            return false;
        }
    }
}

