/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma.JunitTest;

import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ui.cli.CLI;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import projects.gemoma.ExtractRNAseqEvidence;
import projects.gemoma.Extractor;
import projects.gemoma.GeMoMa;
import projects.gemoma.GeMoMaAnnotationFilter;
import projects.gemoma.Tools;

public class GeMoMaTest {
    static String in = "projects/gemoma/JunitTest/given/";

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        System.out.println("start: " + new Date());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        System.out.println("end: " + new Date());
    }

    @Before
    public static void setUp() throws Exception {
    }

    @After
    public static void tearDown() throws Exception {
        System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
    }

    static void assertFile(String name, String givenName, ResultSet rs) throws AssertionError, IOException {
        TextResult tr = (TextResult)rs.getResultForName(name);
        FileParameter.FileRepresentation fr = tr.getValue();
        GeMoMaTest.assertFile(name, String.valueOf(in) + givenName, fr.getFilename());
    }

    static void assertFile(String name, String givenName, String fName) throws AssertionError, IOException {
        long l = -100L;
        String l2 = null;
        String l1 = null;
        File f2 = null;
        File f1 = null;
        BufferedReader r2 = null;
        BufferedReader r1 = null;
        try {
            try {
                f1 = new File(givenName);
                f2 = new File(fName);
                r1 = new BufferedReader(new FileReader(f1));
                r2 = new BufferedReader(new FileReader(f2));
                l = 0L;
                while (true) {
                    if ((l1 = r1.readLine()) != null && l1.charAt(0) == '#') {
                        continue;
                    }
                    while ((l2 = r2.readLine()) != null && l2.charAt(0) == '#') {
                    }
                    if (l1 == null || l2 == null || !l1.toUpperCase().equals(l2.toUpperCase())) break;
                    ++l;
                }
                r1.close();
                r2.close();
                if (l1 != null || l2 != null) {
                    throw new RuntimeException();
                }
            }
            catch (Exception e) {
                if (l < 0L) {
                    throw new AssertionError(String.valueOf(name == null ? "" : String.valueOf(name) + ": ") + "The files differ." + "\nFile 1 (" + f1.getAbsolutePath() + "): " + (f1.exists() ? "exists" : "does not exist") + "\nFile 2 (" + f2.getAbsolutePath() + "): " + (f2.exists() ? "exists" : "does not exist"), e);
                }
                throw new AssertionError((Object)(String.valueOf(name == null ? "" : String.valueOf(name) + ": ") + "The files differ in line " + l + "." + "\nFile 1: " + f1.getAbsolutePath() + "\nContent: " + (l1 == null ? "[EOF]" : l1) + "\nFile 2: " + f2.getAbsolutePath() + "\nContent: " + (l2 == null ? "[EOF]" : l2)));
            }
        }
        finally {
            if (r1 != null) {
                r1.close();
            }
            if (r2 != null) {
                r2.close();
            }
        }
    }

    static void assertStructure(ResultSet[] rs, int num, int ... len) {
        Assert.assertTrue((String)"Different number of ResultSets", (rs.length == num ? 1 : 0) != 0);
        int i = 0;
        while (i < len.length) {
            Assert.assertTrue((String)("Different number of Results in ResultSet " + i), (rs[i].getNumberOfResults() == len[i] ? 1 : 0) != 0);
            ++i;
        }
    }

    void set(ParameterSet ps, int idx, int i, String value) throws SimpleParameter.IllegalValueException, CloneNotSupportedException {
        ParameterSetContainer psc = (ParameterSetContainer)ps.getParameterAt(idx);
        ExpandableParameterSet eps = (ExpandableParameterSet)psc.getValue();
        while (i >= eps.getNumberOfParameters()) {
            eps.addParameterToSet();
        }
        SimpleParameterSet sps = (SimpleParameterSet)((ParameterSetContainer)eps.getParameterAt(i)).getValue();
        sps.getParameterAt(0).setValue(String.valueOf(in) + value);
    }

    @Test
    public void testExtractor() throws Exception {
        Extractor e = new Extractor(-1);
        ToolParameterSet ps = e.getToolParameters();
        ps.getParameterForName("annotation").setValue(String.valueOf(in) + "Arabidopsis_lyrata.v.1.0.31.chr.gff3");
        ps.getParameterForName("genome").setValue(String.valueOf(in) + "Arabidopsis_lyrata.v.1.0.31.dna.genome.fa");
        ps.getParameterForName("repair").setValue(true);
        ps.getParameterForName("full-length").setValue(false);
        ps.getParameterForName("Ambiguity").setValue((Object)Tools.Ambiguity.AMBIGUOUS);
        ps.getParameterForName("proteins").setValue(true);
        ResultSet[] rs = e.run(ps, new CLI.SysProtocol(), new ProgressUpdater(), 1).getValue();
        GeMoMaTest.assertStructure(rs, 1, 3);
        GeMoMaTest.assertFile("cds-parts", "cds-parts.fasta", rs[0]);
        GeMoMaTest.assertFile("assignment", "assignment.tabular", rs[0]);
        GeMoMaTest.assertFile("proteins", "proteins.fasta", rs[0]);
    }

    @Test
    public void testERE() throws Exception {
        ExtractRNAseqEvidence e = new ExtractRNAseqEvidence();
        ToolParameterSet ps = e.getToolParameters();
        ps.getParameterForName("Stranded").setValue((Object)ExtractRNAseqEvidence.Stranded.FR_UNSTRANDED);
        this.set(ps, 1, 0, "RNAseq.bam");
        ps.getParameterForName("coverage output").setValue(true);
        ResultSet[] rs = e.run(ps, new CLI.SysProtocol(), new ProgressUpdater(), 1).getValue();
        GeMoMaTest.assertStructure(rs, 1, 2);
        GeMoMaTest.assertFile("coverage", "coverage.bedgraph", rs[0]);
        GeMoMaTest.assertFile("introns", "introns.gff", rs[0]);
    }

    @Test
    public void testGeMoMa() throws Exception {
        SimpleParameterSet x;
        GeMoMa e = new GeMoMa(-1, 3600L, 604800L);
        boolean simple = false;
        ToolParameterSet ps = e.getToolParameters();
        ps.getParameterForName("tblastn results").setValue(String.valueOf(in) + "tblastn.tabular");
        ps.getParameterForName("contig threshold").setValue(0.4);
        ps.getParameterForName("predictions").setValue(10);
        ps.getParameterForName("target genome").setValue(String.valueOf(in) + "TAIR10_chr_all.fas");
        ps.getParameterForName("assignment").setValue(String.valueOf(in) + "assignment.tabular");
        ps.getParameterForName("cds parts").setValue(String.valueOf(in) + "cds-parts.fasta");
        ps.getParameterForName("query proteins").setValue(String.valueOf(in) + "proteins.fasta");
        if (simple) {
            this.set(ps, 4, 0, "at-introns.gff");
        } else {
            this.set(ps, 4, 0, "at-introns-1.gff");
            this.set(ps, 4, 1, "at-introns-2.gff");
        }
        ExpandableParameterSet eps = (ExpandableParameterSet)ps.getParameterAt(7).getValue();
        if (simple) {
            x = (SimpleParameterSet)((ParameterSetContainer)eps.getParameterAt(0)).getValue();
            SelectionParameter sp = (SelectionParameter)x.getParameterAt(0);
            sp.setValue("UNSTRANDED");
            ((SimpleParameterSet)sp.getValue()).getParameterAt(0).setValue(String.valueOf(in) + "coverage.bedgraph");
        } else {
            x = (SimpleParameterSet)((ParameterSetContainer)eps.getParameterAt(0)).getValue();
            SelectionParameter sp = (SelectionParameter)x.getParameterAt(0);
            sp.setValue("UNSTRANDED");
            ((SimpleParameterSet)sp.getValue()).getParameterAt(0).setValue(String.valueOf(in) + "coverage.bedgraph-0.txt");
            eps.addParameterToSet();
            x = (SimpleParameterSet)((ParameterSetContainer)eps.getParameterAt(1)).getValue();
            sp = (SelectionParameter)x.getParameterAt(0);
            sp.setValue("UNSTRANDED");
            ((SimpleParameterSet)sp.getValue()).getParameterAt(0).setValue(String.valueOf(in) + "coverage.bedgraph-1.txt");
        }
        ResultSet[] rs = e.run(ps, new CLI.SysProtocol(), new ProgressUpdater(), 1).getValue();
        GeMoMaTest.assertStructure(rs, 1, 2);
        GeMoMaTest.assertFile("predicted annotation", "predicted_annotation.gff", rs[0]);
        GeMoMaTest.assertFile("predicted protein", "predicted_protein.fasta", rs[0]);
    }

    @Test
    public void testGAF() throws Exception {
        GeMoMaAnnotationFilter e = new GeMoMaAnnotationFilter();
        ToolParameterSet ps = e.getToolParameters();
        this.set(ps, 6, 0, "predicted_annotation.gff");
        ResultSet[] rs = e.run(ps, new CLI.SysProtocol(), new ProgressUpdater(), 1).getValue();
        GeMoMaTest.assertStructure(rs, 1, 1);
        GeMoMaTest.assertFile("filtered predictions", "filtered_predictions.gff", rs[0]);
    }
}

