/*
 * Decompiled with CFR 0.152.
 */
package projects.gemorna;

import de.jstacs.DataType;
import de.jstacs.parameters.AbstractSelectionParameter;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import de.jstacs.tools.ui.cli.CLI;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class MergeGeMoMaGeMoRNA
implements JstacsTool {
    public static HashMap<String, Gene> parseGFF(String filename, String genePrefix) throws IOException {
        String parent;
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        HashMap<String, Gene> genes = new HashMap<String, Gene>();
        HashMap<String, mRNA> mrnas = new HashMap<String, mRNA>();
        ArrayList<Exon> exons = new ArrayList<Exon>();
        ArrayList<CDS> cdss = new ArrayList<CDS>();
        ArrayList<GFFEntry> other = new ArrayList<GFFEntry>();
        String str = null;
        while ((str = reader.readLine()) != null) {
            GFFEntry temp;
            if (str.trim().length() <= 0 || str.startsWith("#")) continue;
            GFFEntry entry = new GFFEntry(str);
            if ("exon".equals(entry.type)) {
                exons.add(new Exon(entry));
                continue;
            }
            if ("CDS".equals(entry.type)) {
                cdss.add(new CDS(entry));
                continue;
            }
            if ("mRNA".equals(entry.type)) {
                temp = new mRNA(entry, genePrefix);
                mrnas.put(((mRNA)temp).getID(), (mRNA)temp);
                continue;
            }
            if ("gene".equals(entry.type)) {
                temp = new Gene(entry, genePrefix);
                genes.put(((Gene)temp).getID(), (Gene)temp);
                continue;
            }
            other.add(entry);
        }
        reader.close();
        for (Exon exon : exons) {
            parent = exon.getParent();
            if (mrnas.containsKey(parent)) {
                ((mRNA)mrnas.get(parent)).addExon(exon);
                continue;
            }
            throw new RuntimeException();
        }
        for (CDS cds : cdss) {
            parent = cds.getParent();
            if (mrnas.containsKey(parent)) {
                ((mRNA)mrnas.get(parent)).addCDS(cds);
                continue;
            }
            throw new RuntimeException();
        }
        for (mRNA mrna : mrnas.values()) {
            parent = mrna.getParent();
            if (genes.containsKey(parent)) {
                Gene temp = genes.get(parent);
                temp.addmRNA(mrna);
                continue;
            }
            throw new RuntimeException();
        }
        for (GFFEntry entry : other) {
            parent = entry.getParent();
            if (parent == null) continue;
            if (mrnas.containsKey(parent)) {
                ((mRNA)mrnas.get(parent)).addOther(entry);
                continue;
            }
            if (!genes.containsKey(parent)) continue;
            genes.get(parent).addOther(entry);
        }
        return genes;
    }

    public static void main(String[] args) throws Exception {
        CLI cli = new CLI(new MergeGeMoMaGeMoRNA());
        cli.run(args);
    }

    @Override
    public ToolParameterSet getToolParameters() {
        LinkedList<Parameter> pars = new LinkedList<Parameter>();
        pars.add(new FileParameter("GeMoMa", "GeMoMa predictions", "gff,gff3", true));
        pars.add(new FileParameter("GeMoRNA", "GeMoRNA predictions", "gff,gff3", true));
        try {
            pars.add(new SelectionParameter(DataType.PARAMETERSET, new String[]{"intersect", "union", "intermediate", "annotate"}, new ParameterSet[]{new SimpleParameterSet(new Parameter[0]), new SimpleParameterSet(new Parameter[0]), new SimpleParameterSet(new FileParameter("GeMoMa-strict", "GeMoMa predictions with strict settings", "gff,gff3", true), new FileParameter("GeMoRNA-strict", "GeMoRNA predictions with strict settings", "gff,gff3", true)), new SimpleParameterSet(new FileParameter("GeMoMa-strict", "GeMoMa predictions with strict settings", "gff,gff3", true), new FileParameter("GeMoRNA-strict", "GeMoRNA predictions with strict settings", "gff,gff3", true), new SimpleParameter(DataType.BOOLEAN, "Low-confidence", "include low-confidence predictions", true, true))}, new String[]{"Intersection of GeMoRNA and GeMoMa predictions", "Union of GeMoRNA and GeMoMa predictions", "Intersection and strict GeMoRNA and GeMoMa predictions", "Union of GeMoRNA and GeMoMa predictions with annotation as high, medium or low confidence"}, "Mode", "", true));
        }
        catch (AbstractSelectionParameter.InconsistentCollectionException | SimpleParameter.DatatypeNotValidException | SimpleParameter.IllegalValueException e) {
            e.printStackTrace();
        }
        return new ToolParameterSet(this.getToolName(), pars);
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        String gemomaFile = (String)parameters.getParameterAt(0).getValue();
        String gemornaFile = (String)parameters.getParameterAt(1).getValue();
        SplitAndSortedGFF gemoma = new SplitAndSortedGFF(MergeGeMoMaGeMoRNA.parseGFF(gemomaFile, "GeMoMa_"));
        SplitAndSortedGFF gemorna = new SplitAndSortedGFF(MergeGeMoMaGeMoRNA.parseGFF(gemornaFile, "GeMoRNA_"));
        int modei = ((SelectionParameter)parameters.getParameterAt(2)).getSelected();
        SplitAndSortedGFF gemomaStrict = null;
        SplitAndSortedGFF gemornaStrict = null;
        boolean includeLow = true;
        if (modei == 2 || modei == 3) {
            ParameterSet ps = (ParameterSet)parameters.getParameterAt(2).getValue();
            gemomaStrict = new SplitAndSortedGFF(MergeGeMoMaGeMoRNA.parseGFF((String)ps.getParameterAt(0).getValue(), "GeMoMa_"));
            gemornaStrict = new SplitAndSortedGFF(MergeGeMoMaGeMoRNA.parseGFF((String)ps.getParameterAt(1).getValue(), "GeMoRNA_"));
            this.annotateStrict(gemoma, gemomaStrict);
            this.annotateStrict(gemorna, gemornaStrict);
            if (modei == 3) {
                includeLow = (Boolean)ps.getParameterAt(2).getValue();
            }
        }
        LinkedList<TextResult> ress = new LinkedList<TextResult>();
        Mode mode = null;
        switch (modei) {
            case 0: {
                mode = Mode.INTERSECT;
                break;
            }
            case 1: {
                mode = Mode.UNION;
                break;
            }
            case 2: {
                mode = Mode.INTERMEDIATE;
                break;
            }
            default: {
                mode = Mode.ANNOTATE;
            }
        }
        SplitAndSortedGFF union = this.merge(gemoma, gemorna, mode, includeLow);
        File temp = File.createTempFile("merge", "gff", new File("."));
        temp.deleteOnExit();
        PrintWriter wr = new PrintWriter(temp);
        union.print(wr);
        wr.close();
        TextResult tr = new TextResult("Merged Predictions", "", new FileParameter.FileRepresentation(temp.getAbsolutePath()), true, "gff", this.getToolName(), "gff", true);
        ress.add(tr);
        return new ToolResult("Result of " + this.getToolName(), this.getToolName(), null, new ResultSet(ress), parameters, this.getToolName(), new Date(System.currentTimeMillis()));
    }

    private void annotateStrict(SplitAndSortedGFF gemoma, SplitAndSortedGFF gemomaStrict) {
        mRNAComparator cmp = mRNAComparator.getInstance();
        for (String chr : gemoma.map.keySet()) {
            ArrayList ma = (ArrayList)gemoma.map.get(chr);
            ArrayList strict = gemomaStrict.map.containsKey(chr) ? (ArrayList)gemomaStrict.map.get(chr) : new ArrayList();
            int i = 0;
            int j = 0;
            while (i < ma.size() && j < strict.size()) {
                mRNA strictRNA;
                mRNA maRNA = (mRNA)ma.get(i);
                int cmpRes = cmp.compare(maRNA, strictRNA = (mRNA)strict.get(j));
                if (cmpRes == 0) {
                    maRNA.setStrict(true);
                    ++i;
                    ++j;
                    continue;
                }
                if (cmpRes < 0) {
                    ++i;
                    continue;
                }
                if (cmpRes <= 0) continue;
                ++j;
            }
        }
    }

    private SplitAndSortedGFF merge(SplitAndSortedGFF gemoma, SplitAndSortedGFF gemorna, Mode mode, boolean includeLow) {
        HashMap<String, String> geneMap = new HashMap<String, String>();
        HashMap<String, ArrayList<mRNA>> joinedMap = new HashMap<String, ArrayList<mRNA>>();
        mRNAComparator cmp = mRNAComparator.getInstance();
        HashSet keys = new HashSet(gemoma.map.keySet());
        keys.addAll(gemorna.map.keySet());
        for (String chr : keys) {
            mRNA maRNA;
            ArrayList ma = gemoma.map.containsKey(chr) ? (ArrayList)gemoma.map.get(chr) : new ArrayList();
            ArrayList rna = gemorna.map.containsKey(chr) ? (ArrayList)gemorna.map.get(chr) : new ArrayList();
            ArrayList<mRNA> joinedList = new ArrayList<mRNA>();
            int i = 0;
            int j = 0;
            while (i < ma.size() && j < rna.size()) {
                mRNA rnaRNA;
                maRNA = (mRNA)ma.get(i);
                int cmpRes = cmp.compare(maRNA, rnaRNA = (mRNA)rna.get(j));
                if (cmpRes == 0) {
                    mRNA joined = this.join(maRNA, rnaRNA, geneMap);
                    if (mode == Mode.ANNOTATE) {
                        joined.setConfidence(Confidence.HIGH);
                    }
                    joinedList.add(joined);
                    ++i;
                    ++j;
                    continue;
                }
                if (maRNA.overlaps(rnaRNA)) {
                    this.addToMap(maRNA, rnaRNA, geneMap);
                }
                if (cmpRes < 0) {
                    if (mode == Mode.UNION || mode == Mode.ANNOTATE && includeLow || maRNA.isStrict()) {
                        if (mode == Mode.ANNOTATE) {
                            maRNA.setConfidence(maRNA.isStrict() ? Confidence.MEDIUM : Confidence.LOW);
                        }
                        joinedList.add(maRNA);
                    }
                    ++i;
                    continue;
                }
                if (cmpRes <= 0) continue;
                if (mode == Mode.UNION || mode == Mode.ANNOTATE && includeLow || rnaRNA.isStrict()) {
                    if (mode == Mode.ANNOTATE) {
                        rnaRNA.setConfidence(rnaRNA.isStrict() ? Confidence.MEDIUM : Confidence.LOW);
                    }
                    joinedList.add(rnaRNA);
                }
                ++j;
            }
            while (i < ma.size()) {
                maRNA = (mRNA)ma.get(i);
                if (mode == Mode.UNION || mode == Mode.ANNOTATE && includeLow || maRNA.isStrict()) {
                    if (mode == Mode.ANNOTATE) {
                        maRNA.setConfidence(maRNA.isStrict() ? Confidence.MEDIUM : Confidence.LOW);
                    }
                    joinedList.add(maRNA);
                }
                ++i;
            }
            while (j < rna.size()) {
                mRNA rnaRNA = (mRNA)rna.get(j);
                if (mode == Mode.UNION || mode == Mode.ANNOTATE && includeLow || rnaRNA.isStrict()) {
                    if (mode == Mode.ANNOTATE) {
                        rnaRNA.setConfidence(rnaRNA.isStrict() ? Confidence.MEDIUM : Confidence.LOW);
                    }
                    joinedList.add(rnaRNA);
                }
                ++j;
            }
            joinedMap.put(chr, joinedList);
        }
        return new SplitAndSortedGFF(joinedMap, geneMap);
    }

    private void addToMap(mRNA maRNA, mRNA rnaRNA, HashMap<String, String> geneMap) {
        geneMap.put(rnaRNA.getParent(), maRNA.getParent());
    }

    private mRNA join(mRNA maRNA, mRNA rnaRNA, HashMap<String, String> geneMap) {
        String temp;
        mRNA joined = new mRNA(rnaRNA, "");
        joined.source = "merged";
        joined.attributes = new HashMap();
        joined.attributes.put("ID", maRNA.getID());
        joined.attributes.put("Parent", maRNA.getParent());
        String altStr = rnaRNA.getID();
        if (rnaRNA.attributes.containsKey("alternative")) {
            temp = (String)rnaRNA.attributes.get("alternative");
            temp = temp.replaceAll("\"", "");
            altStr = String.valueOf(altStr) + "," + temp;
        }
        if (maRNA.attributes.containsKey("alternative")) {
            temp = (String)maRNA.attributes.get("alternative");
            temp = temp.replaceAll("\"", "");
            altStr = String.valueOf(altStr) + "," + temp;
        }
        joined.attributes.put("alternative", "\"" + altStr + "\"");
        for (String key : maRNA.attributes.keySet()) {
            if ("alternative".equals(key) || "ID".equals(key) || "Parent".equals(key)) continue;
            joined.attributes.put("GeMoMa_" + key, (String)maRNA.attributes.get(key));
        }
        for (String key : rnaRNA.attributes.keySet()) {
            if ("alternative".equals(key) || "ID".equals(key) || "Parent".equals(key)) continue;
            joined.attributes.put("GeMoRNA_" + key, (String)rnaRNA.attributes.get(key));
        }
        geneMap.put(rnaRNA.getParent(), maRNA.getParent());
        for (Exon exon : rnaRNA.exons) {
            Exon joinedExon = new Exon(exon);
            joinedExon.attributes.put("Parent", maRNA.getID());
            joined.addExon(joinedExon);
        }
        for (CDS cds : maRNA.cdss) {
            CDS joinedCDS = new CDS(cds);
            joinedCDS.attributes.put("Parent", maRNA.getID());
            joined.addCDS(joinedCDS);
        }
        for (GFFEntry en : rnaRNA.other) {
            GFFEntry joinedOther = new GFFEntry(en.chr, en.source, en.type, en.start, en.end, en.score, en.strand, en.phase, en.attributes);
            joinedOther.attributes.put("Parent", maRNA.getID());
            joined.addOther(joinedOther);
        }
        return joined;
    }

    @Override
    public String getToolName() {
        return "Merge";
    }

    @Override
    public String getToolVersion() {
        return "1.2";
    }

    @Override
    public String getShortName() {
        return "merge";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public String getHelpText() {
        return "";
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public String[] getReferences() {
        return null;
    }

    public static class CDS
    extends GFFEntry {
        public CDS(GFFEntry entry) {
            super(entry.chr, entry.source, entry.type, entry.start, entry.end, entry.score, entry.strand, entry.phase, entry.attributes);
        }
    }

    public static enum Confidence {
        HIGH,
        MEDIUM,
        LOW;

    }

    public static class Exon
    extends GFFEntry {
        public Exon(GFFEntry entry) {
            super(entry.chr, entry.source, entry.type, entry.start, entry.end, entry.score, entry.strand, entry.phase, entry.attributes);
        }
    }

    public static class GFFComparator
    implements Comparator<GFFEntry> {
        private static GFFComparator instance = new GFFComparator();

        private GFFComparator() {
        }

        @Override
        public int compare(GFFEntry o1, GFFEntry o2) {
            int cmp = Integer.compare(o1.start, o2.start);
            if (cmp == 0) {
                cmp = Integer.compare(o1.end, o2.end);
            }
            return cmp;
        }

        public static Comparator<GFFEntry> getInstance() {
            return instance;
        }
    }

    public static class GFFEntry {
        protected String chr;
        protected String source;
        protected String type;
        protected int start;
        protected int end;
        protected double score;
        protected char strand;
        protected int phase;
        protected HashMap<String, String> attributes;

        public GFFEntry(String line) {
            String[] parts = line.split("\t");
            this.chr = parts[0];
            this.source = parts[1];
            this.type = parts[2];
            this.start = Integer.parseInt(parts[3]);
            this.end = Integer.parseInt(parts[4]);
            this.score = ".".equals(parts[5]) ? Double.NaN : Double.parseDouble(parts[5]);
            this.strand = parts[6].charAt(0);
            this.phase = ".".equals(parts[7]) ? -1 : Integer.parseInt(parts[7]);
            String[] attrs = parts[8].split(";");
            this.attributes = new HashMap();
            int i = 0;
            while (i < attrs.length) {
                String[] keyval = attrs[i].split("=");
                this.attributes.put(keyval[0].trim(), keyval[1].trim());
                ++i;
            }
        }

        public GFFEntry(String chr, String source, String type, int start, int end, double score, char strand, int phase, HashMap<String, String> attributes) {
            this.chr = chr;
            this.source = source;
            this.type = type;
            this.start = start;
            this.end = end;
            this.score = score;
            this.strand = strand;
            this.phase = phase;
            this.attributes = attributes;
        }

        public String toString() {
            String attrs = "";
            if (this.attributes.containsKey("ID")) {
                attrs = String.valueOf(attrs) + "ID=" + this.attributes.get("ID") + ";";
            }
            if (this.attributes.containsKey("Parent")) {
                attrs = String.valueOf(attrs) + "Parent=" + this.attributes.get("Parent") + ";";
            }
            for (String key : this.attributes.keySet()) {
                if ("ID".equals(key) || "Parent".equals(key)) continue;
                attrs = String.valueOf(attrs) + key + "=" + this.attributes.get(key) + ";";
            }
            return String.valueOf(this.chr) + "\t" + this.source + "\t" + this.type + "\t" + this.start + "\t" + this.end + "\t" + (Double.isNaN(this.score) ? "." : Double.valueOf(this.score)) + "\t" + this.strand + "\t" + (this.phase < 0 ? "." : Integer.valueOf(this.phase)) + "\t" + attrs;
        }

        public String getParent() {
            return this.attributes.get("Parent");
        }

        public boolean equalsStartEndStrand(GFFEntry second) {
            return this.start == second.start && this.end == second.end && this.strand == second.strand;
        }
    }

    public static class Gene
    extends GFFEntry {
        private LinkedList<mRNA> mrnas = new LinkedList();
        private LinkedList<GFFEntry> other;

        public Gene(GFFEntry entry, String genePrefix) {
            super(entry.chr, entry.source, entry.type, entry.start, entry.end, entry.score, entry.strand, entry.phase, entry.attributes);
            this.attributes.put("ID", String.valueOf(genePrefix) + (String)this.attributes.get("ID"));
        }

        public String getID() {
            return (String)this.attributes.get("ID");
        }

        public void addmRNA(mRNA mrna) {
            this.mrnas.add(mrna);
        }

        public void addOther(GFFEntry other) {
            this.other.add(other);
        }

        public void sortInternally() {
            this.mrnas.sort(mRNAComparator.getInstance());
            for (mRNA mrna : this.mrnas) {
                mrna.sortInternally();
            }
        }

        public void print(PrintWriter wr) {
            wr.println(this);
            for (mRNA mrna : this.mrnas) {
                mrna.print(wr);
            }
        }
    }

    public static enum Mode {
        UNION,
        INTERSECT,
        INTERMEDIATE,
        ANNOTATE;

    }

    private static class SplitAndSortedGFF {
        private HashMap<String, ArrayList<mRNA>> map;
        private HashMap<String, Gene> genes;

        public SplitAndSortedGFF(HashMap<String, Gene> genes) {
            this.genes = genes;
            this.map = new HashMap();
            for (Gene gene : genes.values()) {
                String chr = String.valueOf(gene.chr) + "#" + gene.strand;
                if (!this.map.containsKey(chr)) {
                    this.map.put(chr, new ArrayList());
                }
                gene.sortInternally();
                this.map.get(chr).addAll(gene.mrnas);
            }
            for (ArrayList arrayList : this.map.values()) {
                arrayList.sort(mRNAComparator.getInstance());
            }
        }

        public SplitAndSortedGFF(HashMap<String, ArrayList<mRNA>> map, HashMap<String, String> geneMap) {
            this.map = map;
            this.genes = new HashMap();
            for (String chr : map.keySet()) {
                ArrayList<mRNA> curr = map.get(chr);
                HashMap newGenes = new HashMap();
                for (mRNA mrna : curr) {
                    String geneID = mrna.getParent();
                    if (geneMap.containsKey(geneID)) {
                        geneID = geneMap.get(geneID);
                        mrna.attributes.put("Parent", geneID);
                    }
                    if (!newGenes.containsKey(geneID)) {
                        newGenes.put(geneID, new LinkedList());
                    }
                    ((LinkedList)newGenes.get(geneID)).add(mrna);
                }
                for (String key : newGenes.keySet()) {
                    LinkedList rnas = (LinkedList)newGenes.get(key);
                    Gene temp = this.createGene(rnas, key);
                    this.genes.put(temp.getID(), temp);
                }
            }
        }

        private Gene createGene(LinkedList<mRNA> rnas, String key) {
            String chr = rnas.getFirst().chr;
            String source = rnas.getFirst().source;
            char strand = rnas.getFirst().strand;
            int start = rnas.getFirst().start;
            int end = rnas.getFirst().end;
            double maxTie = -1.0;
            for (mRNA mrna : rnas) {
                double temp;
                String tie;
                if (!chr.equals(mrna.chr) || strand != mrna.strand) {
                    throw new RuntimeException();
                }
                if (!source.equals(mrna.source)) {
                    source = "merged";
                }
                if (start > mrna.start) {
                    start = mrna.start;
                }
                if (end < mrna.end) {
                    end = mrna.end;
                }
                if (!mrna.attributes.containsKey("tie") || "NA".equals(tie = (String)mrna.attributes.get("tie")) || !((temp = Double.parseDouble(tie)) > maxTie)) continue;
                maxTie = temp;
            }
            Gene gene = new Gene(new GFFEntry(chr, source, "gene", start, end, Double.NaN, strand, -1, new HashMap<String, String>()), "");
            gene.attributes.put("transcripts", String.valueOf(rnas.size()));
            gene.attributes.put("maxTie", "" + (maxTie >= 0.0 ? Double.valueOf(maxTie) : "NA"));
            gene.attributes.put("ID", key);
            gene.mrnas.addAll(rnas);
            return gene;
        }

        public void print(PrintWriter wr) {
            HashMap byChr = new HashMap();
            for (Gene gene : this.genes.values()) {
                if (!byChr.containsKey(gene.chr)) {
                    byChr.put(gene.chr, new ArrayList());
                }
                ((ArrayList)byChr.get(gene.chr)).add(gene);
            }
            for (String chr : byChr.keySet()) {
                ArrayList genes = (ArrayList)byChr.get(chr);
                genes.sort(GFFComparator.getInstance());
                for (Gene gene : genes) {
                    gene.sortInternally();
                    gene.print(wr);
                }
            }
        }
    }

    public static class mRNA
    extends GFFEntry {
        private ArrayList<Exon> exons = new ArrayList();
        private ArrayList<CDS> cdss = new ArrayList();
        private ArrayList<GFFEntry> other = new ArrayList();
        private int cdsStart;
        private int cdsEnd;
        private boolean strict;
        private Confidence conf;

        public mRNA(GFFEntry entry, String genePrefix) {
            super(entry.chr, entry.source, entry.type, entry.start, entry.end, entry.score, entry.strand, entry.phase, entry.attributes);
            this.attributes.put("Parent", String.valueOf(genePrefix) + (String)this.attributes.get("Parent"));
            this.cdsEnd = -1;
            this.cdsStart = -1;
            this.strict = false;
            this.conf = null;
        }

        public void setConfidence(Confidence confidence) {
            this.conf = confidence;
            if (confidence != null) {
                this.attributes.put("confidence", this.conf.toString().toLowerCase());
            } else {
                this.attributes.remove("confidence");
            }
        }

        public String getID() {
            return (String)this.attributes.get("ID");
        }

        public boolean isStrict() {
            return this.strict;
        }

        public void setStrict(boolean strict) {
            this.strict = strict;
        }

        public void addExon(Exon exon) {
            this.exons.add(exon);
        }

        public void addCDS(CDS cds) {
            this.cdss.add(cds);
            if (this.cdsStart == -1) {
                this.cdsStart = cds.start;
                this.cdsEnd = cds.end;
            } else {
                if (cds.start < this.cdsStart) {
                    this.cdsStart = cds.start;
                }
                if (cds.end > this.cdsEnd) {
                    this.cdsEnd = cds.end;
                }
            }
        }

        public void addOther(GFFEntry other) {
            this.other.add(other);
        }

        public void sortInternally() {
            this.exons.sort(GFFComparator.getInstance());
            this.cdss.sort(GFFComparator.getInstance());
        }

        public boolean equalsCDSs(mRNA second) {
            if (this.cdss.size() != second.cdss.size()) {
                return false;
            }
            int i = 0;
            while (i < this.cdss.size()) {
                if (!this.cdss.get(i).equalsStartEndStrand(second.cdss.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public boolean equalsExons(mRNA second) {
            if (this.exons.size() != second.exons.size()) {
                return false;
            }
            int i = 0;
            while (i < this.exons.size()) {
                if (!this.exons.get(i).equalsStartEndStrand(second.exons.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public boolean equalsCDSBorders(mRNA rnaRNA) {
            return this.cdsStart == rnaRNA.cdsStart && this.cdsEnd == rnaRNA.cdsEnd;
        }

        public boolean overlaps(mRNA rnaRNA) {
            return this.start >= rnaRNA.start && this.start < rnaRNA.end || rnaRNA.start >= this.start && rnaRNA.start < this.end;
        }

        public void print(PrintWriter wr) {
            wr.println(this);
            for (Exon exon : this.exons) {
                wr.println(exon);
            }
            for (CDS cds : this.cdss) {
                wr.println(cds);
            }
            for (GFFEntry en : this.other) {
                wr.println(en);
            }
        }
    }

    public static class mRNAComparator
    implements Comparator<mRNA> {
        private static mRNAComparator instance = new mRNAComparator();

        private mRNAComparator() {
        }

        @Override
        public int compare(mRNA o1, mRNA o2) {
            int cmp = Integer.compare(o1.cdsStart, o2.cdsStart);
            if (cmp == 0) {
                cmp = Integer.compare(o1.cdsEnd, o2.cdsEnd);
            }
            if (cmp == 0) {
                cmp = o1.cdss.size() - o2.cdss.size();
            }
            if (cmp == 0) {
                int i = 0;
                while (i < o1.cdss.size() && cmp == 0) {
                    cmp = Integer.compare(((CDS)((mRNA)o1).cdss.get((int)i)).start, ((CDS)((mRNA)o2).cdss.get((int)i)).start);
                    if (cmp == 0) {
                        cmp = Integer.compare(((CDS)((mRNA)o1).cdss.get((int)i)).end, ((CDS)((mRNA)o2).cdss.get((int)i)).end);
                    }
                    ++i;
                }
            }
            return cmp;
        }

        public static mRNAComparator getInstance() {
            return instance;
        }
    }
}

