/*
 * Decompiled with CFR 0.152.
 */
package projects.methyl;

import de.jstacs.classifiers.AbstractScoreBasedClassifier;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.PlotGeneratorResult;
import de.jstacs.utils.graphics.GraphicsAdaptor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class CurvePlotter
implements PlotGeneratorResult.PlotGenerator {
    private AbstractScoreBasedClassifier.DoubleTableResult dtr;
    private String xlab;
    private String ylab;

    CurvePlotter(AbstractScoreBasedClassifier.DoubleTableResult dtr, String xlab, String ylab) {
        this.dtr = dtr;
        this.xlab = xlab;
        this.ylab = ylab;
    }

    public CurvePlotter(StringBuffer xml) throws NonParsableException {
        this.fromXML(xml);
    }

    public void fromXML(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, "CurvePlotter");
        this.dtr = (AbstractScoreBasedClassifier.DoubleTableResult)XMLParser.extractObjectForTags(xml, "dtr");
        this.xlab = (String)XMLParser.extractObjectForTags(xml, "xlab");
        this.ylab = (String)XMLParser.extractObjectForTags(xml, "ylab");
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.dtr, "dtr");
        XMLParser.appendObjectWithTags(xml, this.xlab, "xlab");
        XMLParser.appendObjectWithTags(xml, this.ylab, "ylab");
        XMLParser.addTags(xml, "CurvePlotter");
        return xml;
    }

    @Override
    public void generatePlot(GraphicsAdaptor ga) throws Exception {
        this.plot(ga.getGraphics(1180, 1180));
    }

    private void plot(Graphics2D graphics) {
        graphics = (Graphics2D)graphics.create();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, 1180, 1180);
        graphics.setColor(Color.BLACK);
        graphics.setStroke(new BasicStroke(5.0f));
        Font font = new Font(graphics.getFont().getName(), 0, 30);
        graphics.setFont(font);
        graphics.translate(150, 1030);
        graphics.drawLine(0, 15, 1000, 15);
        graphics.drawLine(-15, 0, -15, -1000);
        String[] labs = new String[]{"0", "0.25", "0.5", "0.75", "1"};
        int i = 0;
        while (i < labs.length) {
            int y = -i * 250;
            graphics.drawLine(-40, y, -15, y);
            Rectangle2D rect = graphics.getFontMetrics().getStringBounds(labs[i], graphics);
            graphics.drawString(labs[i], -45 - (int)rect.getWidth(), y - (int)rect.getCenterY());
            int x = i * 250;
            graphics.drawLine(x, 40, x, 15);
            graphics.drawString(labs[i], x - (int)rect.getCenterX(), 45 + (int)rect.getHeight());
            ++i;
        }
        Rectangle2D rect = graphics.getFontMetrics().getStringBounds(this.xlab, graphics);
        graphics.drawString(this.xlab, 500 - (int)rect.getCenterX(), 100 + (int)rect.getHeight());
        rect = graphics.getFontMetrics().getStringBounds(this.ylab, graphics);
        graphics.rotate(-1.5707963267948966);
        graphics.drawString(this.ylab, 500 - (int)rect.getCenterX(), -110);
        graphics.rotate(1.5707963267948966);
        int[] xPoints = new int[this.dtr.getNumberOfLines()];
        int[] yPoints = new int[this.dtr.getNumberOfLines()];
        int i2 = 0;
        while (i2 < this.dtr.getNumberOfLines()) {
            double[] temp = this.dtr.getLine(i2);
            xPoints[i2] = (int)(temp[0] * 1000.0);
            yPoints[i2] = -((int)(temp[1] * 1000.0));
            ++i2;
        }
        graphics.setColor(new Color(0.45f, 0.65f, 0.96f));
        graphics.drawPolyline(xPoints, yPoints, xPoints.length);
    }
}

