/*
 * Decompiled with CFR 0.152.
 */
package projects.ms;

import de.jstacs.utils.IntList;
import de.jstacs.utils.Pair;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import projects.ms.Deviation;
import projects.ms.DiffPseudoPeak;
import projects.ms.Peak;
import projects.ms.PrecursorPseudoPeak;
import projects.ms.Spectrum;

public class MatchSpectra {
    private UseIntensities useIntensities;
    private Deviation d;
    private double[][] m;
    private byte[][] bt;

    public MatchSpectra(UseIntensities useIntensities, Deviation d, int maxPeaks) {
        this.useIntensities = useIntensities;
        this.d = d;
        this.m = new double[maxPeaks + 1][maxPeaks + 1];
        this.bt = new byte[maxPeaks + 1][maxPeaks + 1];
    }

    public Matching computeMatchesSequential(Spectrum s1, Spectrum s2, boolean includeNeutralLosses, int minGroupSize) {
        HashSet<Peak> isAssigned1 = new HashSet<Peak>();
        HashSet<Peak> isAssigned2 = new HashSet<Peak>();
        HashSet<Peak.PeakType> types = new HashSet<Peak.PeakType>();
        types.add(Peak.PeakType.ORIGINAL);
        IntList s1o = s1.getIndicesOfType(types);
        IntList s2o = s2.getIndicesOfType(types);
        Matching matching = this.dp(s1o, s2o, isAssigned1, isAssigned2, s1, s2, includeNeutralLosses);
        this.addAssignedMatches(matching, isAssigned1, s1, 0);
        this.addAssignedMatches(matching, isAssigned2, s2, 1);
        types.add(Peak.PeakType.PRECURSOR);
        s1o = s1.getIndicesOfType(types);
        s2o = s2.getIndicesOfType(types);
        this.addAssignedPrecursor(s1, s1o, isAssigned1);
        this.addAssignedPrecursor(s2, s2o, isAssigned2);
        Matching matchingPrecursor = this.dp(s1o, s2o, isAssigned1, isAssigned2, s1, s2, includeNeutralLosses);
        this.addAssignedMatches(matchingPrecursor, isAssigned1, s1, 0);
        this.addAssignedMatches(matchingPrecursor, isAssigned2, s2, 1);
        types.add(Peak.PeakType.DIFF);
        s1o = s1.getIndicesOfType(types);
        s2o = s2.getIndicesOfType(types);
        this.addAssignedDiff(s1, s1o, isAssigned1);
        this.addAssignedDiff(s2, s2o, isAssigned2);
        Matching matchingDiff = this.dp(s1o, s2o, isAssigned1, isAssigned2, s1, s2, includeNeutralLosses);
        ArrayList<Pair<Integer, Double>> pairs = matchingDiff.getShiftsForDiffs(false);
        Collections.sort(pairs, new Comparator<Pair<Integer, Double>>(){

            @Override
            public int compare(Pair<Integer, Double> o1, Pair<Integer, Double> o2) {
                return Double.compare(o1.getSecondElement(), o2.getSecondElement());
            }
        });
        ArrayList<Matching.MatchGroup> groups = new ArrayList<Matching.MatchGroup>();
        int k = 0;
        int i = 1;
        while (i < pairs.size()) {
            int prevIdx = pairs.get(i - 1).getFirstElement();
            int currIdx = pairs.get(i).getFirstElement();
            double[] mzsPrev = matchingDiff.getPeakMzs(prevIdx);
            double[] mzsCurr = matchingDiff.getPeakMzs(currIdx);
            double maxMzPrev = mzsPrev[0] > mzsPrev[1] ? mzsPrev[0] : mzsPrev[1];
            double maxMzCurr = mzsCurr[0] > mzsCurr[1] ? mzsCurr[0] : mzsCurr[1];
            boolean sim = this.d.isShiftWithinDeviation(pairs.get(i - 1).getSecondElement(), pairs.get(i).getSecondElement(), Math.max(maxMzPrev, maxMzCurr));
            if (!sim) {
                groups.add(matchingDiff.createGroup(pairs, k, i, true));
                k = i;
            }
            ++i;
        }
        groups.add(matchingDiff.createGroup(pairs, k, pairs.size(), true));
        i = 0;
        while (i < groups.size()) {
            groups.get(i).setGroup(i);
            if (groups.get(i).size() < minGroupSize) {
                groups.get(i).setUsed(false);
            }
            ++i;
        }
        this.doCombinatorics(groups);
        matching.matches.addAll(matchingPrecursor.matches);
        matching.matches.addAll(matchingDiff.matches);
        return matching;
    }

    private void doCombinatorics(ArrayList<Matching.MatchGroup> groups) {
        HashSet[][] peakSets = new HashSet[groups.size()][];
        int i = 0;
        while (i < groups.size()) {
            Matching.MatchGroup g = groups.get(i);
            peakSets[i] = g.getOriginalPeaks();
            ++i;
        }
        int[][] conflicts = new int[groups.size()][groups.size()];
        int i2 = 1;
        while (i2 < groups.size()) {
            int j = 0;
            while (j < i2) {
                HashSet[] g1 = peakSets[i2];
                HashSet[] g2 = peakSets[j];
                int a = (int)g1[0].stream().filter(e -> g2[0].contains(e)).count();
                int b = (int)g1[1].stream().filter(e -> g2[1].contains(e)).count();
                conflicts[i2][j] = a + b;
                conflicts[j][i2] = a + b;
                ++j;
            }
            ++i2;
        }
        IntList remove = new IntList();
        int[] numConflicts = new int[groups.size()];
        int sumOfConflicts = this.update(numConflicts, conflicts);
        while (sumOfConflicts > 0) {
            int idx = this.getMaxIndex(numConflicts, groups);
            this.updateMatrix(conflicts, idx);
            remove.add(idx);
            sumOfConflicts = this.update(numConflicts, conflicts);
        }
        int i3 = 0;
        while (i3 < remove.length()) {
            Matching.MatchGroup g = groups.get(remove.get(i3));
            g.setUsed(false);
            ++i3;
        }
        for (Matching.MatchGroup g : groups) {
            if (!g.getUsed()) continue;
            double m = 0.0;
            double n = 0.0;
            for (Matching.Match match : g.group) {
                m += match.getShift();
                n += 1.0;
            }
            m /= n;
            for (Matching.Match match : g.group) {
                match.setGroupShift(m);
            }
        }
    }

    private void print(int[][] conflicts) {
        int i = 0;
        while (i < conflicts.length) {
            System.out.print("\t" + i);
            ++i;
        }
        System.out.println();
        i = 0;
        while (i < conflicts.length) {
            System.out.print(i);
            int j = 0;
            while (j < conflicts[i].length) {
                System.out.print("\t" + conflicts[i][j]);
                ++j;
            }
            System.out.println();
            ++i;
        }
        System.out.println();
    }

    private void updateMatrix(int[][] conflicts, int idx) {
        int i = 0;
        while (i < conflicts.length) {
            conflicts[idx][i] = 0;
            conflicts[i][idx] = 0;
            ++i;
        }
    }

    private int getMaxIndex(int[] numConflicts, ArrayList<Matching.MatchGroup> groups) {
        int max = 0;
        int i = 0;
        while (i < numConflicts.length) {
            if (numConflicts[i] > max) {
                max = numConflicts[i];
            }
            ++i;
        }
        int minSize = Integer.MAX_VALUE;
        int maxIdx = -1;
        int i2 = 0;
        while (i2 < numConflicts.length) {
            if (numConflicts[i2] == max && groups.get(i2).size() < minSize) {
                minSize = groups.get(i2).size();
                maxIdx = i2;
            }
            ++i2;
        }
        return maxIdx;
    }

    private int update(int[] numConflicts, int[][] conflicts) {
        int totalNum = 0;
        int i = 0;
        while (i < conflicts.length) {
            numConflicts[i] = 0;
            int j = 0;
            while (j < conflicts[i].length) {
                int n = i;
                numConflicts[n] = numConflicts[n] + conflicts[i][j];
                ++j;
            }
            totalNum += numConflicts[i];
            ++i;
        }
        return totalNum;
    }

    private void doCombinatorics(Matching matchingDiff) {
        HashSet<Peak.PeakType> types = new HashSet<Peak.PeakType>();
        types.add(Peak.PeakType.ORIGINAL);
        ArrayList<Peak> s1o = matchingDiff.s1.getPeaksOfType(types);
        ArrayList<Peak> s2o = matchingDiff.s2.getPeaksOfType(types);
        HashMap<Peak, Integer> map1 = new HashMap<Peak, Integer>();
        int i = 0;
        while (i < s1o.size()) {
            map1.put(s1o.get(i), i);
            ++i;
        }
        HashMap<Peak, Integer> map2 = new HashMap<Peak, Integer>();
        int i2 = 0;
        while (i2 < s2o.size()) {
            map2.put(s2o.get(i2), i2);
            ++i2;
        }
        LinkedList[][] conflicts = new LinkedList[s1o.size()][s2o.size()];
        int i3 = 0;
        while (i3 < matchingDiff.matches.size()) {
            Matching.Match m = (Matching.Match)matchingDiff.matches.get(i3);
            if (m.use() && matchingDiff.s1.getPeakAt(m.idx1()).getType() == Peak.PeakType.DIFF && matchingDiff.s2.getPeakAt(m.idx2()).getType() == Peak.PeakType.DIFF) {
                DiffPseudoPeak p1 = (DiffPseudoPeak)matchingDiff.s1.getPeakAt(m.idx1());
                DiffPseudoPeak p2 = (DiffPseudoPeak)matchingDiff.s2.getPeakAt(m.idx2());
                Peak[] peaks1 = p1.getOriginals();
                Peak[] peaks2 = p2.getOriginals();
                int idxa1 = (Integer)map1.get(peaks1[0]);
                int idxa2 = (Integer)map2.get(peaks2[0]);
                int idxb1 = (Integer)map1.get(peaks1[1]);
                int idxb2 = (Integer)map2.get(peaks2[1]);
                if (conflicts[idxa1][idxa2] == null) {
                    conflicts[idxa1][idxa2] = new LinkedList();
                }
                conflicts[idxa1][idxa2].add(m);
                if (conflicts[idxb1][idxb2] == null) {
                    conflicts[idxb1][idxb2] = new LinkedList();
                }
                conflicts[idxb1][idxb2].add(m);
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < conflicts.length) {
            int j = 0;
            while (j < conflicts[i3].length) {
                System.out.println(String.valueOf(i3) + " " + j + " " + conflicts[i3][j]);
                ++j;
            }
            ++i3;
        }
    }

    private void addAssignedDiff(Spectrum s, IntList sxo, HashSet<Peak> isAssigned) {
        int i = 0;
        while (i < sxo.length()) {
            Peak[] os;
            Peak p = s.getPeakAt(sxo.get(i));
            if (p.getType() == Peak.PeakType.DIFF && (isAssigned.contains((os = ((DiffPseudoPeak)p).getOriginals())[0]) || isAssigned.contains(os[1]))) {
                isAssigned.add(p);
            }
            ++i;
        }
    }

    private void addAssignedMatches(Matching matching, HashSet<Peak> isAssigned, Spectrum s, int idx) {
        int i = 0;
        while (i < matching.matches.size()) {
            Matching.Match idxs = (Matching.Match)matching.matches.get(i);
            Peak p = s.getPeakAt(idx == 0 ? idxs.idx1() : idxs.idx2());
            isAssigned.add(p);
            if (p.getType() == Peak.PeakType.PRECURSOR) {
                isAssigned.add(((PrecursorPseudoPeak)p).getOriginal());
            }
            ++i;
        }
    }

    private void addAssignedPrecursor(Spectrum s, IntList sxo, HashSet<Peak> isAssigned) {
        int i = 0;
        while (i < sxo.length()) {
            Peak o;
            Peak p = s.getPeakAt(sxo.get(i));
            if (p.getType() == Peak.PeakType.PRECURSOR && isAssigned.contains(o = ((PrecursorPseudoPeak)p).getOriginal())) {
                isAssigned.add(p);
            }
            ++i;
        }
    }

    private Matching dp3(IntList intList, IntList intList2, HashSet<Peak> hashSet, HashSet<Peak> hashSet2, Spectrum spectrum, Spectrum spectrum2, boolean bl) {
        throw new Error("Unresolved compilation problems: \n\tSwitch Expressions are supported from Java 14 onwards only\n\tArrow in case statement supported from Java 14 onwards only\n\tArrow in case statement supported from Java 14 onwards only\n\tArrow in case statement supported from Java 14 onwards only\n");
    }

    private Matching dp(IntList intList, IntList intList2, HashSet<Peak> hashSet, HashSet<Peak> hashSet2, Spectrum spectrum, Spectrum spectrum2, boolean bl) {
        throw new Error("Unresolved compilation problems: \n\tSwitch Expressions are supported from Java 14 onwards only\n\tArrow in case statement supported from Java 14 onwards only\n\tArrow in case statement supported from Java 14 onwards only\n\tArrow in case statement supported from Java 14 onwards only\n");
    }

    private double getDotProduct(Peak peak, Peak peak2) {
        throw new Error("Unresolved compilation problems: \n\tSwitch Expressions are supported from Java 14 onwards only\n\tArrow in case statement supported from Java 14 onwards only\n\tArrow in case statement supported from Java 14 onwards only\n\tArrow in case statement supported from Java 14 onwards only\n\tSwitch Expressions are supported from Java 14 onwards only\n\tArrow in case statement supported from Java 14 onwards only\n\tArrow in case statement supported from Java 14 onwards only\n\tArrow in case statement supported from Java 14 onwards only\n\tArrow in case statement supported from Java 14 onwards only\n\tSwitch Expressions are supported from Java 14 onwards only\n\tArrow in case statement supported from Java 14 onwards only\n\tArrow in case statement supported from Java 14 onwards only\n\tArrow in case statement supported from Java 14 onwards only\n");
    }

    public Matching computeMatches(Spectrum s1, Spectrum s2) {
        HashSet<Peak> isAssigned1 = new HashSet<Peak>();
        HashSet<Peak> isAssigned2 = new HashSet<Peak>();
        HashSet<Peak.PeakType> types = new HashSet<Peak.PeakType>();
        types.add(Peak.PeakType.ORIGINAL);
        types.add(Peak.PeakType.PRECURSOR);
        types.add(Peak.PeakType.DIFF);
        IntList s1o = s1.getIndicesOfType(types);
        IntList s2o = s2.getIndicesOfType(types);
        Matching matching = this.dp(s1o, s2o, isAssigned1, isAssigned2, s1, s2, true);
        return matching;
    }

    public static class Matching {
        private static DecimalFormat df = new DecimalFormat("#.####", DecimalFormatSymbols.getInstance(Locale.US));
        private Spectrum s1;
        private Spectrum s2;
        private ArrayList<Match> matches;

        public Matching(Spectrum s1, Spectrum s2) {
            this.s1 = s1;
            this.s2 = s2;
            this.matches = new ArrayList();
        }

        public MatchGroup createGroup(ArrayList<Pair<Integer, Double>> pairs, int i, int j, boolean used) {
            ArrayList<Match> group = new ArrayList<Match>();
            while (i < j) {
                group.add(this.matches.get(pairs.get(i).getFirstElement()));
                ++i;
            }
            return new MatchGroup(group, used);
        }

        public ArrayList<Pair<Integer, Double>> getShiftsForDiffs(boolean filterUsed) {
            ArrayList<Pair<Integer, Double>> pairs = new ArrayList<Pair<Integer, Double>>();
            int i = 0;
            while (i < this.matches.size()) {
                Match idxs = this.matches.get(i);
                if (!filterUsed || idxs.use) {
                    Peak p1 = this.s1.getPeakAt(idxs.idx1());
                    Peak p2 = this.s2.getPeakAt(idxs.idx2());
                    if (p1.getType() == Peak.PeakType.DIFF || p2.getType() == Peak.PeakType.DIFF) {
                        pairs.add(new Pair<Integer, Double>(i, this.getShift(i)));
                    }
                }
                ++i;
            }
            return pairs;
        }

        public ArrayList<Pair<Integer, Double>> getShiftsForPrecursors(boolean filterUsed) {
            ArrayList<Pair<Integer, Double>> pairs = new ArrayList<Pair<Integer, Double>>();
            int i = 0;
            while (i < this.matches.size()) {
                Match idxs = this.matches.get(i);
                if (!filterUsed || idxs.use()) {
                    Peak p1 = this.s1.getPeakAt(idxs.idx1());
                    Peak p2 = this.s2.getPeakAt(idxs.idx2());
                    if (p1.getType() == Peak.PeakType.PRECURSOR && p2.getType() == Peak.PeakType.PRECURSOR) {
                        pairs.add(new Pair<Integer, Double>(i, this.getShift(i)));
                    }
                }
                ++i;
            }
            return pairs;
        }

        public double[] getPeakMzs(int idx) {
            Match idxs = this.matches.get(idx);
            return idxs.getPeakMzs();
        }

        public double getShift(int idx) {
            return this.matches.get(idx).getShift();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.s1 + "\n" + this.s2 + "\n");
            int i = 0;
            while (i < this.matches.size()) {
                Match el = this.matches.get(i);
                sb.append(el + " => " + this.getShift(i) + "\n");
                ++i;
            }
            return sb.toString();
        }

        public int getNumberOfMatches(boolean filterUsed) {
            if (!filterUsed) {
                return this.matches.size();
            }
            return (int)this.matches.stream().filter(e -> e.use()).count();
        }

        public Peak[] getMatch(int idx) {
            return new Peak[]{this.s1.getPeakAt(this.matches.get(idx).idx1()), this.s2.getPeakAt(this.matches.get(idx).idx2())};
        }

        public void addMatch(int i, int j, boolean use) {
            this.matches.add(new Match(i, j, use));
        }

        public String forVisualization() {
            Peak p;
            StringBuilder sb = new StringBuilder();
            HashMap<Peak, String> groupAssignment = new HashMap<Peak, String>();
            for (Match m : this.matches) {
                DiffPseudoPeak pp;
                if (!m.use()) continue;
                Peak p1 = this.s1.getPeakAt(m.idx1());
                Peak p2 = this.s2.getPeakAt(m.idx2());
                if (p1.getType() == Peak.PeakType.ORIGINAL && p2.getType() == Peak.PeakType.ORIGINAL) {
                    groupAssignment.put(p1, "O");
                    groupAssignment.put(p2, "O");
                    continue;
                }
                if (p1.getType() == Peak.PeakType.PRECURSOR && p2.getType() == Peak.PeakType.ORIGINAL) {
                    groupAssignment.put(((PrecursorPseudoPeak)p1).getOriginal(), "N");
                    groupAssignment.put(p2, "N");
                    continue;
                }
                if (p1.getType() == Peak.PeakType.ORIGINAL && p2.getType() == Peak.PeakType.PRECURSOR) {
                    groupAssignment.put(p1, "N");
                    groupAssignment.put(((PrecursorPseudoPeak)p2).getOriginal(), "N");
                    continue;
                }
                if (p1.getType() == Peak.PeakType.PRECURSOR && p2.getType() == Peak.PeakType.PRECURSOR) {
                    groupAssignment.put(((PrecursorPseudoPeak)p1).getOriginal(), "P");
                    groupAssignment.put(((PrecursorPseudoPeak)p2).getOriginal(), "P");
                    continue;
                }
                if (p1.getType() == Peak.PeakType.PRECURSOR && p2.getType() == Peak.PeakType.DIFF) {
                    groupAssignment.put(((PrecursorPseudoPeak)p1).getOriginal(), m.groupString());
                    pp = (DiffPseudoPeak)p2;
                    groupAssignment.put(pp.getOriginals()[0], m.groupString());
                    groupAssignment.put(pp.getOriginals()[1], m.groupString());
                    continue;
                }
                if (p1.getType() == Peak.PeakType.DIFF && p2.getType() == Peak.PeakType.PRECURSOR) {
                    pp = (DiffPseudoPeak)p1;
                    groupAssignment.put(pp.getOriginals()[0], m.groupString());
                    groupAssignment.put(pp.getOriginals()[1], m.groupString());
                    groupAssignment.put(((PrecursorPseudoPeak)p2).getOriginal(), m.groupString());
                    continue;
                }
                if (p1.getType() != Peak.PeakType.DIFF || p2.getType() != Peak.PeakType.DIFF) continue;
                pp = (DiffPseudoPeak)p1;
                groupAssignment.put(pp.getOriginals()[0], m.groupString());
                groupAssignment.put(pp.getOriginals()[1], m.groupString());
                DiffPseudoPeak pp2 = (DiffPseudoPeak)p2;
                groupAssignment.put(pp2.getOriginals()[0], m.groupString());
                groupAssignment.put(pp2.getOriginals()[1], m.groupString());
            }
            sb.append(String.valueOf(this.s1.getName()) + "\t" + this.s1.getPrecursor().getMz() + "\t" + 1.0 + "\tT\tT\n");
            int i = 0;
            while (i < this.s1.getNumberOfPeaks()) {
                p = this.s1.getPeakAt(i);
                sb.append(String.valueOf(this.s1.getName()) + "\t" + p.getMz() + "\t" + p.getIntensity());
                if (groupAssignment.containsKey(p)) {
                    sb.append("\t" + (String)groupAssignment.get(p));
                } else {
                    sb.append("\tU");
                }
                sb.append("\t" + p.getType().getCode() + "\n");
                ++i;
            }
            sb.append(String.valueOf(this.s2.getName()) + "\t" + this.s2.getPrecursor().getMz() + "\t" + 1.0 + "\tT\tT\n");
            i = 0;
            while (i < this.s2.getNumberOfPeaks()) {
                p = this.s2.getPeakAt(i);
                sb.append(String.valueOf(this.s2.getName()) + "\t" + p.getMz() + "\t" + p.getIntensity());
                if (groupAssignment.containsKey(p)) {
                    sb.append("\t" + (String)groupAssignment.get(p));
                } else {
                    sb.append("\tU");
                }
                sb.append("\t" + p.getType().getCode() + "\n");
                ++i;
            }
            return sb.toString();
        }

        public class Match {
            private int idx1;
            private int idx2;
            private boolean use;
            private Integer group;
            private Double groupShift;

            public Match(int idx1, int idx2, boolean use) {
                this.idx1 = idx1;
                this.idx2 = idx2;
                this.use = use;
            }

            public Double groupShift() {
                return this.groupShift;
            }

            public void setGroupShift(double shift) {
                this.groupShift = shift;
            }

            public Integer group() {
                return this.group;
            }

            public String groupString() {
                return this.group + " (" + df.format(this.groupShift) + ")";
            }

            public void setGroup(int group) {
                this.group = group;
            }

            public int idx1() {
                return this.idx1;
            }

            public int idx2() {
                return this.idx2;
            }

            public boolean use() {
                return this.use;
            }

            public String toString() {
                return Matching.this.s1.getPeakAt(this.idx1) + " <-> " + Matching.this.s2.getPeakAt(this.idx2) + " " + this.use + " group: " + this.group;
            }

            public double[] getPeakMzs() {
                throw new Error("Unresolved compilation problems: \n\tSwitch Expressions are supported from Java 14 onwards only\n\tArrow in case statement supported from Java 14 onwards only\n\tArrow in case statement supported from Java 14 onwards only\n\tArrow in case statement supported from Java 14 onwards only\n\tSwitch Expressions are supported from Java 14 onwards only\n\tArrow in case statement supported from Java 14 onwards only\n\tArrow in case statement supported from Java 14 onwards only\n\tArrow in case statement supported from Java 14 onwards only\n");
            }

            public double getShift() {
                double[] mzs = this.getPeakMzs();
                return Math.abs(mzs[1] - mzs[0]);
            }
        }

        public class MatchGroup {
            private ArrayList<Match> group;
            private boolean used;

            public MatchGroup(ArrayList<Match> group, boolean used) {
                this.group = group;
                this.used = used;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("group size: " + this.size() + "\n");
                int i = 0;
                while (i < this.group.size()) {
                    Match el = this.group.get(i);
                    sb.append(el + "\n");
                    ++i;
                }
                return sb.toString();
            }

            public int size() {
                return this.group.size();
            }

            public HashSet<Peak>[] getOriginalPeaks() {
                HashSet[] peaks = new HashSet[]{new HashSet(), new HashSet()};
                for (Match m : this.group) {
                    Peak pp;
                    Peak pp2;
                    if (!m.use()) continue;
                    Peak p1 = Matching.this.s1.getPeakAt(m.idx1());
                    if (p1.getType() == Peak.PeakType.PRECURSOR) {
                        pp2 = (PrecursorPseudoPeak)p1;
                        peaks[0].add(((PrecursorPseudoPeak)pp2).getPrecursor());
                        peaks[0].add(((PrecursorPseudoPeak)pp2).getOriginal());
                    } else if (p1.getType() == Peak.PeakType.DIFF) {
                        pp2 = (DiffPseudoPeak)p1;
                        peaks[0].add(((DiffPseudoPeak)pp2).getOriginals()[0]);
                        peaks[0].add(((DiffPseudoPeak)pp2).getOriginals()[1]);
                    } else {
                        throw new RuntimeException();
                    }
                    Peak p2 = Matching.this.s2.getPeakAt(m.idx2());
                    if (p2.getType() == Peak.PeakType.PRECURSOR) {
                        pp = (PrecursorPseudoPeak)p2;
                        peaks[1].add(((PrecursorPseudoPeak)pp).getPrecursor());
                        peaks[1].add(((PrecursorPseudoPeak)pp).getOriginal());
                        continue;
                    }
                    if (p2.getType() == Peak.PeakType.DIFF) {
                        pp = (DiffPseudoPeak)p2;
                        peaks[1].add(((DiffPseudoPeak)pp).getOriginals()[0]);
                        peaks[1].add(((DiffPseudoPeak)pp).getOriginals()[1]);
                        continue;
                    }
                    System.out.println(this.group);
                    throw new RuntimeException();
                }
                return peaks;
            }

            public boolean getUsed() {
                return this.used;
            }

            public void setUsed(boolean used) {
                this.used = used;
                for (Match m : this.group) {
                    m.use = used;
                }
            }

            public void setGroup(int groupID) {
                for (Match m : this.group) {
                    m.setGroup(groupID);
                }
            }
        }
    }

    public static enum UseIntensities {
        ALL,
        ORIGINAL,
        NONE;

    }
}

