/*
 * Decompiled with CFR 0.152.
 */
package projects.talecorrect;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.SimpleSequenceAnnotationParser;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import de.jstacs.tools.ui.cli.CLI;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;

public class PolishTALESubstitutions
implements JstacsTool {
    public static void main(String[] args) throws Exception {
        CLI cli = new CLI(new PolishTALESubstitutions());
        cli.run(args);
    }

    @Override
    public ToolParameterSet getToolParameters() {
        LinkedList<FileParameter> pars = new LinkedList<FileParameter>();
        try {
            pars.add(new FileParameter("Corrected Assembly", "The corrected assembly - output file of CorrectTALESequences.", "fasta,fa,fas,fna", true));
            pars.add(new FileParameter("IGVtoolsCountWig", "The output of igvtools count - wig-File.", "wig", true));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return new ToolParameterSet(this.getShortName(), pars.toArray(new Parameter[0]));
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        FileParameter.FileRepresentation nanoAssemblyTALECorrectedFile = ((FileParameter)parameters.getParameterAt(0)).getFileContents();
        FileParameter.FileRepresentation inputIGVtoolsCountWig = ((FileParameter)parameters.getParameterAt(1)).getFileContents();
        SimpleSequenceAnnotationParser parser = new SimpleSequenceAnnotationParser();
        String[] symbols_caseSensitive = new String[]{"A", "C", "G", "T", "a", "c", "g", "t"};
        AlphabetContainer conCaseSensitive = new AlphabetContainer((Alphabet)new DiscreteAlphabet(false, symbols_caseSensitive));
        DataSet ds = new DataSet(conCaseSensitive, new SparseStringExtractor(nanoAssemblyTALECorrectedFile.getFilename(), '>', (SequenceAnnotationParser)parser));
        AlphabetContainer con = ds.getAlphabetContainer();
        HashMap<String, Sequence> seqHM = new HashMap<String, Sequence>();
        int i = 0;
        while (i < ds.getNumberOfElements()) {
            Sequence seq = ds.getElementAt(i);
            String header = seq.getAnnotation()[0].getResultAt(0).getValue().toString();
            String seqName = header.split(" ")[0];
            seqHM.put(seqName, seq);
            ++i;
        }
        BufferedReader BR = new BufferedReader(new StringReader(inputIGVtoolsCountWig.getContent()));
        Sequence seqCorrected = null;
        String line = "";
        String chrom = "";
        String[] igvSplitLine = new String[8];
        ArrayList<Integer> igvCounts = new ArrayList<Integer>();
        while ((line = BR.readLine()) != null) {
            if (line.matches("variableStep chrom.*")) {
                chrom = line.split(" ")[1].substring(6);
                continue;
            }
            if (line.matches("track type=.*") || line.matches("#Columns: Pos.*")) continue;
            igvSplitLine = line.split("\t");
            int assemblyPos = Integer.parseInt(igvSplitLine[0]);
            igvCounts.clear();
            int j = 1;
            while (j <= 4) {
                igvCounts.add((int)Double.parseDouble(igvSplitLine[j]));
                ++j;
            }
            Integer maxVal = (Integer)Collections.max(igvCounts);
            Integer maxIdx = igvCounts.indexOf(maxVal);
            String nuclUnpolished = ((Sequence)seqHM.get(chrom)).getSubSequence(assemblyPos - 1, 1).toString();
            String nuclMaxCounts = con.getSymbol(0, maxIdx.intValue());
            if (nuclUnpolished.toUpperCase().equals(nuclMaxCounts)) continue;
            int nuclUnpolished_count = (Integer)igvCounts.get(((Sequence)seqHM.get(chrom)).discreteVal(assemblyPos - 1) % 4);
            double frac = (double)maxVal.intValue() / 1.5;
            if (frac < (double)nuclUnpolished_count) continue;
            System.out.println("chrom: " + chrom + "\t" + "pos: " + assemblyPos);
            System.out.println(line);
            System.out.println("nuclUnpolished: " + ((Sequence)seqHM.get(chrom)).getSubSequence(assemblyPos - 1, 1) + " vs nuclMaxCounts: " + con.getSymbol(0, maxIdx.intValue()) + "(" + maxVal + ")");
            System.out.println();
            String seqBefore = ((Sequence)seqHM.get(chrom)).getSubSequence(0, assemblyPos - 1).toString();
            String seqAfter = ((Sequence)seqHM.get(chrom)).getSubSequence(assemblyPos).toString();
            String substitution = con.getSymbol(0, maxIdx.intValue()).toLowerCase();
            seqCorrected = Sequence.create(conCaseSensitive, String.valueOf(seqBefore) + substitution + seqAfter);
            seqHM.replace(chrom, seqCorrected);
        }
        BR.close();
        StringBuffer sb = new StringBuffer();
        ArrayList sortedKeys = new ArrayList(seqHM.keySet());
        Collections.sort(sortedKeys);
        for (String seqName : sortedKeys) {
            sb.append(">" + seqName + "\n");
            String seq2 = ((Sequence)seqHM.get(seqName)).toString();
            sb.append(String.valueOf(seq2) + "\n");
        }
        LinkedList<TextResult> ress = new LinkedList<TextResult>();
        TextResult tr = new TextResult("polishedSubstitutions", "", new FileParameter.FileRepresentation("", sb.toString()), "fa", this.getToolName(), "fasta/as", true);
        ress.addFirst(tr);
        return new ToolResult("Result of " + this.getToolName(), this.getToolName(), null, new ResultSet(new Result[][]{ress.toArray(new Result[0])}), parameters, this.getToolName(), new Date(System.currentTimeMillis()));
    }

    @Override
    public String getToolName() {
        return "PolishTALESubstitutions";
    }

    @Override
    public String getToolVersion() {
        return "0.1";
    }

    @Override
    public String getShortName() {
        return "polish";
    }

    @Override
    public String getDescription() {
        return "polishes substitions after run of CorrectTALESequences tool";
    }

    @Override
    public String getHelpText() {
        return null;
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public String[] getReferences() {
        return null;
    }
}

