/*
 * Decompiled with CFR 0.152.
 */
package projects.tals.epigenetic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import projects.tals.epigenetic.Narrowpeakprofil;

public class NarrowpeakprofilHashMap {
    private HashMap<String, Narrowpeakprofil> narrowpeakProfiles = new HashMap();

    public NarrowpeakprofilHashMap(String faiPath, String PathtoFile, String type) throws Exception {
        this(faiPath, PathtoFile, 300, 50, type);
    }

    public NarrowpeakprofilHashMap(HashMap<String, Integer> chromLengthHash, String PathtoFile, int before, int after) throws Exception {
        float[] peakValue;
        boolean[][] peakBool;
        BufferedReader BR = PathtoFile.endsWith("gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(new File(PathtoFile))))) : new BufferedReader(new InputStreamReader(new FileInputStream(new File(PathtoFile))));
        String line = "";
        HashMap<String, float[]> peakValueHash = new HashMap<String, float[]>();
        HashMap<String, boolean[][]> peakBoolHash = new HashMap<String, boolean[][]>();
        for (String chrom : chromLengthHash.keySet()) {
            peakBool = new boolean[2][chromLengthHash.get(chrom).intValue()];
            peakValue = new float[chromLengthHash.get(chrom).intValue()];
            Arrays.fill(peakBool[0], false);
            Arrays.fill(peakBool[1], false);
            Arrays.fill(peakValue, 0.0f);
            peakBoolHash.put(chrom, (boolean[][])peakBool.clone());
            peakValueHash.put(chrom, (float[])peakValue.clone());
        }
        while ((line = BR.readLine()) != null) {
            String[] splitLine2 = line.split("\t");
            String chrom = splitLine2[0];
            peakValue = (float[])peakValueHash.get(chrom);
            int startPeakPos = Integer.parseInt(splitLine2[1]);
            int endPeakPos = Integer.parseInt(splitLine2[2]) - 1;
            float aktPeak = Float.parseFloat(splitLine2[6]);
            int p = startPeakPos;
            while (p <= endPeakPos) {
                peakValue[p] = aktPeak;
                ++p;
            }
            peakValueHash.put(chrom, peakValue);
        }
        BR.close();
        for (String chrom : chromLengthHash.keySet()) {
            int s;
            int windowend;
            int windowStart;
            peakBool = (boolean[][])peakBoolHash.get(chrom);
            peakValue = (float[])peakValueHash.get(chrom);
            int chromLength = chromLengthHash.get(chrom);
            int lastPos = chromLengthHash.get(chrom) - 1;
            int i = 0;
            while (i < chromLength) {
                windowStart = i - before < 0 ? 0 : i - before;
                windowend = i + after > lastPos ? lastPos : i + after;
                s = windowStart;
                while (s <= windowend) {
                    if (peakValue[s] > 0.0f) {
                        peakBool[0][i] = true;
                        break;
                    }
                    ++s;
                }
                ++i;
            }
            i = 0;
            while (i < chromLength) {
                windowStart = i - after < 0 ? 0 : i - after;
                windowend = i + before > lastPos ? lastPos : i + before;
                s = windowStart;
                while (s <= windowend) {
                    if (peakValue[s] > 0.0f) {
                        peakBool[1][i] = true;
                        break;
                    }
                    ++s;
                }
                ++i;
            }
            peakBoolHash.put(chrom, peakBool);
            this.narrowpeakProfiles.put(chrom, new Narrowpeakprofil(chrom, chromLengthHash.get(chrom), (boolean[][])peakBoolHash.get(chrom), before, after));
        }
    }

    public NarrowpeakprofilHashMap(String faiPath, String PathtoFile, int before, int after, String type) throws Exception {
        float[] peakValue;
        boolean[][] peakBool;
        HashMap<String, Integer> chromLengthHash = new HashMap<String, Integer>();
        BufferedReader readFai = new BufferedReader(new FileReader(faiPath));
        String line = "";
        int chromLength = -1;
        while ((line = readFai.readLine()) != null) {
            String[] splitLine = line.split("\t");
            chromLength = Integer.parseInt(splitLine[1]);
            chromLengthHash.put(splitLine[0], chromLength);
        }
        readFai.close();
        BufferedReader BR = new BufferedReader(new InputStreamReader(new FileInputStream(new File(PathtoFile))));
        line = "";
        HashMap<String, float[]> peakValueHash = new HashMap<String, float[]>();
        HashMap<String, boolean[][]> peakBoolHash = new HashMap<String, boolean[][]>();
        for (String chrom : chromLengthHash.keySet()) {
            peakBool = new boolean[2][((Integer)chromLengthHash.get(chrom)).intValue()];
            peakValue = new float[((Integer)chromLengthHash.get(chrom)).intValue()];
            Arrays.fill(peakBool[0], false);
            Arrays.fill(peakBool[1], false);
            Arrays.fill(peakValue, 0.0f);
            peakBoolHash.put(chrom, (boolean[][])peakBool.clone());
            peakValueHash.put(chrom, (float[])peakValue.clone());
        }
        boolean typeIsGenome = false;
        if (type.equals("genome")) {
            typeIsGenome = true;
        } else if (!type.equals("promotor")) {
            System.err.println("Type should be 'genome' or 'promotor'!");
        }
        while ((line = BR.readLine()) != null) {
            String[] splitLine2 = line.split("\t");
            String chrom = splitLine2[0];
            peakValue = (float[])peakValueHash.get(chrom);
            if (typeIsGenome) {
                int startPeakPos = Integer.parseInt(splitLine2[1]);
                int endPeakPos = Integer.parseInt(splitLine2[2]) - 1;
                float aktPeak = Float.parseFloat(splitLine2[6]);
                int p = startPeakPos;
                while (p <= endPeakPos) {
                    peakValue[p] = aktPeak;
                    ++p;
                }
            } else {
                peakValue[Integer.parseInt((String)splitLine2[1]) - 1] = Float.parseFloat(splitLine2[2]);
            }
            peakValueHash.put(chrom, peakValue);
        }
        BR.close();
        for (String chrom : chromLengthHash.keySet()) {
            int s;
            int windowend;
            peakBool = (boolean[][])peakBoolHash.get(chrom);
            peakValue = (float[])peakValueHash.get(chrom);
            chromLength = (Integer)chromLengthHash.get(chrom);
            int lastPos = (Integer)chromLengthHash.get(chrom) - 1;
            int i = 0;
            while (i < chromLength) {
                int windowStart = i - before < 0 ? 0 : i - before;
                windowend = i + after > lastPos ? lastPos : i + after;
                s = windowStart;
                while (s <= windowend) {
                    if (peakValue[s] > 0.0f) {
                        peakBool[0][i] = true;
                        break;
                    }
                    ++s;
                }
                ++i;
            }
            i = 0;
            while (i < chromLength) {
                int windowStart = i - after < 0 ? 0 : i - after;
                windowend = i + before > lastPos ? lastPos : i + before;
                s = windowStart;
                while (s <= windowend) {
                    if (peakValue[s] > 0.0f) {
                        peakBool[1][i] = true;
                        break;
                    }
                    ++s;
                }
                ++i;
            }
            peakBoolHash.put(chrom, peakBool);
            this.narrowpeakProfiles.put(chrom, new Narrowpeakprofil(chrom, (Integer)chromLengthHash.get(chrom), (boolean[][])peakBoolHash.get(chrom), before, after));
        }
    }

    public Narrowpeakprofil getNarrowpeakprofil(String chrom) {
        return this.narrowpeakProfiles.get(chrom);
    }
}

