/*
 * Decompiled with CFR 0.152.
 */
package projects.tals.epigenetic;

import de.jstacs.io.FileManager;
import de.jstacs.parameters.FileParameter;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import de.jstacs.tools.ui.cli.CLI;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Date;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class PileupConvertToPromoterSearch
implements JstacsTool {
    public static void main(String[] args) throws Exception {
        CLI cli = new CLI(new PileupConvertToPromoterSearch());
        cli.run(args);
    }

    @Override
    public ToolParameterSet getToolParameters() {
        FileParameter pileupFile = new FileParameter("Normalized pileup output file", "Normalized pileup output file.", "tsv.gz,tsv", true);
        FileParameter promoterFasta = new FileParameter("Promoter fasta file", "Promoter fastA file", "fa,fasta", true);
        return new ToolParameterSet(this.getShortName(), pileupFile, promoterFasta);
    }

    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads) throws Exception {
        String chrom;
        progress.setLast(1.0);
        progress.setCurrent(0.0);
        String pileupFile = parameters.getParameterAt(0).getValue().toString();
        BufferedReader BR = null;
        BR = pileupFile.endsWith("gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(new File(pileupFile))))) : new BufferedReader(new InputStreamReader(new FileInputStream(new File(pileupFile))));
        String promotorFasta = parameters.getParameterAt(1).getValue().toString();
        BufferedReader FA = new BufferedReader(new FileReader(promotorFasta));
        File out = File.createTempFile("promoter.pileup", ".temp.tsv.gz", new File("."));
        out.deleteOnExit();
        GZIPOutputStream os = new GZIPOutputStream(new FileOutputStream(out));
        PrintStream os_ps = new PrintStream(os);
        HashMap<String, HashMap> tempPileup = new HashMap<String, HashMap>();
        String line = "";
        while ((line = BR.readLine()) != null) {
            String[] splitLine;
            if (!line.matches(".*\t(\\d*)\t.*") || !(Double.parseDouble((splitLine = line.split("\t"))[2]) > 0.0)) continue;
            HashMap temp = null;
            chrom = splitLine[0];
            int pos = Integer.parseInt(splitLine[1]);
            temp = tempPileup.containsKey(chrom) ? (HashMap)tempPileup.get(chrom) : new HashMap();
            temp.put(pos, line);
            tempPileup.put(chrom, temp);
        }
        BR.close();
        line = "";
        String gene = "";
        chrom = "";
        int startPos = -1;
        int endPos = -1;
        int startBAM = -1;
        while ((line = FA.readLine()) != null) {
            if (!line.startsWith(">")) continue;
            String[] splitHeader = line.split(" ");
            String[] splitArea = splitHeader[2].split(":");
            String[] splitPos = splitArea[1].split("-");
            gene = line.substring(1).trim();
            int idx = gene.indexOf(" ");
            if (idx > 0) {
                gene = gene.substring(0, idx);
            }
            chrom = splitArea[0];
            startPos = Integer.parseInt(splitPos[0]);
            endPos = Integer.parseInt(splitPos[1]);
            int i = startPos;
            while (i < endPos) {
                if (tempPileup.containsKey(chrom) && ((HashMap)tempPileup.get(chrom)).containsKey(i + 1)) {
                    String lineBAM = (String)((HashMap)tempPileup.get(chrom)).get(i + 1);
                    String[] splitBAM = lineBAM.split("\t");
                    startBAM = Integer.parseInt(splitBAM[1]) - startPos;
                    String output = String.valueOf(gene) + "\t" + startBAM + "\t" + splitBAM[2];
                    os_ps.print(String.valueOf(output) + "\n");
                }
                ++i;
            }
        }
        FA.close();
        os.close();
        TextResult tr = new TextResult("Pileup promoter file", "Pileup promoter file", new FileParameter.FileRepresentation(out.getAbsolutePath()), "tsv.gz", this.getToolName(), null, true);
        return new ToolResult("Result of " + this.getToolName(), this.getToolName(), null, new ResultSet(tr), parameters, this.getToolName(), new Date(System.currentTimeMillis()));
    }

    @Override
    public String getToolName() {
        return "PileupConvertToPromoter";
    }

    @Override
    public String getToolVersion() {
        return "0.1";
    }

    @Override
    public String getShortName() {
        return "pile2prom";
    }

    @Override
    public String getDescription() {
        return "Creates Pileup file in promoter region";
    }

    @Override
    public String getHelpText() {
        try {
            return FileManager.readInputStream(PileupConvertToPromoterSearch.class.getClassLoader().getResourceAsStream("projects/tals/epigenetic/toolHelpFiles/PileupConvertToPromoterSearch.txt")).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return null;
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public String[] getReferences() {
        return null;
    }
}

