/*
 * Decompiled with CFR 0.152.
 */
package projects.xanthogenomes;

import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.FileManager;
import de.jstacs.utils.IntList;
import projects.xanthogenomes.TALE;
import projects.xanthogenomes.TALEFamilyBuilder;

public class AlignDNARepeats {
    public static void main(String[] args) throws Exception {
        String first = "TalCM5";
        String[] second = new String[]{"TalCM2", "TalCM4"};
        TALEFamilyBuilder builder = new TALEFamilyBuilder(FileManager.readFile(args[0]));
        TALE ft = null;
        TALE[] st = new TALE[second.length];
        TALE[] tales = builder.getAllTALEs();
        int i = 0;
        while (i < tales.length) {
            if (tales[i].getId().startsWith(first)) {
                ft = tales[i];
            } else {
                int j = 0;
                while (j < second.length) {
                    if (tales[i].getId().startsWith(second[j])) {
                        st[j] = tales[i];
                    }
                    ++j;
                }
            }
            ++i;
        }
        IntList firstUsed = new IntList();
        int i2 = 0;
        while (i2 < 3) {
            firstUsed.add(i2);
            ++i2;
        }
        i2 = 4;
        while (i2 < 11) {
            firstUsed.add(i2);
            ++i2;
        }
        i2 = 12;
        while (i2 < ft.getNumberOfRepeats()) {
            firstUsed.add(i2);
            ++i2;
        }
        IntList secondUsed = new IntList();
        int i3 = 0;
        while (i3 < st[0].getNumberOfRepeats()) {
            secondUsed.add(i3);
            ++i3;
        }
        if (firstUsed.length() != secondUsed.length()) {
            throw new RuntimeException(String.valueOf(firstUsed.length()) + " " + secondUsed.length());
        }
        Sequence fn = ft.getDnaOriginal().getStart();
        Sequence[] sns = new Sequence[st.length];
        int i4 = 0;
        while (i4 < st.length) {
            sns[i4] = st[i4].getDnaOriginal().getStart();
            ++i4;
        }
        int offset = 0;
        AlignDNARepeats.compare(fn, sns, offset, "n", false);
        offset += fn.getLength();
        int i5 = 0;
        while (i5 < firstUsed.length()) {
            Sequence fr = ft.getDnaOriginal().getRepeat(firstUsed.get(i5)).getRepeat();
            Sequence[] srs = new Sequence[st.length];
            int j = 0;
            while (j < st.length) {
                srs[j] = st[j].getDnaOriginal().getRepeat(secondUsed.get(i5)).getRepeat();
                ++j;
            }
            AlignDNARepeats.compare(fr, srs, offset, "r" + i5, i5 > 0 && (firstUsed.get(i5) - 1 != firstUsed.get(i5 - 1) || secondUsed.get(i5) - 1 != secondUsed.get(i5 - 1)));
            offset += fr.getLength();
            ++i5;
        }
        Sequence fc = ft.getDnaOriginal().getEnd();
        Sequence[] scs = new Sequence[st.length];
        int i6 = 0;
        while (i6 < st.length) {
            scs[i6] = st[i6].getDnaOriginal().getEnd();
            ++i6;
        }
        AlignDNARepeats.compare(fc, scs, offset, "c", false);
    }

    private static void compare(Sequence fn, Sequence[] sns, int offset, String type, boolean breakpoint) {
        int[] diffs = new int[fn.getLength()];
        int i = 0;
        while (i < fn.getLength()) {
            int j = 0;
            while (j < sns.length) {
                if (fn.discreteVal(i) != sns[j].discreteVal(i)) {
                    int n = i;
                    diffs[n] = diffs[n] + 1;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < diffs.length) {
            System.out.println(String.valueOf(i + offset) + "\t" + diffs[i] + "\t" + type + "\t" + (i == 0 ? "y" : "n") + "\t" + (i == 0 && breakpoint ? "b" : "n"));
            ++i;
        }
    }
}

