/*
 * Decompiled with CFR 0.152.
 */
package projects.xanthogenomes;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.FileManager;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.Pair;
import de.jstacs.utils.ToolBox;
import de.jstacs.utils.graphics.PDFAdaptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import projects.xanthogenomes.BuildFamilies;
import projects.xanthogenomes.TALE;
import projects.xanthogenomes.TALEFamilyBuilder;
import projects.xanthogenomes.TALEFamilyTreePlotter;
import projects.xanthogenomes.alignmentCosts.RVDCosts;

public class AlignmentPValues {
    private double[][] cost;
    private double[][] prob;
    private static int n = 0;
    private static double doublePrec = 0.001;

    public AlignmentPValues(TALE[] allTales, RVDCosts costs) {
        AlphabetContainer rvdAlph = allTales[0].getRvdSequence().getAlphabetContainer();
        double[] rvdProbs = new double[(int)rvdAlph.getAlphabetLengthAt(0)];
        Arrays.fill(rvdProbs, 1.0 / (double)rvdProbs.length);
        int i = 0;
        while (i < allTales.length) {
            Sequence rvds = allTales[i].getRvdSequence();
            int j = 0;
            while (j < rvds.getLength()) {
                int n = rvds.discreteVal(j);
                rvdProbs[n] = rvdProbs[n] + 1.0;
                ++j;
            }
            ++i;
        }
        Normalisation.sumNormalisation(rvdProbs);
        this.cost = new double[rvdProbs.length][];
        this.prob = new double[rvdProbs.length][];
        i = 0;
        while (i < rvdProbs.length) {
            HashMap<Double, Double> map = new HashMap<Double, Double>();
            int j = 0;
            while (j < rvdProbs.length) {
                Double c = costs.getCostFor(rvdAlph, i, j);
                if (map.containsKey(c)) {
                    map.put(c, (Double)map.get(c) + rvdProbs[j]);
                } else {
                    map.put(c, rvdProbs[j]);
                }
                ++j;
            }
            Set keys = map.keySet();
            LinkedList list = new LinkedList(keys);
            Collections.sort(list);
            this.cost[i] = new double[list.size()];
            this.prob[i] = new double[list.size()];
            int j2 = 0;
            while (j2 < list.size()) {
                this.cost[i][j2] = (Double)list.get(j2);
                this.prob[i][j2] = Math.log((Double)map.get(list.get(j2)));
                ++j2;
            }
            ++i;
        }
    }

    public double getLog10PValue(Sequence rvds, double costThresh, double baseScore) {
        double[] prevScores = new double[]{baseScore};
        double[] prevProbs = new double[]{0.0};
        int i = 0;
        while (i < rvds.getLength()) {
            int rvd = rvds.discreteVal(i);
            double[] sc = this.cost[rvd];
            double[] pr = this.prob[rvd];
            Pair<double[], double[]> pair = this.joinAggregateAndFilter(prevScores, prevProbs, sc, pr, costThresh);
            prevScores = pair.getFirstElement();
            prevProbs = pair.getSecondElement();
            if (prevScores.length == 0) {
                return Double.NEGATIVE_INFINITY;
            }
            ++i;
        }
        i = 0;
        while (i < prevScores.length && prevScores[i] < costThresh) {
            ++i;
        }
        return Normalisation.getLogSum(0, i, prevProbs) / Math.log(10.0);
    }

    private Pair<double[], double[]> joinAggregateAndFilter(double[] prevScores, double[] prevProbs, double[] sc, double[] pr, double costThresh) {
        double[] tempSc = new double[prevScores.length * sc.length];
        double[] tempPr = new double[prevProbs.length * pr.length];
        int i = 0;
        int k = 0;
        while (i < prevScores.length) {
            int j = 0;
            while (j < sc.length) {
                tempSc[k] = prevScores[i] + sc[j];
                tempPr[k] = prevProbs[i] + pr[j];
                ++j;
                ++k;
            }
            ++i;
        }
        ToolBox.sortAlongWith(tempSc, new double[][]{tempPr});
        DoubleList resSc = new DoubleList(tempSc.length);
        DoubleList resPr = new DoubleList(tempSc.length);
        int i2 = 0;
        while (i2 < tempSc.length) {
            int j = i2;
            double prev = tempSc[j];
            while (i2 < tempSc.length && Math.abs(tempSc[i2] - prev) < doublePrec) {
                ++i2;
            }
            resSc.add(prev);
            resPr.add(Normalisation.getLogSum(j, i2, tempPr));
        }
        return new Pair<double[], double[]>(resSc.toArray(), resPr.toArray());
    }

    public static void main(String[] args) throws Exception {
        TALEFamilyBuilder builder = new TALEFamilyBuilder(FileManager.readFile(args[0]));
        builder.setToOld();
        TALE[] tales = builder.getAllTALEs();
        Pair<TALEFamilyBuilder, BuildFamilies.FamilyResult[]> fams = BuildFamilies.build(tales, 2.147483647E9, 1.1);
        BuildFamilies.FamilyResult res = fams.getSecondElement()[0];
        TALEFamilyTreePlotter plotter = new TALEFamilyTreePlotter(10);
        PDFAdaptor ad = new PDFAdaptor();
        int[] dim = plotter.getDimension(ad.getGraphics(10, 10), res.getFamily());
        ad = new PDFAdaptor();
        plotter.plot(ad.getGraphics(dim[0], dim[1]), res.getFamily());
        ad.generateOutput("/Users/dev/Downloads/completeTree.pdf");
    }

    public double getLog10PValue(TALE tale, TALE tale2, double sc, double extraGapOpening, double extraGapExtension) {
        Object str = null;
        if (tale.getNumberOfRepeats() > tale2.getNumberOfRepeats()) {
            TALE temp = tale;
            tale = tale2;
            tale2 = temp;
        }
        Sequence rvd = tale.getRvdSequence();
        Sequence rvd2 = tale2.getRvdSequence();
        double sum = 0.0;
        double sumq = 0.0;
        int l = rvd2.getLength() - rvd.getLength() + 1;
        int i = 0;
        while (i < l) {
            double base = (i > 0 && l > 1 ? extraGapOpening : 0.0) + (i < l - 1 && l > 1 ? extraGapOpening : 0.0) + (double)(l - 1) * extraGapExtension;
            double p = this.getLog10PValue(rvd2.getSubSequence(i, rvd.getLength()), sc, base);
            p = AlignmentPValues.log1m(p * Math.log(10.0));
            sum += p;
            double q = this.getLog10PValue(rvd, sc, base);
            q = AlignmentPValues.log1m(q * Math.log(10.0));
            sumq += q;
            ++i;
        }
        double ret = AlignmentPValues.log1m(sum + sumq) / Math.log(10.0);
        return ret;
    }

    private static double log1m(double d) {
        double d1 = Math.log1p(-Math.exp(d));
        return d1;
    }
}

