/*
 * Decompiled with CFR 0.152.
 */
package projects.xanthogenomes;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.FileManager;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Random;
import projects.xanthogenomes.TALEFamilyBuilder;

public class RVDCopies {
    public static void main(String[] args) throws Exception {
        TALEFamilyBuilder builder = new TALEFamilyBuilder(FileManager.readFile(args[0]));
        TALEFamilyBuilder.TALEFamily[] fams = builder.getFamilies();
        int minlen = 4;
        Sequence[][] allSeqs = new Sequence[fams.length][];
        String[] names = new String[fams.length];
        String[] strains = new String[fams.length];
        int i = 0;
        while (i < fams.length) {
            names[i] = fams[i].getFamilyId();
            allSeqs[i] = new Sequence[fams[i].getFamilySize()];
            String strain = null;
            int j = 0;
            while (j < allSeqs[i].length) {
                allSeqs[i][j] = fams[i].getFamilyMembers()[j].getRvdSequence();
                strain = fams[i].getFamilyMembers()[j].getStrain();
                strain = strain.substring(0, strain.indexOf(" "));
                if (strains[i] == null) {
                    strains[i] = strain;
                } else if (!strains[i].equals(strain)) {
                    strains[i] = "mult";
                }
                ++j;
            }
            ++i;
        }
        AlphabetContainer rvdAlph = allSeqs[0][0].getAlphabetContainer();
        RVDCopies.printCounts(allSeqs, names, "real", strains);
        System.exit(1);
        int r = 0;
        while (r < 1000) {
            Sequence[][] allSeqs2 = new Sequence[allSeqs.length][];
            int i2 = 0;
            while (i2 < fams.length) {
                String[] al = fams[i2].getInducedMultipleAlignment().getSecondElement();
                String[][] split = new String[al.length][];
                int k = 0;
                while (k < al.length) {
                    split[k] = al[k].trim().split(" ");
                    ++k;
                }
                int[] part = new int[split[0].length];
                int curr = 0;
                int j = 1;
                while (j < part.length) {
                    int k2 = 0;
                    while (k2 < split.length) {
                        if (split[k2][j].equals("--") && !split[k2][j - 1].equals("--") || !split[k2][j].equals("--") && split[k2][j - 1].equals("--")) break;
                        ++k2;
                    }
                    part[j] = ++curr;
                    ++j;
                }
                int[] ends = new int[part[part.length - 1] + 1];
                int j2 = -1;
                int k3 = 0;
                while (j2 < part.length) {
                    ++j2;
                    while (j2 < part.length && (j2 == 0 || part[j2] == part[j2 - 1])) {
                        ++j2;
                    }
                    ends[k3] = j2;
                    ++k3;
                }
                int start = 0;
                int[] perms = new int[part.length];
                j2 = 0;
                while (j2 < ends.length) {
                    int end = ends[j2];
                    int[] perm = new int[end - start];
                    int l = 0;
                    while (l < perm.length) {
                        perm[l] = start + l;
                        ++l;
                    }
                    RVDCopies.permute(perm);
                    System.arraycopy(perm, 0, perms, start, perm.length);
                    start = ends[j2];
                    ++j2;
                }
                if (split.length != allSeqs[i2].length) {
                    throw new RuntimeException();
                }
                allSeqs2[i2] = new Sequence[split.length];
                j2 = 0;
                while (j2 < split.length) {
                    Sequence rvds;
                    String[] temp = (String[])split[j2].clone();
                    k3 = 0;
                    while (k3 < temp.length) {
                        temp[k3] = split[j2][perms[k3]];
                        ++k3;
                    }
                    StringBuffer strb = new StringBuffer();
                    k3 = 0;
                    while (k3 < temp.length) {
                        if (strb.length() > 0) {
                            strb.append(" ");
                        }
                        if (!temp[k3].equals("--")) {
                            strb.append(temp[k3]);
                        }
                        ++k3;
                    }
                    allSeqs2[i2][j2] = rvds = Sequence.create(rvdAlph, strb.toString(), " ");
                    ++j2;
                }
                ++i2;
            }
            RVDCopies.printCounts(allSeqs2, names, "rand" + r, strains);
            ++r;
        }
    }

    private static void printCounts(Sequence[][] allSeqs2, String[] names, String suffix, String[] strains) {
        Sequence rvds1;
        int j;
        Sequence[] seqs1;
        int minlen = 4;
        ArrayList<Match> matches = new ArrayList<Match>();
        Sequence[][] allSeqs = new Sequence[allSeqs2.length][];
        int i = 0;
        while (i < allSeqs2.length) {
            seqs1 = new LinkedList();
            j = 0;
            while (j < allSeqs2[i].length) {
                rvds1 = allSeqs2[i][j];
                if (!seqs1.contains(rvds1)) {
                    seqs1.add(rvds1);
                }
                ++j;
            }
            allSeqs[i] = seqs1.toArray(new Sequence[0]);
            ++i;
        }
        i = 0;
        while (i < allSeqs.length) {
            seqs1 = allSeqs[i];
            j = 0;
            while (j < seqs1.length) {
                rvds1 = seqs1[j];
                int k = i + 1;
                while (k < allSeqs.length) {
                    Sequence[] seqs2 = allSeqs[k];
                    int l = 0;
                    while (l < seqs2.length) {
                        Sequence rvds2 = seqs2[l];
                        matches.clear();
                        RVDCopies.findMatches(rvds1, rvds2, matches, minlen);
                        int m = 0;
                        while (m < matches.size()) {
                            Match ma = matches.get(m);
                            System.out.println(String.valueOf(names[i]) + "\t" + names[k] + "\t" + ma.start1 + "\t" + ma.start2 + "\t" + (ma.len1 - (ma.start1 + ma.lenm)) + "\t" + (ma.len2 - (ma.start2 + ma.lenm)) + "\t" + ma.lenm + "\t" + suffix + "\t" + strains[i] + "\t" + strains[k]);
                            ++m;
                        }
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private static void permute(int[] perm) {
        Random r = new Random();
        int i = 0;
        while (i < perm.length) {
            int swap = i + r.nextInt(perm.length - i);
            int temp = perm[swap];
            perm[swap] = perm[i];
            perm[i] = temp;
            ++i;
        }
    }

    private static void findMatches(Sequence rvds1, Sequence rvds2, ArrayList<Match> matches, int minlen) {
        int i = 0;
        while (i < rvds1.getLength() - minlen + 1) {
            Sequence sub1 = rvds1.getSubSequence(i);
            int j = 0;
            while (j < rvds2.getLength() - minlen + 1) {
                Sequence sub2 = rvds2.getSubSequence(j);
                if (i == 0 || j == 0 || rvds1.discreteVal(i - 1) != rvds2.discreteVal(j - 1)) {
                    int k = 0;
                    while (k < sub1.getLength() && k < sub2.getLength() && sub1.discreteVal(k) == sub2.discreteVal(k)) {
                        ++k;
                    }
                    if (k > minlen) {
                        matches.add(new Match(i, j, rvds1, rvds2, k));
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private static class Match {
        private int start1;
        private int start2;
        private int len1;
        private int len2;
        private int lenm;

        public Match(int start1, int start2, Sequence rvds1, Sequence rvds2, int len) {
            this.start1 = start1;
            this.start2 = start2;
            this.len1 = rvds1.getLength();
            this.len2 = rvds2.getLength();
            this.lenm = len;
        }
    }
}

